/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.9 $
* Date:         $Date: 2010-05-14 08:45:26 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsll3.h"
#include "dsltype.h"
#include "mibequ.h"
#include "vdsllib.h"
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define OPEN_VDSL(vdslfd) ({vdslfd=open("/dev/vdsl", O_RDWR);if(vdslfd == -1){printf("vdsl device open failed.\n");return -1;}})
#define FW_HEADER_SIZE	4
#define SPMA_HEADER_SIZE	4
#define HEADER_SIZE	3

int vdslfd;
char ioctl_buf[SMALL_BUF_SIZE];
char ioctl_big_buf[BUF_SIZE+FW_HEADER_SIZE];
mt_ret ret;

/**
 * \file 
 * \brief API set that metanoia provide
 */


/** This file is the main API that export to user.
 */
// -------------------------- MIB  -----------------------
/**
 * GetPortMIB get any MIB value on this port
 * \param portid
 * 		port ID number
 * \param oid
 * 		MIB Object ID string
 * \param pvalue
 * 		memory location to receive the value of the parameter in the MIB
 * 
 * \return
 * 	- 0 : success
 * 	- -DSL_ERR_NODATA : no this interval data
 *  - -DSL_ERR_PARAM: invalid parameter
 * \par Notice:
 * 
 */
mt_ret get_port_mib(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue)
{
	dsl_er(check_param(MT_PAR_PORT,0,portid));	

	OPEN_VDSL(vdslfd);
	ioctl_big_buf[0]=portid;
	strcpy(ioctl_big_buf+1, loid);
	ret = ioctl(vdslfd, VDSL_GET_PORT_MIB, ioctl_big_buf);
	memcpy(strvalue, ioctl_big_buf, BUF_SIZE);
	close(vdslfd);

	return ret;
}


/**
 * SetPortMIB sets a parameter in the MIB for the selected port.
 * \param portid
 * 		port ID number
 * \param oid
 * 		MIB Object ID string
 * \param pvalue
 * 		memory location with the value to be set into the MIB
 * 
 * \return
 * 	- 0 : success
 * 	- < 0 : error code 
 * \par Notice:
 * 		some MIB can't be set randomly, in order to protect system, SetPortMIB will filter it. and response with error\n
 * 		SetPortMIB don't support interval paramter
 *  - filter table list: LineConfProfile table, AlarmConfProfile Table
 */
mt_ret set_port_mib(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue)
{
	dsl_er(check_param(MT_PAR_PORT, 0, portid));	

	OPEN_VDSL(vdslfd);
	ioctl_big_buf[0]=portid;
	strcpy(ioctl_big_buf+1, loid);
	strcpy(ioctl_big_buf+1+strlen(loid)+1, strvalue);
	ret = ioctl(vdslfd, VDSL_SET_PORT_DATA_LOGIC, ioctl_big_buf);
	close(vdslfd);

	return ret;
}


/**
 * GetPhyStatus
 * \param phy_status
 * 		defined in  MT_OPSTATE_*
 * \return 
 * 	- DSL_ERR_OK: success
 * 	- < 0 : error code
 */
mt_ret get_phy_status(mt_uint32 portid, mt_uint8 *phy_status, mt_uint8 *conn_status)
{
	dsl_er(check_param(MT_PAR_PORT,0,portid));

	OPEN_VDSL(vdslfd);
	ioctl_buf[0] = portid;
	ret = ioctl(vdslfd, VDSL_GET_PHY_STATUS, ioctl_buf);
	if(phy_status != NULL) *phy_status = ioctl_buf[0];
	if(conn_status != NULL) *conn_status = ioctl_buf[1];
	close(vdslfd);

	return ret;		
}


/**
 * get port's OpState
 * \param portid
 *  	port ID , start from 1
 * \param *state
 *  	return OpState defined in MT_OPSTATE_* to user
 * \return
 *  - DSL_ERR_OK: success
 *  - < 0 : error code
 *
 */
mt_ret get_op_status(mt_uint32 portid,mt_uint8 *state)
{
	dsl_er(check_param(MT_PAR_PORT,0,portid));

	OPEN_VDSL(vdslfd);
	ioctl_buf[0]=portid;
	ret = ioctl(vdslfd, VDSL_GET_OP_STATE, ioctl_buf);
	*state=ioctl_buf[0];
	close(vdslfd);

	return ret;
}


// -------------------------- statistic routine -----------------------
/**
 * This API must be called every 15 Min
 * \n get statistic data from firmware every 15 min
 * \return 
 * 	- DSL_ERR_OK: success
 * 	- < 0 : error code
 */
mt_ret mt_perf_15min()
{
	OPEN_VDSL(vdslfd);
	ret = ioctl(vdslfd, VDSL_MT_PERF_15_MIN, ioctl_buf);
	close(vdslfd);

	return ret;
}


/**
 * This API must be called every 24 Hour
 * \n get statistic data from firmware every 24 hour
 * \param portid
 * 		port ID number
 * \return 
 * 	- DSL_ERR_OK: success
 * 	- < 0 : error code
 */
mt_ret mt_perf_24hour()
{
	OPEN_VDSL(vdslfd);
	ret = ioctl(vdslfd, VDSL_MT_PERF_24_HOUR, ioctl_buf);
	close(vdslfd);

	return ret;
}


/**
 * ClearPortStats clears port statistics
 * \param portid
 * 		port ID number 
 */
mt_ret clear_port_stats(mt_uint32 portid)
{
	dsl_er(check_param(MT_PAR_PORT,0,portid));

	OPEN_VDSL(vdslfd);
	ioctl_buf[0]=portid;
	ret = ioctl(vdslfd, VDSL_CLEAR_PORT_STATS, ioctl_buf);
	close(vdslfd);

	return ret;
} 


// -------------------------- Debug -----------------------
// -------------------------- Misc -----------------------
/**
 * get vdsl device driver version
 * \param buffer
 * 		buffer to receive version string
 * \return
 * 	- DSL_ERR_OK: success
 * 	- < 0 : error code
 */
mt_ret get_version(mt_uint8 *buffer)
{
	OPEN_VDSL(vdslfd);
	ret = ioctl(vdslfd, VDSL_GET_VERSION, ioctl_buf);
	memcpy(buffer, ioctl_buf, sizeof(ioctl_buf));
	close(vdslfd);

	return ret;
}
