#!/bin/sh
#
# vdsl_control.sh 
# 2009/06/18 
# Author:yuan_lee@metanoia 
#
# for ralink 3052 platfrom
#

Usage()
{
	echo "Usage : vdsl_control.sh [option]"
	echo "option:"
	echo "		init: 	 Init re-make board.conf from flash"
	echo "		save:	 Save board.conf to flash"
	echo "		CO:	 Set VDSL CO and running"
	echo "		CPE:	 Set VDSL CPE and running"
	echo "		run:	 VDSL running"
	echo "		ftcheck: If Flash no VDSL parameter , re-cover default value"
	exit 0
}

#### If Flash no VDSL parameter ,re-cover default value ###
FirstTimeCheck()
{
	name=`nvram_get 2860 CLI_HOSTNAME`
	if [ "$name" = "" ]; then
		sleep 10
		echo "Set VDSL default value..."
		Save
	fi

}

###init re-make board.conf from flash###
Init()
{
	foo=1
	name1=`nvram_get 2860 CLI_HOSTNAME`
	name2=`nvram_get 2860 V_DISABLE_P1`
	name3=`nvram_get 2860 PROFILE_VERSION`
	name4=`nvram_get 2860 PROFILE_INDEX`
	name5=`nvram_get 2860 port1_map_profile`
	name6=`nvram_get 2860 PORT1_MODE`
	/mtd/bin/cfgmgr -w "CLI_HOSTNAME=$name1,V_DISABLE_P1=$name2,PROFILE_VERSION=$name3,PROFILE_INDEX=$name4,port1_map_profile=$name5,PORT1_MODE=$name6"

	while [ "$foo" -le 21 ]
	do
		value=`nvram_get 2860 VdslProfiles"$foo"`
		/mtd/bin/cfgmgr -w VdslProfiles$foo=$value
		foo=`expr $foo + 1`
	done
}

###save board.conf to flash###
Save()
{
	echo "Default" > /tmp/save.conf
	cat /etc/board.conf | sed 's/export //g' >> /tmp/save.conf
	ralink_init renew 2860 /tmp/save.conf
	rm -fr /tmp/save.conf
	sleep 3
}

###Set VDSL running###
SetVdsl()
{
#Ralink Switch GMII port 5 disable
	switch reg w 0xc8 0x3f50bbf5

	side=`/mtd/bin/cfgmgr -r PORT1_MODE`

	if [ "$side" = "CO" ]; then
		echo "CO running..."
		/mtd/bin/dslcli /mtd/co.scr
	elif [ "$side" = "CPE" ]; then
		echo "CPE running..."
		/mtd/bin/dslcli /mtd/cpe.scr
	else
		echo "CPE running...(default)"
		/mtd/bin/dslcli /mtd/cpe.scr
	fi

#Ralink Switch GMII port 5 enable
	switch reg w 0xc8 0x3f50bff5
}

##########main prog#############
if [ "$1" = "init" ]; then
	echo "VDSL parameter init..."
	Init
elif [ "$1" = "save" ]; then
	echo "VDSL parameter save..."
	Save
elif [ "$1" = "CO" ]; then
        echo "set CO running..."
	/mtd/bin/cfgmgr -w "PORT1_MODE=CO" 
	SetVdsl
elif [ "$1" = "CPE" ]; then
        echo "set CPE running..."
	/mtd/bin/cfgmgr -w "PORT1_MODE=CPE" 
	SetVdsl
elif [ "$1" = "run" ]; then
	echo "running VDSL..."
	SetVdsl
elif [ "$1" = "ftcheck" ]; then
	echo "VDSL First Time Parameter Check..."
	FirstTimeCheck
else 
	Usage
fi
