/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.5 $
* Date:         $Date: 2011-09-23 02:43:36 $
*
* Overview:
* Functions:
*
* Author:       Ian Tsao
*
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
*
* Metanoia reserves the right to change specifications without notice.
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet
* indicates this product is in design and the specification may change.
* Electrical parametrics have not been analyzed and are not specified. Do not
* use this data sheet as a design reference document. Please contact Metanoia
* for a current data sheet that may be used as a design reference. All
* contents of this document are protected by copyright law and may not be
* reproduced without the express written consent of Metanoia, Inc. Metanoia,
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.
* Other product names used in this publication are for identification purposes
* only and may be trademarks or registered trademarks of their respective
* companies. The contents of this document are provided in connection with
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that
* the information contained herein is accurate and reliable. However, Metanoia,
* Inc. makes no warranties, express or implied, as to the accuracy or
* completeness of the contents of this publication and is providing this
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to
* specifications and product descriptions at any time without notice, and to
* discontinue or make changes to its products at any time without notice.
* Metanoia, Inc. does not assume any liability arising out of the application
* or use of any product or circuit, and specifically disclaims any and all
* liability, including without limitation special, consequential, or
* incidental damages.
*
****************************************************************************/
#ifndef _TR069_H_
#define _TR069_H_

#define MAX_PARAMETER 198
#define MAX_METHOD 5

#define READ_ENABLE FALSE
#define WRITE_ENABLE TRUE

#define TR069_ERROR -1
#define TR069_ERR_METHOD_NOT_SUPPORT 9000
#define TR069_ERR_INTERNAL 9002
#define TR069_ERR_INVALID_ARGU 9003
#define TR069_ERR_INVALID_PARNAME 9005
#define TR069_ERR_NON_WRITE_PARNAME 9008
//--------------------------- Function declaration -----------------------
// following function implementation in tr069.c
extern mt_ret vdsl_tr069(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret get_parameter_value_vdsl(mt_uint32 instance, mt_uint32 paramid, mt_uint8 *pbuf);
extern mt_ret get_parameter_value(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret set_parameter_value(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret get_parameter_attribute(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret set_parameter_attribute(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret get_parameter_name(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf);
extern mt_ret search_method_list(mt_uint8 *name);
extern mt_ret search_com_list(mt_uint8 *name);
extern mt_ret search_num_id(mt_uint8 *buffer);
extern mt_ret com_recombin(mt_uint8 *inbuf, mt_uint32 *instance, mt_uint32 *value);
extern mt_uint8 *TR069_Methodlist[MAX_METHOD];
extern void dump_tr069(mt_uint32 instance);
                              
typedef struct {
	mt_uint8 *name;
	mt_uint8 type;//0:boolean 1:string, 2:unsignedint 3:int
	mt_uint8 write_read;
	mt_uint8 *loid;
	mt_uint8 notification;
	mt_uint8 *accesslist;
	int (*callback)(mt_uint32 instance, mt_uint32 paramid, mt_uint8 *pbuf);
} tr069_data;

enum type_def
{
	BOOLEAN = 0,
	STRING,
	UNSIGNEDINT,
	INT,
	FAULT,
	BASE64
};

extern tr069_data tr069_array[];

#endif	//_TR069_H_
