/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.34 $
* Date:         $Date: 2012-05-23 12:44:14 $
*
* Overview:
* Functions:
*
* Author:       Ian Tsao
*
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
*
* Metanoia reserves the right to change specifications without notice.
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet
* indicates this product is in design and the specification may change.
* Electrical parametrics have not been analyzed and are not specified. Do not
* use this data sheet as a design reference document. Please contact Metanoia
* for a current data sheet that may be used as a design reference. All
* contents of this document are protected by copyright law and may not be
* reproduced without the express written consent of Metanoia, Inc. Metanoia,
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.
* Other product names used in this publication are for identification purposes
* only and may be trademarks or registered trademarks of their respective
* companies. The contents of this document are provided in connection with
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that
* the information contained herein is accurate and reliable. However, Metanoia,
* Inc. makes no warranties, express or implied, as to the accuracy or
* completeness of the contents of this publication and is providing this
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to
* specifications and product descriptions at any time without notice, and to
* discontinue or make changes to its products at any time without notice.
* Metanoia, Inc. does not assume any liability arising out of the application
* or use of any product or circuit, and specifically disclaims any and all
* liability, including without limitation special, consequential, or
* incidental damages.
*
****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "dsll3.h"
#include "dslcli.h"
#include "vdsl2loid.h"
#include "tr069.h"

#define FAULT_METHOD "Method not support"
#define FAULT_INTERNALE "Internal error"
#define FAULT_INVALID_ARGU "Invalid argument"
#define FAULT_INVALID_PARNAME "Invalid parameter name"
#define FAULT_NON_WRITE_PARNAME "Attempt to set a non-writable parameter"

enum{
	WANDSLInterfaceConfigEnable = 0,
	WANDSLInterfaceConfigStatus,
	WANDSLInterfaceConfigLinkEncapsulationSupported,
	WANDSLInterfaceConfigLinkEncapsulationRequested,
	WANDSLInterfaceConfigLinkEncapsulationUsed,
	WANDSLInterfaceConfigModulationType,
	WANDSLInterfaceConfigStandardsSupported,
	WANDSLInterfaceConfigStandardUsed,
	WANDSLInterfaceConfigLineEncoding,
	WANDSLInterfaceConfigAllowedProfiles,
	WANDSLInterfaceConfigCurrentProfile,
	WANDSLInterfaceConfigPowerManagementState,
	WANDSLInterfaceConfigSuccessFailureCause,
	WANDSLInterfaceConfigLastStateTransmittedDownstream,
	WANDSLInterfaceConfigLastStateTransmittedpstream,
	WANDSLInterfaceConfigUPBOKLE,
	WANDSLInterfaceConfigMREFPSDds,
	WANDSLInterfaceConfigMREFPSDus,
	WANDSLInterfaceConfigLIMITMASK,
	WANDSLInterfaceConfigUS0MASK,
	WANDSLInterfaceConfigDataPath,
	WANDSLInterfaceConfigInterleaveDepth,
	WANDSLInterfaceConfigLPATH,
	WANDSLInterfaceConfigINTLVDEPTH,
	WANDSLInterfaceConfigINTLVBLOCK,
	WANDSLInterfaceConfigActualInterleavingDelay,
	WANDSLInterfaceConfigACTINP,
	WANDSLInterfaceConfigINPREPORT,
	WANDSLInterfaceConfigNFEC,
	WANDSLInterfaceConfigRFEC,
	WANDSLInterfaceConfigLSYMB,
	WANDSLInterfaceConfigTRELLISds,
	WANDSLInterfaceConfigTRELLISus,
	WANDSLInterfaceConfigACTSNRMODEds,
	WANDSLInterfaceConfigACTSNTMODEus,
	WANDSLInterfaceConfigVirtualNoisePSDds,
	WANDSLInterfaceConfigVirtualNoisePSDus,
	WANDSLInterfaceConfigACTUALCE,
	WANDSLInterfaceConfigLineNumber,
	WANDSLInterfaceConfigUpstreamCurrRate,
	WANDSLInterfaceConfigDownstreamCurrRate,
	WANDSLInterfaceConfigUpstreamMaxRate,
	WANDSLInterfaceConfigDownstreamMaxRate,
	WANDSLInterfaceConfigUpstreamNoiseMargin,
	WANDSLInterfaceConfigDownstreamNoiseMargin,
	WANDSLInterfaceConfigSNRMpbus,
	WANDSLInterfaceConfigSNRMpbds,
	WANDSLInterfaceConfigINMIATOds,
	WANDSLInterfaceConfigINMIATSds,
	WANDSLInterfaceConfigINMCCds,
	WANDSLInterfaceConfigINMINPEQMODEds,
	WANDSLInterfaceConfigUpstreamAttenuation,
	WANDSLInterfaceConfigDownstreamAttenuation,
	WANDSLInterfaceConfigUpstreamPower,
	WANDSLInterfaceConfigDownstreamPower,
	WANDSLInterfaceConfigATURVendor,
	WANDSLInterfaceConfigATURCountry,
	WANDSLInterfaceConfigATURANSIStd,
	WANDSLInterfaceConfigATURANSIRev,
	WANDSLInterfaceConfigATUCVendor,
	WANDSLInterfaceConfigATUCCountry,
	WANDSLInterfaceConfigATUCANSIStd,
	WANDSLInterfaceConfigATUCANSIRev,
	WANDSLInterfaceConfigTotalStart,
	WANDSLInterfaceConfigShowtimeStart,
	WANDSLInterfaceConfigLastShowtimeStart,
	WANDSLInterfaceConfigCurrentDayStart,
	WANDSLInterfaceConfigQuarterHourStart,
	WANDSLInterfaceConfigStatsTotalReceiveBlocks,
	WANDSLInterfaceConfigStatsTotalTransmitBlocks,
	WANDSLInterfaceConfigStatsTotalCellDlin,
	WANDSLInterfaceConfigStatsTotalLinkRetrain,
	WANDSLInterfaceConfigStatsTotalInitErrors,
	WANDSLInterfaceConfigStatsTotalLInit,
	WANDSLInterfaceConfigStatsTotalInitTimeouts,
	WANDSLInterfaceConfigStatsTotalLossOfFraming,
	WANDSLInterfaceConfigStatsTotalLOF,
	WANDSLInterfaceConfigStatsTotalErroredSecs,
	WANDSLInterfaceConfigStatsTotalATUCErroredSecs,
	WANDSLInterfaceConfigStatsTotalSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsTotalATUCSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsTotalFECErrors,
	WANDSLInterfaceConfigStatsTotalATUCFECErrors,
	WANDSLInterfaceConfigStatsTotalHECErrors,
	WANDSLInterfaceConfigStatsTotalATUCHECErrors,
	WANDSLInterfaceConfigStatsTotalCRCErrors,
	WANDSLInterfaceConfigStatsTotalATUCCRCErrors,
	WANDSLInterfaceConfigStatsShowtimeReceiveBlocks,
	WANDSLInterfaceConfigStatsShowtimeTransmitBlocks,
	WANDSLInterfaceConfigStatsShowtimeCellDlin,
	WANDSLInterfaceConfigStatsShowtimeLinkRetrain,
	WANDSLInterfaceConfigStatsShowtimeInitErrors,
	WANDSLInterfaceConfigStatsShowtimeLInit,
	WANDSLInterfaceConfigStatsShowtimeInitTimeouts,
	WANDSLInterfaceConfigStatsShowtimeLossOfFraming,
	WANDSLInterfaceConfigStatsShowtimeLOF,
	WANDSLInterfaceConfigStatsShowtimeErroredSecs,
	WANDSLInterfaceConfigStatsShowtimeATUCErroredSecs,
	WANDSLInterfaceConfigStatsShowtimeSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsShowtimeATUCSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsShowtimeFECErrors,
	WANDSLInterfaceConfigStatsShowtimeATUCFECErrors,
	WANDSLInterfaceConfigStatsShowtimeHECErrors,
	WANDSLInterfaceConfigStatsShowtimeATUCHECErrors,
	WANDSLInterfaceConfigStatsShowtimeCRCErrors,
	WANDSLInterfaceConfigStatsShowtimeATUCCRCErrors,
	WANDSLInterfaceConfigStatsLastShowtimeReceiveBlocks,
	WANDSLInterfaceConfigStatsLastShowtimeTransmitBlocks,
	WANDSLInterfaceConfigStatsLastShowtimeCellDlin,
	WANDSLInterfaceConfigStatsLastShowtimeLinkRetrain,
	WANDSLInterfaceConfigStatsLastShowtimeInitErrors,
	WANDSLInterfaceConfigStatsLastShowtimeLInit,
	WANDSLInterfaceConfigStatsLastShowtimeInitTimeouts,
	WANDSLInterfaceConfigStatsLastShowtimeLossOfFraming,
	WANDSLInterfaceConfigStatsLastShowtimeLOF,
	WANDSLInterfaceConfigStatsLastShowtimeErroredSecs,
	WANDSLInterfaceConfigStatsLastShowtimeATUCErroredSecs,
	WANDSLInterfaceConfigStatsLastShowtimeSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsLastShowtimeATUCSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsLastShowtimeFECErrors,
	WANDSLInterfaceConfigStatsLastShowtimeATUCFECErrors,
	WANDSLInterfaceConfigStatsLastShowtimeHECErrors,
	WANDSLInterfaceConfigStatsLastShowtimeATUCHECErrors,
	WANDSLInterfaceConfigStatsLastShowtimeCRCErrors,
	WANDSLInterfaceConfigStatsLastShowtimeATUCCRCErrors,
	WANDSLInterfaceConfigStatsCurrentDayReceiveBlocks,
	WANDSLInterfaceConfigStatsCurrentDayTransmitBlocks,
	WANDSLInterfaceConfigStatsCurrentDayCellDlin,
	WANDSLInterfaceConfigStatsCurrentDayLinkRetrain,
	WANDSLInterfaceConfigStatsCurrentDayInitErrors,
	WANDSLInterfaceConfigStatsCurrentDayLInit,
	WANDSLInterfaceConfigStatsCurrentDayInitTimeouts,
	WANDSLInterfaceConfigStatsCurrentDayLossOfFraming,
	WANDSLInterfaceConfigStatsCurrentDayLOF,
	WANDSLInterfaceConfigStatsCurrentDayErroredSecs,
	WANDSLInterfaceConfigStatsCurrentDayATUCErroredSecs,
	WANDSLInterfaceConfigStatsCurrentDaySeverelyErroredSecs,
	WANDSLInterfaceConfigStatsCurrentDayATUCSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsCurrentDayFECErrors,
	WANDSLInterfaceConfigStatsCurrentDayATUCFECErrors,
	WANDSLInterfaceConfigStatsCurrentDayHECErrors,
	WANDSLInterfaceConfigStatsCurrentDayATUCHECErrors,
	WANDSLInterfaceConfigStatsCurrentDayCRCErrors,
	WANDSLInterfaceConfigStatsCurrentDayATUCCRCErrors,
	WANDSLInterfaceConfigStatsQuarterHourReceiveBlocks,
	WANDSLInterfaceConfigStatsQuarterHourTransmitBlocks,
	WANDSLInterfaceConfigStatsQuarterHourCellDlin,
	WANDSLInterfaceConfigStatsQuarterHourLinkRetrain,
	WANDSLInterfaceConfigStatsQuarterHourInitErrors,
	WANDSLInterfaceConfigStatsQuarterHourLInit,
	WANDSLInterfaceConfigStatsQuarterHourInitTimeouts,
	WANDSLInterfaceConfigStatsQuarterHourLossOfFraming,
	WANDSLInterfaceConfigStatsQuarterHourLOF,
	WANDSLInterfaceConfigStatsQuarterHourErroredSecs,
	WANDSLInterfaceConfigStatsQuarterHourATUCErroredSecs,
	WANDSLInterfaceConfigStatsQuarterHourSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsQuarterHourATUCSeverelyErroredSecs,
	WANDSLInterfaceConfigStatsQuarterHourFECErrors,
	WANDSLInterfaceConfigStatsQuarterHourATUCFECErrors,
	WANDSLInterfaceConfigStatsQuarterHourHECErrors,
	WANDSLInterfaceConfigStatsQuarterHourATUCHECErrors,
	WANDSLInterfaceConfigStatsQuarterHourCRCErrors,
	WANDSLInterfaceConfigStatsQuarterHourATUCCRCErrors,
	WANDSLConnectionManagementConnectionServiceNumberOfEntries, 
	WANDSLConnectionManagementConnectionServiceWANConnectionDevice,
	WANDSLConnectionManagementConnectionServiceWANConnectionService,
	WANDSLConnectionManagementConnectionServiceDestinationAddress,
	WANDSLConnectionManagementConnectionServiceLinkType,
	WANDSLConnectionManagementConnectionServiceConnectionType,
	WANDSLConnectionManagementConnectionServiceName,
	WANDSLDiagnosticsLoopDiagnosticsStats,
	WANDSLDiagnosticsACTPSDds,
	WANDSLDiagnosticsACTPSDus,
	WANDSLDiagnosticsACTATPds,
	WANDSLDiagnosticsACTATPus,
	WANDSLDiagnosticsHLINSCds,
	//new
	WANDSLDiagnosticsHLINSCus,
	//new
	WANDSLDiagnosticsHLINGds,
	//new
	WANDSLDiagnosticsHLINGus,
	WANDSLDiagnosticsHLINpsds,
	//new
	WANDSLDiagnosticsHLINpsus,
	//new
	WANDSLDiagnosticsHLOGGds,
	//new
	WANDSLDiagnosticsHLOGGus,
	//new
	WANDSLDiagnosticsHLOGpsds,
	//new
	WANDSLDiagnosticsHLOGpsus,
	//new
	WANDSLDiagnosticsHLOGMTds,
	//new
	WANDSLDiagnosticsHLOGMTus,
	//new
	WANDSLDiagnosticsQLNGds,
	//new
	WANDSLDiagnosticsQLNGus,
	WANDSLDiagnosticsQLNpsds,
	//new
	WANDSLDiagnosticsQLNpsus,
	//new
	WANDSLDiagnosticsSNRGds,
	//new
	WANDSLDiagnosticsSNRGus,
	WANDSLDiagnosticsSNRpsds,
	//new
	WANDSLDiagnosticsSNRpsus,
	WANDSLDiagnosticsBITSpsds,
	//new
	WANDSLDiagnosticsBITSpsus,
	WANDSLDiagnosticsGAINSpsds,
};

//{"name",type,w_r,vdslmib}
tr069_data tr069_array[MAX_PARAMETER+1]={
{"WANDSLInterfaceConfig.Enable", BOOLEAN, READ_ENABLE | WRITE_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLInterfaceConfig.Status", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLInterfaceConfig.LinkEncapsulationSupported", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LinkEncapsulationRequested", STRING, READ_ENABLE | WRITE_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LinkEncapsulationUsed", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ModulationType", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //local support
{"WANDSLInterfaceConfig.StandardsSupported", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.StandardUsed", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,?
{"WANDSLInterfaceConfig.LineEncoding", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //local support
{"WANDSLInterfaceConfig.AllowedProfiles", STRING, READ_ENABLE, xdsl2LConfProfProfiles, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.CurrentProfile", STRING, READ_ENABLE, xdsl2LineStatusActProfile, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.PowerManagementState", STRING, READ_ENABLE, xdsl2LineStatusPwrMngState, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.SuccessFailureCause", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusInitResult, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LastStateTransmittedDownstream", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusLastStateDs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LastStateTransmittedUpstream", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusLastStateUs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.UPBOKLE", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusElectricalLength, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.MREFPSDds",BASE64, READ_ENABLE, xdsl2LineStatusMrefPsdDs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.MREFPSDus",BASE64, READ_ENABLE, xdsl2LineStatusMrefPsdUs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LIMITMASK", UNSIGNEDINT, READ_ENABLE, xdsl2LConfProfLimitMask, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.US0MASK", UNSIGNEDINT, READ_ENABLE, xdsl2LConfProfUs0Mask, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.DataPath", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLInterfaceConfig.InterleaveDepth", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},// tr098: for ADSL 1, other return 0
{"WANDSLInterfaceConfig.LPATH", UNSIGNEDINT, READ_ENABLE, xdsl2ChStatusLPath2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.INTLVDEPTH", INT, READ_ENABLE, xdsl2ChStatusIntlvDepth2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.INTLVBLOCK", INT, READ_ENABLE, xdsl2ChStatusIntlvBlock2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ActualInterleavingDelay", UNSIGNEDINT, READ_ENABLE, xdsl2ChStatusActDelay2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ACTINP", INT, READ_ENABLE, xdsl2ChStatusActInp2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.INPREPORT", BOOLEAN, READ_ENABLE, xdsl2ChStatusInpReport2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.NFEC", INT, READ_ENABLE, xdsl2ChStatusNFec2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.RFEC", INT, READ_ENABLE, xdsl2ChStatusRFec2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LSYMB", INT, READ_ENABLE, xdsl2ChStatusLSymb2, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.TRELLISds", INT, READ_ENABLE, xdsl2LineStatusTrellisDs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.TRELLISus", INT, READ_ENABLE, xdsl2LineStatusTrellisUs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ACTSNRMODEds", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusActSnrModeDs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ACTSNRMODEus", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusActSnrModeUs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.VirtualNoisePSDds",BASE64, READ_ENABLE, xdsl2LConfProfTxRefVnDs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.VirtualNoisePSDus",BASE64, READ_ENABLE, xdsl2LConfProfTxRefVnUs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.ACTUALCE", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusActualCe, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.LineNumber", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //local support, return 1
{"WANDSLInterfaceConfig.UpstreamCurrRate", UNSIGNEDINT, READ_ENABLE, xdsl2ChStatusActDataRate, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.DownstreamCurrRate", UNSIGNEDINT, READ_ENABLE, xdsl2ChStatusActDataRate2, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.UpstreamMaxRate", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusAttainableRateUs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.DownstreamMaxRate", UNSIGNEDINT, READ_ENABLE, xdsl2LineStatusAttainableRateDs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.UpstreamNoiseMargin", INT, READ_ENABLE, xdsl2LineBandStatusSnrMargin9, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.DownstreamNoiseMargin", INT, READ_ENABLE, xdsl2LineBandStatusSnrMargin10, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.SNRMpbus", STRING, READ_ENABLE, xdsl2LineBandStatusSnrMargin, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.SNRMpbds", STRING, READ_ENABLE, xdsl2LineBandStatusSnrMargin, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.INMIATOds", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,?
{"WANDSLInterfaceConfig.INMIATSds", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,?
{"WANDSLInterfaceConfig.INMCCds", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,?
{"WANDSLInterfaceConfig.INMINPEQMODEds", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,?
{"WANDSLInterfaceConfig.UpstreamAttenuation", INT, READ_ENABLE, xdsl2LineBandStatusSigAtten9, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.DownstreamAttenuation", INT, READ_ENABLE, xdsl2LineBandStatusSigAtten10, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.UpstreamPower", INT, READ_ENABLE, xdsl2LineStatusActAtpUs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.DownstreamPower", INT, READ_ENABLE, xdsl2LineStatusActAtpDs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.ATURVendor", STRING, READ_ENABLE, xdsl2LInvG994VendorId1, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data
{"WANDSLInterfaceConfig.ATURCountry", STRING, READ_ENABLE, xdsl2LInvG994VendorId1, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data
{"WANDSLInterfaceConfig.ATURANSIStd", UNSIGNEDINT, READ_ENABLE, xdsl2LInvVersionNumber1, 0, "Subscriber", get_parameter_value_vdsl}, //T1.413 revision number
{"WANDSLInterfaceConfig.ATURANSIRev", UNSIGNEDINT, READ_ENABLE, xdsl2LInvVersionNumber1, 0, "Subscriber", get_parameter_value_vdsl}, //Vendor revision number
{"WANDSLInterfaceConfig.ATUCVendor", STRING, READ_ENABLE, xdsl2LInvG994VendorId, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data
{"WANDSLInterfaceConfig.ATUCCountry", STRING, READ_ENABLE, xdsl2LInvG994VendorId, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data
{"WANDSLInterfaceConfig.ATUCANSIStd", UNSIGNEDINT, READ_ENABLE, xdsl2LInvVersionNumber, 0, "Subscriber", get_parameter_value_vdsl}, //T1.413 revision number
{"WANDSLInterfaceConfig.ATUCANSIRev", UNSIGNEDINT, READ_ENABLE, xdsl2LInvVersionNumber, 0, "Subscriber", get_parameter_value_vdsl}, //Vendor revision number
/*[ STEP 2 */
{"WANDSLInterfaceConfig.TotalStart", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.ShowtimeStart", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.LastShowtimeStart", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
/* STEP 2 ]*/
{"WANDSLInterfaceConfig.CurrentDayStart", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr1DayTimeElapsed, 0, "Subscriber", get_parameter_value_vdsl}, // CO or CPE ??
{"WANDSLInterfaceConfig.QuarterHourStart", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr15MTimeElapsed, 0, "Subscriber", get_parameter_value_vdsl}, // CO or CPE ??
/*[ STEP 2 *///yalee980518
{"WANDSLInterfaceConfig.Stats.Total.ReceiveBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.TransmitBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.CellDlin", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.LinkRetrain", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.InitErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.LInit", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.InitTimeouts", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.LossOfFraming", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.LOF", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ErroredSecs", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ATUCErroredSecs", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.SeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ATUCSeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.FECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ATUCFECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.HECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ATUCHECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.CRCErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Total.ATUCCRCErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ReceiveBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.TransmitBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.CellDlin", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.LinkRetrain", UNSIGNEDINT, READ_ENABLE, xdsl2StatsShowtimeLinkRetrain, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.InitErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsShowtimeInitErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.LInit", BOOLEAN, READ_ENABLE, xdsl2StatsShowtimeInitErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.InitTimeouts", UNSIGNEDINT, READ_ENABLE, xdsl2StatsShowtimeInitTimeouts, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.LossOfFraming", UNSIGNEDINT, READ_ENABLE, xdsl2StatsShowtimeLossOfFraming, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.LOF", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrEs01, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ATUCErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrEs0, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.SeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrSes01, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ATUCSeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrSes0, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.FECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrCorrectedBlocks01, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ATUCFECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrCorrectedBlocks0, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.HECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ATUCHECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.CRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrCodingViolation01, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.Showtime.ATUCCRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2MetanoiaOtCurrCodingViolation0, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ReceiveBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.TransmitBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.CellDlin", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.LinkRetrain", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeLinkRetrain, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.InitErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeInitErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.LInit", BOOLEAN, READ_ENABLE, xdsl2StatsLastShowtimeInitErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.InitTimeouts", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeInitTimeouts, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.LossOfFraming", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeLossOfFraming, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.LOF", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeErroredSecs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ATUCErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeATUCErroredSecs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.SeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeSeverelyErroredSecs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ATUCSeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeATUCSeverelyErroredSecs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.FECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeFECErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ATUCFECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeATUCFECErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.HECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ATUCHECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.CRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeCRCErrors, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.LastShowtime.ATUCCRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2StatsLastShowtimeATUCCRCErrors, 0, "Subscriber", get_parameter_value_vdsl},
/* STEP 2 ]*/
{"WANDSLInterfaceConfig.Stats.CurrentDay.ReceiveBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //soon
{"WANDSLInterfaceConfig.Stats.CurrentDay.TransmitBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //soon
{"WANDSLInterfaceConfig.Stats.CurrentDay.CellDlin", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.CurrentDay.LinkRetrain", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr1DayFullInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.InitErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr1DayFailedFullInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.LInit", BOOLEAN, READ_ENABLE, xdsl2PMLInitCurr1DayFailedFullInits, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.CurrentDay.InitTimeouts", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr1DayFailedShortInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.LossOfFraming", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.CurrentDay.LOF", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,not need support
{"WANDSLInterfaceConfig.Stats.CurrentDay.ErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr1DayEs1, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.ATUCErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr1DayEs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.CurrentDay.SeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr1DaySes1, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.ATUCSeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr1DaySes, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.CurrentDay.FECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr1DayCorrectedBlocks2, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.ATUCFECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr1DayCorrectedBlocks, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.HECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.CurrentDay.ATUCHECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.CurrentDay.CRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr1DayCodingViolations2, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.CurrentDay.ATUCCRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr1DayCodingViolations, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.ReceiveBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //soon
{"WANDSLInterfaceConfig.Stats.QuarterHour.TransmitBlocks", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //soon
{"WANDSLInterfaceConfig.Stats.QuarterHour.CellDlin", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.QuarterHour.LinkRetrain", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr15MFullInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.InitErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr15MFailedFullInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.LInit", BOOLEAN, READ_ENABLE, xdsl2PMLInitCurr15MFailedFullInits, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.QuarterHour.InitTimeouts", UNSIGNEDINT, READ_ENABLE, xdsl2PMLInitCurr15MFailedShortInits, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.LossOfFraming", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.QuarterHour.LOF", BOOLEAN, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //tr98,not need support
{"WANDSLInterfaceConfig.Stats.QuarterHour.ErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr15MEs1, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.ATUCErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr15MEs, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.QuarterHour.SeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr15MSes1, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.ATUCSeverelyErroredSecs", UNSIGNEDINT, READ_ENABLE, xdsl2PMLCurr15MSes, 0, "Subscriber", get_parameter_value_vdsl}, //tr98
{"WANDSLInterfaceConfig.Stats.QuarterHour.FECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr15MCorrectedBlocks2, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.ATUCFECErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr15MCorrectedBlocks, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.HECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.QuarterHour.ATUCHECErrors", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //not need support
{"WANDSLInterfaceConfig.Stats.QuarterHour.CRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr15MCodingViolations2, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLInterfaceConfig.Stats.QuarterHour.ATUCCRCErrors", UNSIGNEDINT, READ_ENABLE, xdsl2PMChCurr15MCodingViolations, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLConnectionManagement.ConnectionService.NumberOfEntries", UNSIGNEDINT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLConnectionManagement.ConnectionService.WANConnectionDevice", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLConnectionManagement.ConnectionService.WANConnectionService", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},  //mib3
{"WANDSLConnectionManagement.ConnectionService.DestinationAddress", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLConnectionManagement.ConnectionService.LinkType", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLConnectionManagement.ConnectionService.ConnectionType", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLConnectionManagement.ConnectionService.Name", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, //mib3
{"WANDSLDiagnostics.LoopDiagnosticsStats", STRING, READ_ENABLE | WRITE_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},//mib3
{"WANDSLDiagnostics.ACTPSDds", INT, READ_ENABLE, xdsl2LineStatusActPsdDs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.ACTPSDus", INT, READ_ENABLE, xdsl2LineStatusActPsdUs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.ACTATPds", INT, READ_ENABLE, xdsl2LineStatusActAtpDs, 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.ACTATPus", INT, READ_ENABLE, xdsl2LineStatusActAtpUs, 0, "Subscriber", get_parameter_value_vdsl},
/*[ STEP 2 */
{"WANDSLDiagnostics.HLINSCds", INT, READ_ENABLE, xdsl2SCStatusLinScale1, 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLINSCus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLINGds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLINGus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.HLINpsds", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl}, // xdsl2SCStatusSegmentLinReal + xdsl2SCStatusSegmentLinImg, downstream
//new
{"WANDSLDiagnostics.HLINpsus", STRING, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGGds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGGus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGpsds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGpsus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGMTds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.HLOGMTus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.QLNGds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.QLNGus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.QLNpsds", STRING, READ_ENABLE, xdsl2SCStatusSegmentQln, 0, "Subscriber", get_parameter_value_vdsl}, //downstream
//new
{"WANDSLDiagnostics.QLNpsus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.SNRGds", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
//new
{"WANDSLDiagnostics.SNRGus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.SNRpsds", STRING, READ_ENABLE, xdsl2SCStatusSegmentSnr, 0, "Subscriber", get_parameter_value_vdsl}, //downstream
//new
{"WANDSLDiagnostics.SNRpsus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.BITSpsds", STRING, READ_ENABLE, xdsl2SCStatusSegmentBitsGainAlloc, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data, downstream
//new
{"WANDSLDiagnostics.BITSpsus", INT, READ_ENABLE, "", 0, "Subscriber", get_parameter_value_vdsl},
{"WANDSLDiagnostics.GAINSpsds", STRING, READ_ENABLE, xdsl2SCStatusSegmentBitsGainAlloc, 0, "Subscriber", get_parameter_value_vdsl}, //must parse return data, downstream
/* STEP 2 ]*/
{NULL, 0, 0, NULL, 0, NULL}
};

mt_uint8 * type_string [] = {
	"boolean",
	"string",
	"unsignedint",
	"int",
	"fault",
	"base64"
};

enum{
	METHOD_SETPARVALUE = 0,
	METHOD_GETPARVALUE,
	METHOD_SETPARATTR,
	METHOD_GETPARATTR,
	METHOD_GETPARNAME
};

mt_uint8 *TR069_Methodlist[MAX_METHOD]={
	"SetParameterValues",		//0
	"GetParameterValues",		//1
	"SetParameterAttributes",	//2
	"GetParameterAttributes",	//3
	"GetParameterNames"			//4
};

mt_uint8 *PROFILES[]={"8a","8b","8c","8d","12a","12b","17a","30a"};
mt_uint8 strvalue[BUF_SIZE];
mt_uint8 attribute_load = 0;


void base64_encode(mt_uint8 * raw, mt_uint8 * base64){
	const mt_uint8 b64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	int rawlen, read, write;
	
	rawlen = strlen(raw);
	write = 0;
	
	for (read = 0; read < rawlen;){
		base64[write++] = b64[raw[read] >> 2];
		base64[write++] = b64[((raw[read] & 0x3) << 4) | (raw[read + 1] >> 4)];
		base64[write++] = (read + 1 < rawlen) ? b64[((raw[read + 1] & 0xf) << 2) | (raw[read + 2] >> 6)] : '=';
		base64[write++] = (read + 2 < rawlen) ? b64[raw[read + 2] & 0x3f] : '=';
		
		read += 3;
	}
	base64[write] = '\0';
}

mt_uint8 * get_fault_string(mt_uint32 fault)
{
	switch (fault){
		case TR069_ERR_METHOD_NOT_SUPPORT:
			return FAULT_METHOD;
		case TR069_ERR_INTERNAL:
			return FAULT_INTERNALE;
		case TR069_ERR_INVALID_ARGU:
			return FAULT_INVALID_ARGU;
		case TR069_ERR_INVALID_PARNAME:
			return FAULT_INVALID_PARNAME;
		case TR069_ERR_NON_WRITE_PARNAME:
			return FAULT_NON_WRITE_PARNAME;
		default:
			return "UNDEFINED FAULT";
	}
}


int search_method_list(mt_uint8 *name)
{
	int i = 0;

	for(i=0;i<MAX_METHOD;i++) {
		if(strstr(name, TR069_Methodlist[i]) != NULL) return i;
	}

	return TR069_ERROR;
}


mt_ret search_com_list(mt_uint8 *name)
{
	int i = 0;

	while(tr069_array[i].name != NULL) {
		if(strstr(name, tr069_array[i].name) != NULL) return i;
		i++;
	}

	//no search result
	return TR069_ERROR;
}


mt_ret search_num_id(mt_uint8* ptr)
{
	mt_uint32 i;

	for(i=0;(ptr[i])!=0;i++) {
		if (!(ptr[i] >= '0' && ptr[i] <= '9')) return 0;		//character
	}

	return 1;	//number
}


mt_ret load_tr069_attr(void)
{
	mt_ret ret = MT_OK;
	mt_uint8 command[64];
	mt_uint8 line[MAX_PARAMETER+1];
	mt_uint32 i;
	FILE *streamout;

	if(attribute_load == 1) return MT_OK;

	sprintf(command, ""CFGMGR_PATH" -r TR069_ATTR");
	if((streamout = popen(command, "r")) != NULL) {
		if(fgets(line, MAX_PARAMETER+1, streamout) != NULL) {
			stripwhite(line);
		}
		else
			ret = DSL_ERR_NOTOK;

		pclose(streamout);
	}
	else
		ret = DSL_ERR_NOTOK;

	if(ret == MT_OK) {
		for(i=0;i<MAX_PARAMETER;i++) {
			tr069_array[i].notification = line[i] - 0x30;	//convert ascii to numeric
		}

		attribute_load = 1;
	}

	return ret;
}


mt_ret store_tr069_attr(void)
{
	mt_ret ret = MT_OK;
	mt_uint8 command[64];
	mt_uint8 line[MAX_PARAMETER+1];
	mt_uint32 i;

	/*if(attribute_load == 0) {
		ret = load_tr069_attr();
		if(ret != MT_OK) return ret;
	}*/

	for(i=0;i<MAX_PARAMETER;i++) {
		line[i] = tr069_array[i].notification + 0x30;	//convert numeric to ascii
	}
	line[MAX_PARAMETER] = '\0';

	sprintf(command, ""CFGMGR_PATH" -w TR069_ATTR=%s", line);
	ret = system(command);

	return ret;
}


mt_ret com_recombin(mt_uint8 *inbuf, mt_uint32 *instance, mt_uint32 *value)
{
	mt_ret ret;
	mt_uint8 tr069_buf[BUF_SIZE], numid[10];
	mt_uint8 *ptr, *last = NULL;
	mt_uint8 first_num = 1;

	memset(numid, 0, sizeof(numid));
	strcpy(tr069_buf, inbuf);

	ptr = strtok(tr069_buf, ".");
	if(ptr == NULL) return TR069_ERROR;
	while((ptr = strtok(NULL, "."))) {
		ret = search_num_id(ptr);
		if(ret) {
			if(first_num) {
				first_num = 0;
				*instance = strtoul(ptr, NULL, 10);
			}
		}
		last = ptr;
	}
	if(last != NULL) *value = strtoul(last, NULL, 10);	//keep value for SetParameterValues method or notification for SetParameterAttributes method or nextlevel for GetParameterNames method

	if(first_num == 1) return TR069_ERROR;

	return MT_OK;
}


mt_ret get_parameter_value_vdsl(mt_uint32 instance, mt_uint32 paramid, mt_uint8 *pbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 phy_status, conn_status = FALSE;
	mt_uint32 value = 0, idx, offset;

	memset(pbuf, 0x00, 36);
	instance--;	//Port ID start from 0 but device ID start from 1

	switch(paramid) {
		case WANDSLInterfaceConfigEnable:
			ret = get_phy_status(instance, NULL, &conn_status);
			if(ret == MT_OK) {
				sprintf(pbuf, "%d", conn_status);
			}
			break;
		case WANDSLInterfaceConfigStatus:
			ret = get_phy_status(instance, &phy_status, NULL);
			if(ret != MT_OK) {
				phy_status = MT_OPSTATE_ERROR;
			}
		
			switch(phy_status) {
				case MT_OPSTATE_SHOWTIME:
				    strcpy(pbuf, "Up");
				    break;
				/*case X:
				    strcpy(pbuf, "Initializing");
				    break;*/
				case MT_OPSTATE_HANDSHAKE:
				case MT_OPSTATE_TRAINING:
				    strcpy(pbuf, "EstablishingLink");
				    break;
				case MT_OPSTATE_IDLE:
				    strcpy(pbuf, "NoSignal");
				    break;
				case MT_OPSTATE_ERROR:
					strcpy(pbuf, "Error");
				    break;
				case MT_OPSTATE_DISABLE:
					strcpy(pbuf, "Disabled");
				    break;
				default:
					strcpy(pbuf, "Error");
					break;
			}
			ret = MT_OK;
			break;
		case WANDSLInterfaceConfigLinkEncapsulationSupported:
			strcpy(pbuf, "G.993.2_Annex_K_PTM,G.994.1");
			break;
		case WANDSLInterfaceConfigLinkEncapsulationRequested:
			strcpy(pbuf, "G.993.2_Annex_K_PTM");
			break;
		case WANDSLInterfaceConfigLinkEncapsulationUsed:
			strcpy(pbuf, "G.993.2_Annex_K_PTM");
			break;
		case WANDSLInterfaceConfigModulationType:
			strcpy(pbuf, "VDSL");
			break;
		case WANDSLInterfaceConfigStandardsSupported:
			strcpy(pbuf, "G.993.2,G.993.2_Annex_A,G.993.2_Annex_B,G.993.2_Annex_C");
			break;
		case WANDSLInterfaceConfigStandardUsed:
			strcpy(pbuf, "G.993.2");
			break;
		case WANDSLInterfaceConfigLineEncoding:
			strcpy(pbuf, "DMT");
			break;
		case WANDSLInterfaceConfigAllowedProfiles:
			if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value)){
				for (idx = 0; idx < 8; idx++){
					if ((value >> idx) & 0x00000001){
						if (strlen(pbuf) != 0)
							strcat(pbuf, ",");
						strcat(pbuf, PROFILES[idx]);
					}
				}
			}else
				ret = TR069_ERR_INTERNAL;
				
			break;
		case WANDSLInterfaceConfigCurrentProfile:
			if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value)){
				for (idx = 0; idx < 8; idx++){
					if ((value >> idx) & 0x00000001)
						strcpy(pbuf, PROFILES[idx]);
				}
			}else
				ret = TR069_ERR_INTERNAL;
				
			break; 
		case WANDSLInterfaceConfigPowerManagementState:
			if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value)){
				sprintf(pbuf, "L%d", value - 1);
			}else
				ret = TR069_ERR_INTERNAL;
			break;
		case WANDSLInterfaceConfigDataPath:
			ret = get_port_mib(instance, xdsl2ChStatusActDelay, strvalue);
			if(ret != MT_OK) return TR069_ERR_INTERNAL;
			if(strcmp(strvalue, "000001") == 0) {
				ret = get_port_mib(instance, xdsl2ChStatusActDelay2, strvalue);
				if(ret != MT_OK) return TR069_ERR_INTERNAL;
				if(strcmp(strvalue, "000001") == 0) {
					strcpy(pbuf, "Fast");
				}
				else {
					strcpy(pbuf, "Interleaved");
				}
			}
			else {
				strcpy(pbuf, "Interleaved");
			}

			break;
		case WANDSLInterfaceConfigINPREPORT:
			if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value))
				sprintf(pbuf, "%d", value - 1);
			else
				ret = TR069_ERR_INTERNAL;
			break;			
		case WANDSLInterfaceConfigLineNumber:
			sprintf(pbuf, "%d", 1);
			break;
		case WANDSLInterfaceConfigInterleaveDepth:
			sprintf(pbuf, "%d", 0);	// ADSL1 Interleaved depth. This variable is only applicable to ADSL1 and only if DataPath = Interleaved. Otherwise, the value of this parameter MUST be zero.
			break;
		case WANDSLInterfaceConfigSNRMpbus:
			offset = 0;
			for (idx = 1; idx <= 5; idx++){
				if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value, idx)){
					if (value != 0x7FFFFE)
						offset += sprintf(pbuf + offset, "%d,", value);
					else
						offset += sprintf(pbuf + offset, "NA,");
				}else{
					ret = TR069_ERR_INTERNAL;
					break;
				}
			}
			if (idx == 6) pbuf[strlen(pbuf) - 1] = '\0';
			break;
		case WANDSLInterfaceConfigSNRMpbds:
			offset = 0;
			for (idx = 6; idx <= 9; idx++){
				if (MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value, idx)){
					if (value != 0x7FFFFE)
						offset += sprintf(pbuf + offset, "%d,", value);
					else
						offset += sprintf(pbuf + offset, "NA,");
				}else{
					ret = TR069_ERR_INTERNAL;
					break;
				}
			}
			if (idx == 10) pbuf[strlen(pbuf) - 1] = '\0';
			break;			
		case WANDSLInterfaceConfigATURVendor:
		case WANDSLInterfaceConfigATUCVendor:
			if (MT_OK == get_mib2_uint8(instance, tr069_array[paramid].loid, strvalue, 9, NULL))
				strcpy(pbuf, strvalue + 2);
			else
				ret = TR069_ERR_INTERNAL;
			break;
		case WANDSLInterfaceConfigATURCountry:
		case WANDSLInterfaceConfigATUCCountry:
			if (MT_OK == get_mib2_uint8(instance, tr069_array[paramid].loid, strvalue, 9, NULL))
				sprintf(pbuf, "%02x%02x", strvalue[0], strvalue[1]);
			else
				ret = TR069_ERR_INTERNAL;
			break;
		case WANDSLInterfaceConfigATURANSIStd:
		case WANDSLInterfaceConfigATURANSIRev:
		case WANDSLInterfaceConfigATUCANSIStd:
		case WANDSLInterfaceConfigATUCANSIRev:
			if (MT_OK == get_port_mib(instance, tr069_array[paramid].loid, strvalue)){
				strvalue[8] = '\0';
				strcpy(pbuf, strvalue + 2);
			}else
				ret = TR069_ERR_INTERNAL;
			break;
		case WANDSLInterfaceConfigTotalStart:
		case WANDSLInterfaceConfigShowtimeStart:
		case WANDSLInterfaceConfigLastShowtimeStart:
//yalee980518
		case WANDSLInterfaceConfigStatsTotalLinkRetrain:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLInitCurr1DayFullInits, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHistInit1DFullInits, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalInitErrors:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLInitCurr1DayFailedFullInits, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHistInit1DFailedFullInits, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalInitTimeouts:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLInitCurr1DayFailedShortInits, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHistInit1DShortInits, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalErroredSecs:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLCurr1DayEs1, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHist1DEs, pbuf, MT_INV_MAX24, MT_IDX_RT);
			break;
		case WANDSLInterfaceConfigStatsTotalATUCErroredSecs:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLCurr1DayEs, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHist1DEs, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalSeverelyErroredSecs:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLCurr1DaySes1, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHist1DSes, pbuf, MT_INV_MAX24, MT_IDX_RT);
			break;
		case WANDSLInterfaceConfigStatsTotalATUCSeverelyErroredSecs:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLCurr1DaySes, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHist1DSes, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalFECErrors:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMChCurr1DayCorrectedBlocks1, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMChHist1DCorrectedBlocks, pbuf, MT_INV_MAX24, MT_IDX_RT);
			break;
		case WANDSLInterfaceConfigStatsTotalATUCFECErrors:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMChCurr1DayCorrectedBlocks, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMChHist1DCorrectedBlocks, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsTotalCRCErrors:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMChCurr1DayCodingViolations1, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMChHist1DCodingViolations, pbuf, MT_INV_MAX24, MT_IDX_RT);
			break;
		case WANDSLInterfaceConfigStatsTotalATUCCRCErrors:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMChCurr1DayCodingViolations, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMChHist1DCodingViolations, pbuf, MT_INV_MAX24, MT_IDX_OT);
			break;
		case WANDSLInterfaceConfigStatsShowtimeLinkRetrain:
		case WANDSLInterfaceConfigStatsShowtimeInitErrors:
		case WANDSLInterfaceConfigStatsShowtimeInitTimeouts:
		case WANDSLInterfaceConfigStatsShowtimeErroredSecs:
		case WANDSLInterfaceConfigStatsShowtimeATUCErroredSecs:
		case WANDSLInterfaceConfigStatsShowtimeSeverelyErroredSecs:
		case WANDSLInterfaceConfigStatsShowtimeATUCSeverelyErroredSecs:
		case WANDSLInterfaceConfigStatsShowtimeFECErrors:
		case WANDSLInterfaceConfigStatsShowtimeATUCFECErrors:
		case WANDSLInterfaceConfigStatsShowtimeCRCErrors:
		case WANDSLInterfaceConfigStatsShowtimeATUCCRCErrors:
			if (MT_OK == get_port_mib(instance, tr069_array[paramid].loid, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsLastShowtimeLinkRetrain:
		case WANDSLInterfaceConfigStatsLastShowtimeInitErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeInitTimeouts:
		case WANDSLInterfaceConfigStatsLastShowtimeErroredSecs:
		case WANDSLInterfaceConfigStatsLastShowtimeATUCErroredSecs:
		case WANDSLInterfaceConfigStatsLastShowtimeSeverelyErroredSecs:
		case WANDSLInterfaceConfigStatsLastShowtimeFECErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeATUCFECErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeCRCErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeATUCCRCErrors:
			if (MT_OK == get_port_mib(instance, tr069_array[paramid].loid, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsTotalHECErrors:
		case WANDSLInterfaceConfigStatsTotalATUCHECErrors:
		case WANDSLInterfaceConfigStatsShowtimeHECErrors:
		case WANDSLInterfaceConfigStatsShowtimeATUCHECErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeHECErrors:
		case WANDSLInterfaceConfigStatsLastShowtimeATUCHECErrors:
		case WANDSLInterfaceConfigStatsCurrentDayHECErrors:
		case WANDSLInterfaceConfigStatsCurrentDayATUCHECErrors:
		case WANDSLInterfaceConfigStatsQuarterHourHECErrors:
		case WANDSLInterfaceConfigStatsQuarterHourATUCHECErrors:
			strcpy(pbuf, "4294967295");	//4294967295 is the maximum for it's data type
			break;
		case WANDSLInterfaceConfigStatsTotalLOF:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLCurr1DayLoss, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHist1DLoss, pbuf, MT_INV_MAX24, MT_IDX_RT);
			value = strtoul(pbuf, NULL, 16);
			if(value > 0) sprintf(pbuf, "1"); else sprintf(pbuf, "0"); 
			break;

		case WANDSLInterfaceConfigStatsShowtimeLOF:
			if (MT_OK == get_port_mib(instance, xdsl2StatsShowtimeRtLoss, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				if(value > 0) sprintf(pbuf, "1"); else sprintf(pbuf, "0"); 
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsLastShowtimeLOF:
			if (MT_OK == get_port_mib(instance, xdsl2StatsLastShowtimeRtLoss, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				if(value > 0) sprintf(pbuf, "1"); else sprintf(pbuf, "0"); 
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsCurrentDayLOF:
			if (MT_OK == get_port_mib(instance, xdsl2PMLCurr1DayLoss1, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				if(value > 0) sprintf(pbuf, "1"); else sprintf(pbuf, "0"); 
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsQuarterHourLOF:
			if (MT_OK == get_port_mib(instance, xdsl2PMLCurr15MLoss1, strvalue))
			{
				value = strtoul(strvalue+2, NULL, 16);
				if(value > 0) sprintf(pbuf, "1"); else sprintf(pbuf, "0"); 
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLInterfaceConfigStatsTotalCellDlin:
		case WANDSLInterfaceConfigStatsTotalReceiveBlocks:
		case WANDSLInterfaceConfigStatsTotalTransmitBlocks:
		case WANDSLInterfaceConfigStatsTotalLossOfFraming:
		case WANDSLInterfaceConfigStatsShowtimeCellDlin:
		case WANDSLInterfaceConfigStatsShowtimeReceiveBlocks:
		case WANDSLInterfaceConfigStatsShowtimeTransmitBlocks:
		case WANDSLInterfaceConfigStatsShowtimeLossOfFraming:
		case WANDSLInterfaceConfigStatsLastShowtimeCellDlin:
		case WANDSLInterfaceConfigStatsLastShowtimeReceiveBlocks:
		case WANDSLInterfaceConfigStatsLastShowtimeTransmitBlocks:
		case WANDSLInterfaceConfigStatsLastShowtimeLossOfFraming:
		case WANDSLInterfaceConfigStatsCurrentDayCellDlin:
		case WANDSLInterfaceConfigStatsCurrentDayReceiveBlocks:
		case WANDSLInterfaceConfigStatsCurrentDayTransmitBlocks:
		case WANDSLInterfaceConfigStatsCurrentDayLossOfFraming:
		case WANDSLInterfaceConfigStatsQuarterHourCellDlin:
		case WANDSLInterfaceConfigStatsQuarterHourReceiveBlocks:
		case WANDSLInterfaceConfigStatsQuarterHourTransmitBlocks:
		case WANDSLInterfaceConfigStatsQuarterHourLossOfFraming:
		case WANDSLDiagnosticsGAINSpsds:
			strcpy(pbuf, "DEPRECATED");	// DEPRECATED after TR-098 Amendment 2
			break;
		case WANDSLInterfaceConfigStatsTotalLInit:
			//Total = 30 day
			ret = get_port_mib(instance, xdsl2PMLInitCurr1DayFailedFullInits, strvalue);
			strcpy(pbuf, strvalue + 2);
			ret = get_port_mib_range_tr069(instance, xdsl2PMLHistInit1DFailedFullInits, pbuf, MT_INV_MAX24, MT_IDX_RT);
			break;
		case WANDSLInterfaceConfigStatsShowtimeLInit:
		case WANDSLInterfaceConfigStatsLastShowtimeLInit:
		case WANDSLInterfaceConfigStatsCurrentDayLInit:
		case WANDSLInterfaceConfigStatsQuarterHourLInit:
			if ( MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value)) {
				sprintf(pbuf, "%d", (value > 0));
			}else
				ret = TR069_ERR_INTERNAL;
			break;
		case WANDSLDiagnosticsLoopDiagnosticsStats:
			strcpy(pbuf, "None");
			break;
			//need to add below parameters
		case WANDSLDiagnosticsACTPSDds:
			if (MT_OK == get_port_mib(instance, xdsl2LineStatusActPsdDs, strvalue)) {
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLDiagnosticsACTPSDus:
			if (MT_OK == get_port_mib(instance, xdsl2LineStatusActPsdUs, strvalue)) {
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLDiagnosticsACTATPds:
			if (MT_OK == get_port_mib(instance, xdsl2LineStatusActAtpDs, strvalue)) {
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLDiagnosticsACTATPus:
			if (MT_OK == get_port_mib(instance, xdsl2LineStatusActAtpUs, strvalue)) {
				value = strtoul(strvalue+2, NULL, 16);
				sprintf(pbuf, "%d", value);
			}else{
				ret = TR069_ERR_INTERNAL;
			}
			break;
		case WANDSLDiagnosticsHLINSCds:
			//ret = generate_scstatus_output(instance, 1, "lin", "get", "tr069-");
			sprintf(pbuf, "%d", 0);
			break;
			//new
		case WANDSLDiagnosticsHLINSCus:
			sprintf(pbuf, "%d", 0);
			break;
			//new
		case WANDSLDiagnosticsHLINGds:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsHLINGus:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsHLOGGds:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsHLOGGus:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsHLOGpsds:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsHLOGpsus:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsHLOGMTds:
			sprintf(pbuf, "%d", 0);
			break;
			//new
		case WANDSLDiagnosticsHLOGMTus:
			sprintf(pbuf, "%d", 0);
			break;
		case WANDSLDiagnosticsHLINpsds:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsHLINpsus:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsQLNGds:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsQLNGus:
			sprintf(pbuf, "%d", 1);
			break;
		case WANDSLDiagnosticsQLNpsds:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsQLNpsus:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsSNRGds:
			sprintf(pbuf, "%d", 1);
			break;
			//new
		case WANDSLDiagnosticsSNRGus:
			sprintf(pbuf, "%d", 1);
			break;
		case WANDSLDiagnosticsSNRpsds:
			strcpy(pbuf, "None");
			break;
			//new
		case WANDSLDiagnosticsSNRpsus:
			strcpy(pbuf, "None");
			break;
			//need to add below parameters
		case WANDSLDiagnosticsBITSpsds:
			//new
		case WANDSLDiagnosticsBITSpsus:
			//provided by host platform
		case WANDSLConnectionManagementConnectionServiceNumberOfEntries:
		case WANDSLConnectionManagementConnectionServiceWANConnectionDevice:
		case WANDSLConnectionManagementConnectionServiceWANConnectionService:
		case WANDSLConnectionManagementConnectionServiceDestinationAddress:
		case WANDSLConnectionManagementConnectionServiceLinkType:
		case WANDSLConnectionManagementConnectionServiceConnectionType:
		case WANDSLConnectionManagementConnectionServiceName:
			//need to add below parameters
		case WANDSLInterfaceConfigINMIATOds:
		case WANDSLInterfaceConfigINMIATSds:
		case WANDSLInterfaceConfigINMCCds:
		case WANDSLInterfaceConfigINMINPEQMODEds:
			//ret = TR069_ERR_INVALID_PARNAME; // STEP 2 support
			strcpy(pbuf, "None");
			break;
		default: 
			switch (tr069_array[paramid].type){
			case BOOLEAN:
			case UNSIGNEDINT:
			case INT:
				if ( MT_OK == get_mib2_int(instance, tr069_array[paramid].loid, &value))
					sprintf(pbuf, "%d", value);
				else
					ret = TR069_ERR_INTERNAL;
				break;
			case STRING:
				if ( MT_OK != get_mib2_uint8(instance, tr069_array[paramid].loid, pbuf, BUF_SIZE, NULL))
					ret = TR069_ERR_INTERNAL;
				break;
			case BASE64:
				memset(strvalue, 0x00, BUF_SIZE);
				if (MT_OK == get_port_mib(instance, tr069_array[paramid].loid, strvalue)){
					base64_encode(strvalue+2, pbuf);
				}else
					ret = TR069_ERR_INTERNAL;
				break;
			}
		} 

	return ret;
}


mt_ret get_parameter_value(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint8 tmp[OID_MAX_LEN], tmpbuf[LARGE_BUF_SIZE];
	mt_uint32 method;
	mt_uint32 paramid, i = 0;
	mt_uint32 value, instance;

	strcpy(buffer, inbuf);
	chridx = strchr(buffer, ' ');
	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string

	// command recombination
	ret = com_recombin(buffer, &instance, &value);
	if(ret != MT_OK) {
		return TR069_ERR_INVALID_PARNAME;
	}

	memset(tmpbuf, 0, sizeof(tmpbuf));

	if(parname == NULL || strlen(parname) == 0) {	//return whole DSL-related table
		while (tr069_array[i].name != NULL) {
			memset(buffer, 0, sizeof(buffer));
			ret = (*tr069_array[i].callback)(instance, i, buffer);
			if(ret == MT_OK) {
				sprintf(tmp, "|%s@%s@", tr069_array[i].name, type_string[tr069_array[i].type]);
				strcat(tmpbuf, tmp);
				strcat(tmpbuf, buffer);
			}
			else {
				return ret;
			}

			i++;
		}
	}
	else {	//starting matching parameter name
		if(parname[strlen(parname)-1] != '.') { //input parameter name is not partial name(end without dot)
			paramid = search_com_list(parname);
			PRINTL(DBG_LVL_CLI, "paramid = %d\n", paramid);
			if(paramid == TR069_ERROR)	//input parameter name does not hit
				ret = TR069_ERR_INVALID_PARNAME;
			else {	//input parameter name hits
				memset(buffer, 0, sizeof(buffer));
				ret = (*tr069_array[paramid].callback)(instance, paramid, buffer);
				if(ret == MT_OK) {
					sprintf(tmp, "|%s@%s@", tr069_array[paramid].name, type_string[tr069_array[paramid].type]);
					strcat(tmpbuf, tmp);
					strcat(tmpbuf, buffer);

				}
				else {
					return ret;
				}
			}
		}
		else {	//input parameter name is partial name(end with dot)
			while(tr069_array[i].name != NULL) {	//return any parameter name that start with input parameter partial name
				if(strstr(tr069_array[i].name, parname) != NULL) {
					memset(buffer, 0, sizeof(buffer));
					ret = (*tr069_array[i].callback)(instance, i, buffer);
					if(ret == MT_OK) {
						sprintf(tmp, "|%s@%s@", tr069_array[i].name, type_string[tr069_array[i].type]);
						strcat(tmpbuf, tmp);
						strcat(tmpbuf, buffer);
					}
					else {
						sprintf(tmp, "|%s@%s@%d@%s", tr069_array[i].name, type_string[FAULT], ret, get_fault_string(ret));
						strcat(tmpbuf, tmp);
					}
				}

				i++;
			}
		}
	}

	sprintf(outbuf, "%s%s", parname, tmpbuf);

	return ret;
}


mt_ret set_parameter_value(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint32 method;
	mt_uint32 paramid;
	mt_uint32 value, instance;

	strcpy(buffer, inbuf);
	chridx = strchr(buffer, ' ');
	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string
	if(method != METHOD_GETPARVALUE) {	//strip argument
		chridx = strrchr(parname, '.');
		if(chridx != NULL) *chridx = '\0';
	}
	PRINTL(DBG_LVL_CLI, "parname = %s\n", parname);

	// command recombination
	ret = com_recombin(buffer, &instance, &value);
	if(ret != MT_OK) {
		return TR069_ERR_INVALID_PARNAME;
	}

	//Seach parameter List tranfer to Mapping
	paramid = search_com_list(buffer);
	PRINTL(DBG_LVL_CLI, "paramid = %d\n",paramid);
	if(paramid == TR069_ERROR) {
		return TR069_ERR_INVALID_PARNAME;
	}

	instance--;	//Port ID start from 0 but device ID start from 1

	if(tr069_array[paramid].write_read != WRITE_ENABLE) {	//write not supported
		ret = TR069_ERR_NON_WRITE_PARNAME;
	}
	else {
		switch(paramid) {
			//WANDSL
			case WANDSLInterfaceConfigEnable:
				if(value == TRUE) {	//enable link 
					ret = connect_port(instance);
				}
				else {	//FALSE, disable link
					ret = disconnect_port(instance);
				}

				if(ret != MT_OK)
					ret = TR069_ERR_INTERNAL;

				break;

			default: 
				ret = TR069_ERR_INVALID_PARNAME;
				break;
		}
	}

	sprintf(outbuf, "%s|%s@%s", parname, type_string[INT], "0");

	return ret;
}


mt_ret get_parameter_attribute(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 tmp[OID_MAX_LEN];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint8 tmpbuf[LARGE_BUF_SIZE];
	mt_uint32 paramid, i = 0;
	//mt_uint32 value, instance;

	strcpy(buffer, inbuf);
	chridx = strchr(buffer, ' ');
	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string

	// command recombination
	/*ret = com_recombin(buffer, &instance, &value);
	if(ret != MT_OK) {
		return TR069_ERR_INVALID_PARNAME;
	}*/

	//instance--;	//Port ID start from 0 but device ID start from 1

	memset(tmpbuf, 0, sizeof(tmpbuf));

	load_tr069_attr();

	if(parname == NULL || strlen(parname) == 0) {	//return whole DSL-related table
		while (tr069_array[i].name != NULL) {
			sprintf(tmp, "|%s@%d@%s", tr069_array[i].name, tr069_array[i].notification, tr069_array[i].accesslist);
			strcat(tmpbuf, tmp);
			i++;
		}
	}
	else {	//starting matching parameter name
		if(parname[strlen(parname)-1] != '.') { //input parameter name is not partial name(end without dot)
			paramid = search_com_list(parname);
			PRINTL(DBG_LVL_CLI, "paramid = %d\n", paramid);
			if(paramid == TR069_ERROR)	//input parameter name does not hit
				ret = TR069_ERR_INVALID_PARNAME;
			else	//input parameter name hits
				sprintf(tmpbuf, "|%s@%d@%s", tr069_array[paramid].name, tr069_array[paramid].notification, tr069_array[paramid].accesslist);
		}
		else {	//input parameter name is partial name(end with dot)
			while(tr069_array[i].name != NULL) {	//return any parameter name that start with input parameter partial name
				if(strstr(tr069_array[i].name, parname) != NULL) {
					sprintf(tmp, "|%s@%d@%s", tr069_array[i].name, tr069_array[i].notification, tr069_array[i].accesslist);
					strcat(tmpbuf, tmp);
				}
				i++;
			}
		}
	}

	sprintf(outbuf, "%s%s", parname, tmpbuf);

	return ret;
}


mt_ret set_parameter_attribute(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 tmp[OID_MAX_LEN], current_level[OID_MAX_LEN];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint8 *accesslist = NULL;
	mt_uint32 method;
	mt_uint32 notification;
	mt_uint32 paramid, i = 0;
	mt_uint32 instance;

	strcpy(buffer, inbuf);
	chridx = strchr(buffer, ' ');
	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string
	if(method != METHOD_GETPARVALUE) {	//strip argument
		chridx = strrchr(parname, '.');
		if(chridx != NULL) *chridx = '\0';
	}
	PRINTL(DBG_LVL_CLI, "parname = %s\n", parname);

	// command recombination
	ret = com_recombin(buffer, &instance, &notification);
	if(ret != MT_OK) {
		return TR069_ERR_INVALID_PARNAME;
	}

	//instance--;	//Port ID start from 0 but device ID start from 1

	load_tr069_attr();

	if(parname == NULL || strlen(parname) == 0) {	//apply to whole DSL-related table
		while (tr069_array[i].name != NULL) {
			tr069_array[i].notification = notification;
			//tr069_array[i].accesslist = NULL;
			i++;
		}
	}
	else {	//starting matching parameter name
		if(parname[strlen(parname)-1] != '.') { //input parameter name is not partial name(end without dot)
			paramid = search_com_list(parname);
			PRINTL(DBG_LVL_CLI, "paramid = %d\n", paramid);
			if(paramid == TR069_ERROR)	//input parameter name does not hit
				ret = TR069_ERR_INVALID_PARNAME;
			else {	//input parameter name hits
				tr069_array[paramid].notification = notification;
				//tr069_array[paramid].accesslist = NULL;
			}
		}
		else {	//input parameter name is partial name(end with dot)
			while(tr069_array[i].name != NULL) {	//apply to any parameter name that start with input parameter partial name
				if(strstr(tr069_array[i].name, parname) != NULL) {
					tr069_array[i].notification = notification;
					//tr069_array[i].accesslist = NULL;
				}
				i++;
			}
		}
	}

	store_tr069_attr();

	sprintf(outbuf, "%s", parname);

	return ret;
}


mt_ret get_parameter_name(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 tmp[OID_MAX_LEN], current_level[OID_MAX_LEN];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint8 tmpbuf[LARGE_BUF_SIZE];
	mt_uint8 *ptr;
	mt_uint32 method;
	mt_uint32 nextlevel;
	mt_uint32 paramid, i = 0;
	mt_uint32 instance;

	strcpy(buffer, inbuf);
	chridx = strchr(buffer, ' ');
	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string
	if(method != METHOD_GETPARVALUE) {	//strip argument
		chridx = strrchr(parname, '.');
		if(chridx != NULL) *chridx = '\0';
	}
	PRINTL(DBG_LVL_CLI, "parname = %s\n", parname);

	// command recombination
	ret = com_recombin(buffer, &instance, &nextlevel);
	if(ret != MT_OK) {
		return TR069_ERR_INVALID_PARNAME;
	}
	
	memset(tmpbuf, 0, sizeof(tmpbuf));

	if(parname == NULL || strlen(parname) == 0) {	//return whole DSL-related table
		while (tr069_array[i].name != NULL) {
			sprintf(tmp, "|%s@%d", tr069_array[i].name, tr069_array[i].write_read);
			strcat(tmpbuf, tmp);
			i++;
		}
	}
	else if(nextlevel == FALSE) {	//return requested parameters with nextlevel == FALSE
		if(parname[strlen(parname)-1] != '.') { //input parameter name is not partial name(end without dot)
			paramid = search_com_list(parname);
			PRINTL(DBG_LVL_CLI, "paramid = %d\n", paramid);
		    if(paramid == TR069_ERROR)	//input parameter name does not hit
		    	ret = TR069_ERR_INVALID_PARNAME;
			else	//input parameter name hits
				sprintf(tmpbuf, "|%s@%d", tr069_array[paramid].name, tr069_array[paramid].write_read);
		}
		else {	//input parameter name is partial name(end with dot)
			while(tr069_array[i].name != NULL) {	//return any parameter name that start with input parameter partial name 
				if(strstr(tr069_array[i].name, parname) != NULL) {
					sprintf(tmp, "|%s@%d", tr069_array[i].name, tr069_array[i].write_read);
					strcat(tmpbuf, tmp);
				}
				i++;
			}
		}
	}
	else {	//return requested parameters with nextlevel == TRUE
		memset(current_level, 0, OID_MAX_LEN);
		while(tr069_array[i].name != NULL) {
			if(strstr(tr069_array[i].name, parname) != NULL) {
				if(parname[strlen(parname)-1] != '.' && strchr(tr069_array[i].name+strlen(parname), '.') != NULL) { //input parameter name is not partial name(end without dot) and corresponding partial name do have next level
					ret = TR069_ERR_INVALID_PARNAME;
					break;
				}
				else if(strchr(tr069_array[i].name+strlen(parname), '.') == NULL)	{	//matched parameter has no next level
					sprintf(tmp, "|%s@%d", tr069_array[i].name, tr069_array[i].write_read);
				}
				else {		//matched parameter has next level
					if(strlen(current_level) == 0) {	//first parameter with next level 
						strcpy(current_level, tr069_array[i].name);
						ptr = strchr(current_level+strlen(parname), '.');
						if(ptr != NULL) *(ptr+1) = '\0';
						sprintf(tmp, "|%s@%d", current_level, tr069_array[i].write_read);
					}
					else {	//more parameters with next level
						if(strstr(tr069_array[i].name, current_level) == NULL) {	//check if parameter share the same next level, if no, add this partial name	
							strcpy(current_level, tr069_array[i].name);
							ptr = strchr(current_level+strlen(parname), '.');
							if(ptr != NULL) *(ptr+1) = '\0';
							sprintf(tmp, "|%s@%d", current_level, tr069_array[i].write_read);
						}
						else	//parameter share the same next level, skip
							memset(tmp, 0, OID_MAX_LEN);
					}
				}
				strcat(tmpbuf, tmp);
			}
			i++;
		}
	}

	sprintf(outbuf, "%s%s", parname, tmpbuf);

	return ret;
}


mt_ret vdsl_tr069(mt_uint8 *leading, mt_uint8 *inbuf, mt_uint8 *outbuf)
{
	mt_ret ret = MT_OK;
	mt_uint8 *chridx = NULL;
	mt_uint8 buffer[BUF_SIZE];
	mt_uint8 parname[OID_MAX_LEN];
	mt_uint32 method;
	
	strcpy(buffer, inbuf);
	PRINTL(DBG_LVL_CLI, "com_old = %s\n", buffer);
	//Seach Method List tranfer to Mapping 
	method = search_method_list(buffer);
	chridx = strchr(buffer, ' ');
	if(method == TR069_ERROR) {
		*chridx = '\0';
		sprintf(outbuf ,"%s|%s|%d|%s",buffer, type_string[FAULT], TR069_ERR_METHOD_NOT_SUPPORT, FAULT_METHOD);
		return DSL_ERR_NOTOK;
	}

	strcpy(parname, chridx + 1 + strlen(leading));	//skip leading string
	if(method != METHOD_GETPARVALUE && method != METHOD_GETPARATTR) {	//strip argument
		chridx = strrchr(parname, '.');
		if(chridx != NULL) *chridx = '\0';
	}
	PRINTL(DBG_LVL_CLI, "parname = %s\n", parname);

	switch (method) {
		case METHOD_SETPARVALUE:
			//Set Parameter Values
			ret = set_parameter_value(leading, inbuf, outbuf);
			break;
		case METHOD_GETPARVALUE:
			//Get Parameter Values
			ret = get_parameter_value(leading, inbuf, outbuf);
			break;
		case METHOD_SETPARATTR:
			//Set Parameter Attributes
			ret = set_parameter_attribute(leading, inbuf, outbuf);
			break;
		case METHOD_GETPARATTR:
			//Get Parameter Attributes
			ret = get_parameter_attribute(leading, inbuf, outbuf);
			break;
		case METHOD_GETPARNAME:
			//Get Parameter Names
			ret = get_parameter_name(leading, inbuf, outbuf);
			break;
	}
    
	if(ret != MT_OK) sprintf(outbuf, "%s|%s|%d|%s", parname, type_string[FAULT], ret, get_fault_string(ret));
	PRINTL(DBG_LVL_CLI, "ret = %s\n", outbuf);
	PRINTL(DBG_LVL_XML|DBG_LVL_OPTION, "%s", outbuf);

	return MT_OK;
}


void dump_tr069(mt_uint32 instance)
{
	int i = 0;
	mt_uint8 buf[BUF_SIZE];
	mt_ret ret;
	
	//instance--;

	while (tr069_array[i].name != NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s\n", tr069_array[i].name);
		if ((ret = (*tr069_array[i].callback)(instance, i, buf)) == MT_OK)
			PRINTL(DBG_LVL_ALWAYS, "%s\n", buf);
		else{
			switch(ret){
			case TR069_ERR_METHOD_NOT_SUPPORT:
				PRINTL(DBG_LVL_ALWAYS, "ERROR!! Method not support\n");
				break;
			case TR069_ERR_INTERNAL:
				PRINTL(DBG_LVL_ALWAYS, "ERROR!! Internal\n");
				break;
			case TR069_ERR_INVALID_ARGU:
				PRINTL(DBG_LVL_ALWAYS, "ERROR!! Invalid argument\n");
				break;
			case TR069_ERR_INVALID_PARNAME:
				PRINTL(DBG_LVL_ALWAYS, "ERROR!! Invalid parameter name\n");
				break;
			default:
				PRINTL(DBG_LVL_ALWAYS, "ERROR!! Unknown\n");
				break;
			}
		}
				
		i++;
	}
	
	PRINTL(DBG_LVL_ALWAYS, "Dump finish\n");
}


//yalee980518
mt_ret get_port_mib_range_tr069(mt_uint32 instance, mt_uint8 *loid, mt_uint8 *pbuf, mt_uint32 range, mt_uint32 side)
{
	mt_ret ret = MT_OK;
	mt_uint8 loid_tmp[64], loid_idx[8];
	mt_uint32 i, value;
	
	value = strtoul(pbuf, NULL, 16);
	for(i=1;i<=range;i++) {
		memset(loid_tmp, '\0', 64);
		memset(loid_idx, '\0', 8);

		sprintf(loid_tmp, "%s", loid);
		if( side == MT_IDX_OT) {
			strcat(loid_tmp, ".1");
		}	
		if( side == MT_IDX_RT) {
			strcat(loid_tmp, ".2");
		}	
		sprintf(loid_idx, ".%d", i);
		strcat(loid_tmp, loid_idx);
		//printf("loid_tmp %s\n",loid_tmp);
		if (MT_OK == get_port_mib(instance, loid_tmp, strvalue)) {
			value += strtoul(strvalue+2, NULL, 16);
		}
		else {
			break;
		}
	}
	sprintf(pbuf, "%d", value);

	return ret;
}
