#include <stdio.h>
#include <string.h>

#define VDSL 0
#define ADSL 1
#define INACTIVE 2
#define MT_OPSTATE_SHOWTIME 5
#define str(s) #s
#define xdslDslOpMode str(2.1.234)


extern int get_phy_status(unsigned int portid, unsigned char *phy_status, unsigned char *conn_status);
extern int get_port_mib(unsigned int portid, unsigned char *loid, unsigned char *strvalue);

int test_phy_mode(void)
{
	int ret;
	unsigned char phy_status;
	int phy_mode = INACTIVE;
	unsigned int value;
	unsigned char buf[1080];

	ret = get_phy_status(0, &phy_status, NULL);
	if(ret != 0) return phy_mode;
	if(phy_status == MT_OPSTATE_SHOWTIME) {
		ret = get_port_mib(0, xdslDslOpMode, buf);
		value = strtoul(buf+2, NULL, 16);

		if(value == 0) {
			phy_mode = VDSL;
		}
		else {
			phy_mode = ADSL;
		}
	}
	return phy_mode;
}


int main(void)
{
	int phy_mode;

	phy_mode = test_phy_mode();
	if(phy_mode == VDSL)
		printf("VDSL Mode\n");
	else if(phy_mode == ADSL)
		printf("ADSL Mode\n");
	else if(phy_mode == INACTIVE)
		printf("Inactive Mode\n");
	else
		printf("Unknow Mode\n");

	return 0;
}
