/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.40 $
* Date:         $Date: 2012-05-23 12:44:14 $
*
* Overview:     
* Functions:
*
* Author:       Yuan lee 
* 
* -- Metanoia Copyright Notice --				
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief VDSL Template Profile Manage header 
 */
#ifndef _PROFILEMGR_H_
#define _PROFILEMGR_H_

#include "list.h"//link-list header file
#include "profiledef.h"//profile manage data struct header file
#include "dsll3.h"

/*extern declare for dslcli.c */
extern int init_profile_linklist; //0:not init profile, 1:init profile
extern char port_map_linetemplate[MAX_PORTS][256];
extern char port_map_alarmtemplate[MAX_PORTS][256];
extern struct list_head vdsl_all_profile_head;

/*extern show function for dslcli.c*/
int com_profiles_vdsllinetemplate_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdsllineprofile_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslchanprofile_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslalarmtemplate_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdsllinealarmprofile_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslchanalarmprofile_show (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslexternprofile_vnshow (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslexternprofile_dpbshow (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslexternprofile_rfishow (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslexternprofile_psdshow (unsigned char * pbuf, cmdt * pcmd);
int com_profiles_vdslport_show (unsigned char * pbuf, cmdt * pcmd);

/*extern cli function from dslcli.c*/
extern mt_ret get_package_profile_name(mt_uint8 option, mt_uint16 profileid, mt_uint8 *prefix, mt_uint8 *buffer);
extern mt_ret set_package_profile_by_name(mt_uint8 portid, mt_uint8 *prefix, mt_uint8 *profile_name);

#ifdef CO_API
extern cmdt profiles_cmd[];
#endif	//CO_API
extern cmdt * commands;
extern int com_root (unsigned char * pbuf, cmdt * pcmd);
extern int com_home (unsigned char * pbuf, cmdt * pcmd); 
extern int com_help (unsigned char * pbuf, cmdt * pcmd); 
extern int exitf(unsigned char * pbuf, cmdt * pcmd);

#endif //_PROFILEMGR_H_
