/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.6 $
* Date:         $Date: 2012-07-24 11:05:38 $
*
* Overview:     
* Functions:
*
* Author:       Yuan lee 
* 
* -- Metanoia Copyright Notice --				
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief VDSL Template Profile Manage Profile Program
 */

#include <stdio.h>
#include <string.h>
#include "dsltype.h"
#include "dsll3.h"
#include "dslcli.h"
#include "list.h"//link-list header file
#include "profilemgr.h"//profile manage define header file
#include "vdsl2loid.h"


#ifdef CO_API
#ifdef TEMPLATE_PROFILE
int init_profile_linklist = 0; //0:not init profile, 1:init profile
char port_map_linetemplate[MAX_PORTS][256];
char port_map_alarmtemplate[MAX_PORTS][256];
struct vdsl_all_profile_param profile_param[VDSL_PROFILE_END_ID];
struct list_head vdsl_all_profile_head;

//Sub function
int profiles_main_vdslprofile_show (unsigned char * pbuf, cmdt * pcmd);
int profiles_main_vdslprofile_init(int type);
int free_vdsl_profiles_fun ();
int update_psd_type_profile_fun(char* profile_name, int type , char *oid, unsigned int index , unsigned int tone, float nlevel);
struct vdsl_all_profile *all_profile_search(int type, char* profile_name);

mt_uint8 pbuffer[BUF_SIZE];
/**
 * VDSL Template Profile Manage Profile Array Define 
 **/
struct mib_struct4 mib_line_profile_default[MIB_LineP_NUMBER]={
	{xdsl2BanplanSYS,"none"},
	{xdsl2BanplanBND,"none"},
	{xdsl2BanplanVNS,"none"},
	{xdsl2BanplanPSD,"none"},
	{xdsl2BanplanRFI,"none"},
	{xdsl2BanplanDpboEPsd,"none"},
        {xdsl2LConfProfProfiles,"ff"},//Multi-Profile
        {xdsl2LConfProfTargetSnrmDs,"3c"},//snr:default target is 6db ,max is 310, min is 30 :6 mibs
        {xdsl2LConfProfTargetSnrmUs,"3c"},
        {xdsl2LConfProfMaxSnrmDs,"136"},
        {xdsl2LConfProfMaxSnrmUs,"136"},
        {xdsl2LConfProfMinSnrmDs,"1e"},
        {xdsl2LConfProfMinSnrmUs,"1e"},
        {xdslTwConfig,"off"},//led
        {xdslTwConfig,"on"},//bitswap Us
        {xdslTwConfig,"on"},//bitswap Ds
        {xdsl2LConfProfUs0Disable,"allow"},//enable US0
        {xdslGhsConfOtCarrierSet,"0"},//Handshake tone config in OT side
//	{xdsl2LConfProfUpboKL,"0"},//User_UPBO:14 mibs
        {xdsl2LConfProfUpboKLF,"3"},//ensable : 1 ,disable: 3
        {xdsl2LConfProfUpboPsdA0,"fa0"},
        {xdsl2LConfProfUpboPsdB0,"0"},
//	{xdsl2LConfProfBandUpboKL0,"0"},
        {xdsl2LConfProfUpboPsdA1,"fa0"},
        {xdsl2LConfProfUpboPsdB1,"0"},
//	{xdsl2LConfProfBandUpboKL1,"0"},
        {xdsl2LConfProfUpboPsdA2,"fa0"},
        {xdsl2LConfProfUpboPsdB2,"0"},
//	{xdsl2LConfProfBandUpboKL2,"0"},
        {xdsl2LConfProfUpboPsdA3,"fa0"},
        {xdsl2LConfProfUpboPsdB3,"0"},
//	{xdsl2LConfProfBandUpboKL3,"0"},
	{xdsl2LConfProfDpboEsEL,"0"},//enable: 1 ,disable: 0 //User_DPBO:7 mibs
	{xdsl2LConfProfDpboEsCableModelA,"0"},
	{xdsl2LConfProfDpboEsCableModelB,"0"},
	{xdsl2LConfProfDpboEsCableModelC,"0"},
	{xdsl2LConfProfDpboMus,"0"},
	{xdsl2LConfProfDpboFMin,"20"},
	{xdsl2LConfProfDpboFMax,"200"},
	{xdsl2LConfProfRaModeDs,"2"},//enable:3 init:2 //User_SRA:10 mibs
	{xdsl2LConfProfRaModeUs,"2"},//enable:3 init:2
	{xdsl2LConfProfRaUsNrmDs,"46"},//70 dec
	{xdsl2LConfProfRaUsNrmUs,"46"},
	{xdsl2LConfProfRaUsTimeDs,"e10"},
	{xdsl2LConfProfRaUsTimeUs,"e10"},
	{xdsl2LConfProfRaDsNrmDs,"32"},//50 dec
	{xdsl2LConfProfRaDsNrmUs,"32"},
	{xdsl2LConfProfRaDsTimeDs,"e10"},
	{xdsl2LConfProfRaDsTimeUs,"e10"},
	{xdsl2LConfProfSnrModeDs,"1"},//1:disable 2:enable //Virtual Noise
	{xdsl2LConfProfSnrModeUs,"1"},
	{xdsl2LConfProfMaxNomAtpDs,"91"},//Tx Power
	{xdsl2LConfProfMaxNomAtpUs,"91"},
	{xdsl2LConfProfMaxNomPsdDs,"fffe93"},//Tx Power Psd
	{xdsl2LConfProfMaxNomPsdUs,"fffea7"},
	{xdsl2LineCmndAutomodeColdStart,"0"},//0:off 1:on
	{xdslGhsConfAutomodeLength,"ed8"},//default:3800
	{xdsl2LConfProfVdsl2CarMask,"0"},//0:ALL_TONE_ON 1:DISABLE_1100K_BELOW 2:DISABLE_2200K_BELOW
	{xdsl2BanplanIOT,"0"}
};

struct mib_struct4 mib_chan_profile_default[MIB_ChanP_NUMBER]={
	{xdsl2ChConfProfMinDataRateDs,"100"},
	{xdsl2ChConfProfMinDataRateUs,"100"},
	{xdsl2ChConfProfMaxDataRateDs,"18ac8"},//10164
	{xdsl2ChConfProfMaxDataRateUs,"18ac8"},
#ifdef PROFILE_DUAL_CHANNEL
	//index 2
	{xdsl2ChConfProfMinDataRateDs1,"0"},
	{xdsl2ChConfProfMinDataRateUs1,"0"},
	{xdsl2ChConfProfMaxDataRateDs1,"18ac8"},
	{xdsl2ChConfProfMaxDataRateUs1,"18ac8"},
#endif
	//impulse noise protection: 12 mibs
	{xdsl2ChConfProfMaxDelayDs,"8"},
	{xdsl2ChConfProfMaxDelayUs,"8"},
	{xdsl2ChConfProfMinProtectionDs,"4"},
	{xdsl2ChConfProfMinProtectionUs,"4"},
	{xdsl2ChConfProfMinProtection8Ds,"3"},
	{xdsl2ChConfProfMinProtection8Us,"3"}
#ifdef PROFILE_DUAL_CHANNEL
	//index 2
	{xdsl2ChConfProfMaxDelayDs1,"0"},
	{xdsl2ChConfProfMaxDelayUs1,"0"},
	{xdsl2ChConfProfMinProtectionDs1,"1"},
	{xdsl2ChConfProfMinProtectionUs1,"1"},
	{xdsl2ChConfProfMinProtection8Ds1,"1"},
	{xdsl2ChConfProfMinProtection8Us1,"1"},
#endif
};

struct mib_struct4 mib_line_alarm_profile_default[MIB_LineAlarmP_NUMBER]={
	{xdsl2LineAlarmConfProfileXtucThresh15MinFecs,"0"},//sec 0~86400
	{xdsl2LineAlarmConfProfileXtucThresh15MinEs,"0"},
	{xdsl2LineAlarmConfProfileXtucThresh15MinSes,"0"},
	{xdsl2LineAlarmConfProfileXtucThresh15MinLoss,"0"},
	{xdsl2LineAlarmConfProfileXtucThresh15MinUas,"0"},
	{xdsl2LineAlarmConfProfileXturThresh15MinFecs,"0"},
	{xdsl2LineAlarmConfProfileXturThresh15MinEs,"0"},
	{xdsl2LineAlarmConfProfileXturThresh15MinSes,"0"},
	{xdsl2LineAlarmConfProfileXturThresh15MinLoss,"0"},
	{xdsl2LineAlarmConfProfileXturThresh15MinUas,"0"},
	{xdsl2LineAlarmConfProfileThresh15MinFailedFullInt,"0"},//unsigned 32
	{xdsl2LineAlarmConfProfileThresh15MinFailedShrtInt,"0"}//12 //unsigned 32
};

struct mib_struct4 mib_chan_alarm_profile_default[MIB_ChanAlarmP_NUMBER]={
	{xdsl2ChAlarmConfProfileXtucThresh15MinCodingViolations,"0"}, //unsigned 32
	{xdsl2ChAlarmConfProfileXtucThresh15MinCorrected,"0"},
	{xdsl2ChAlarmConfProfileXturThresh15MinCodingViolations,"0"},
	{xdsl2ChAlarmConfProfileXturThresh15MinCorrected,"0"}//4
};

struct mib_struct4 mib_vn_profile_default[MIB_VN_NUMBER]={
	{xdsl2LConfProfTxRefVnDs,"none"}, 
	{xdsl2LConfProfTxRefVnUs,"none"} 
};

struct mib_struct4 mib_dpb_profile_default[MIB_DPB_NUMBER]={
	{xdsl2LConfProfDpboEPsd,"none"} 
};

struct mib_struct4 mib_rfi_profile_default[MIB_RFI_NUMBER]={
	{xdsl2LConfProfRfiBands,"none"} 
};

struct mib_struct4 mib_psd_profile_default[MIB_PSD_NUMBER]={
	{xdsl2LConfProfPsdMaskDs,"none"}, 
	{xdsl2LConfProfPsdMaskUs,"none"} 
};

struct mib_struct4 const mib_default_line_name[MIB_LineP_NUMBER]={
	{"SYS","System Profile Bandplan"},
	{"BND","Band Profile"},
	{"VNS","Virtual Noise PSD"},
	{"PSD","Power Spectral Density"},
	{"RFI","Radio Frequency Interference"},
	{"DPB","Downstream Power Backoff PSD"},
	{"profiles","xDSL Profile"},
	//snr:default target is 9db ,max is 310, min is 30 :9 mibs
        {"targetSnrmDs","Min Noise Margin the xTU-R receiver shall achieve(0.1dB)"},
        {"targetSnrmUs","Min Noise Margin the xTU-C receiver shall achieve(0.1dB)"},
        {"maxSnrmDs","Max Noise Margin the xTU-R receiver shall try to sustain(0.1dB)"},
        {"maxSnrmUs","Max Noise Margin the xTU-C receiver shall try to sustain(0.1dB)"},
       	{"minSnrmDs","Min Noise Margin the xTU-R receiver shall tolerate(0.1dB)"},
        {"minSnrmUs","Min Noise Margin the xTU-C receiver shall tolerate(0.1dB)"},
        {"led", "On/Off vdsl led slow flash of light at vdsl idle status"},
        {"bitSwapUs", "On/Off bit swapping in the upstream"},
        {"bitSwapDs", "On/Off bit swapping in the downstream"},
        {"us0disable", "Allow/Disable Upstream band number 0"},
        {"handshakeTone", "Handshake tone mode"},
	//User_UPBO:14 mibs
//	{"upboKL","UPBO electrical length"},
	{"upboKLF","UPBO force mode"},
	{"upboPsdA0","UPBO Parameter A for band 0"},
	{"upboPsdB0","UPBO Parameter B for band 0"},
//	{"bandUpboKL0","UPBO electrical length for band 0"},
	{"upboPsdA1","UPBO Parameter A for band 1"},
	{"upboPsdB1","UPBO Parameter B for band 1"},
//	{"bandUpboKL1","UPBO electrical length for band 1"},
	{"upboPsdA2","UPBO Parameter A for band 2"},
	{"upboPsdB2","UPBO Parameter B for band 2"},
//	{"bandUpboKL2","UPBO electrical length for band 2"},
	{"upboPsdA3","UPBO Parameter A for band 3"},
	{"upboPsdB3","UPBO Parameter B for band 3"},
//	{"bandUpboKL3","UPBO electrical length for band 3"},
	//User_DPBO:7 mibs
	{"dpboEsEL","The electrical length of exchange to cabinet cable"},
	{"dpboEsCableModelA","E-side cable model parameter A"},
	{"dpboEsCableModelB","E-side cable model parameter B"},
	{"dpboEsCableModelC","E-side cable model parameter C"},
	{"dpboMus","Assumed minimum usable PSD mask of exchange signals at remote site"},
	{"dpboFMin","The lower bound on the DPBO frequency span"},
	{"dpboFMax","The upper bound on the DPBO frequency span"},
	//User_SRA:10 mibs
	{"raModeDs","The mode of operation of a rate-adaptive xTU-C in the transmit direction"},
	{"raModeUs","The mode of operation of a rate-adaptive xTU-R in the transmit direction"},
	{"raUsNrmDs","Downstream up-shift Signal/Noise Margin"},
	{"raUsNrmUs","Upstream up-shift Signal/Noise Margin"},
	{"raUsTimeDs","Downstream up-shift time interval"},
	{"raUsTimeUs","Upstream up-shift  time interval"},
	{"raDsNrmDs","Downstream down-shift Signal/Noise Margin"},
	{"raDsNrmUs","Upstream down-shift Signal/Noise Margin"},
	{"raDsTimeDs","Downstream down-shift time interval"},
	{"raDsTimeUs","Upstream down-shift  time interval"},
	//virtual noise 2 mibs
	{"snrModeDs","Enable/Disable virtual noise is active on the line in the downstream"},
	{"snrModeUs","Enable/Disable virtual noise is active on the line in the upstream"},
	//Tx Power 2mibs
	{"maxNomAtpDs","Maximum nominal aggregate transmit power in the downstream"},
	{"maxNomAtpUs","Maximum nominal aggregate transmit power in the upstream"},
	{"maxNomPsdDs","Maximum nominal aggregate transmit PSD in the downstream"},
	{"maxNomPsdUs","Maximum nominal aggregate transmit PSD in the upstream"},
	{"automodeColdStart","Automode cold start forced"},
	{"automodeLength","Automode threshold"},
	{"bandConfig","All tone on or disable 1100K/2200K below"},
	{"IOT","IOT option"}
};

struct mib_struct4 const mib_default_chan_name[MIB_ChanP_NUMBER]={
	//rate limit: 8 mibs
	{"minDataRateDsCh1","Min Data Rate on Ds direction(kbps) CH1"},
	{"minDataRateUsCh1","Min Data Rate on Us direction(kbps) CH1"},
	{"maxDataRateDsCh1","Max Data Rate on Ds direction(kbps) CH1"},
	{"maxDataRateUsCh1","Max Data Rate on Us direction(kbps) CH1"},
#ifdef PROFILE_DUAL_CHANNEL
	//index 2
	{"minDataRateDsCh2","Min Data Rate on Ds direction(kbps) CH2"},
	{"minDataRateUsCh2","Min Data Rate on Us direction(kbps) CH2"},
	{"maxDataRateDsCh2","Max Data Rate on Ds direction(kbps) CH2"},
	{"maxDataRateUsCh2","Max Data Rate on Us direction(kbps) CH2"},
#endif
	//impulse noise protection: 12 mibs
	{"maxDelayDsCh1","Max Interleave Delay on Ds direction(ms) CH1"},
	{"maxDelayUsCh1","Max Interleave Delay on Us direction(ms) CH1"},
	{"minInpDsCh1","Ds min impulse noise protection in 4.3125kHz(symbol) CH1"},
	{"minInpUsCh1","Us min impulse noise protection in 4.3125kHz(symbol) CH1"},
	{"minInp8DsCh1","Ds min impulse noise protection in 8.625kHz(symbol) CH1"},
	{"minInp8UsCh1","Us min impulse noise protection in 8.625kHz(symbol) CH1"}
#ifdef PROFILE_DUAL_CHANNEL
	//index 2
	{"maxDelayDsCh2","Max Interleave Delay on Ds direction(ms) CH2"},
	{"maxDelayUsCh2","Max Interleave Delay on Us direction(ms) CH2"},
	{"minInpDsCh2","Ds min impulse noise protection in 4.3125kHz(symbol) CH2"},
	{"minInpUsCh2","Us min impulse noise protection in 4.3125kHz(symbol) CH2"},
	{"minInp8DsCh2","Ds min impulse noise protection in 8.625kHz(symbol) CH2"},
	{"minInp8UsCh2","Us min impulse noise protection in 8.625kHz(symbol) CH2"}
#endif
};

struct mib_struct4 const mib_default_line_alarm_name[MIB_LineAlarmP_NUMBER]={
	{"xtucFecs","A threshold for the Fecs counter in the current 15M interval on XTUC"},
	{"xtucEs","A threshold for the Es counter in the current 15M interval on XTUC"},
	{"xtucSes","A threshold for the Ses counter in the current 15M interval on XTUC"},
	{"xtucLoss","A threshold for the Loss counter in the current 15M interval on XTUC"},
	{"xtucUas","A threshold for the Uas counter in the current 15M interval on XTUC"},
	{"xturFecs","A threshold for the Fecs counter in the current 15M interval on XTUR"},
	{"xturEs","A threshold for the Es counter in the current 15M interval on XTUR"},
	{"xturSes","A threshold for the Ses counter in the current 15M interval on XTUR"},
	{"xturLoss","A threshold for the Loss counter in the current 15M interval on XTUR"},
	{"xturUas","A threshold for the Uas counter in the current 15M interval on XTUR"},
	{"fullInt","A threshold for the count of failed full initilizations in the current 15M interval"},
	{"shrtInt","A threshold for the count of failed short initilizations in the current 15M interval"}//12
};

struct mib_struct4 const mib_default_chan_alarm_name[MIB_ChanAlarmP_NUMBER]={
	{"cvThresXtuc","A threshold for the coding violation counter in the current 15M interval on XTUC"},
	{"correctedThresXtuc","A threshold for the corrected code word counter in the current 15M interval on XTUC"},
	{"cvThresXtur","A threshold for the coding violation counter in the current 15M interval on XTUR"},
	{"correctedThresXtur","A threshold for the corrected code word counter in the current 15M interval on XTUR"}//4
};


/**
 * VDSL Template Profile Manage Profile Sub Function
 **/
//yalee971126
//xDSL mibs tranfer to tables display
/**
 * RFI tables display function 
 * \param profile name: 
 * \param mibs: 
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int rfi_tables_display_fun(char *profile_name, char *mibs)
{
	char buff[7];
	int i = 0 ;
	char tone_c[16], nlevel_c[16];
	int startTone ,endTone;
	char port_map[MAX_PORTS];
	char portUsed[64];
	//Mibs must 192 hex

	PRINTL(DBG_LVL_ALWAYS, "RFI Config Tables: %s",profile_name);
	PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
	PRINTL(DBG_LVL_ALWAYS, "%2s  %10s %20s","Bands index"," start tone(4.3125kHz)", " end tone(4.3125kHz)");
	for ( i = 0 ; i < (PROFILE_RFI_NUM/2) ; i++){
		sprintf(buff,"%c%c%c%c%c%c",mibs[i*12],mibs[(i*12)+1],mibs[(i*12)+2],
						mibs[(i*12)+3],mibs[(i*12)+4],mibs[(i*12)+5]);
			mib_to_psd(tone_c, nlevel_c, buff);
			startTone = atoi(tone_c);//start tone

			sprintf(buff,"%c%c%c%c%c%c",mibs[(i*12)+6],mibs[(i*12)+7],mibs[(i*12)+8],
							mibs[(i*12)+9],mibs[(i*12)+10],mibs[(i*12)+11]);
			mib_to_psd(tone_c, nlevel_c, buff);
			endTone = atoi(tone_c);//end tone

			PRINTL(DBG_LVL_ALWAYS,"%10d  %10d %20d",i+1 ,startTone, endTone);
			PRINTL(DBG_LVL_XML,"%d,%d,%d|",i+1 ,startTone, endTone);
	}
	vdsl_profiles_map_port_fun (VDSL_PROFILE_RFI_ID, profile_name, port_map);
	memset(portUsed,'\0',64);
	for(i = 0 ; i < MAX_PORTS ; i++){
		if(port_map[i] == '*')
		{
			sprintf(buff,"%d,",i+1);
			strcat(portUsed, buff);
		}
	}
	if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
	PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
	PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
	PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
	return DSL_ERR_OK;
}

/**
 * PSD Mask tables display function 
 * \param profile name: 
 * \param mibs: mibs string  
 * \param mibs2: mibs2 string
 * \param type: profile type  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int psdmask_tables_display_fun(char *profile_name, char *mibs ,char *mibs2, int type)
{
	char buff[7];
	int i = 0 ;
	char tone_c[16], nlevel_c[16];
	int tone;
	float nlevel;
	char port_map[MAX_PORTS];
	char portUsed[64];
	//Mibs must 192hex

	switch(type){
		case VDSL_PROFILE_DPB_ID:
			//mibs must 192 hex
			PRINTL(DBG_LVL_ALWAYS, "DpboPsd Config Tables: %s",profile_name);
			PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
			PRINTL(DBG_LVL_ALWAYS, "%2s  %10s %20s","index"," tone(4.3125kHz)","noise_level(dBm/Hz)");
			for ( i = 0 ; i < PROFILE_DPB_NUM ; i++){
				sprintf(buff,"%c%c%c%c%c%c",mibs[i*6],mibs[(i*6)+1],mibs[(i*6)+2],
								mibs[(i*6)+3],mibs[(i*6)+4],mibs[(i*6)+5]);
				mib_to_psd(tone_c, nlevel_c, buff);
				tone = atoi(tone_c);
				nlevel = atof(nlevel_c);
				PRINTL(DBG_LVL_ALWAYS,"%2d  %10d %20.1f",i+1 ,tone ,nlevel);
				PRINTL(DBG_LVL_XML,"%d,%d,%.1f|",i+1 ,tone ,nlevel);
			}
			vdsl_profiles_map_port_fun (type, profile_name, port_map);
			memset(portUsed,'\0',64);
			for(i = 0 ; i < MAX_PORTS ; i++){
				if(port_map[i] == '*')
				{
					sprintf(buff,"%d,",i+1);
					strcat(portUsed, buff);
				}
			}
			if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
			PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
			PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
			PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
			break;
		case VDSL_PROFILE_PSD_ID:
			if(strcmp(profile_name,"DEFVAL")==0){
				PRINTL(DBG_LVL_ALWAYS, "PsdMask Config Tables: DEFVAL can't display");
				return -DSL_ERR_NOPASS;
			}
			//mibs must 240 hex
			PRINTL(DBG_LVL_ALWAYS, "PsdMask Config Tables: %s",profile_name);
			PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
			PRINTL(DBG_LVL_ALWAYS, "%2s  %10s %20s %s","index"," tone(4.3125kHz)","noise_level(dBm/Hz)","DS");
			//Ds
			for ( i = 0 ; i < PROFILE_PSD_NUM ; i++){
				sprintf(buff,"%c%c%c%c%c%c",mibs[i*6],mibs[(i*6)+1],mibs[(i*6)+2],
								mibs[(i*6)+3],mibs[(i*6)+4],mibs[(i*6)+5]);
				mib_to_psd(tone_c, nlevel_c, buff);
				tone = atoi(tone_c);
				nlevel = atof(nlevel_c);
				PRINTL(DBG_LVL_ALWAYS,"%2d  %10d %20.1f",i+1 ,tone ,nlevel);
				PRINTL(DBG_LVL_XML,"DS,%d,%d,%.1f|",i+1 ,tone ,nlevel);
			}
			//Us
			PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
			PRINTL(DBG_LVL_ALWAYS, "%2s  %10s %20s %s","index"," tone(4.3125kHz)","noise_level(dBm/Hz)","US");
			for ( i = 0 ; i < PROFILE_PSD_NUM ; i++){
				sprintf(buff,"%c%c%c%c%c%c",mibs2[i*6],mibs2[(i*6)+1],mibs2[(i*6)+2],
								mibs2[(i*6)+3],mibs2[(i*6)+4],mibs2[(i*6)+5]);
				mib_to_psd(tone_c, nlevel_c, buff);
				tone = atoi(tone_c);
				nlevel = atof(nlevel_c);
				PRINTL(DBG_LVL_ALWAYS,"%2d  %10d %20.1f",i+1 ,tone ,nlevel);
				PRINTL(DBG_LVL_XML,"US,%d,%d,%.1f|",i+1 ,tone ,nlevel);
			}

			vdsl_profiles_map_port_fun (type, profile_name, port_map);
			memset(portUsed,'\0',64);
			for(i = 0 ; i < MAX_PORTS ; i++){
				if(port_map[i] == '*')
				{
					sprintf(buff,"%d,",i+1);
					strcat(portUsed, buff);
				}
			}
			if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
			PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
			PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
			PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS,"PROFILE TYPE ERROR in psdmask_tables_display_fun");
			break;
	}
	return DSL_ERR_OK;
}

/**
 * Virtual Noise tables display function 
 * \param profile name: 
 * \param mibsDs: mibs of Down string  
 * \param mibsUs: mibs of  Up string
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int virtual_noise_tables_display_fun(char *profile_name, char *mibsDs, char *mibsUs)
{
	char buff[7];
	int i = 0 ;
	char tone_c[16], nlevel_c[16];
	int toneDs ,toneUs;
	float nlevelDs ,nlevelUs;
	char port_map[MAX_PORTS];
	char portUsed[64];
	//DsMibs must 192hex
	//UsMibs must 96Hex

	PRINTL(DBG_LVL_ALWAYS, "Vitual Noise Config Tables: %s",profile_name);
	PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
	PRINTL(DBG_LVL_ALWAYS, "%2s  %10s %20s %20s %20s","index"," VnDs_tone(4.3125kHz)","VnDs_level(dBm/Hz)","VnUs_tone(4.3125kHz)","VnUs_level(dBm/Hz)");
	for ( i = 0 ; i < PROFILE_VN_US_NUM ; i++){
		sprintf(buff,"%c%c%c%c%c%c",mibsDs[i*6],mibsDs[(i*6)+1],mibsDs[(i*6)+2],
						mibsDs[(i*6)+3],mibsDs[(i*6)+4],mibsDs[(i*6)+5]);
		vn_mib_to_psd(tone_c, nlevel_c, buff);
		toneDs = atoi(tone_c);
		if(toneDs == 0) {//yalee990223:if tone is zero nlevel show zero
			nlevelDs = 0;
		}else{
			nlevelDs = atof(nlevel_c);
		}
		sprintf(buff,"%c%c%c%c%c%c",mibsUs[i*6],mibsUs[(i*6)+1],mibsUs[(i*6)+2],
						mibsUs[(i*6)+3],mibsUs[(i*6)+4],mibsUs[(i*6)+5]);
		vn_mib_to_psd(tone_c, nlevel_c, buff);
		toneUs = atoi(tone_c);
		if(toneUs == 0) {
			nlevelUs = 0;
		}else{
			nlevelUs = atof(nlevel_c);
		}

		PRINTL(DBG_LVL_ALWAYS,"%2d  %10d %30.1f %10d %30.1f",
					i+1 ,toneDs, nlevelDs, toneUs ,nlevelUs);
		PRINTL(DBG_LVL_XML,"DS,%d,%d,%.1f|US,%d,%d,%.1f|",
					i+1 ,toneDs, nlevelDs, i+1,toneUs ,nlevelUs);

	}

	for ( i = PROFILE_VN_US_NUM ; i < PROFILE_VN_DS_NUM ; i++){
		sprintf(buff,"%c%c%c%c%c%c",mibsDs[i*6],mibsDs[(i*6)+1],mibsDs[(i*6)+2],
						mibsDs[(i*6)+3],mibsDs[(i*6)+4],mibsDs[(i*6)+5]);
		vn_mib_to_psd(tone_c, nlevel_c, buff);
		toneDs = atoi(tone_c);
		if(toneDs == 0) {
			nlevelDs = 0;
		}else{
			nlevelDs = atof(nlevel_c);
		}
		PRINTL(DBG_LVL_ALWAYS,"%2d  %10d %30.1f",i+1 ,toneDs ,nlevelDs);
		PRINTL(DBG_LVL_XML,"DS,%d,%d,%.1f|",i+1 ,toneDs ,nlevelDs);
	}

	vdsl_profiles_map_port_fun (VDSL_PROFILE_VN_ID, profile_name, port_map);
	memset(portUsed,'\0',64);
	for(i = 0 ; i < MAX_PORTS ; i++){
		if(port_map[i] == '*')
		{
			sprintf(buff,"%d,",i+1);
			strcat(portUsed, buff);
		}
	}
	if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
	PRINTL(DBG_LVL_ALWAYS, "----------------------------------------------------------------------------");
	PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
	PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
	return DSL_ERR_OK;
}

/**
 *  Vdsl all profile search function
 */
/**
 * Profile search function 
 * \param type: profile type  
 * \param profile_name: profile name  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
struct vdsl_all_profile *all_profile_search(int type, char* profile_name)
{
	struct vdsl_all_profile	*index;
        struct list_head        *next;

	//yalee990302:if not init ,init profile
	if(profile_param[type].init_profile == 0)
		profiles_main_vdslprofile_init(type);

	list_for_each_prev(next, &vdsl_all_profile_head) {
		index = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
		if((strcmp(index->profile_name, profile_name) == 0) && (index->type == type)){
			//Hit
			return index;
		}

	}
	//Not Hit
	return NULL;
} 
/**
 * Update Profile mib function 
 * \param profile_name: profile name  
 * \param type: profile type  
 * \param oid: mib oid   
 * \param command: command name    
 * \param value: update int value   
 * \param value_cc: update string value    
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int update_profile_value_fun(char* profile_name, int type, char *oid, char* command, unsigned int value, char *value_cc)
{

	struct vdsl_all_profile     *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next;
	char value_c[PROFILE_SMALL_BUF_SIZE];
	int i = 0, hit = 0;

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

	/*search link list*/
	profile_P = all_profile_search(type, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	//yalee980219 modify mark star
	profile_P->modify = '*';

	if(value_cc == NULL) sprintf(value_c,"%x",value);
	else sprintf(value_c,"%s",value_cc);

	switch(type){
		case VDSL_LINE_PROFILE_ID:
			uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_LineP_NUMBER ; i++){
				if(command != NULL){
					if(strcmp(mib_default_line_name[i].oid, command)==0){
						hit = 1;
						break;
					}
				}
				else if(oid != NULL){
					if(strcmp(mib_line_profile_default[i].oid, oid)==0){
					hit = 1;
					break;
					}
				}else{
					PRINTL(DBG_LVL_ALWAYS, "update_line_profile fail!!");
					return -DSL_ERR_NOPASS;
				}
			}
			if(hit != 1) break;

				//free old space
			if(uMibs.mibs_line->mib[i].value != NULL)
				free(uMibs.mibs_line->mib[i].value);

			uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(value_c)+1);
			if(uMibs.mibs_line->mib[i].value == NULL){
				PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
				return -DSL_ERR_NOPASS;
			}
			sprintf(uMibs.mibs_line->mib[i].value, "%s",value_c);
			break;
		case VDSL_CHAN_PROFILE_ID:
			uMibs.mibs_chan = (struct mibs_chan_struct *)profile_P->mibs;
			//free old space
			for (i = 0 ; i < MIB_ChanP_NUMBER ; i++){
				if(strcmp(mib_chan_profile_default[i].oid, oid)==0)
				{
					if(uMibs.mibs_chan->mib[i].value != NULL){
						free(uMibs.mibs_chan->mib[i].value);
					}
					uMibs.mibs_chan->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.mibs_chan->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_chan->mib[i].value, "%s",value_c);
				}
			}
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
			uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_LineAlarmP_NUMBER ; i++){
				if(strcmp(mib_line_alarm_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.mibs_line_alarm->mib[i].value != NULL){
						free(uMibs.mibs_line_alarm->mib[i].value);
					}
					uMibs.mibs_line_alarm->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.mibs_line_alarm->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line_alarm->mib[i].value, "%s",value_c);
				}
			}
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
			uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_ChanAlarmP_NUMBER ; i++){
				if(strcmp(mib_chan_alarm_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.mibs_chan_alarm->mib[i].value != NULL){
						free(uMibs.mibs_chan_alarm->mib[i].value);
					}
					uMibs.mibs_chan_alarm->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.mibs_chan_alarm->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_chan_alarm->mib[i].value, "%s",value_c);
				}
			}
			break;
		case VDSL_PROFILE_VN_ID:
			uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_VN_NUMBER ; i++)
			{
				if(strcmp(mib_vn_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.vn->mib[i].value != NULL){
						free(uMibs.vn->mib[i].value);
					}
					uMibs.vn->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.vn->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.vn->mib[i].value, "%s",value_c);
				}
			}
			break;
		case VDSL_PROFILE_DPB_ID:
			uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_DPB_NUMBER ; i++)
			{
				if(strcmp(mib_dpb_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.dpb->mib[i].value != NULL){
						free(uMibs.dpb->mib[i].value);
					}
					uMibs.dpb->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.dpb->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.dpb->mib[i].value, "%s",value_c);

				}
			}
			break;
		case VDSL_PROFILE_RFI_ID:
			uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_RFI_NUMBER ; i++)
			{
				if(strcmp(mib_rfi_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.rfi->mib[i].value != NULL){
						free(uMibs.rfi->mib[i].value);
					}
					uMibs.rfi->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.rfi->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.rfi->mib[i].value, "%s",value_c);

				}
			}
			break;
		case VDSL_PROFILE_PSD_ID:
			uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_PSD_NUMBER ; i++)
			{
				if(strcmp(mib_psd_profile_default[i].oid, oid)==0)
				{
					//free old space
					if(uMibs.psd->mib[i].value != NULL){
						free(uMibs.psd->mib[i].value);
					}
					uMibs.psd->mib[i].value = (char*)malloc(strlen(value_c)+1);
					if(uMibs.psd->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.psd->mib[i].value, "%s",value_c);

				}
			}
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in update_profile_value_fun!!");
			break;
	}
	//global value save flag
	profile_param[type].modify_vdsl_profile = 1;


		return DSL_ERR_OK;
}

/**
 * Update Profile PSD function 
 * \param profile_name: profile name  
 * \param type: profile type  
 * \param oid: mib oid   
 * \param index: psd index    
 * \param tone: psd tone   
 * \param nlevel: noise level    
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int update_psd_type_profile_fun(char* profile_name, int type , char *oid, unsigned int index , unsigned int tone, float nlevel)
{
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	char buff[7],tone_c[32],nlevel_c[32];
	int i = 0 , j = 0 ,mib_index = 0;

	profile_P = all_profile_search(type, profile_name);
	if(profile_P == NULL){
		if(type == VDSL_PROFILE_VN_ID)
			PRINTL(DBG_LVL_ALWAYS, "%s Vatual Noise No Exist",profile_name);
		if(type == VDSL_PROFILE_DPB_ID)
			PRINTL(DBG_LVL_ALWAYS, "%s DpboEPsd No Exist",profile_name);
		if(type == VDSL_PROFILE_RFI_ID)
			PRINTL(DBG_LVL_ALWAYS, "%s RFI No Exist",profile_name);
		if(type == VDSL_PROFILE_PSD_ID)
			PRINTL(DBG_LVL_ALWAYS, "%s PSD No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}
	if(index < 1 )
	{
		PRINTL(DBG_LVL_ALWAYS, "index value must over one in update_psd_type_profile_fun");
		return -DSL_ERR_NOPASS;
	}

	//1 mibs = 6 char
	mib_index = ( index - 1 ) * 6;
	sprintf(tone_c,"%d",tone);
	sprintf(nlevel_c,"%.4f",nlevel);
	profile_P->modify = '*';
	profile_param[type].modify_vdsl_profile = 1;
	switch(type){
		case VDSL_PROFILE_VN_ID:
			vn_psd_to_mib(tone_c, nlevel_c, buff);
			uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_VN_NUMBER ; i++){
				if(strcmp(uMibs.vn->mib[i].oid ,oid)==0)
				break;
			}
			for (j = 0 ; j < 6; j++){
				uMibs.vn->mib[i].value[mib_index + j] = buff[j];
			}
			break;
		case VDSL_PROFILE_DPB_ID:
			psd_to_mib(tone_c, nlevel_c, buff);
			uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_DPB_NUMBER ; i++){
				if(strcmp(uMibs.dpb->mib[i].oid ,oid)==0)
				break;
			}
			for (j = 0 ; j < 6; j++){
				uMibs.dpb->mib[i].value[mib_index + j] = buff[j];
			}
			break;
		case VDSL_PROFILE_RFI_ID:
			psd_to_mib(tone_c, nlevel_c, buff);
			uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_RFI_NUMBER ; i++){
				if(strcmp(uMibs.rfi->mib[i].oid ,oid)==0)
				break;
			}
			for (j = 0 ; j < 6; j++){
				uMibs.rfi->mib[i].value[mib_index + j] = buff[j];
			}
			break;
		case VDSL_PROFILE_PSD_ID:
			psd_to_mib(tone_c, nlevel_c, buff);
			uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
			for(i = 0 ; i < MIB_PSD_NUMBER ; i++){
				if(strcmp(uMibs.psd->mib[i].oid ,oid)==0)
				break;
			}
			for (j = 0 ; j < 6; j++){
				uMibs.psd->mib[i].value[mib_index + j] = buff[j];
			}
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in update_psd_type_profile_fun!!");
			break;

	}
	return DSL_ERR_OK;
}

/**
 * Sort prefix number of Profile
 * \param type: profile type  
 * \param prefix: prefix of profile  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int sort_vdsl_profiles_fun(int type, char* prefix)
{
	char vdsl_profile_id_array[65535];
	char command[256];
	struct vdsl_all_profile     *profile_P;
	struct list_head        *next;
	unsigned int i = 0;
	int ret = 0;

	memset(vdsl_profile_id_array,'\0',sizeof(vdsl_profile_id_array));

	list_for_each_prev(next, &vdsl_all_profile_head) {
		profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
		if(profile_P->type == type)
		vdsl_profile_id_array[profile_P->vdsl_profile_id - 1] = '*';
	}

	list_for_each_prev(next, &vdsl_all_profile_head) {
		profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
		if(profile_P->type != type) continue;
		//if(profile_P->vdsl_profile_id > init_main_profile_number)
		if(profile_P->vdsl_profile_id > profile_param[type].init_profile_number){
			while(vdsl_profile_id_array[i] == '*'){
				i++;
				if(i >= 65535)
				break;
			}
			if(i >= 65535)
			break;

			if(vdsl_profile_id_array[i] != '*'){
				vdsl_profile_id_array[i] = '*';
				//**delete old vdsl_profile start**//
				//sprintf(command, ""CFGMGR_PATH" -d VdslMainProfiles%d",profile_P->vdsl_profile_id);
				sprintf(command, ""CFGMGR_PATH" -d %s%d",prefix,profile_P->vdsl_profile_id);
				ret = system(command);
				//**free this seat**//
				vdsl_profile_id_array[profile_P->vdsl_profile_id - 1] = '\0';
				//**delete old vdsl_profile end**//
				profile_P->vdsl_profile_id = i + 1;
				profile_P->modify = '*';
			}
		}
	}
	//save?
	//com_profiles_vdslprofile_save (NULL, NULL);

	return DSL_ERR_OK;
}

/**
 * Save Profile function
 * \param type: profile type  
 * \param prefix_index: prefix index of profile  
 * \param prefix: prefix of profile  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int save_vdsl_profiles_fun (int type, char *prefix_index, char *prefix)
{
	int i = 0 , ret;
	char command[PROFILE_LARGE_BUF_SIZE];
	char write_buff[PROFILE_LARGE_BUF_SIZE];
	char profile_index[PROFILE_LARGE_BUF_SIZE], tmp[256];
	struct vdsl_all_profile     *profile_P;     //profile point
	union union_mibs_struct uMibs;
	struct list_head        *next;
	int len = 0;


   	if(list_empty(&vdsl_all_profile_head) == 1) {
       		return DSL_ERR_OK;
        }


	memset(profile_index, '\0', sizeof(char)*PROFILE_LARGE_BUF_SIZE);
	memset(write_buff, '\0', sizeof(char)*PROFILE_LARGE_BUF_SIZE);
	list_for_each_prev(next, &vdsl_all_profile_head) {
               	profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
		if(profile_P->type != type) continue;
       		 /*print profile context*/
		sprintf(tmp,"%d@",profile_P->vdsl_profile_id);
		strcat(profile_index, tmp);

		//**yalee980219:if not modified ,need save**//
		if(profile_P->modify != '*') continue;

		strcat(write_buff, profile_P->profile_name);

		switch (type){
			case VDSL_PROFILE_ID:
			case VDSL_LINE_TEMPLATE_ID:
			case VDSL_ALARM_TEMPLATE_ID:
		 		uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				/*paser symbol use @*/
				strcat(write_buff,"@");
				/*strcat all oid value then write to board.conf*/
				strcat(write_buff, uMibs.mibs_member->vdsl_line_name);
				strcat(write_buff,"@");
				strcat(write_buff, uMibs.mibs_member->vdsl_chan_name);
				break;
			case VDSL_LINE_PROFILE_ID:
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
				for (i = 0 ; i < MIB_LineP_NUMBER ; i++)
				{
					len += strlen(uMibs.mibs_line->mib[i].value);
					if ( len + MIB_LineP_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}

					/*paser symbol use @*/
					strcat(write_buff,"@");
					/*strcat all oid value then write to board.conf*/
					strcat(write_buff, uMibs.mibs_line->mib[i].value);
				}
				break;
			case VDSL_CHAN_PROFILE_ID:
				uMibs.mibs_chan = (struct mibs_chan_struct *)profile_P->mibs;
				for (i = 0 ; i < MIB_ChanP_NUMBER ; i++)
				{
					len += strlen(uMibs.mibs_chan->mib[i].value);
					if ( len + MIB_ChanP_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}

					/*paser symbol use @*/
					strcat(write_buff,"@");
					/*strcat all oid value then write to board.conf*/
					strcat(write_buff, uMibs.mibs_chan->mib[i].value);
				}
				break;
			case VDSL_LINE_ALARM_PROFILE_ID:
				uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)profile_P->mibs;
				for (i = 0 ; i < MIB_LineAlarmP_NUMBER ; i++)
				{
					len += strlen(uMibs.mibs_line_alarm->mib[i].value);
					if ( len + MIB_LineAlarmP_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}

					/*paser symbol use @*/
					strcat(write_buff,"@");
					/*strcat all oid value then write to board.conf*/
					strcat(write_buff, uMibs.mibs_line_alarm->mib[i].value);
				}
				break;
			case VDSL_CHAN_ALARM_PROFILE_ID:
				uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)profile_P->mibs;
				for (i = 0 ; i < MIB_ChanAlarmP_NUMBER ; i++)
				{
					len += strlen(uMibs.mibs_chan_alarm->mib[i].value);
					if ( len + MIB_ChanAlarmP_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}

					/*paser symbol use @*/
					strcat(write_buff,"@");
					/*strcat all oid value then write to board.conf*/
					strcat(write_buff, uMibs.mibs_chan_alarm->mib[i].value);
				}
				break;
			case VDSL_PROFILE_VN_ID:
				uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
				for(i = 0 ; i < MIB_VN_NUMBER ; i++)
				{
					len += strlen(uMibs.vn->mib[i].value);
					if ( len + MIB_VN_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}
					/*paser symbol use @*/
					strcat(write_buff,"@");
					strcat(write_buff, uMibs.vn->mib[i].value);

				}
				break;
			case VDSL_PROFILE_DPB_ID:
				uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
				for(i = 0 ; i < MIB_DPB_NUMBER ; i++)
				{
					len += strlen(uMibs.dpb->mib[i].value);
					if ( len + MIB_DPB_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}
					/*paser symbol use @*/
					strcat(write_buff,"@");
					strcat(write_buff, uMibs.dpb->mib[i].value);

				}
				break;
			case VDSL_PROFILE_RFI_ID:
				uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
				for(i = 0 ; i < MIB_RFI_NUMBER ; i++)
				{
					len += strlen(uMibs.rfi->mib[i].value);
					if ( len + MIB_RFI_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}
					/*paser symbol use @*/
					strcat(write_buff,"@");
					strcat(write_buff, uMibs.rfi->mib[i].value);

				}
				break;
			case VDSL_PROFILE_PSD_ID:
				uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
				for(i = 0 ; i < MIB_PSD_NUMBER ; i++)
				{
					len += strlen(uMibs.psd->mib[i].value);
					if ( len + MIB_PSD_NUMBER > PROFILE_LARGE_BUF_SIZE ){
						PRINTL(DBG_LVL_ALWAYS, "length over buffer size (4096) ,save not complete");
						break;
					}
					/*paser symbol use @*/
					strcat(write_buff,"@");
					strcat(write_buff, uMibs.psd->mib[i].value);

				}
				break;
			default:
				PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in save_vdsl_profiles_fun!!");
			break;

		}

			/*save link-list context to board.conf*/
		//sprintf(command, ""CFGMGR_PATH" -w VdslMainProfiles%d=%s", profile_P->vdsl_profile_id, write_buff);
		sprintf(command, ""CFGMGR_PATH" -w %s%d=%s", prefix, profile_P->vdsl_profile_id, write_buff);
		ret = system(command);
		profile_P->modify = 'X';
		memset(write_buff, '\0', sizeof(char)*PROFILE_LARGE_BUF_SIZE);
		len = 0;

	}

	//if vdsl_profile_id not last one use @
	profile_index[strlen(profile_index) - 1] = '\0';
	sprintf(command, ""CFGMGR_PATH" -w %s=%s", prefix_index, profile_index);
	ret = system(command);

	return DSL_ERR_OK;
}

/**
 * Add new Profile function
 * \param type: profile type  
 * \param prefix_index: prefix index of profile  
 * \param prefix: prefix of profile  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int new_vdsl_profiles_fun (int type, char *profile_name)
{
	mt_ret ret = DSL_ERR_NOPASS;
	struct vdsl_all_profile *new;
	union union_mibs_struct uMibs;
	char tmp[128];
	int i = 0;

	new = all_profile_search(type , profile_name);
	if(new != NULL){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "%s Profile Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	//if new VirtualNoise DpboEPsd Rfi profile name in firmware package return
	if(type == VDSL_PROFILE_VN_ID ){
		ret = syspackage_checkid_fun(VNS_PREFIX, profile_name);
	}
	else if (type == VDSL_PROFILE_DPB_ID){
		ret = syspackage_checkid_fun(DPB_PREFIX, profile_name);
	}
	else if (type == VDSL_PROFILE_RFI_ID){
		ret = syspackage_checkid_fun(RFI_PREFIX, profile_name);
	}
	else if (type == VDSL_PROFILE_PSD_ID){
		ret = syspackage_checkid_fun(PSD_PREFIX, profile_name);
	}

	if(ret == DSL_ERR_OK) {
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "%s Profile Exist in System package",profile_name);
		return -DSL_ERR_NOPASS;
	}


	new = (struct vdsl_all_profile *)malloc(sizeof(struct vdsl_all_profile));
	if(new == NULL){
		PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
		return -DSL_ERR_NOPASS;
	}

	sprintf(new->profile_name, "%s",profile_name);
	new->modify = '*';
	new->type = type;

	//total profile number add 1
	profile_param[type].max_vdsl_profile_id += 1;
	new->vdsl_profile_id = profile_param[type].max_vdsl_profile_id;
	profile_param[type].init_profile_number++;
	//global value save flag
	profile_param[type].modify_vdsl_profile = 1;
	switch(type){
		case VDSL_PROFILE_ID:
		case VDSL_LINE_TEMPLATE_ID:
		case VDSL_ALARM_TEMPLATE_ID:
			uMibs.mibs_member = (struct mibs_member_struct *)malloc(sizeof(struct mibs_member_struct));
			sprintf(uMibs.mibs_member->vdsl_line_name, "DEFVAL");
			sprintf(uMibs.mibs_member->vdsl_chan_name, "DEFVAL");
			new->mibs = uMibs.mibs_member;
			break;
		case VDSL_LINE_PROFILE_ID:
			uMibs.mibs_line = (struct mibs_line_struct *)malloc(sizeof(struct mibs_line_struct));
			//**copy mib_default oid to new profile struct **//
			for(i = 0 ; i < MIB_LineP_NUMBER; i++){
				sprintf(uMibs.mibs_line->mib[i].oid ,"%s",mib_line_profile_default[i].oid);

				if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanSYS) == 0){
					get_package_profile_name(0,1, SYS_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanBND) == 0){
					get_package_profile_name(0,1, BND_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);

				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanVNS) == 0){
					get_package_profile_name(0,1, VNS_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);

				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanPSD) == 0){
					get_package_profile_name(0,1, PSD_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);

				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanRFI) == 0){
					get_package_profile_name(0,1, RFI_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);

				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanDpboEPsd) == 0){
					get_package_profile_name(0,1, DPB_PREFIX,tmp);
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(tmp)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					sprintf(uMibs.mibs_line->mib[i].value, "%s",tmp);

				}
				else{
					//yalee980715 copy default profile's value to new profile's value
					uMibs.mibs_line->mib[i].value = (char*)malloc(strlen(mib_line_profile_default[i].value)+1);
					if(uMibs.mibs_line->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}

					//yalee980715 copy default profile's value to new profile's value
					sprintf(uMibs.mibs_line->mib[i].value, "%s",mib_line_profile_default[i].value);
				}
			}
			//save mibs address to void pointer
			new->mibs = uMibs.mibs_line;
			break;
		case VDSL_CHAN_PROFILE_ID:
			uMibs.mibs_chan = (struct mibs_chan_struct *)malloc(sizeof(struct mibs_chan_struct));
			for(i = 0 ; i < MIB_ChanP_NUMBER; i++){
				sprintf(uMibs.mibs_chan->mib[i].oid , "%s",mib_chan_profile_default[i].oid);

				//yalee980715 copy default profile's value to new profile's value
				uMibs.mibs_chan->mib[i].value = (char*)malloc(strlen(mib_chan_profile_default[i].value)+1);
				if(uMibs.mibs_chan->mib[i].value == NULL){
					PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
					return -DSL_ERR_NOPASS;
				}

				//yalee980715 copy default profile's value to new profile's value
				sprintf(uMibs.mibs_chan->mib[i].value, "%s",mib_chan_profile_default[i].value);
			}
			new->mibs = uMibs.mibs_chan;
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
			uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)malloc(sizeof(struct mibs_line_alarm_struct));
			for(i = 0 ; i < MIB_LineAlarmP_NUMBER; i++){
				sprintf(uMibs.mibs_line_alarm->mib[i].oid , "%s",mib_line_alarm_profile_default[i].oid);
				//yalee980715 copy default profile's value to new profile's value
				uMibs.mibs_line_alarm->mib[i].value = (char*)malloc(strlen(mib_line_alarm_profile_default[i].value)+1);
				if(uMibs.mibs_line_alarm->mib[i].value == NULL){
					PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
					return -DSL_ERR_NOPASS;
				}

				//yalee980715 copy default profile's value to new profile's value
				sprintf(uMibs.mibs_line_alarm->mib[i].value, "%s",mib_line_alarm_profile_default[i].value);
			}
			new->mibs = uMibs.mibs_line_alarm;
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
			uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)malloc(sizeof(struct mibs_chan_alarm_struct));
			for(i = 0 ; i < MIB_ChanAlarmP_NUMBER; i++){
				sprintf(uMibs.mibs_chan_alarm->mib[i].oid , "%s",mib_chan_alarm_profile_default[i].oid);

				//yalee980715 copy default profile's value to new profile's value
				uMibs.mibs_chan_alarm->mib[i].value = (char*)malloc(strlen(mib_chan_alarm_profile_default[i].value)+1);
				if(uMibs.mibs_chan_alarm->mib[i].value == NULL){
					PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
					return -DSL_ERR_NOPASS;
				}

				//yalee980715 copy default profile's value to new profile's value
				sprintf(uMibs.mibs_chan_alarm->mib[i].value, "%s",mib_chan_alarm_profile_default[i].value);
			}
			new->mibs = uMibs.mibs_chan_alarm;
			break;
		case VDSL_PROFILE_VN_ID:
			uMibs.vn = (struct mibs_VN_struct *)malloc(sizeof(struct mibs_VN_struct));
			for(i = 0 ; i < MIB_VN_NUMBER; i++){
				sprintf(uMibs.vn->mib[i].oid , "%s",mib_vn_profile_default[i].oid);

				if(strcmp(uMibs.vn->mib[i].oid, xdsl2LConfProfTxRefVnDs) == 0){
					uMibs.vn->mib[i].value = (char *)malloc(PROFILE_VN_DS_NUM*6+1);
					if(uMibs.vn->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					memset(uMibs.vn->mib[i].value,'0',PROFILE_VN_DS_NUM*6);
					uMibs.vn->mib[i].value[PROFILE_VN_DS_NUM*6] = '\0';
				}
				else if(strcmp(uMibs.vn->mib[i].oid, xdsl2LConfProfTxRefVnUs) == 0){
					uMibs.vn->mib[i].value = (char *)malloc(PROFILE_VN_US_NUM*6+1);
					if(uMibs.vn->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					memset(uMibs.vn->mib[i].value,'0',PROFILE_VN_US_NUM*6);
					uMibs.vn->mib[i].value[PROFILE_VN_US_NUM*6] = '\0';
				}
				else{
					//yalee980715 copy default profile's value to new profile's value
					uMibs.vn->mib[i].value = (char*)malloc(strlen(mib_vn_profile_default[i].value)+1);
					if(uMibs.vn->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					//yalee980715 copy default profile's value to new profile's value
					sprintf(uMibs.vn->mib[i].value, "%s",mib_vn_profile_default[i].value);
				}

			}
			new->mibs = uMibs.vn;
			break;
		case VDSL_PROFILE_DPB_ID:
			uMibs.dpb = (struct mibs_DPB_struct *)malloc(sizeof(struct mibs_DPB_struct));
			for(i = 0 ; i < MIB_DPB_NUMBER; i++){
				sprintf(uMibs.dpb->mib[i].oid , "%s",mib_dpb_profile_default[i].oid);
				if(strcmp(uMibs.dpb->mib[i].oid, xdsl2LConfProfDpboEPsd) == 0){
					uMibs.dpb->mib[i].value = (char *)malloc(PROFILE_DPB_NUM*6+1);
					if(uMibs.dpb->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					memset(uMibs.dpb->mib[i].value,'0',PROFILE_DPB_NUM*6);
					uMibs.dpb->mib[i].value[PROFILE_DPB_NUM*6] = '\0';
				}
				else{
					//yalee980715 copy default profile's value to new profile's value
					uMibs.dpb->mib[i].value = (char*)malloc(strlen(mib_dpb_profile_default[i].value)+1);
					if(uMibs.dpb->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					//yalee980715 copy default profile's value to new profile's value
					sprintf(uMibs.dpb->mib[i].value, "%s",mib_dpb_profile_default[i].value);
				}
			}
			new->mibs = uMibs.dpb;
			break;
		case VDSL_PROFILE_RFI_ID:
			uMibs.rfi = (struct mibs_RFI_struct *)malloc(sizeof(struct mibs_RFI_struct));
			for(i = 0 ; i < MIB_RFI_NUMBER; i++){
				sprintf(uMibs.rfi->mib[i].oid ,"%s",mib_rfi_profile_default[i].oid);
					uMibs.rfi->mib[i].value = (char *)malloc(PROFILE_RFI_NUM*6+1);
					if(uMibs.rfi->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					memset(uMibs.rfi->mib[i].value,'0',PROFILE_RFI_NUM*6);
					uMibs.rfi->mib[i].value[PROFILE_RFI_NUM*6] = '\0';
			}
			new->mibs = uMibs.rfi;
			break;
		case VDSL_PROFILE_PSD_ID:
			uMibs.psd = (struct mibs_PSD_struct *)malloc(sizeof(struct mibs_PSD_struct));
			for(i = 0 ; i < MIB_PSD_NUMBER; i++){
				sprintf(uMibs.psd->mib[i].oid ,"%s",mib_psd_profile_default[i].oid);
					uMibs.psd->mib[i].value = (char *)malloc(PROFILE_PSD_NUM*6+1);
					if(uMibs.psd->mib[i].value == NULL){
						PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
						return -DSL_ERR_NOPASS;
					}
					memset(uMibs.psd->mib[i].value,'0',PROFILE_PSD_NUM*6);
					uMibs.psd->mib[i].value[PROFILE_PSD_NUM*6] = '\0';
			}
			new->mibs = uMibs.psd;
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in new_vdsl_profiles_fun!!");
			break;
	}
		list_add(&new->list, &vdsl_all_profile_head);

	return DSL_ERR_OK;
}

/**
 * Delete Profile function
 * \param type: profile type  
 * \param prefix_index: prefix index of profile  
 * \param prefix: prefix of profile  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int del_vdsl_profiles_fun (int type, char *profile_name , char *prefix)
{
	mt_ret ret;
	struct vdsl_all_profile *del;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char command[256];
	int i = 0;

	//del check,must not profile used ,can delete
	list_for_each_safe(next, tmp, &vdsl_all_profile_head){
		del = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
		if((strcmp(del->profile_name, profile_name) == 0) && (del->type == type)){
			//Hit
			break;
		}else{
			del = NULL;
		}
	}

	if(del == NULL){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "%s User defined Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	list_del(next);
	sprintf(command, ""CFGMGR_PATH" -d %s%d", prefix, del->vdsl_profile_id);
	ret = system(command);
	switch(type){
		case VDSL_PROFILE_ID:
		case VDSL_LINE_TEMPLATE_ID:
		case VDSL_ALARM_TEMPLATE_ID:
			uMibs.mibs_member = (struct mibs_member_struct *)del->mibs;
			free(uMibs.mibs_member);
			break;
		case VDSL_LINE_PROFILE_ID:
			uMibs.mibs_line = (struct mibs_line_struct *)del->mibs;
			for (i = 0; i < MIB_LineP_NUMBER ; i++ )
			{
				if (uMibs.mibs_line->mib[i].value != NULL){
					free(uMibs.mibs_line->mib[i].value);
				}
			}
			free(uMibs.mibs_line);
			break;
		case VDSL_CHAN_PROFILE_ID:
			uMibs.mibs_chan = (struct mibs_chan_struct *)del->mibs;
			for (i = 0; i < MIB_ChanP_NUMBER ; i++ )
			{
				if (uMibs.mibs_chan->mib[i].value != NULL){
					free(uMibs.mibs_chan->mib[i].value);
				}
			}
			free(uMibs.mibs_chan);
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
			uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)del->mibs;
			for (i = 0; i < MIB_LineAlarmP_NUMBER ; i++ )
			{
				if (uMibs.mibs_line_alarm->mib[i].value != NULL){
					free(uMibs.mibs_line_alarm->mib[i].value);
				}
			}
			free(uMibs.mibs_line_alarm);
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
			uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)del->mibs;
			for (i = 0; i < MIB_ChanAlarmP_NUMBER ; i++ )
			{
				if (uMibs.mibs_chan_alarm->mib[i].value != NULL){
					free(uMibs.mibs_chan_alarm->mib[i].value);
				}
			}
			free(uMibs.mibs_chan_alarm);
			break;
		case VDSL_PROFILE_VN_ID:
			uMibs.vn = (struct mibs_VN_struct *)del->mibs;
			for (i = 0; i < MIB_VN_NUMBER ; i++ )
			{
				if (uMibs.vn->mib[i].value != NULL){
					free(uMibs.vn->mib[i].value);
				}
			}
			free(uMibs.vn);
			break;
		case VDSL_PROFILE_DPB_ID:
			uMibs.dpb = (struct mibs_DPB_struct *)del->mibs;
			for (i = 0; i < MIB_DPB_NUMBER ; i++ )
			{
				if (uMibs.dpb->mib[i].value != NULL){
					free(uMibs.dpb->mib[i].value);
				}
			}
			free(uMibs.dpb);
			break;
		case VDSL_PROFILE_RFI_ID:
			uMibs.rfi = (struct mibs_RFI_struct *)del->mibs;
			for (i = 0; i < MIB_RFI_NUMBER ; i++ )
			{
				if (uMibs.rfi->mib[i].value != NULL){
					free(uMibs.rfi->mib[i].value);
				}
			}
			free(uMibs.rfi);
			break;
		case VDSL_PROFILE_PSD_ID:
			uMibs.psd = (struct mibs_PSD_struct *)del->mibs;
			for (i = 0; i < MIB_PSD_NUMBER ; i++ )
			{
				if (uMibs.psd->mib[i].value != NULL){
					free(uMibs.psd->mib[i].value);
				}
			}
			free(uMibs.psd);
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in del_vdsl_profiles_fun!!");
			break;

	}
	profile_param[type].modify_vdsl_profile = 1;
	profile_param[type].init_profile_number--;
	free(del);
	return DSL_ERR_OK;

}

/**
 * Release memory of all Profile function
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int free_vdsl_profiles_fun ()
{
	mt_ret ret;
	struct vdsl_all_profile *del = NULL;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	int i = 0;

	if(list_empty(&vdsl_all_profile_head) != 1) {
		//del check,must not profile used ,can delete
		list_for_each_safe(next, tmp, &vdsl_all_profile_head){
			del = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
			list_del(next);
			switch(del->type){
				case VDSL_PROFILE_ID:
				case VDSL_LINE_TEMPLATE_ID:
				case VDSL_ALARM_TEMPLATE_ID:
					uMibs.mibs_member = (struct mibs_member_struct *)del->mibs;
					free(uMibs.mibs_member);
					break;
				case VDSL_LINE_PROFILE_ID:
					uMibs.mibs_line = (struct mibs_line_struct *)del->mibs;
					for (i = 0; i < MIB_LineP_NUMBER ; i++ )
					{
						if (uMibs.mibs_line->mib[i].value != NULL){
							free(uMibs.mibs_line->mib[i].value);
						}
					}
					free(uMibs.mibs_line);
					break;
				case VDSL_CHAN_PROFILE_ID:
					uMibs.mibs_chan = (struct mibs_chan_struct *)del->mibs;
					for (i = 0; i < MIB_ChanP_NUMBER ; i++ )
					{
						if (uMibs.mibs_chan->mib[i].value != NULL){
							free(uMibs.mibs_chan->mib[i].value);
						}
					}
					free(uMibs.mibs_chan);
					break;
				case VDSL_LINE_ALARM_PROFILE_ID:
					uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)del->mibs;
					for (i = 0; i < MIB_LineAlarmP_NUMBER ; i++ )
					{
						if (uMibs.mibs_line_alarm->mib[i].value != NULL){
							free(uMibs.mibs_line_alarm->mib[i].value);
						}
					}
					free(uMibs.mibs_line_alarm);
					break;
				case VDSL_CHAN_ALARM_PROFILE_ID:
					uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)del->mibs;
					for (i = 0; i < MIB_ChanAlarmP_NUMBER ; i++ )
					{
						if (uMibs.mibs_chan_alarm->mib[i].value != NULL){
							free(uMibs.mibs_chan_alarm->mib[i].value);
						}
					}
					free(uMibs.mibs_chan_alarm);
					break;
				case VDSL_PROFILE_VN_ID:
					uMibs.vn = (struct mibs_VN_struct *)del->mibs;
					for (i = 0; i < MIB_VN_NUMBER ; i++ )
					{
						if (uMibs.vn->mib[i].value != NULL){
							free(uMibs.vn->mib[i].value);
						}
					}
					free(uMibs.vn);
					break;
				case VDSL_PROFILE_DPB_ID:
					uMibs.dpb = (struct mibs_DPB_struct *)del->mibs;
					for (i = 0; i < MIB_DPB_NUMBER ; i++ )
					{
						if (uMibs.dpb->mib[i].value != NULL){
							free(uMibs.dpb->mib[i].value);
						}
					}
					free(uMibs.dpb);
					break;
				case VDSL_PROFILE_RFI_ID:
					uMibs.rfi = (struct mibs_RFI_struct *)del->mibs;
					for (i = 0; i < MIB_RFI_NUMBER ; i++ )
					{
						if (uMibs.rfi->mib[i].value != NULL){
							free(uMibs.rfi->mib[i].value);
						}
					}
					free(uMibs.rfi);
					break;
				case VDSL_PROFILE_PSD_ID:
					uMibs.psd = (struct mibs_PSD_struct *)del->mibs;
					for (i = 0; i < MIB_PSD_NUMBER ; i++ )
					{
						if (uMibs.psd->mib[i].value != NULL){
							free(uMibs.psd->mib[i].value);
						}
					}
					free(uMibs.psd);
					break;
				default:
					PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in free_vdsl_profiles_fun!!");
					break;
			}
			if(del != NULL)
			free(del);
		}
	}

	init_profile_global_fun();
	return DSL_ERR_OK;
}

/** 
 * Initialize Profile global param function
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int init_profile_global_fun()
{
	int i = 0;
	//init global vlaue
	init_profile_linklist = 0;

	for (i = 0 ; i < VDSL_PROFILE_END_ID ; i++){
		profile_param[i].max_vdsl_profile_id = 0;
		profile_param[i].init_profile_number = 0;
		profile_param[i].modify_vdsl_profile = 0;
		profile_param[i].init_profile = 0;
	}

	return DSL_ERR_OK;
}

/**
 * Initialize Profile function
 * \param type: profile type  
 * \param mibs_num: number of mibs 
 * \param prefix_index: prefix index of profile  
 * \param prefix: prefix of profile  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int init_vdsl_profiles_fun (int type, int mibs_num, char *prefix_index, char *prefix)
{
	mt_ret ret;
	struct vdsl_all_profile     *profile_P;
	union union_mibs_struct uMibs;
	char command[4096],line[4096],*pch,profile_name[256];
	unsigned int profile_index[4096];
	int i = 0, j = 0,k = 0;
	struct list_head *next;
	FILE *streamout;
	char tmp[64];
	int vdsl_profile_id_num = 0;
	int max_profile_id = 0;

	//cut PROFILE_INDEX string token save to array
	sprintf(command, ""CFGMGR_PATH" -r %s",prefix_index);
	if((streamout = popen(command, "r")) != NULL) {
		if(fgets(line, 4096, streamout) != NULL) {
				stripwhite(line);
				pclose(streamout);
		}else{
			PRINTL(DBG_LVL_ALWAYS, "Profile %s List Empty",prefix_index);
			return -DSL_ERR_NOPASS;
			}

	}else{
			PRINTL(DBG_LVL_ALWAYS, "No %s\n",prefix_index);
			return -DSL_ERR_NOPASS;
		}

	pch = strtok (line,"@");
	i = 0;
	memset(profile_index, 0, sizeof(profile_index));
	while(pch != NULL){
		profile_index[i] = atoi(pch);
		if (max_profile_id < profile_index[i]){
			max_profile_id = profile_index[i];
		}

		i = i + 1;
		pch = strtok (NULL,"@");

		if(i > MAX_PROFILE_NUMBER)
		break;
	}

	//**rebuild profile link-list **//
	i = 0;
	while(profile_index[i] != 0){
		//yalee980319 use cfgmgr multi command start
		sprintf(command, ""CFGMGR_PATH" -r %s%d",prefix ,profile_index[i]);
		k = 0;
		while(k < CFGMGR_READ_NUM){
			i++;
			k++;
			if(profile_index[i] == 0){
			//yalee: if profile_index[i] == 0, empty
				break;
			}
			sprintf(tmp,",%s%d",prefix ,profile_index[i]);
			//strcat(command, ",VdslLineProfiles");
			strcat(command, tmp);
		}


		if((streamout = popen(command, "r")) != NULL) {
			while(fgets(line, 4096, streamout) != NULL) {
				stripwhite(line);
				//get first token of string
				pch = strtok (line,"@");
				if(pch == NULL) continue;
				sprintf(profile_name,"%s",pch);
				ret = new_vdsl_profiles_fun (type, profile_name);
			        /*search link list*/
				profile_P = all_profile_search(type, profile_name);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Profile No Exist",profile_name);
					return -DSL_ERR_NOPASS;
				}

				j = 0;
				sprintf(profile_P->profile_name, "%s",pch);
				//yalee980219
				profile_P->modify = 'X';
				profile_P->vdsl_profile_id = profile_index[vdsl_profile_id_num];
				profile_P->type = type;
				vdsl_profile_id_num++;
				while (pch != NULL)
				{
					pch = strtok (NULL, "@");
					if(pch == NULL) break;

					/*if over MIB_NUMBER break i.e. no space*/
					//printf("j=%d, pch = %s\n",j,pch);
					if( j >= mibs_num )
					{
						PRINTL(DBG_LVL_ALWAYS, "%s config file isn't match!! argument too more!!",prefix);
						PRINTL(DBG_LVL_ALWAYS, "%s need %d token but config file have %d token",
													prefix, mibs_num ,j+1);
						free_vdsl_profiles_fun();
						pclose(streamout);
						return -DSL_ERR_NOPASS;
					}

					//switch start
					switch(type){
						case VDSL_PROFILE_ID:
						case VDSL_LINE_TEMPLATE_ID:
						case VDSL_ALARM_TEMPLATE_ID:
							uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
							if(j == 0) sprintf(uMibs.mibs_member->vdsl_line_name, "%s",pch);
							if(j == 1) sprintf(uMibs.mibs_member->vdsl_chan_name, "%s",pch);
							break;
						case VDSL_LINE_PROFILE_ID:
							uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
							if(uMibs.mibs_line->mib[j].value != NULL)
								free(uMibs.mibs_line->mib[j].value);

							uMibs.mibs_line->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.mibs_line->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.mibs_line->mib[j].value, "%s",pch);
							break;
						case VDSL_CHAN_PROFILE_ID:
							uMibs.mibs_chan = (struct mibs_chan_struct *)profile_P->mibs;
							if(uMibs.mibs_chan->mib[j].value != NULL)
								free(uMibs.mibs_chan->mib[j].value);

							uMibs.mibs_chan->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.mibs_chan->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.mibs_chan->mib[j].value, "%s",pch);
							break;
						case VDSL_LINE_ALARM_PROFILE_ID:
							uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)profile_P->mibs;
							if(uMibs.mibs_line_alarm->mib[j].value != NULL)
								free(uMibs.mibs_line_alarm->mib[j].value);

							uMibs.mibs_line_alarm->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.mibs_line_alarm->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.mibs_line_alarm->mib[j].value, "%s",pch);
							break;
						case VDSL_CHAN_ALARM_PROFILE_ID:
							uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)profile_P->mibs;
							if(uMibs.mibs_chan_alarm->mib[j].value != NULL)
								free(uMibs.mibs_chan_alarm->mib[j].value);

							uMibs.mibs_chan_alarm->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.mibs_chan_alarm->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.mibs_chan_alarm->mib[j].value, "%s",pch);
							break;
						case VDSL_PROFILE_VN_ID:
							uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
							if(uMibs.vn->mib[j].value != NULL)
								free(uMibs.vn->mib[j].value);

							uMibs.vn->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.vn->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.vn->mib[j].value, "%s",pch);
							break;
						case VDSL_PROFILE_DPB_ID:
							uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
							if(uMibs.dpb->mib[j].value != NULL)
								free(uMibs.dpb->mib[j].value);

							uMibs.dpb->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.dpb->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.dpb->mib[j].value, "%s",pch);
							break;
						case VDSL_PROFILE_RFI_ID:
							uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
							if(uMibs.rfi->mib[j].value != NULL)
								free(uMibs.rfi->mib[j].value);

							uMibs.rfi->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.rfi->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.rfi->mib[j].value, "%s",pch);
							break;
						case VDSL_PROFILE_PSD_ID:
							uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
							if(uMibs.psd->mib[j].value != NULL)
								free(uMibs.psd->mib[j].value);

							uMibs.psd->mib[j].value = (char*)malloc(strlen(pch)+1);
							if(uMibs.psd->mib[j].value == NULL){
								PRINTL(DBG_LVL_ALWAYS, "Memory allocation fail!!");
								pclose(streamout);
								return -DSL_ERR_NOPASS;
							}
							sprintf(uMibs.psd->mib[j].value, "%s",pch);
							break;
						default:
							PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in init_vdsl_profiles_fun!!");
						break;
					}
					//switch end

					j = j + 1;
				}

				if(j < mibs_num)
				{
					PRINTL(DBG_LVL_ALWAYS, "%s config file isn't match!!!! argument too less!!",prefix);
					PRINTL(DBG_LVL_ALWAYS, "%s need %d token but config file have %d token",
												prefix, mibs_num ,j);
					free_vdsl_profiles_fun();
					pclose(streamout);
					return -DSL_ERR_NOPASS;
				}
			}//while fgets
			pclose(streamout);
		}
		i = i + 1;
	}

	profile_param[type].max_vdsl_profile_id = max_profile_id;
	profile_param[type].modify_vdsl_profile = 0;

	return DSL_ERR_OK;
}

/**
 * Display parent of Profile function
 * \param profile_name: name of profile
 * \param type: profile type  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int display_vdsl_parent_profile_fun(char *profile_name, int type)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next;
	char printArray[PROFILE_BUF_SIZE];
	int len = 0;
	int j = 0;


	printArray[0] = 0x00;
	//search ID setting
	switch(type){
		case VDSL_PROFILE_VN_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"VNS")==0)
				break;
			}
			break;
		case VDSL_PROFILE_DPB_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"DPB")==0)
				break;
			}
			break;
		case VDSL_PROFILE_RFI_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"RFI")==0)
				break;
			}
			break;
		case VDSL_PROFILE_PSD_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"PSD")==0)
				break;
			}
			break;
		default:
			j = 0;
			break;
	}

	list_for_each_prev(next, &vdsl_all_profile_head) {
		profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
			switch(type){
				case VDSL_LINE_PROFILE_ID://parent is line-template
					if(profile_P->type == VDSL_LINE_TEMPLATE_ID){
						uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
						if(strcmp(uMibs.mibs_member->vdsl_line_name, profile_name)==0){
							len += (strlen(profile_P->profile_name) + 1);
							if(len < PROFILE_BUF_SIZE){
								strcat(printArray, profile_P->profile_name);
								strcat(printArray, ",");
							}
							else{
								PRINTL(DBG_LVL_ALWAYS, "String buff full in display_vdsl_parent_profile_fun");
							}
						}
					}
					break;
				case VDSL_CHAN_PROFILE_ID:
					if(profile_P->type == VDSL_LINE_TEMPLATE_ID){
						uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
						if(strcmp(uMibs.mibs_member->vdsl_chan_name, profile_name)==0){
							len += (strlen(profile_P->profile_name) + 1);
							if(len < PROFILE_BUF_SIZE){
								strcat(printArray, profile_P->profile_name);
								strcat(printArray, ",");
							}
							else{
								PRINTL(DBG_LVL_ALWAYS, "String buff full in display_vdsl_parent_profile_fun");
							}
						}
					}
					break;
				case VDSL_LINE_ALARM_PROFILE_ID:
					if(profile_P->type == VDSL_ALARM_TEMPLATE_ID){
						uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
						if(strcmp(uMibs.mibs_member->vdsl_line_name, profile_name)==0){
							len += (strlen(profile_P->profile_name) + 1);
							if(len < PROFILE_BUF_SIZE){
								strcat(printArray, profile_P->profile_name);
								strcat(printArray, ",");
							}
							else{
								PRINTL(DBG_LVL_ALWAYS, "String buff full in display_vdsl_parent_profile_fun");
							}
						}
					}
					break;
				case VDSL_CHAN_ALARM_PROFILE_ID:
					if(profile_P->type == VDSL_ALARM_TEMPLATE_ID){
						uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
						if(strcmp(uMibs.mibs_member->vdsl_chan_name, profile_name)==0){
							len += (strlen(profile_P->profile_name) + 1);
							if(len < PROFILE_BUF_SIZE){
								strcat(printArray, profile_P->profile_name);
								strcat(printArray, ",");
							}
							else{
								PRINTL(DBG_LVL_ALWAYS, "String buff full in display_vdsl_parent_profile_fun");
							}
						}
					}
					break;
				case VDSL_PROFILE_VN_ID:
				case VDSL_PROFILE_DPB_ID:
				case VDSL_PROFILE_RFI_ID:
				case VDSL_PROFILE_PSD_ID:
					if(profile_P->type == VDSL_LINE_PROFILE_ID){
						uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
						if(strcmp(uMibs.mibs_line->mib[j].value, profile_name)==0){
							len += (strlen(profile_P->profile_name) + 1);
							if(len < PROFILE_BUF_SIZE){
								strcat(printArray, profile_P->profile_name);
								strcat(printArray, ",");
							}
							else{
								PRINTL(DBG_LVL_ALWAYS, "String buff full in display_vdsl_parent_profile_fun");
							}
						}
					}
					break;
				default:
					PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in display_vdsl_parent_profile_fun");
					break;
			}
	}

	if(strlen(printArray) != 0) printArray[strlen(printArray)-1] = '\0';

	switch(type){
		case VDSL_LINE_PROFILE_ID://parent is line-template
		case VDSL_CHAN_PROFILE_ID:
			PRINTL(DBG_LVL_ALWAYS, "LineTemplate #%s use this profile",printArray);
			break;
		case VDSL_LINE_ALARM_PROFILE_ID://parent is line-alarm-template
		case VDSL_CHAN_ALARM_PROFILE_ID:
			PRINTL(DBG_LVL_ALWAYS, "LineAlarmTemplate #%s use this profile",printArray);
			break;
		case VDSL_PROFILE_VN_ID://parent is line-profile
		case VDSL_PROFILE_DPB_ID:
		case VDSL_PROFILE_RFI_ID:
		case VDSL_PROFILE_PSD_ID:
			PRINTL(DBG_LVL_ALWAYS, "LineProfile #%s use this profile",printArray);
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in display_vdsl_parent_profile_fun");
			break;
	}
	PRINTL(DBG_LVL_XML, "parent_profile %s|",printArray);

}

/**
 * Display Profile function
 * \param profile_name: name of profile
 * \param type: profile type  
 * \param options:   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int display_vdsl_profiles_fun(char *profile_name, int type, int options)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next;
	char multiP[256];
	int i = 0 ,value = 0;
	char tone_c[16], nlevel_c[16], buff[7];
	int tone, toneDs ,toneUs;
	float nlevel, nlevelDs ,nlevelUs;
	int flag = 0;//one time flag
	char portUsed[64];
	char port_map[MAX_PORTS];

	if(profile_param[type].init_profile == 0){
		//init profile
		profiles_main_vdslprofile_init(type);
	}
	if(options == 0){
	//display up layer
		//show all profile name
		list_for_each_prev(next, &vdsl_all_profile_head) {
			profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
			if(profile_P->type == type){
				if(flag == 0){//print one time
					switch(type){
						case VDSL_PROFILE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Vdsl Main Profile:");
							break;
						case VDSL_LINE_TEMPLATE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Line Template:");
							break;
						case VDSL_LINE_PROFILE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Line Profile:");
							break;
						case VDSL_CHAN_PROFILE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Channel Profile:");
							break;
						case VDSL_ALARM_TEMPLATE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Alarm Template:");
							break;
						case VDSL_LINE_ALARM_PROFILE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Line Alarm Profile:");
							break;
						case VDSL_CHAN_ALARM_PROFILE_ID:
							PRINTL(DBG_LVL_ALWAYS, "xDSL Channel Alarm Profile:");
							break;
						case VDSL_PROFILE_VN_ID:
							PRINTL(DBG_LVL_ALWAYS, "User defined Virtual Noise profile:");
							break;
						case VDSL_PROFILE_DPB_ID:
							PRINTL(DBG_LVL_ALWAYS, "User defined DPBO PSD profile:");
							break;
						case VDSL_PROFILE_RFI_ID:
							PRINTL(DBG_LVL_ALWAYS, "User defined RFI Band profile:");
							break;
						case VDSL_PROFILE_PSD_ID:
							PRINTL(DBG_LVL_ALWAYS, "User defined PSD Masks profile:");
							break;
						default:
							PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in display_vdsl_profiles_fun 0!!");
							break;
					}
					flag = 1;
				}
					//print hit profile name in link list
					PRINTL(DBG_LVL_ALWAYS,"%s",profile_P->profile_name);
					PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
			}

		}
		return DSL_ERR_OK;
	}

	if(options == 1){
		profile_P = all_profile_search(type, profile_name);
		if(profile_P == NULL){
			PRINTL(DBG_LVL_ALWAYS, "%s User defined Profile No Exist",profile_name);
			return -DSL_ERR_NOPASS;
		}
		//switch start
        	 /*print profile context*/
		switch(type){
			case VDSL_PROFILE_ID:
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				PRINTL(DBG_LVL_ALWAYS, "xDSL Main Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "LineTemplate :%s",uMibs.mibs_member->vdsl_line_name);
				PRINTL(DBG_LVL_ALWAYS, "AlarmTemplate:%s",uMibs.mibs_member->vdsl_chan_name);
				PRINTL(DBG_LVL_XML, "%s|%s|",uMibs.mibs_member->vdsl_line_name,uMibs.mibs_member->vdsl_chan_name);
				break;
			case VDSL_LINE_TEMPLATE_ID:
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
        			 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Line Template Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "LineProfile   :%s",uMibs.mibs_member->vdsl_line_name);
				PRINTL(DBG_LVL_ALWAYS, "ChannelProfile:%s",uMibs.mibs_member->vdsl_chan_name);
				PRINTL(DBG_LVL_XML, "%s|%s|",uMibs.mibs_member->vdsl_line_name,uMibs.mibs_member->vdsl_chan_name);
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				break;
			case VDSL_LINE_PROFILE_ID:
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
	        		 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Line Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ","","Value","Description");
				for (i = 0 ; i < MIB_LineP_NUMBER ; i++)
				{
					if (strcmp(mib_default_line_name[i].oid,"SYS")==0
					|| strcmp(mib_default_line_name[i].oid,"BND")==0
					|| strcmp(mib_default_line_name[i].oid,"VNS")==0
					|| strcmp(mib_default_line_name[i].oid,"PSD")==0
					|| strcmp(mib_default_line_name[i].oid,"RFI")==0
					|| strcmp(mib_default_line_name[i].oid,"DPB")==0
					|| strcmp(mib_default_line_name[i].oid,"IOT")==0
					|| strcmp(mib_default_line_name[i].oid,"led")==0
					|| strcmp(mib_default_line_name[i].oid,"bitSwapUs")==0
					|| strcmp(mib_default_line_name[i].oid,"bitSwapDs")==0
					|| strcmp(mib_default_line_name[i].oid,"us0disable")==0){

						/*char format display*/
             	  		 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ",
						mib_default_line_name[i].oid, uMibs.mibs_line->mib[i].value, mib_default_line_name[i].value);
             			  	 	PRINTL(DBG_LVL_XML, "%s %s|",
						mib_default_line_name[i].oid, uMibs.mibs_line->mib[i].value);
					}else if(strcmp(mib_default_line_name[i].oid,"profiles")==0){
						memset(multiP,'\0',256);
					 	value = strtoul(uMibs.mibs_line->mib[i].value,NULL,16);
						if((value & 0x00000080) == 0x00000080)
						strcat(multiP,"30a,");
						if((value & 0x00000040) == 0x00000040)
						strcat(multiP,"17a,");
						if((value & 0x00000020) == 0x00000020)
						strcat(multiP,"12b,");
						if((value & 0x00000010) == 0x00000010)
						strcat(multiP,"12a,");
						if((value & 0x00000008) == 0x00000008)
						strcat(multiP,"8d,");
						if((value & 0x00000004) == 0x00000004)
						strcat(multiP,"8c,");
						if((value & 0x00000002) == 0x00000002)
						strcat(multiP,"8b,");
						if((value & 0x00000001) == 0x00000001)
						strcat(multiP,"8a,");

						if(strlen(multiP) != 0) multiP[strlen(multiP) - 1] = '\0';
             	  		 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ",
						mib_default_line_name[i].oid, multiP, mib_default_line_name[i].value);
             	  		 		PRINTL(DBG_LVL_XML, "profiles %s|",multiP);

					}else{
						/*char transfer to int and use decimal format display*/
				 		//value = strtoul(uMibs.mibs_line->mib[i].value,NULL,16);
				 		value = strtol(uMibs.mibs_line->mib[i].value,NULL,16);
						if(value & 0x800000) value |=0xff000000;

             		  	 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20d %-s ",
						mib_default_line_name[i].oid, value, mib_default_line_name[i].value);
             		  	 		PRINTL(DBG_LVL_XML, "%s %d|",
						mib_default_line_name[i].oid, value);
					}
				}
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_CHAN_PROFILE_ID:
				uMibs.mibs_chan = (struct mibs_chan_struct *)profile_P->mibs;
       			 	 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Channel Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ","","Value","Description");
				for (i = 0 ; i < MIB_ChanP_NUMBER ; i++)
				{
					/*char transfer to int and use decimal format display*/
			 		value = strtoul(uMibs.mibs_chan->mib[i].value,NULL,16);
       		  	 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20d %-s ",
					mib_default_chan_name[i].oid, value, mib_default_chan_name[i].value);
       		  	 		PRINTL(DBG_LVL_XML, "%s %d|",
					mib_default_chan_name[i].oid, value);
				}
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_ALARM_TEMPLATE_ID:
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
        		 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Alarm Template Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "LineAlarmProfile   :%s",uMibs.mibs_member->vdsl_line_name);
				PRINTL(DBG_LVL_ALWAYS, "ChanneAlarmlProfile:%s",uMibs.mibs_member->vdsl_chan_name);
				PRINTL(DBG_LVL_XML, "%s|%s|",uMibs.mibs_member->vdsl_line_name,uMibs.mibs_member->vdsl_chan_name);
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				break;
			case VDSL_LINE_ALARM_PROFILE_ID:
				uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)profile_P->mibs;
	       	 	 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Line Alarm Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ","","Value","Description");

				for (i = 0 ; i < MIB_LineAlarmP_NUMBER ; i++)
				{
					/*char transfer to int and use decimal format display*/
				 	value = strtoul(uMibs.mibs_line_alarm->mib[i].value,NULL,16);
       		  		 	PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20d %-s ",
					mib_default_line_alarm_name[i].oid, value, mib_default_line_alarm_name[i].value);
       		  		 	PRINTL(DBG_LVL_XML, "%s %d|",
					mib_default_line_alarm_name[i].oid, value);
				}
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_CHAN_ALARM_PROFILE_ID:
				uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)profile_P->mibs;
 	 		      	 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Channel Alarm Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ","","Value","Description");

				for (i = 0 ; i < MIB_ChanAlarmP_NUMBER ; i++)
				{
					/*char transfer to int and use decimal format display*/
				 	value = strtoul(uMibs.mibs_chan_alarm->mib[i].value,NULL,16);
       		  		 	PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20d %-s ",
					mib_default_chan_alarm_name[i].oid, value, mib_default_chan_alarm_name[i].value);
       		  	 		PRINTL(DBG_LVL_XML, "%s %d|",
					mib_default_chan_alarm_name[i].oid, value);
				}
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_PROFILE_VN_ID:
				uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
				virtual_noise_tables_display_fun(profile_P->profile_name, uMibs.vn->mib[0].value, uMibs.vn->mib[1].value);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_PROFILE_DPB_ID:
				uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
				psdmask_tables_display_fun(profile_P->profile_name, uMibs.dpb->mib[0].value, NULL, VDSL_PROFILE_DPB_ID);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_PROFILE_RFI_ID:
				uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
				rfi_tables_display_fun(profile_P->profile_name, uMibs.rfi->mib[0].value);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			case VDSL_PROFILE_PSD_ID:
				uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
				psdmask_tables_display_fun(profile_P->profile_name, uMibs.psd->mib[0].value, uMibs.psd->mib[1].value, VDSL_PROFILE_PSD_ID);
				display_vdsl_parent_profile_fun(profile_name, type);
				break;
			default:
				PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in display_vdsl_profiles_fun 1!!");
				break;
		}//switch end

		return DSL_ERR_OK;
	}

	if(options == 2){
		//yalee990624:options 2 : for WebUI used
		profile_P = all_profile_search(type, profile_name);
		if(profile_P == NULL){
			PRINTL(DBG_LVL_ALWAYS, "%s User defined Profile No Exist",profile_name);
			return -DSL_ERR_NOPASS;
		}
		//switch start
        	 /*print profile context*/
		switch(type){
			case VDSL_LINE_PROFILE_ID:
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
	        		 /*print profile context*/
				PRINTL(DBG_LVL_ALWAYS, "xDSL Line Profile Config Tables: %s ",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_XML, "%s|",profile_P->profile_name);
				PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ","","Value","Description");
				for (i = 0 ; i < MIB_LineP_NUMBER ; i++)
				{
					if (strcmp(mib_default_line_name[i].oid,"BND")==0){

						/*char format display*/
             	  		 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ",
						mib_default_line_name[i].oid, uMibs.mibs_line->mib[i].value, mib_default_line_name[i].value);
             			  	 	PRINTL(DBG_LVL_XML, "%s %s|",
						mib_default_line_name[i].oid, uMibs.mibs_line->mib[i].value);
					}else if(strcmp(mib_default_line_name[i].oid,"profiles")==0){
						memset(multiP,'\0',256);
					 	value = strtoul(uMibs.mibs_line->mib[i].value,NULL,16);
						if((value & 0x00000080) == 0x00000080)
						strcat(multiP,"30a,");
						if((value & 0x00000040) == 0x00000040)
						strcat(multiP,"17a,");
						if((value & 0x00000020) == 0x00000020)
						strcat(multiP,"12b,");
						if((value & 0x00000010) == 0x00000010)
						strcat(multiP,"12a,");
						if((value & 0x00000008) == 0x00000008)
						strcat(multiP,"8d,");
						if((value & 0x00000004) == 0x00000004)
						strcat(multiP,"8c,");
						if((value & 0x00000002) == 0x00000002)
						strcat(multiP,"8b,");
						if((value & 0x00000001) == 0x00000001)
						strcat(multiP,"8a,");

						if(strlen(multiP) != 0) multiP[strlen(multiP) - 1] = '\0';
             	  		 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20s %-s ",
						mib_default_line_name[i].oid, multiP, mib_default_line_name[i].value);
             	  		 		PRINTL(DBG_LVL_XML, "profiles %s|",multiP);

					}
					else if(strcmp(mib_default_line_name[i].oid,"targetSnrmDs")==0
						|| strcmp(mib_default_line_name[i].oid,"targetSnrmUs")==0){
						/*char transfer to int and use decimal format display*/
				 		value = strtol(uMibs.mibs_line->mib[i].value,NULL,16);
						if(value & 0x800000) value |=0xff000000;

             		  	 		PRINTL(DBG_LVL_ALWAYS, "%-30s|%-20d %-s ",
						mib_default_line_name[i].oid, value, mib_default_line_name[i].value);
             		  	 		PRINTL(DBG_LVL_XML, "%s %d|",
						mib_default_line_name[i].oid, value);
					}
				}
				vdsl_profiles_map_port_fun (type, profile_P->profile_name, port_map);
				memset(portUsed,'\0',64);
				for(i = 0 ; i < MAX_PORTS ; i++){
					if(port_map[i] == '*')
					{
						sprintf(buff,"%d,",i+1);
						strcat(portUsed, buff);
					}
				}
				if(strlen(portUsed) != 0) portUsed[strlen(portUsed)-1] = '\0';
				PRINTL(DBG_LVL_ALWAYS, "---------------------------------------------------------------------------------------------------------------");
				PRINTL(DBG_LVL_ALWAYS, "Line #%s use this profile",portUsed);
				PRINTL(DBG_LVL_XML, "port_list %s|",portUsed);
				break;
			default:
				PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in display_vdsl_profiles_fun 2!!");
				break;
		}//switch end

		return DSL_ERR_OK;
	}

	PRINTL(DBG_LVL_ALWAYS, "input param ERROR in display_vdsl_profiles_fun!!");
	return -DSL_ERR_NOPASS;
}

/**
 * Hex String check function
 * \param buffer: hex string
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int hexString_check_fun(char *buffer)
{
	int i = 0;

	while(buffer[i] != '\0')
	{
		if((buffer[i] >= '0') && (buffer[i] <= '9'))
		{
			//0-9
		}
		else if((buffer[i] >= 'A') && (buffer[i] <= 'F'))
		{
			//A-F
		}
		else if((buffer[i] >= 'a') && (buffer[i] <= 'f'))
		{
			//a-f
		}
		else
		{
			//Not Hex string
			PRINTL(DBG_LVL_ALWAYS, "%c Not Hex in String !!",buffer[i]);
			return -DSL_ERR_NOPASS;
		}
		i++;
	}
		//Hex string
		return DSL_ERR_OK;
}

/**
 * firmware package check id function
 * \param prefix: prefix of profile  
 * \param profile_name: name of profile
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int syspackage_checkid_fun(char *prefix, char *profile_name)
{
	int i = 1;
	char bandplan[128];
		/*need check bandplan code, if not suppourt can't setting*/
	do{
		get_package_profile_name(0, i, prefix, bandplan);
		if(strcmp(bandplan, profile_name) == 0){
			/*Hit ,support this bandplan*/
			return DSL_ERR_OK;
		}
		i++;
	}while(bandplan[0] != '\0');
	return -DSL_ERR_NOPASS;
}

/**
 * Set Profile function
 * \param portid: vdsl port id   
 * \param profile_name: name of profile
 * \param type: profile type  
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int set_vdsl_profiles_fun(int portid, char *profile_name, int type)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	int i = 0 , j = 0;
	int value;
	char value_c[7];

	profile_P = all_profile_search(type, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	switch(type){
		case VDSL_PROFILE_ID:
			uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_line_name, VDSL_LINE_TEMPLATE_ID);
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_chan_name, VDSL_ALARM_TEMPLATE_ID);
			break;
		case VDSL_LINE_TEMPLATE_ID:
			uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_line_name, VDSL_LINE_PROFILE_ID);
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_chan_name, VDSL_CHAN_PROFILE_ID);
			break;
		case VDSL_LINE_PROFILE_ID:
			uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
			//set LineProfile MIBS
			for (i = 0 ; i < MIB_LineP_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
				 PRINTL(DBG_LVL_CLI, "set profile oid: %s, value: %s",
					uMibs.mibs_line->mib[i].oid, uMibs.mibs_line->mib[i].value);
#endif

				if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanSYS) == 0)
				{
					set_package_profile_by_name(portid, SYS_PREFIX, uMibs.mibs_line->mib[i].value);
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanBND) == 0)
				{
					set_package_profile_by_name(portid, BND_PREFIX, uMibs.mibs_line->mib[i].value);
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanPSD) == 0)
				{
					ret = syspackage_checkid_fun(PSD_PREFIX, uMibs.mibs_line->mib[i].value);
					if(ret == DSL_ERR_OK){
						set_package_profile_by_name(portid, PSD_PREFIX, uMibs.mibs_line->mib[i].value);
					}else{
						set_vdsl_profiles_fun(portid, uMibs.mibs_line->mib[i].value, VDSL_PROFILE_PSD_ID);
					}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanVNS) == 0)
				{
					ret = syspackage_checkid_fun(VNS_PREFIX, uMibs.mibs_line->mib[i].value);
					if(ret == DSL_ERR_OK){
						set_package_profile_by_name(portid, VNS_PREFIX, uMibs.mibs_line->mib[i].value);
					}else{
						set_vdsl_profiles_fun(portid, uMibs.mibs_line->mib[i].value, VDSL_PROFILE_VN_ID);
					}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanRFI) == 0)
				{
					ret = syspackage_checkid_fun(RFI_PREFIX, uMibs.mibs_line->mib[i].value);
					if(ret == DSL_ERR_OK){
						set_package_profile_by_name(portid, RFI_PREFIX, uMibs.mibs_line->mib[i].value);
					}else{
						set_vdsl_profiles_fun(portid, uMibs.mibs_line->mib[i].value, VDSL_PROFILE_RFI_ID);
					}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanDpboEPsd) == 0)
				{
					ret = syspackage_checkid_fun(DPB_PREFIX, uMibs.mibs_line->mib[i].value);
					if(ret == DSL_ERR_OK){
						set_package_profile_by_name(portid, DPB_PREFIX, uMibs.mibs_line->mib[i].value);
					}else{
						set_vdsl_profiles_fun(portid, uMibs.mibs_line->mib[i].value, VDSL_PROFILE_DPB_ID);
					}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanIOT) == 0)
				{
					ret = syspackage_checkid_fun(IOT_PREFIX, uMibs.mibs_line->mib[i].value);
					if(ret == DSL_ERR_OK){
						set_package_profile_by_name(portid, IOT_PREFIX, uMibs.mibs_line->mib[i].value);
					}else{
						set_package_profile_by_name(portid, IOT_PREFIX, "0");
					}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid , xdslTwConfig) == 0)
				{
					//get old value
					ret= get_mib2_uint32(portid, uMibs.mibs_line->mib[i].oid, &value);
					if(strcmp(mib_default_line_name[i].oid, "led") == 0)
					{
						if (strcmp(uMibs.mibs_line->mib[i].value,"on")==0)
						{
							//led TwConfig bit 8 ,turn on
							value = value | 0x000100;
						}else{
							//turn off
							value = value & 0xfffeff;
						}
					}
					else if(strcmp(mib_default_line_name[i].oid, "bitSwapUs") == 0)
					{
						if (strcmp(uMibs.mibs_line->mib[i].value,"on")==0)
						{
							//bitswap TwConfig bit 21,22 ,turn on
							//value = value | 0x600000;
							//bitSwapUs TwConfig bit 21 ,turn on
							value = value | 0x200000;
						}else{
							//turn off
							//value = value & 0x9fffff;
							value = value & 0xdfffff;
						}
					}
					else if(strcmp(mib_default_line_name[i].oid, "bitSwapDs") == 0)
					{
						if (strcmp(uMibs.mibs_line->mib[i].value,"on")==0)
						{
							//bitSwapDs TwConfig bit 22 ,turn on
							value = value | 0x400000;
					}else{
							//turn off
							value = value & 0xbfffff;
						}
					}
					else{
               					PRINTL(DBG_LVL_ALWAYS, "TwConfig Error setting MIB value.");
					}
						sprintf(value_c, "%x", value);
						ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid, value_c);
						if(ret != DSL_ERR_OK){
							PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
						}
				}
				else if(strcmp(uMibs.mibs_line->mib[i].oid , xdsl2LConfProfUs0Disable) == 0)
				{
					ret = get_port_mib(portid, uMibs.mibs_line->mib[i].oid, pbuffer);
					if(ret != DSL_ERR_OK){
						PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
					}
					pbuffer[8] = '\0';
					value = strtoul(pbuffer+2, NULL, 16);
					if (strcmp(uMibs.mibs_line->mib[i].value,"disable")==0)
					{
						// bit 0-7 ,turn off
						value = value | 0x0000ff;
					}else{
						//turn allow
						value = value & 0xffff00;
					}
					sprintf(value_c, "%x", value);
					ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid, value_c);
					if(ret != DSL_ERR_OK){
						PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
					}
				}
				else if(strcmp(mib_default_line_name[i].oid, "bandConfig") == 0)
				{
					if (strcmp(uMibs.mibs_line->mib[i].value,"1")==0)
					{
						//DISABLE_1100K_BELOW:000108
						ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid, "000108");
						if(ret != DSL_ERR_OK){
							PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
						}

					}
					else if (strcmp(uMibs.mibs_line->mib[i].value,"2")==0)
					{
						//DISABLE_2200K_BELOW:000208
						ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid, "000208");
						if(ret != DSL_ERR_OK){
							PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
						}

					}
					//ALL_TONE_ON:zero or other value:done nothing
				}
#ifdef ATPDS_ISSUE
				else if(strcmp(uMibs.mibs_line->mib[i].oid , xdsl2LConfProfMaxNomAtpDs) == 0)
				{
					//yalee990408:this function is aggregate transmit power issue for Planet
					value = strtoul(uMibs.mibs_line->mib[i].value, NULL, 16);

					if(value > 145){//yalee990408:aggregate transmit power value can't set over 0x91
						ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid, "91");
					}
					else{
						ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid,
										uMibs.mibs_line->mib[i].value);
					}
				}
#endif//ATPDS_ISSUE
				else {
					ret= set_port_mib(portid, uMibs.mibs_line->mib[i].oid,
									uMibs.mibs_line->mib[i].value);
					if(ret != DSL_ERR_OK){
						PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
					}

					//yalee990312 RaModeDs or RaModeUs enable
					//set xdslMetanoiaOtAmend to 1 otherwise set to 0
					if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2LConfProfRaModeDs) == 0){
						if((strcmp(uMibs.mibs_line->mib[i].value,"3") == 0) ||
							(strcmp(uMibs.mibs_line->mib[i+1].value,"3") == 0)){
							ret= set_port_mib(portid, xdslMetanoiaOtAmend, "1");
						}else{
							ret= set_port_mib(portid, xdslMetanoiaOtAmend, "0");
						}

						if(ret != DSL_ERR_OK){
							PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
						}
					}
				}

			}
			break;
		case VDSL_CHAN_PROFILE_ID:
			uMibs.mibs_chan = (struct mibs_chan_struct *)profile_P->mibs;
			//set Channel Profile mibs
			for (i = 0 ; i < MIB_ChanP_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
				PRINTL(DBG_LVL_CLI, "set profile oid: %s, value: %s",
					uMibs.mibs_chan->mib[i].oid, uMibs.mibs_chan->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.mibs_chan->mib[i].oid, uMibs.mibs_chan->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}

#if PROFILE_DEBUG_MEG
				//confirm setting value
				ret= get_mib2_uint32(portid, uMibs.mibs_chan->mib[i].oid, &value);
				printf("get profile oid: %s, value: %x\n",uMibs.mibs_chan->mib[i].oid, value);
#endif
			}
			break;
		case VDSL_ALARM_TEMPLATE_ID:
			uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_line_name, VDSL_LINE_ALARM_PROFILE_ID);
			set_vdsl_profiles_fun(portid, uMibs.mibs_member->vdsl_chan_name, VDSL_CHAN_ALARM_PROFILE_ID);
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
			uMibs.mibs_line_alarm = (struct mibs_line_alarm_struct *)profile_P->mibs;
		//set Line Alarm Profile MIBS
			for (i = 0 ; i < MIB_LineAlarmP_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
				PRINTL(DBG_LVL_CLI, "set profile oid: %s, value: %s",
					uMibs.mibs_line_alarm->mib[i].oid, uMibs.mibs_line_alarm->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.mibs_line_alarm->mib[i].oid, uMibs.mibs_line_alarm->mib[i].value);
				if(ret != DSL_ERR_OK){
					PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}

#if PROFILE_DEBUG_MEG
					//confirm setting value
				ret= get_mib2_uint32(portid, uMibs.mibs_line_alarm->mib[i].oid, &value);
				printf("get profile oid: %s, value: %x\n",uMibs.mibs_line_alarm->mib[i].oid, value);
#endif
			}
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
			uMibs.mibs_chan_alarm = (struct mibs_chan_alarm_struct *)profile_P->mibs;
		//set Channel Alarm Profile mibs
			for (i = 0 ; i < MIB_ChanAlarmP_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
				PRINTL(DBG_LVL_CLI, "set profile oid: %s, value: %s",
						uMibs.mibs_chan_alarm->mib[i].oid, uMibs.mibs_chan_alarm->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.mibs_chan_alarm->mib[i].oid, uMibs.mibs_chan_alarm->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}

#if PROFILE_DEBUG_MEG
					//confirm setting value
					ret= get_mib2_uint32(portid, uMibs.mibs_chan_alarm->mib[i].oid, &value);
					printf("get profile oid: %s, value: %x\n",
								uMibs.mibs_chan_alarm->mib[i].oid, value);
#endif
			}
			break;
		case VDSL_PROFILE_VN_ID:
			uMibs.vn = (struct mibs_VN_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_VN_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
        	       		PRINTL(DBG_LVL_CLI,"LOID %s VN:%s", uMibs.vn->mib[i].oid, uMibs.vn->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.vn->mib[i].oid, uMibs.vn->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}

			}
			break;
		case VDSL_PROFILE_DPB_ID:
			uMibs.dpb = (struct mibs_DPB_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_DPB_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
        	       		PRINTL(DBG_LVL_CLI,"LOID %s DPB:%s", uMibs.dpb->mib[i].oid, uMibs.dpb->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.dpb->mib[i].oid, uMibs.dpb->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}
			}
			break;
		case VDSL_PROFILE_RFI_ID:
			uMibs.rfi = (struct mibs_RFI_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_RFI_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
        	       		PRINTL(DBG_LVL_CLI,"LOID %s RFI:%s", uMibs.rfi->mib[i].oid, uMibs.rfi->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.rfi->mib[i].oid, uMibs.rfi->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}
			}
			break;
		case VDSL_PROFILE_PSD_ID:
			uMibs.psd = (struct mibs_PSD_struct *)profile_P->mibs;
			for (i = 0 ; i < MIB_PSD_NUMBER ; i++)
			{
#if PROFILE_DP_MEG
        	       		PRINTL(DBG_LVL_CLI,"LOID %s PSD:%s", uMibs.psd->mib[i].oid, uMibs.psd->mib[i].value);
#endif
				ret= set_port_mib(portid, uMibs.psd->mib[i].oid, uMibs.psd->mib[i].value);
				if(ret != DSL_ERR_OK){
               				PRINTL(DBG_LVL_ALWAYS, "Error setting MIB value.");
				}
			}
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in set_vdsl_profiles_fun!!");
			break;
	}
	return DSL_ERR_OK;
}

/**
 * Add new Profile of Command line main function
 */
int com_profiles_main_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	int type;//profile type
	char *p = NULL;

	ret = sscanf(pbuf, "%d %s", &type ,profile_name);

	if(profile_param[type].init_profile == 0){
		profiles_main_vdslprofile_init(type);
	}

	//**test file name exist ?**//
	if(strlen(profile_name) > 20){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "profile_name len=%d too long limit 20 char",strlen(profile_name));
		return -DSL_ERR_NOPASS;

	}
	//check reserve word @
	p = strstr(profile_name,"@");
	if( p != NULL ){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "@ is reserve word in profile manage");
		return -DSL_ERR_NOPASS;
	}

	new = all_profile_search(type, profile_name);
	if (ret != 2 || new != NULL)
	{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");

		if(new != NULL) PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "profile_name exist");
		return -DSL_ERR_NOPASS;
	}
	//profile limit:1024
	if(profile_param[type].init_profile_number >= MAX_PROFILE_NUMBER){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Profile Number Full. Limit:%d",MAX_PROFILE_NUMBER);
		return -DSL_ERR_NOPASS;
	}
	//**if max_vdsl_profile_id over 32bit **//
	if(profile_param[type].max_vdsl_profile_id+1 >= 65535){
		PRINTL(DBG_LVL_ALWAYS, "Sorting Profile , please wait few minutes");
		profiles_main_sort_vdslprofiles();
	}
	ret = new_vdsl_profiles_fun (type, profile_name);

	return ret;
}

/**
 * Delete Profile of Command line main function
 */
int com_profiles_main_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	int i = 0;
	int type;//profile type

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf,"%d %s",&type ,profile_name);
	if ( ret != 2 )
	{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Can't delete Default Profile");
		return -DSL_ERR_NOPASS;
	}

	switch (type){
		case VDSL_PROFILE_ID:
			ret = del_vdsl_profiles_fun (VDSL_PROFILE_ID, profile_name, "VdslMainProfiles");
			break;
		case VDSL_LINE_TEMPLATE_ID:
		//del check,must not profile used ,can delete
#if 0//for VDSL Profile used
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_PROFILE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_line_name, profile_name) == 0){
				//Hit
				PRINTL(DBG_LVL_ALWAYS, "Vdsl Main Profile(%s) used ,Can't Delete LineTemplate(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
#endif
			for(i = 0 ; i < MAX_PORTS; i++){
				if(strcmp(port_map_linetemplate[i], profile_name) == 0){
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "xDSL Port%d used ,Can't Delete LineTemplate(%s) used",i+1,profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_LINE_TEMPLATE_ID, profile_name , "VdslLineTemplates");
			break;
		case VDSL_LINE_PROFILE_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_TEMPLATE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_line_name, profile_name) == 0){
				//Hit
				PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Template(%s) used ,Can't Delete LineProfile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_LINE_PROFILE_ID, profile_name , "VdslLineProfiles");
			break;
		case VDSL_CHAN_PROFILE_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_TEMPLATE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_chan_name, profile_name) == 0){
				//Hit
				PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Template(%s) used ,Can't Delete ChannelProfile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_CHAN_PROFILE_ID, profile_name , "VdslChanProfiles");
			break;
		case VDSL_ALARM_TEMPLATE_ID:
		//del check,must not profile used ,can delete
#if 0//for VDSL Profile used
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_PROFILE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_chan_name, profile_name) == 0){
				//Hit
				PRINTL(DBG_LVL_ALWAYS, "Vdsl Main Profile(%s) used ,Can't Delete AlarmTemplate(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
#endif
			for(i = 0 ; i < MAX_PORTS; i++){
				if(strcmp(port_map_alarmtemplate[i], profile_name) == 0){
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "xDSL Port%d used ,Can't Delete AlarmTemplate(%s) used",i+1,profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_ALARM_TEMPLATE_ID, profile_name , "VdslAlarmTemplates");
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_ALARM_TEMPLATE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_line_name, profile_name) == 0){
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Alarm Template(%s) used ,Can't Delete LineAlarmProfile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_LINE_ALARM_PROFILE_ID, profile_name , "VdslLineAlarmProfiles");
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_ALARM_TEMPLATE_ID ) continue;
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(uMibs.mibs_member->vdsl_chan_name, profile_name) == 0){
				//Hit
				PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Alarm Template(%s) used ,Can't Delete ChannelAlarmProfile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_CHAN_ALARM_PROFILE_ID, profile_name , "VdslChanAlarmProfiles");
			break;
		case VDSL_PROFILE_VN_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_PROFILE_ID ) continue;
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
				for(i = 0; i < MIB_LineP_NUMBER ; i++){
					if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanVNS)==0)
						break;
				}
				if(strcmp(uMibs.mibs_line->mib[i].value, profile_name) == 0){
					//Hit
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Profile(%s) used ,Can't Delete VirtualNoiseProfile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_PROFILE_VN_ID, profile_name , "VdslVitualNoise");
			break;
		case VDSL_PROFILE_DPB_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_PROFILE_ID ) continue;
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
				for(i = 0; i < MIB_LineP_NUMBER ; i++){
					if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanDpboEPsd)==0)
						break;
				}
				if(strcmp(uMibs.mibs_line->mib[i].value, profile_name) == 0){
					//Hit
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Profile(%s) used ,Can't Delete DpboEPsd Profile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_PROFILE_DPB_ID, profile_name , "VdslDpboEPsd");
			break;
		case VDSL_PROFILE_RFI_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_PROFILE_ID ) continue;
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
				for(i = 0; i < MIB_LineP_NUMBER ; i++){
					if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanRFI)==0)
						break;
				}
				if(strcmp(uMibs.mibs_line->mib[i].value, profile_name) == 0){
					//Hit
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Profile(%s) used ,Can't Delete RFI Profile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_PROFILE_RFI_ID, profile_name , "VdslRfiBands");
			break;
		case VDSL_PROFILE_PSD_ID:
		//del check,must not profile used ,can delete
			list_for_each_safe(next, tmp, &vdsl_all_profile_head){
				profile_P = (struct vdsl_all_profile *) list_entry(next, struct vdsl_all_profile, list);
				if(profile_P->type != VDSL_LINE_PROFILE_ID ) continue;
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
				for(i = 0; i < MIB_LineP_NUMBER ; i++){
					if(strcmp(uMibs.mibs_line->mib[i].oid, xdsl2BanplanPSD)==0)
						break;
				}
				if(strcmp(uMibs.mibs_line->mib[i].value, profile_name) == 0){
					//Hit
					PRINTL(DBG_LVL_ALWAYS|DBG_LVL_XML, "Vdsl Line Profile(%s) used ,Can't Delete PSD Profile(%s)",
					profile_P->profile_name, profile_name);
					return -DSL_ERR_NOPASS;
				}
			}
			ret = del_vdsl_profiles_fun (VDSL_PROFILE_PSD_ID, profile_name , "VdslPsdMasks");
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in com_profiles_main_new!!");
			ret = DSL_ERR_NOPASS;
			break;
	}

	return ret;
}

/**
 * Initialize Profile of Command line main function
 * \param type: profile type  
 */
int profiles_main_vdslprofile_init(int type)
{
	mt_ret ret;
	char command[4096],line[4096];
	int i = 0, k = 0;
	FILE *streamout;
	char tmp[64];
	char *token = NULL;
	int value = 0;

//yalee981223
//init_profile_linklist value mean:
//0:VDSL profile has not initialized
//1:VDSL profile has one time or more time initialized but it has not initialized finish,
//2:VDSL profile has initialized finish

	if(init_profile_linklist == 2 )
	{
		PRINTL(DBG_LVL_ALWAYS, "VDSL Profile has been initialized finish, not need again\n");
		return -DSL_ERR_NOPASS;
	}

	if(init_profile_linklist == 0){
		init_profile_global_fun();
		init_profile_linklist = 1;
		/*rebuild port_map_profile array*/
		k = 1;
		sprintf(command, ""CFGMGR_PATH" -r port%d_map_profile", k);
		while(k < MAX_PORTS){
			sprintf(tmp,",port%d_map_profile",k+1);
			strcat(command, tmp);
			k++;
		}

		if((streamout = popen(command, "r")) != NULL) {
			for ( i = 0 ; i < MAX_PORTS ; i++){
				if(fgets(line, 256, streamout) != NULL) {
					stripwhite(line);
					if(strcmp(line,"\n")==0){
						//sprintf(port_map_profile[i],"\0");
						port_map_linetemplate[i][0] = '\0';
						port_map_alarmtemplate[i][0] = '\0';
						continue;
					}
				//	sprintf(port_map_profile[i],line);
					token = strtok (line,"@");
					sprintf(port_map_linetemplate[i],"%s", token);
					token = strtok (NULL,"@");
					sprintf(port_map_alarmtemplate[i],"%s", token);
				}
			}
			pclose(streamout);
		}
	}
	/*rebuild profiles linklist*/
//yalee Template2
//int init_vdsl_profiles_fun (int type, int mibs_num, char *prefix_index, char *prefix)
#if 0//for VDSL Profile used
	if((type == VDSL_PROFILE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_PROFILE_ID].init_profile == 0)
	{
		profile_param[VDSL_PROFILE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_PROFILE_ID, MIB_MainP_NUMBER, "MAIN_PROFILE_INDEX", "VdslMainProfiles");
	}
#endif
	if((type == VDSL_LINE_TEMPLATE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_LINE_TEMPLATE_ID].init_profile == 0)
	{
		profile_param[VDSL_LINE_TEMPLATE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_LINE_TEMPLATE_ID, MIB_LineT_NUMBER, "LINE_TEMPLATE_INDEX", "VdslLineTemplates");
	}
	if((type == VDSL_LINE_PROFILE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_LINE_PROFILE_ID].init_profile == 0)
	{
		profile_param[VDSL_LINE_PROFILE_ID].init_profile = 1;
		ret = init_vdsl_profiles_fun (VDSL_LINE_PROFILE_ID, MIB_LineP_NUMBER, "LINE_PROFILE_INDEX", "VdslLineProfiles");
	}
	if((type == VDSL_CHAN_PROFILE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_CHAN_PROFILE_ID].init_profile == 0)
	{
		profile_param[VDSL_CHAN_PROFILE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_CHAN_PROFILE_ID, MIB_ChanP_NUMBER, "CHAN_PROFILE_INDEX", "VdslChanProfiles");
	}
	if((type == VDSL_ALARM_TEMPLATE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_ALARM_TEMPLATE_ID].init_profile == 0)
	{
		profile_param[VDSL_ALARM_TEMPLATE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_ALARM_TEMPLATE_ID, MIB_AlarmT_NUMBER, "ALARM_TEMPLATE_INDEX", "VdslAlarmTemplates");
	}
	if((type == VDSL_LINE_ALARM_PROFILE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_LINE_ALARM_PROFILE_ID].init_profile == 0)
	{
		profile_param[VDSL_LINE_ALARM_PROFILE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_LINE_ALARM_PROFILE_ID, MIB_LineAlarmP_NUMBER, "LINE_ALARM_PROFILE_INDEX", "VdslLineAlarmProfiles");
	}
	if((type == VDSL_CHAN_ALARM_PROFILE_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_CHAN_ALARM_PROFILE_ID].init_profile == 0)
	{
		profile_param[VDSL_CHAN_ALARM_PROFILE_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_CHAN_ALARM_PROFILE_ID, MIB_ChanAlarmP_NUMBER, "CHAN_ALARM_PROFILE_INDEX", "VdslChanAlarmProfiles");
	}
	if((type == VDSL_PROFILE_VN_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_PROFILE_VN_ID].init_profile == 0)
	{
		profile_param[VDSL_PROFILE_VN_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_PROFILE_VN_ID, MIB_VN_NUMBER, "VN_PROFILE_INDEX", "VdslVitualNoise");
	}
	if((type == VDSL_PROFILE_DPB_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_PROFILE_DPB_ID].init_profile == 0)
	{
		profile_param[VDSL_PROFILE_DPB_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_PROFILE_DPB_ID, MIB_DPB_NUMBER, "DPB_PROFIE_INDEX", "VdslDpboEPsd");
	}
	if((type == VDSL_PROFILE_RFI_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_PROFILE_RFI_ID].init_profile == 0)
	{
		profile_param[VDSL_PROFILE_RFI_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_PROFILE_RFI_ID, MIB_RFI_NUMBER, "RFI_PROFILE_INDEX", "VdslRfiBands");
	}
	if((type == VDSL_PROFILE_PSD_ID || type == VDSL_PROFILE_END_ID)
		&& profile_param[VDSL_PROFILE_PSD_ID].init_profile == 0)
	{
		profile_param[VDSL_PROFILE_PSD_ID].init_profile = 1;
		init_vdsl_profiles_fun (VDSL_PROFILE_PSD_ID, MIB_PSD_NUMBER, "PSD_PROFILE_INDEX", "VdslPsdMasks");
	}

	for (i = 0 ; i < VDSL_PROFILE_END_ID ; i++){
		if(profile_param[i].max_vdsl_profile_id >= 60000){
			PRINTL(DBG_LVL_ALWAYS, "Sorting Profile , please wait few minutes");
			profiles_main_sort_vdslprofiles();
			break;
		}
		value += profile_param[i].init_profile;
	}

	//yalee990302:because VDSL_PROFILE_ID not used, so VDSL_PROFILE_END_ID - 1
	if (type == VDSL_PROFILE_END_ID || value == (VDSL_PROFILE_END_ID - 1))
		init_profile_linklist = 2;

	return DSL_ERR_OK;
}

/**
 * Save Profile of Command line main function
 */
int profiles_main_vdslprofile_save()
{
	/**if no call init function, not need save**/
	if(init_profile_linklist == 0){
                return -DSL_ERR_NOPASS;
	}
//Template2
//int save_vdsl_profiles_fun (int type, char *prefix_index, char *prefix)
#if 0//for VDSL Profile used
	if(modify_vdsl_main_profile){
		save_vdsl_profiles_fun ( VDSL_PROFILE_ID, "MAIN_PROFILE_INDEX", "VdslMainProfiles");
		profile_param[VDSL_PROFILE_ID].modify_vdsl_profile = 0;
	}
#endif
	if(profile_param[VDSL_LINE_TEMPLATE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_LINE_TEMPLATE_ID, "LINE_TEMPLATE_INDEX", "VdslLineTemplates");
		profile_param[VDSL_LINE_TEMPLATE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_LINE_PROFILE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_LINE_PROFILE_ID, "LINE_PROFILE_INDEX", "VdslLineProfiles");
		profile_param[VDSL_LINE_PROFILE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_CHAN_PROFILE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_CHAN_PROFILE_ID, "CHAN_PROFILE_INDEX", "VdslChanProfiles");
		profile_param[VDSL_CHAN_PROFILE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_ALARM_TEMPLATE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_ALARM_TEMPLATE_ID, "ALARM_TEMPLATE_INDEX", "VdslAlarmTemplates");
		profile_param[VDSL_ALARM_TEMPLATE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_LINE_ALARM_PROFILE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_LINE_ALARM_PROFILE_ID, "LINE_ALARM_PROFILE_INDEX", "VdslLineAlarmProfiles");
		profile_param[VDSL_LINE_ALARM_PROFILE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_CHAN_ALARM_PROFILE_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_CHAN_ALARM_PROFILE_ID, "CHAN_ALARM_PROFILE_INDEX", "VdslChanAlarmProfiles");
		profile_param[VDSL_CHAN_ALARM_PROFILE_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_PROFILE_VN_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_PROFILE_VN_ID, "VN_PROFILE_INDEX", "VdslVitualNoise");
		profile_param[VDSL_PROFILE_VN_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_PROFILE_DPB_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_PROFILE_DPB_ID, "DPB_PROFIE_INDEX", "VdslDpboEPsd");
		profile_param[VDSL_PROFILE_DPB_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_PROFILE_RFI_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_PROFILE_RFI_ID, "RFI_PROFILE_INDEX", "VdslRfiBands");
		profile_param[VDSL_PROFILE_RFI_ID].modify_vdsl_profile = 0;
	}
	if(profile_param[VDSL_PROFILE_PSD_ID].modify_vdsl_profile){
		save_vdsl_profiles_fun ( VDSL_PROFILE_PSD_ID, "PSD_PROFILE_INDEX", "VdslPsdMasks");
		profile_param[VDSL_PROFILE_PSD_ID].modify_vdsl_profile = 0;
	}

	return DSL_ERR_OK;
}

/**
 * Display Profile of Command line main function
 */
int profiles_main_vdslprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	char option[256],profile_name[256];
	int i = 0 , value = 0, ret;
	FILE *streamout;
	char command[4096];
	char line[256];
	char active[256],connect[256];
	char mibsBuff[256];
	char mibsBuffDs[256],mibsBuffUs[256];

	ret = sscanf(pbuf,"%s %s", option, profile_name);
	if (ret < 1 || ret > 2  ||
		(strcmp(option,"line-template")!=0 &&
		strcmp(option,"line-profile")!=0 && strcmp(option,"sprofile")!= 0 &&
		strcmp(option,"virtual-noise")!= 0 && strcmp(option,"dpbopsd")!= 0 &&
		strcmp(option,"rfi-bands")!= 0 && strcmp(option,"psd")!= 0 &&
		strcmp(option,"chan-profile")!=0 &&
		strcmp(option,"alarm-template")!=0 &&
		strcmp(option,"line-alarm-profile")!=0 && strcmp(option,"chan-alarm-profile")!=0 &&
		strcmp(option,"port")!=0 ))
	{
//		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd profile 				:show profile names");
//		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd profile <profile_name> 		:show single profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd sprofile 				:show system profile names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-template 			:show line template names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-template <profile_name>		:show single line template content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-profile 			:show line profile names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-profile <profile_name> 		:show single line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd virtual-noise <profile_name>		:show single virtual noise line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd dpbopsd <profile_name>		:show single DpboPsd line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd rfi-bands <profile_name>		:show single RfiBands line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd psd <profile_name>			:show single PsdMask line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd chan-profile 			:show channel profile names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd chan-profile <profile_name> 		:show single channel profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd alarm-template 			:show line template names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd alarm-template <profile_name>	:show single line template content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-alarm-profile 			:show line profile names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd line-alarm-profile <profile_name> 	:show single line profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd chan-alarm-profile 			:show channel profile names");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd chan-alarm-profile <profile_name> 	:show single channel profile content");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd port 				:show profile used in each port");
		return -DSL_ERR_NOPASS;
	}
//yalee Template2
//int display_vdsl_profiles_fun(char *profile_name, int type, int options)
#if 0//for VDSL Profile used
	if(strcmp(option,"profile")==0) {
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_ID, 1);
	}
#endif
	if(strcmp(option,"line-template")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_LINE_TEMPLATE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_TEMPLATE_ID, 1);
	}
	else if(strcmp(option,"line-profile")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_LINE_PROFILE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_PROFILE_ID, 1);
	}
	else if(strcmp(option,"chan-profile")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_CHAN_PROFILE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_CHAN_PROFILE_ID, 1);
	}
	else if(strcmp(option,"alarm-template")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_ALARM_TEMPLATE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_ALARM_TEMPLATE_ID, 1);
	}
	else if(strcmp(option,"line-alarm-profile")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_LINE_ALARM_PROFILE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, 1);
	}
	else if(strcmp(option,"chan-alarm-profile")==0){
		if(ret == 1)
		display_vdsl_profiles_fun(NULL, VDSL_CHAN_ALARM_PROFILE_ID, 0);
		if(ret == 2)
		display_vdsl_profiles_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, 1);
	}
	else if(strcmp(option,"virtual-noise")==0){
		if(ret == 1){
			get_package_profile_name(1,0,VNS_PREFIX,NULL);
			display_vdsl_profiles_fun(NULL, VDSL_PROFILE_VN_ID, 0);
		}
		if(ret == 2){
			ret = syspackage_checkid_fun(VNS_PREFIX, profile_name);
			if (ret == DSL_ERR_OK)
			{
				//print system package virtual noise define
				get_package_profile_oid_value(VNS_PREFIX , profile_name, xdsl2LConfProfTxRefVnDs, mibsBuffDs);
				get_package_profile_oid_value(VNS_PREFIX , profile_name, xdsl2LConfProfTxRefVnUs, mibsBuffUs);
				virtual_noise_tables_display_fun(profile_name, mibsBuffDs, mibsBuffUs);
				display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_VN_ID);
			}
			else{
				//print user define virtual noise define
				display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_VN_ID, 1);
			}
		}
	}
	else if(strcmp(option,"dpbopsd")==0){
		if(ret == 1){
			get_package_profile_name(1,0,DPB_PREFIX,NULL);
			display_vdsl_profiles_fun(NULL, VDSL_PROFILE_DPB_ID, 0);
		}
		if(ret == 2){
			ret = syspackage_checkid_fun(DPB_PREFIX, profile_name);
			if (ret == DSL_ERR_OK){
				get_package_profile_oid_value(DPB_PREFIX , profile_name, xdsl2LConfProfDpboEPsd, mibsBuff);
				psdmask_tables_display_fun(profile_name, mibsBuff, NULL,VDSL_PROFILE_DPB_ID);
				display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_DPB_ID);
			}
			else{
				display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_DPB_ID, 1);
			}
		}
	}
	else if(strcmp(option,"rfi-bands")==0){
		if(ret == 1){
			get_package_profile_name(1,0,RFI_PREFIX,NULL);
			display_vdsl_profiles_fun(NULL, VDSL_PROFILE_RFI_ID, 0);
		}

		if(ret == 2){
			ret = syspackage_checkid_fun(RFI_PREFIX, profile_name);
			if (ret == DSL_ERR_OK){
				//display systemp define
				get_package_profile_oid_value(RFI_PREFIX , profile_name, xdsl2LConfProfRfiBands, mibsBuff);
				rfi_tables_display_fun(profile_name, mibsBuff);
				display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_RFI_ID);
			}
			else{
				//display user define
				display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_RFI_ID, 1);
			}
		}
	}
	else if(strcmp(option,"psd")==0){
		if(ret == 1){
			get_package_profile_name(1,0,PSD_PREFIX,NULL);
			display_vdsl_profiles_fun(NULL, VDSL_PROFILE_PSD_ID, 0);
		}
		if(ret == 2){
			ret = syspackage_checkid_fun(PSD_PREFIX, profile_name);
			if (ret == DSL_ERR_OK){
				get_package_profile_oid_value(PSD_PREFIX , profile_name, xdsl2LConfProfPsdMaskDs, mibsBuffDs);
				get_package_profile_oid_value(PSD_PREFIX , profile_name, xdsl2LConfProfPsdMaskUs, mibsBuffUs);
				psdmask_tables_display_fun(profile_name, mibsBuffDs, mibsBuffUs, VDSL_PROFILE_PSD_ID);
				display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_PSD_ID);
			}
			else{
				display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_PSD_ID, 1);
			}
		}
	}
	else if(strcmp(option,"port")==0){
		/*print port and profile relations*/
		for ( i = 0 ; i < MAX_PORTS ; i++){
			line[0]=0x00;
			sprintf(command, ""CFGMGR_PATH" -r V_POWEROFF_P%d", i+1);
			if((streamout = popen(command, "r")) != NULL) {
				if(fgets(line, 256, streamout) != NULL) {
					stripwhite(line);
				}
				pclose(streamout);
			}
			if(line[0] == '#') {
				sprintf(active,"PowerOn");
			} else {
				sprintf(active,"PowerOff");
			}

			line[0]=0x00;
			sprintf(command, ""CFGMGR_PATH" -r V_DISABLE_P%d", i+1);
			if((streamout = popen(command, "r")) != NULL) {
				if(fgets(line, 256, streamout) != NULL) {
					stripwhite(line);
				}
				pclose(streamout);
			}
			if(line[0] == '#') {
				sprintf(connect,"Enable");
			} else {
				sprintf(connect,"Disable");
			}
			//yalee990303: because port is not in VDSL ID, so use Other ID replace this action
			if(profile_param[VDSL_LINE_TEMPLATE_ID].init_profile == 0)
					profiles_main_vdslprofile_init(VDSL_LINE_TEMPLATE_ID);

			PRINTL(DBG_LVL_ALWAYS, "Port%d %s %s LineTemplate(%s), AlarmTemplate(%s)",
				i+1, active, connect,port_map_linetemplate[i], port_map_alarmtemplate[i]);
			PRINTL(DBG_LVL_XML, "%d %s %s %s %s|",i+1, active, connect,port_map_linetemplate[i], port_map_alarmtemplate[i]);
		}
	}
	else if(strcmp(option,"sprofile")==0){
		/*show package support bandplan*/
		get_package_profile_name(1,0, SYS_PREFIX,NULL);
		get_package_profile_name(1,0, BND_PREFIX,NULL);
		get_package_profile_name(1,0, VNS_PREFIX,NULL);
		get_package_profile_name(1,0, PSD_PREFIX,NULL);
		get_package_profile_name(1,0, RFI_PREFIX,NULL);
		get_package_profile_name(1,0, DPB_PREFIX,NULL);
	}else{

		PRINTL(DBG_LVL_ALWAYS, "input param ERROR in profiles_main_vdslprofile_show!!");

	}

	return DSL_ERR_OK;
}

/**
 * Sort Profile main function
 */
int profiles_main_sort_vdslprofiles()
{
	int i = 0;
	if(init_profile_linklist != 2){
		//init all vdsl profile function space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}
//yalee Template2

//	int sort_vdsl_profiles_fun(int type, int profile_num, char* prefix)
#if 0//for VDSL Profile used
	sort_vdsl_profiles_fun( VDSL_PROFILE_ID, init_main_profile_number,"VdslMainProfiles");
#endif
	sort_vdsl_profiles_fun(VDSL_LINE_TEMPLATE_ID, "VdslLineTemplates");
	sort_vdsl_profiles_fun(VDSL_LINE_PROFILE_ID, "VdslLineProfiles");
	sort_vdsl_profiles_fun(VDSL_CHAN_PROFILE_ID, "VdslChanProfiles");
	sort_vdsl_profiles_fun(VDSL_ALARM_TEMPLATE_ID, "VdslAlarmTemplates");
	sort_vdsl_profiles_fun(VDSL_LINE_ALARM_PROFILE_ID, "VdslLineAlarmProfiles");
	sort_vdsl_profiles_fun(VDSL_CHAN_ALARM_PROFILE_ID, "VdslChanAlarmProfiles");
	sort_vdsl_profiles_fun(VDSL_PROFILE_VN_ID, "VdslVitualNoise");
	sort_vdsl_profiles_fun(VDSL_PROFILE_DPB_ID, "VdslDpboEPsd");
	sort_vdsl_profiles_fun(VDSL_PROFILE_RFI_ID, "VdslRfiBands");
	sort_vdsl_profiles_fun(VDSL_PROFILE_PSD_ID, "VdslPsdMasks");
	for (i = 0 ; i < VDSL_PROFILE_END_ID ; i++){
		profile_param[i].modify_vdsl_profile = 1;
	}
	profiles_main_vdslprofile_save();
	//Sort vdsl parameter in board.conf
	//reset vdsl global value
	for (i = 0 ; i < VDSL_PROFILE_END_ID ; i++){
		profile_param[i].max_vdsl_profile_id = profile_param[i].init_profile_number;
	}

	return DSL_ERR_OK;
}

//yalee981210:search profile and port relations functions return port_map array *:used X:not used
/**
 *  Profile Mapping to port function
 * \param type: profile type  
 * \param profile_name: name of profile
 * \param port_map: return *:use ,X:not use   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int vdsl_profiles_map_port_fun (int type, char *profile_name, char *port_map)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	char profile_name_tmp[256];
	int i , j;

	switch (type){
		case VDSL_PROFILE_ID:
			break;
		case VDSL_LINE_TEMPLATE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				if(strcmp(profile_name, port_map_linetemplate[i]) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
#if 0//yalee1210
			for(i = 0 ; i < MAX_PORTS ; i++) printf("yalee:port_map:%c",port_map[i]);
			printf("\n");
#endif
			break;
		case VDSL_LINE_PROFILE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(profile_name, uMibs.mibs_member->vdsl_line_name) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_CHAN_PROFILE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(profile_name, uMibs.mibs_member->vdsl_chan_name) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_ALARM_TEMPLATE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				if(strcmp(profile_name, port_map_alarmtemplate[i]) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_LINE_ALARM_PROFILE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID ,port_map_alarmtemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Alarm Template No Exist",port_map_alarmtemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(profile_name, uMibs.mibs_member->vdsl_line_name) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_CHAN_ALARM_PROFILE_ID:
			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID ,port_map_alarmtemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Alarm Template No Exist",port_map_alarmtemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				if(strcmp(profile_name, uMibs.mibs_member->vdsl_chan_name) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_PROFILE_VN_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"VNS")==0)
				break;
			}

			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				sprintf(profile_name_tmp, "%s",uMibs.mibs_member->vdsl_line_name);
				profile_P = all_profile_search(VDSL_LINE_PROFILE_ID ,profile_name_tmp);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Profile No Exist",profile_name_tmp);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;

				if(strcmp(profile_name, uMibs.mibs_line->mib[j].value) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_PROFILE_DPB_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"DPB")==0)
				break;
			}

			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				sprintf(profile_name_tmp, "%s",uMibs.mibs_member->vdsl_line_name);
				profile_P = all_profile_search(VDSL_LINE_PROFILE_ID ,profile_name_tmp);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Profile No Exist",profile_name_tmp);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;

				if(strcmp(profile_name, uMibs.mibs_line->mib[j].value) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_PROFILE_RFI_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"RFI")==0)
				break;
			}

			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				sprintf(profile_name_tmp, "%s",uMibs.mibs_member->vdsl_line_name);
				profile_P = all_profile_search(VDSL_LINE_PROFILE_ID ,profile_name_tmp);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Profile No Exist",profile_name_tmp);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;

				if(strcmp(profile_name, uMibs.mibs_line->mib[j].value) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		case VDSL_PROFILE_PSD_ID:
			for(j = 0 ; j < MIB_LineP_NUMBER ; j++)
			{
				if(strcmp(mib_default_line_name[j].oid,"PSD")==0)
				break;
			}

			for(i = 0 ; i < MAX_PORTS ; i++){
				profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID ,port_map_linetemplate[i]);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Template No Exist",port_map_linetemplate[i]);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
				sprintf(profile_name_tmp, "%s",uMibs.mibs_member->vdsl_line_name);
				profile_P = all_profile_search(VDSL_LINE_PROFILE_ID ,profile_name_tmp);
				if(profile_P == NULL){
					PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Line Profile No Exist",profile_name_tmp);
					return -DSL_ERR_NOPASS;
				}
				uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;

				if(strcmp(profile_name, uMibs.mibs_line->mib[j].value) == 0)
					port_map[i] = '*';
				else
					port_map[i] = 'X';
			}
			break;
		default:
			PRINTL(DBG_LVL_ALWAYS, "PROFILE TYPE ERROR in vdsl_profiles_map_port_fun!!");
			break;
	}

	return DSL_ERR_OK;
}

/**
 * Virtual Noise PSD transfer to mib function
 * \param tone:   
 * \param level_c: noise level 
 * \param buffer: return mib   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int vn_psd_to_mib(char *tone, char *level_c, char *buffer)
{
        int level = 0 ,subc = 0;
        int psd = 0;
        float level_f = 0;
        float carry = 0;

        //yalee: virtual noise encode function (((noise_level*10+1400) * 2/10 ) << 16) | tone == encode
        //tone range 1~7000
        //nlevel range -40 ~ -140dbm

//      printf("------psd_to_mib encode------\n");
        level_f = atof(level_c);
        subc = atoi(tone);

        level = (int)level_f;
        carry = (float)level;

        carry = carry - level_f;
//        printf("carry %.1f\n",carry);
        if(carry >= 0.5){
                level = (level * 10 ) - 5;
        }
        else{
                //carry == 0
                level = level * 10;
        }

        psd = (((level+1400) * 2/10) << 16) | subc;
#if PROFILE_DEBUG_MEG
        printf("psd:%06x = (((level:%d +1400)* 2/10) << 16) | subc:%d\n",psd ,level ,subc);
#endif
        sprintf(buffer,"%06x",psd);

	return DSL_ERR_OK;
}

/**
 * Virtual Noise mib transfer to PSD function
 * \param tone:   
 * \param level_c: noise level 
 * \param buffer: return mib   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int vn_mib_to_psd(char *tone, char *level_c, char *buffer)
{
        int level = 0 ,subc = 0;
        int psd = 0;
        float level_f = 0;


//      printf("------mib_to_psd decode------\n");
        psd = strtol(buffer, NULL, 16);
        subc = psd & 0x00ffff;
        sprintf(tone,"%d",subc);

//      level = (psd & 0xff0000) >>16;
        level = psd >> 16;

        level_f = (float)level;
        level_f = ((level_f * 5) - 1400) / 10;
        sprintf(level_c,"%.1f",level_f);

#if PROFILE_DEBUG_MEG
        printf("tone:%d, nlevel:%.1f\n",subc,level_f);
#endif
        return DSL_ERR_OK;
}

/**
 * PSD transfer to mib function
 * \param tone:   
 * \param level_c: noise level 
 * \param buffer: return mib   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int psd_to_mib(char *tone, char *level_c, char *buffer)
{
	int level = 0 ,subc = 0;
	int psd = 0;
	float level_f = 0;
	float carry = 0;

	//yalee: encode function ((noise_level * -2 ) << 16) | (freq / 4.3125) == encode
	//tone range 1-7000
	//nlevel range -127.5-0

//	printf("------psd_to_mib encode------\n");
	level_f = atof(level_c);
	subc = atoi(tone);

	level = (int)level_f;
	carry = (float)level;

	carry = carry - level_f;
	if(carry > 0.5){
		level = (level * 10 ) - 10;
	}
	else if((carry <= 0.5) && (carry > 0)){
		level = (level * 10 ) - 5;
	}
	else{
		//carry == 0
		level = level * 10;
	}

	psd = ((level * -2/10) << 16) | subc;
#if PROFILE_DEBUG_MEG
	printf("psd:%06x = ((level:%d * -2/10) << 16) | subc:%d\n",psd ,level ,subc);
#endif
	sprintf(buffer,"%06x",psd);

	return DSL_ERR_OK;
}

/**
 * Mib transfer to psd function
 * \param tone:   
 * \param level_c: noise level 
 * \param buffer: return mib   
 * \return
 *      - 0 : success
 *      - other : error code 
 */
int mib_to_psd(char *tone, char *level_c, char *buffer)
{
	int level = 0 ,subc = 0;
	int psd = 0;
	float level_f = 0;


//	printf("------mib_to_psd decode------\n");
	psd = strtol(buffer, NULL, 16);
	subc = psd & 0x00ffff;
	sprintf(tone,"%d",subc);

//	level = (psd & 0xff0000) >>16;
	level = psd >> 16;

	level_f = (float)level;
	if(level_f != 0){
		level_f = level_f / -2;
	}
	sprintf(level_c,"%.1f",level_f);

	return DSL_ERR_OK;
}
#endif //TEMPLATE_PROFILE
#endif //CO_API

#if 0
int psd_to_mib_freq(char *freq_c, char *level_c, char *buffer)
{
	int level = 0 ,subc = 0;
	int psd = 0;

	float level_f = 0;
	float freq = 0;
	float subc_f= 0;
	float carry = 0;

	//yalee: encode function ((noise_level * -2 ) << 16) | (freq / 4.3125) == encode

//	printf("------psd_to_mib encode------\n");
	freq = atof(freq_c);
	level_f = atof(level_c);

	subc_f = freq / 4.3125;
	subc = (int)subc_f;

	level = (int)level_f;
	carry = (float)level;

	carry = carry - level_f;
	if(carry > 0.5){
		level = (level * 10 ) - 10;
	}
	else if((carry <= 0.5) && (carry > 0)){
		level = (level * 10 ) - 5;
	}
	else{
		//carry == 0
		level = level * 10;
	}

	psd = ((level * -2/10) << 16) | subc;
#if PROFILE_DEBUG_MEG
	printf("psd:%06x = ((level:%d * -2/10) << 16) | subc:%d\n",psd ,level ,subc);
#endif
	sprintf(buffer,"%06x",psd);

	return DSL_ERR_OK;
}

int mib_to_psd_freq(char *freq_c, char *level_c, char *buffer)
{
	int level = 0 ,subc = 0;
	int psd = 0;
	float level_f = 0;
	float freq = 0;
	float subc_f = 0;


//	printf("------mib_to_psd decode------\n");
	psd = strtol(buffer, NULL, 16);
	subc = psd & 0x00ffff;
	subc_f = (float)subc;
	freq = subc_f * 4.3125;
	sprintf(freq_c,"%.4f",freq);

//	level = (psd & 0xff0000) >>16;
	level = psd >> 16;

	level_f = (float)level;
	if(level_f != 0){
		level_f = level_f / -2;
	}
	sprintf(level_c,"%.1f",level_f);

	return DSL_ERR_OK;
}
#endif


/**
 * VDSL Template Profile Manage Profile CLI Function
 **/

//yalee991124:maybe move to profilecli.c 
#ifdef CO_API
#ifdef TEMPLATE_PROFILE
//yalee980812 vdsl-profile start Template2
int com_profiles_vdslprofile_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}
#if 1
	sprintf(buff,"%d %s",VDSL_PROFILE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);
	return ret;
#endif
#if 0
		//**test file name exist ?**//
		new = all_profile_search(VDSL_PROFILE_ID, profile_name);
		if (ret != 1 || new != NULL){
			PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");

			if(new != NULL)
			PRINTL(DBG_LVL_ALWAYS, "profile_name exist");
			return -DSL_ERR_NOPASS;
		}

		if(strlen(profile_name) > 64){
			PRINTL(DBG_LVL_ALWAYS, "profile_name len=%d too long limit 64 char",strlen(profile_name));
			return -DSL_ERR_NOPASS;

		}

		//profile limit:1024
		if(init_main_profile_number > MAX_PROFILE_NUMBER){
			PRINTL(DBG_LVL_ALWAYS, "Profile Number Full. Limit:%d",MAX_PROFILE_NUMBER);
				return -DSL_ERR_NOPASS;
		}

		//**if max_vdsl_profile_id over 32bit **//
		if(max_vdsl_main_profile_id+1 >= 65535){
			PRINTL(DBG_LVL_ALWAYS, "Sorting Profile , please wait few minutes");
			profiles_main_sort_vdslprofiles();
		}

		new_vdsl_profiles_fun (VDSL_PROFILE_ID, profile_name);
	return DSL_ERR_OK;
#endif
}

int com_profiles_vdslprofile_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int i = 0;
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}
#if 1
	sprintf(buff,"%d %s",VDSL_PROFILE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
#endif
#if 0
	if ( ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't delete Default Profile");
		return -DSL_ERR_NOPASS;
	}

	for(i = 0 ; i < MAX_PORTS; i++){
		if(strcmp(port_map_profile[i], profile_name) == 0){
			PRINTL(DBG_LVL_ALWAYS, "Vdsl Port %d used ,Can't Delete Vdsl Main Profile(%s) used",i+1,profile_name);
			return -DSL_ERR_NOPASS;
		}
	}

	del_vdsl_profiles_fun (VDSL_PROFILE_ID, profile_name , "VdslMainProfiles");

	return DSL_ERR_OK;
#endif
}

int com_profiles_vdslprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_tree (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], command[256] ;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	char vdsl_line_template[64], vdsl_line_profile[64],vdsl_chan_profile[64];
	char vdsl_alarm_template[64], vdsl_line_alarm_profile[64],vdsl_chan_alarm_profile[64];
	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <Vdsl Profile Name>");
		return -DSL_ERR_NOPASS;
	}

	//Line Template
	profile_P = all_profile_search(VDSL_PROFILE_ID ,profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Main Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(vdsl_line_template, "%s",uMibs.mibs_member->vdsl_line_name);
	sprintf(vdsl_alarm_template, "%s",uMibs.mibs_member->vdsl_chan_name);

	profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID, vdsl_line_template);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Template No Exist",vdsl_line_template);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(vdsl_line_profile, "%s",uMibs.mibs_member->vdsl_line_name);
	sprintf(vdsl_chan_profile, "%s",uMibs.mibs_member->vdsl_chan_name);

	profile_P = all_profile_search(VDSL_LINE_PROFILE_ID, vdsl_line_profile);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Profile No Exist",vdsl_line_profile);
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_CHAN_PROFILE_ID, vdsl_chan_profile);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Channel Profile No Exist",vdsl_chan_profile);
		return -DSL_ERR_NOPASS;
	}

	//tree alarm template
	profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID, vdsl_alarm_template);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template No Exist",vdsl_alarm_template);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(vdsl_line_alarm_profile, "%s",uMibs.mibs_member->vdsl_line_name);
	sprintf(vdsl_chan_alarm_profile, "%s",uMibs.mibs_member->vdsl_chan_name);

	//tree line alarm profile
	profile_P = all_profile_search(VDSL_LINE_ALARM_PROFILE_ID, vdsl_line_alarm_profile);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Alarm Profile No Exist",vdsl_line_alarm_profile);
		return -DSL_ERR_NOPASS;
	}

	//tree channel alarm profile
	profile_P = all_profile_search(VDSL_CHAN_ALARM_PROFILE_ID, vdsl_chan_alarm_profile);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Channel Alarm Profile No Exist",vdsl_chan_alarm_profile);
		return -DSL_ERR_NOPASS;
	}

//print binary tree
PRINTL(DBG_LVL_ALWAYS,"");
PRINTL(DBG_LVL_ALWAYS,"VDSL Profile Binary Tree Relations:");
PRINTL(DBG_LVL_ALWAYS,"                              \n\n\n");
PRINTL(DBG_LVL_ALWAYS,"                              / => Line Profile(%s)",vdsl_line_profile);
PRINTL(DBG_LVL_ALWAYS,"               =>Line Template(%s)",vdsl_line_template);
PRINTL(DBG_LVL_ALWAYS,"             /                \\ => Channel Profile(%s)",vdsl_chan_profile);
PRINTL(DBG_LVL_ALWAYS,"      Profile(%s)",profile_name);
PRINTL(DBG_LVL_ALWAYS,"             \\                 / =>Line Alarm Profile(%s)",vdsl_line_alarm_profile);
PRINTL(DBG_LVL_ALWAYS,"               =>Alarm Template(%s)",vdsl_alarm_template);
PRINTL(DBG_LVL_ALWAYS,"                               \\ =>Channel Alarm Profile(%s)",vdsl_chan_alarm_profile);
PRINTL(DBG_LVL_ALWAYS,"                              \n\n\n");

	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_free (unsigned char * pbuf, cmdt * pcmd)
{
	free_vdsl_profiles_fun();
	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslprofile_set_cmd;
	set_prompt("(profiles profile set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdslprofile_cmd[] = {
	{"new","Create new xdsl profile", NULL, NULL,com_profiles_vdslprofile_new},
	{"del", "Delete xdsl profile",NULL, NULL,com_profiles_vdslprofile_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdslprofile_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdslprofile_save},
//	{"init","Initialize Vdsl Profile", NULL, NULL,profiles_main_vdslprofile_init},//com_profiles_vdslprofile_init},
	{"tree","Show profile relation binary tree", NULL, NULL,com_profiles_vdslprofile_tree},
//	{"free","Free all link list", NULL, NULL,com_profiles_vdslprofile_free},
	{"set", "Set commands for xdsl profile",profiles_vdslprofile_set_cmd, NULL,com_profiles_vdslprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslprofile_cmd;
	set_prompt("(profiles profile)");
	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_set_linetemplate (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char profile_name_lt[256];
	int i = 0;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name, profile_name_lt);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <LineTemplate profile_name>");
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID, profile_name_lt);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Template No Exist",profile_name_lt);
		profiles_main_vdslprofile_show("line-template",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_PROFILE_ID, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Main Profile No Exist",profile_name);
		profiles_main_vdslprofile_show("profile",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P->modify = '*';
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_line_name, "%s",profile_name_lt);
	profile_param[VDSL_PROFILE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}

int com_profiles_vdslprofile_set_alarmtemplate (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char profile_name_at[256];
	int i = 0;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name, profile_name_at);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <AlarmTemplate profile_name>");
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID ,profile_name_at);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template No Exist",profile_name_at);
		profiles_main_vdslprofile_show("alarm-template",NULL);
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_PROFILE_ID ,profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Main Profile No Exist",profile_name);
		profiles_main_vdslprofile_show("profile",NULL);
		return -DSL_ERR_NOPASS;
	}
	profile_P->modify = '*';
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_chan_name, "%s",profile_name_at);
	profile_param[VDSL_PROFILE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}


cmdt profiles_vdslprofile_set_cmd[] = {
	{"line-template","Specifies the line configuration profile template", NULL, NULL, com_profiles_vdslprofile_set_linetemplate},
	{"alarm-template","Specifies the alarm configuration profile template", NULL, NULL, com_profiles_vdslprofile_set_alarmtemplate},
	{"exit", "Change to upper directory", profiles_vdslprofile_cmd, NULL, com_vdsl_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-profile end Template2


//yalee980812 vdsl-line-template start Template2
int com_profiles_vdsllinetemplate_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_TEMPLATE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdsllinetemplate_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_TEMPLATE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdsllinetemplate_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_TEMPLATE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_LINE_TEMPLATE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdsllinetemplate_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllinetemplate_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllinetemplate_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllinetemplate_set_cmd;
	set_prompt("(profiles line-template set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdsllinetemplate_cmd[] = {
	{"new","Create new xdsl template profile", NULL, NULL,com_profiles_vdsllinetemplate_new},
	{"del", "Delete xdsl template profile",NULL, NULL,com_profiles_vdsllinetemplate_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdsllinetemplate_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdsllinetemplate_save},
//	{"init","Initialize Vdsl Line Template", NULL, NULL,com_profiles_vdsllinetemplate_init},
	{"set", "Set commands for xdsl template profile",profiles_vdsllinetemplate_set_cmd, NULL,com_profiles_vdsllinetemplate_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_line_template (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllinetemplate_cmd;
	set_prompt("(profiles line-template)");
	return DSL_ERR_OK;
}

int com_profiles_vdsllinetemplate_set_lineprofile (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name_lt[256];
	char profile_name_lp[256];
	int i = 0;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name_lt, profile_name_lp);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <LineTemplate profile_name> <LineProfile profile_name>");
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_LINE_PROFILE_ID, profile_name_lp);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Profile No Exist",profile_name_lp);
		profiles_main_vdslprofile_show("line-profile",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID, profile_name_lt);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Template No Exist",profile_name_lt);
		profiles_main_vdslprofile_show("line-template",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P->modify = '*';
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_line_name, "%s",profile_name_lp);
	profile_param[VDSL_LINE_TEMPLATE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}

int com_profiles_vdsllinetemplate_set_chanprofile (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name_lt[256];
	char profile_name_cp[256];
	int i = 0;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name_lt, profile_name_cp);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <LineTemplate profile_name> <ChannelProfile profile_name>");
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_CHAN_PROFILE_ID, profile_name_cp);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Channel Profile No Exist",profile_name_cp);
		profiles_main_vdslprofile_show("chan-profile",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID, profile_name_lt);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Template No Exist",profile_name_lt);
		profiles_main_vdslprofile_show("line-template",NULL);
		return -DSL_ERR_NOPASS;
	}

	profile_P->modify = '*';
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_chan_name, "%s",profile_name_cp);
	profile_param[VDSL_LINE_TEMPLATE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}


cmdt profiles_vdsllinetemplate_set_cmd[] = {
	{"line-profile","Specifies the line configuration profile", NULL, NULL, com_profiles_vdsllinetemplate_set_lineprofile},
	{"chan-profile","Specifies the channel configuration profile", NULL, NULL, com_profiles_vdsllinetemplate_set_chanprofile},
	{"exit", "Change to upper directory", profiles_vdsllinetemplate_cmd, NULL, com_vdsl_line_template},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-line-template end Template2


//yalee980812 vdsl-line-profile start Template2
int com_profiles_vdsllineprofile_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_PROFILE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdsllineprofile_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_PROFILE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdsllineprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int options = 1;

	ret = sscanf(pbuf,"%s %d", profile_name, &options);

	if(ret == 1 || ret == 2){
		//yalee990624:options 2 : for WebUI used
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_PROFILE_ID, options);
	}
	else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_LINE_PROFILE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllineprofile_set_cmd;
	set_prompt("(profiles line-profile set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdsllineprofile_cmd[] = {
	{"new","Create new xdsl line profile", NULL, NULL,com_profiles_vdsllineprofile_new},
	{"del", "Delete xdsl line profile",NULL, NULL,com_profiles_vdsllineprofile_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdsllineprofile_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdsllineprofile_save},
//	{"init","Initialize Vdsl Line Profile", NULL, NULL,com_profiles_vdsllineprofile_init},
	{"set", "Set commands for xdsl line profile",profiles_vdsllineprofile_set_cmd, NULL,com_profiles_vdsllineprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_line_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllineprofile_cmd;
	set_prompt("(profiles line-profile)");
	return DSL_ERR_OK;
}

/**
 * modify profile bandplan id
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_SYS (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	int i = 1;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,SYS_PREFIX,NULL);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

		/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(SYS_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanSYS, NULL, 0, value);
		return DSL_ERR_OK;
	}

		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s System Profile Bandplan",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,SYS_PREFIX,NULL);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_BND (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	char mibsBuff[256];
	int i = 1;
	int multiProfile = 0, value_i = 0;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,BND_PREFIX,NULL);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

		/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(BND_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanBND, NULL, 0, value);

		//recover maxNomAtpDs maxNomAtpUs maxNomPsdDs maxNomPsdUs
		get_package_profile_oid_value(BND_PREFIX , value, xdsl2LConfProfMaxNomAtpDs, mibsBuff);
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomAtpDs, NULL, 0, mibsBuff);

		get_package_profile_oid_value(BND_PREFIX , value, xdsl2LConfProfMaxNomAtpUs, mibsBuff);
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomAtpUs, NULL, 0, mibsBuff);

		get_package_profile_oid_value(BND_PREFIX , value, xdsl2LConfProfMaxNomPsdDs, mibsBuff);
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomPsdDs, NULL, 0, mibsBuff);

		get_package_profile_oid_value(BND_PREFIX , value, xdsl2LConfProfMaxNomPsdUs, mibsBuff);
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomPsdUs, NULL, 0, mibsBuff);

		//yalee990706:recover BND support profile frequency(Hz) 
		get_package_profile_oid_value(BND_PREFIX , value, xdsl2LConfProfProfiles, mibsBuff);
		multiProfile = strtol(mibsBuff,NULL,16);
		if(multiProfile == 0x10){ 
			value_i = (multiProfile*4) - 1; 
		}else{
			value_i = (multiProfile*2) - 1;
		}
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfProfiles, NULL, value_i, NULL);

		return DSL_ERR_OK;
	}

		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s Band Profile",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,BND_PREFIX,NULL);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_VNS (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	int i = 1;
	struct vdsl_all_profile *profile_P;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,VNS_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_VN_ID, 0);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}
	/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(VNS_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanVNS, NULL, 0, value);
		return DSL_ERR_OK;
	}

	profile_P = all_profile_search(VDSL_PROFILE_VN_ID , value);
	if(profile_P != NULL){
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanVNS, NULL, 0, value);
		return DSL_ERR_OK;
	}
		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s Virtual Noise PSD",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,VNS_PREFIX,NULL);
	display_vdsl_profiles_fun(NULL, VDSL_PROFILE_VN_ID, 0);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_PSD (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	int i = 1;
	struct vdsl_all_profile *profile_P;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,PSD_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_PSD_ID, 0);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

	/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(PSD_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanPSD, NULL, 0, value);
		return DSL_ERR_OK;
	}

	profile_P = all_profile_search(VDSL_PROFILE_PSD_ID , value);
	if(profile_P != NULL){
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanPSD, NULL, 0, value);
		return DSL_ERR_OK;
	}
		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s PSD",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,PSD_PREFIX,NULL);
	display_vdsl_profiles_fun(NULL, VDSL_PROFILE_PSD_ID, 0);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_RFI (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	int i = 1;
	struct vdsl_all_profile *profile_P;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,RFI_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_RFI_ID, 0);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

	/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(RFI_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanRFI, NULL, 0, value);
		return DSL_ERR_OK;
	}

	profile_P = all_profile_search(VDSL_PROFILE_RFI_ID , value);
	if(profile_P != NULL){
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanRFI, NULL, 0, value);
		return DSL_ERR_OK;
	}
		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s RFI",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,RFI_PREFIX,NULL);
	display_vdsl_profiles_fun(NULL, VDSL_PROFILE_RFI_ID, 0);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_DPB (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[128];
	char bandplan[128];
	int i = 1;
	struct vdsl_all_profile *profile_P;

	ret = sscanf(pbuf, "%s %s", profile_name, value);
	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		get_package_profile_name(1,0,DPB_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_DPB_ID, 0);
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}

	/*need check bandplan code, if not suppourt can't setting*/
	ret = syspackage_checkid_fun(DPB_PREFIX, value);
	if (ret == DSL_ERR_OK) {
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanDpboEPsd, NULL, 0, value);
		return DSL_ERR_OK;
	}

	profile_P = all_profile_search(VDSL_PROFILE_DPB_ID , value);
	if(profile_P != NULL){
		update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanDpboEPsd, NULL, 0, value);
		return DSL_ERR_OK;
	}
		/*not support this bandplan*/
	PRINTL(DBG_LVL_ALWAYS, "Not support %s DpboPsd",value);
	/*show support bandplan*/
	get_package_profile_name(1,0,DPB_PREFIX,NULL);
	display_vdsl_profiles_fun(NULL, VDSL_PROFILE_DPB_ID, 0);
	return -DSL_ERR_NOPASS;
}

int com_profiles_vdsllineprofile_set_IOT (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[6];
	char bandplan[128];
	int i = 1, value_i = 0;

	ret = sscanf(pbuf, "%s %d", profile_name, &value_i);

	if (ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-65535");
		return -DSL_ERR_NOPASS;
	}

	if (strcmp(profile_name,"DEFVAL") == 0){
		PRINTL(DBG_LVL_ALWAYS, "Can't modify Default Profile");
		return -DSL_ERR_NOPASS;
	}
	if (value_i > 65535 || value_i < 0){
		PRINTL(DBG_LVL_ALWAYS, "over integer range");
		return -DSL_ERR_NOPASS;
	}
	sprintf(value,"%d",value_i);

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2BanplanIOT, NULL, 0, value);
	return DSL_ERR_OK;

}

/**
 * modify Multi Profile settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-1
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_profiles (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256], value[9];
	unsigned int i = 0, value_i = 0;
	char BND[128];
	char mibsBuff[256];
	int multiProfile = 0, value_i2 = 0;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	memset(value,'\0',sizeof(char)*9);
	ret = sscanf(pbuf, "%s %s", profile_name, value);
	strlen(value);
	if ((ret != 2) || (strlen(value) != 8)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <8 bit bitmasks>");
		PRINTL(DBG_LVL_ALWAYS, "	0 : non-active");
		PRINTL(DBG_LVL_ALWAYS, "	1 : active\n");
		PRINTL(DBG_LVL_ALWAYS, "Bit 7:30a, Bit 6:17a, Bit 5:12b, Bit 4:12a");
		PRINTL(DBG_LVL_ALWAYS, "Bit 3:8d,  Bit 2:8c,  Bit 1:8b,  Bit 0:8a");
		PRINTL(DBG_LVL_ALWAYS, "ex:");
		PRINTL(DBG_LVL_ALWAYS, "active 30a:");
		PRINTL(DBG_LVL_ALWAYS, "cmd <profile_name> 10000000");
		PRINTL(DBG_LVL_ALWAYS, "active 30a,12b:");
		PRINTL(DBG_LVL_ALWAYS, "cmd <profile_name> 10100000");
		PRINTL(DBG_LVL_ALWAYS, "active 30a,17a,12b,12a,8d,8c,8b,8a:");
		PRINTL(DBG_LVL_ALWAYS, "cmd <profile_name> 11111111");
		return -DSL_ERR_NOPASS;
	}
	for(i=0 ; i < 8 ;i++){
		if((value[i] != '0') && (value[i] != '1')){
			PRINTL(DBG_LVL_ALWAYS, "input value is not binary value");
			return -DSL_ERR_NOPASS;
		}
	}
	value_i = strtoul(value, NULL, 2);
	if(value_i == 0){
		PRINTL(DBG_LVL_ALWAYS, "Least choice one bit");
		return -DSL_ERR_NOPASS;
	}
	//yalee990706:must check BND support frequency(Hz) 
	profile_P = all_profile_search(VDSL_LINE_PROFILE_ID, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_line = (struct mibs_line_struct *)profile_P->mibs;
	for (i = 0 ; i < MIB_LineP_NUMBER ; i++)
	{
		if (strcmp(mib_default_line_name[i].oid,"BND")==0){
			sprintf(BND,"%s",uMibs.mibs_line->mib[i].value);
			break;
		}
	}

	get_package_profile_oid_value(BND_PREFIX , BND, xdsl2LConfProfProfiles, mibsBuff);
	multiProfile = strtol(mibsBuff,NULL,16);
	if(multiProfile == 0x10){ 
		value_i2 = (multiProfile*4) - 1; 
	}else{
		value_i2 = (multiProfile*2) - 1;
	}
	if(value_i2 < value_i){
		//if(value_i2 == 0xff)
			//PRINTL(DBG_LVL_ALWAYS, "This BND(%s) only support 30a,17a,12b/a,8d/c/b/a",BND);
		if(value_i2 == 0x7f)
			PRINTL(DBG_LVL_ALWAYS, "This BND(%s) only support 17a,12b/a,8d/c/b/a",BND);
		if(value_i2 == 0x3f)
			PRINTL(DBG_LVL_ALWAYS, "This BND(%s) only support 12b/a,8d/c/b/a",BND);
		if(value_i2 == 0xf)
			PRINTL(DBG_LVL_ALWAYS, "This BND(%s) only support 8d/c/b/a",BND);
	
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfProfiles, NULL, value_i, NULL);

	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin target downstream settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_targetSnrmDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfTargetSnrmDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin target upstream settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_targetSnrmUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfTargetSnrmUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin max downstream settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_maxSnrmDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxSnrmDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin max upstream settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_maxSnrmUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxSnrmUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin min DS settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_minSnrmDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMinSnrmDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile signal Noise Ratio margin min upstream settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-310
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_minSnrmUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMinSnrmUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify vdsl led turn on or off at idle status
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_led (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char value[PROFILE_SMALL_BUF_SIZE];
	char profile_name[256];

	ret = sscanf(pbuf, "%s %s",profile_name, value);
	if ((ret != 2) || ((strcmp(value,"on") != 0) && (strcmp(value,"off") != 0))){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <option>");
		PRINTL(DBG_LVL_ALWAYS, "option:	on");
		PRINTL(DBG_LVL_ALWAYS, "	off");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, NULL, "led", 0, value);
	return DSL_ERR_OK;
}

/**
 * modify bitSwapUs turn on or off
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_bitSwapUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char value[PROFILE_SMALL_BUF_SIZE];
	char profile_name[256];

	ret = sscanf(pbuf, "%s %s",profile_name, value);
	if ((ret != 2) || ((strcmp(value,"on") != 0) && (strcmp(value,"off") != 0))){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <option>");
		PRINTL(DBG_LVL_ALWAYS, "option:	on");
		PRINTL(DBG_LVL_ALWAYS, "	off");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, NULL, "bitSwapUs", 0, value);
	return DSL_ERR_OK;
}

/**
 * modify bitSwapDs turn on or off
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_bitSwapDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char value[PROFILE_SMALL_BUF_SIZE];
	char profile_name[256];

	ret = sscanf(pbuf, "%s %s",profile_name, value);
	if ((ret != 2) || ((strcmp(value,"on") != 0) && (strcmp(value,"off") != 0))){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <option>");
		PRINTL(DBG_LVL_ALWAYS, "option:	on");
		PRINTL(DBG_LVL_ALWAYS, "	off");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, NULL, "bitSwapDs", 0, value);
	return DSL_ERR_OK;
}

/**
 * modify us0disable turn allow or disable
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_us0disable (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char value[PROFILE_SMALL_BUF_SIZE];
	char profile_name[256];

	ret = sscanf(pbuf, "%s %s",profile_name, value);
	if ((ret != 2) || ((strcmp(value,"allow") != 0) && (strcmp(value,"disable") != 0))){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <option>");
		PRINTL(DBG_LVL_ALWAYS, "option:	allow");
		PRINTL(DBG_LVL_ALWAYS, "	disable");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, NULL, "us0disable", 0, value);
	return DSL_ERR_OK;
}

/**
 * modify profile bandplan id
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: support bandplan form firmware package
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllineprofile_set_handshakeTone (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || ((value != 0) &&
			(value != 1)&&(value != 2)&&(value != 7))){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0 , 1 , 2 , 7");
		PRINTL(DBG_LVL_ALWAYS, "0:auto");
		PRINTL(DBG_LVL_ALWAYS, "1:A43");
		PRINTL(DBG_LVL_ALWAYS, "2:B43");
		PRINTL(DBG_LVL_ALWAYS, "7:V43");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdslGhsConfOtCarrierSet, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboKL (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1280)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1280");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboKL, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboKLF (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	//if ((ret != 2) || ((value != 1) && (value != 2) && (value != 3)))//yalee990406:firmware not support override now
	if ((ret != 2) || ((value != 1) && (value != 3))){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-3");
		PRINTL(DBG_LVL_ALWAYS, "1:auto");
//		PRINTL(DBG_LVL_ALWAYS, "2:override");
		PRINTL(DBG_LVL_ALWAYS, "3:disableUpbo");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboKLF, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdA0 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 8095) || (value < 4000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:4000-8095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdA0, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdB0 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 4095)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-4095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdB0, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_bandUpboKL0 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1280)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1280");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfBandUpboKL0, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdA1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 8095) || (value < 4000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:4000-8095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdA1, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdB1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 4095)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-4095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdB1, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_bandUpboKL1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1280)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1280");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfBandUpboKL1, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdA2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 8095) || (value < 4000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:4000-8095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdA2, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdB2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 4095)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-4095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdB2, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_bandUpboKL2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1280)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1280");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfBandUpboKL2, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdA3 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 8095) || (value < 4000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:4000-8095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdA3, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_upboPsdB3 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 4095)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-4095");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfUpboPsdB3, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_bandUpboKL3 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1280)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1280");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfBandUpboKL3, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboEsEL (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 511)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-511");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboEsEL, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboEsCableModelA (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 640)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-640");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboEsCableModelA, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboEsCableModelB (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 640)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-640");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboEsCableModelB, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboEsCableModelC (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 640)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-640");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboEsCableModelC, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboMus (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 255)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-255");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboMus, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboFMin (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 2048)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-2048");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboFMin, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_dpboFMax (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 6956) || (value < 32)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:32-6956");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfDpboFMax, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raModeDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || ((value != 1 ) && (value != 2) && (value != 3))){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-3");
		PRINTL(DBG_LVL_ALWAYS, "1:manual");
		PRINTL(DBG_LVL_ALWAYS, "2:raInit");
		PRINTL(DBG_LVL_ALWAYS, "3:dynamicRa");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaModeDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raModeUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || ((value != 1 ) && (value != 2) && (value != 3))){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-3");
		PRINTL(DBG_LVL_ALWAYS, "1:manual");
		PRINTL(DBG_LVL_ALWAYS, "2:raInit");
		PRINTL(DBG_LVL_ALWAYS, "3:dynamicRa");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaModeUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raUsNrmDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaUsNrmDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raUsNrmUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaUsNrmUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raUsTimeDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 16383)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-16383");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaUsTimeDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raUsTimeUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 16383)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-16383");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaUsTimeUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raDsNrmDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;
	
	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaDsNrmDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raDsNrmUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 310)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-310");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaDsNrmUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raDsTimeDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 16383)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-16383");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaDsTimeDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_raDsTimeUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 16383)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-16383");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfRaDsTimeUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_snrModeDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 2) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-2");
		PRINTL(DBG_LVL_ALWAYS, "1:disable");
		PRINTL(DBG_LVL_ALWAYS, "2:enable");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfSnrModeDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_snrModeUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 2) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-2");
		PRINTL(DBG_LVL_ALWAYS, "1:disable");
		PRINTL(DBG_LVL_ALWAYS, "2:enable");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfSnrModeUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_maxNomAtpDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 205)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-205 units 0.1dBm");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomAtpDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_maxNomAtpUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 205)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-205 units 0.1dBm");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomAtpUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_maxNomPsdDs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;
	char value_cc[16];

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < -600) || (value > -300)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:-300~-600 units 0.1dBm/Hz");
		return -DSL_ERR_NOPASS;
	}
	//because int is  32bit in C lang  but mib is 24bit , delete 2byte use value_cc+2
	sprintf(value_cc,"%x",value);

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomPsdDs, NULL, 0, value_cc+2);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_maxNomPsdUs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;
	char value_cc[16];

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < -600) || (value > -300)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:-300~-600 units 0.1dBm/Hz");
		return -DSL_ERR_NOPASS;
	}
	sprintf(value_cc,"%x",value);

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfMaxNomPsdUs, NULL, 0, value_cc+2);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_automodeColdStart(unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 1) || (value < 0)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-1");
		PRINTL(DBG_LVL_ALWAYS, "0:off");
		PRINTL(DBG_LVL_ALWAYS, "1:on");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LineCmndAutomodeColdStart, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_automodeLength(unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 3900) || (value < 1500)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1500-3900");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdslGhsConfAutomodeLength, NULL, value, NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdsllineprofile_set_bandConfig(unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value > 2)){
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-2");
		PRINTL(DBG_LVL_ALWAYS, "0:ALL_TONE_ON");
		PRINTL(DBG_LVL_ALWAYS, "1:DISABLE_1100K_BELOW");
		PRINTL(DBG_LVL_ALWAYS, "2:DISABLE_2200K_BELOW");
	
		PRINTL(DBG_LVL_ALWAYS, "\nWARNING:If you will choice 1 or 2");
		PRINTL(DBG_LVL_ALWAYS, "	suggest set us0 disable,please refer us0disable command");
		return -DSL_ERR_NOPASS;
	}
	PRINTL(DBG_LVL_ALWAYS, "\nWARNING:If you will choice 1 or 2");
	PRINTL(DBG_LVL_ALWAYS, "	suggest set us0 disable,please refer us0disable command");

	update_profile_value_fun(profile_name, VDSL_LINE_PROFILE_ID, xdsl2LConfProfVdsl2CarMask, NULL, value, NULL);
	return DSL_ERR_OK;
}
cmdt profiles_vdsllineprofile_set_cmd[] = {
	//**Line Profile Modify command space**//
	{"SYS","xDSL System profile", NULL, NULL, com_profiles_vdsllineprofile_set_SYS},
	{"BND","Band Profile name", NULL, NULL, com_profiles_vdsllineprofile_set_BND},
	{"VNS","Virtual Noise PSD Name", NULL, NULL, com_profiles_vdsllineprofile_set_VNS},
	{"PSD","PSD name", NULL, NULL, com_profiles_vdsllineprofile_set_PSD},
	{"RFI","RFI name", NULL, NULL, com_profiles_vdsllineprofile_set_RFI},
	{"DPB","DpboEPsd name", NULL, NULL, com_profiles_vdsllineprofile_set_DPB},
	{"profiles","xDSL Profiles", NULL, NULL, com_profiles_vdsllineprofile_set_profiles},
	{"targetSnrmDs","signal Noise Ratio margin target at DS", NULL, NULL,com_profiles_vdsllineprofile_targetSnrmDs},
	{"targetSnrmUs","signal Noise Ratio margin target at US", NULL, NULL,com_profiles_vdsllineprofile_targetSnrmUs},
	{"maxSnrmDs","signal Noise Ratio margin max at DS", NULL, NULL,com_profiles_vdsllineprofile_maxSnrmDs},
	{"maxSnrmUs","signal Noise Ratio margin max at US", NULL, NULL,com_profiles_vdsllineprofile_maxSnrmUs},
	{"minSnrmDs","signal Noise Ratio margin min at DS", NULL, NULL,com_profiles_vdsllineprofile_minSnrmDs},
	{"minSnrmUs","signal Noise Ratio margin min at US", NULL, NULL,com_profiles_vdsllineprofile_minSnrmUs},
	{"led","On/Off vdsl led slow flash of light at vdsl idle status", NULL, NULL,com_profiles_vdsllineprofile_set_led},
	{"bitSwapUs","On/Off Upstream bit swapping", NULL, NULL,com_profiles_vdsllineprofile_set_bitSwapUs},
	{"bitSwapDs","On/Off Downstream bit swapping", NULL, NULL,com_profiles_vdsllineprofile_set_bitSwapDs},
	{"us0disable","Upstream band number 0", NULL, NULL,com_profiles_vdsllineprofile_set_us0disable},
	{"handshakeTone","Handshake tone mode", NULL, NULL,com_profiles_vdsllineprofile_set_handshakeTone},
//	{"upboKL","UPBO electrical length", NULL, NULL,com_profiles_vdsllineprofile_set_upboKL},
	{"upboKLF","UPBO force mode", NULL, NULL,com_profiles_vdsllineprofile_set_upboKLF},
	{"upboPsdA0","UPBO Parameter A for band 0", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdA0},
	{"upboPsdB0","UPBO Parameter B for band 0", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdB0},
//	{"bandUpboKL0","UPBO electrical length for band 0", NULL, NULL,com_profiles_vdsllineprofile_set_bandUpboKL0},
	{"upboPsdA1","UPBO Parameter A for band 1", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdA1},
	{"upboPsdB1","UPBO Parameter B for band 1", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdB1},
//	{"bandUpboKL1","UPBO electrical length for band 1", NULL, NULL,com_profiles_vdsllineprofile_set_bandUpboKL1},
	{"upboPsdA2","UPBO Parameter A for band 2", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdA2},
	{"upboPsdB2","UPBO Parameter B for band 2", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdB2},
//	{"bandUpboKL2","UPBO electrical length for band 2", NULL, NULL,com_profiles_vdsllineprofile_set_bandUpboKL2},
	{"upboPsdA3","UPBO Parameter A for band 3", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdA3},
	{"upboPsdB3","UPBO Parameter B for band 3", NULL, NULL,com_profiles_vdsllineprofile_set_upboPsdB3},
//	{"bandUpboKL3","UPBO electrical length for band 3", NULL, NULL,com_profiles_vdsllineprofile_set_bandUpboKL3},
	{"dpboEsEL","The electrical length of exchange to cabinet cable", NULL, NULL,com_profiles_vdsllineprofile_set_dpboEsEL},
	{"dpboEsCableModelA","E-side cable model parameter A", NULL, NULL,com_profiles_vdsllineprofile_set_dpboEsCableModelA},
	{"dpboEsCableModelB","E-side cable model parameter B", NULL, NULL,com_profiles_vdsllineprofile_set_dpboEsCableModelB},
	{"dpboEsCableModelC","E-side cable model parameter C", NULL, NULL,com_profiles_vdsllineprofile_set_dpboEsCableModelC},
	{"dpboMus","Assumed minimum usable PSD mask of exchange signals at remote site", NULL, NULL,com_profiles_vdsllineprofile_set_dpboMus},
	{"dpboFMin","The lower bound on the DPBO frequency span", NULL, NULL,com_profiles_vdsllineprofile_set_dpboFMin},
	{"dpboFMax","The upper bound on the DPBO frequency span", NULL, NULL,com_profiles_vdsllineprofile_set_dpboFMax},
	{"raModeDs","The mode of operation of a rate-adaptive xTU-C in the transmit direction", NULL, NULL,com_profiles_vdsllineprofile_set_raModeDs},
	{"raModeUs","The mode of operation of a rate-adaptive xTU-R in the transmit direction", NULL, NULL,com_profiles_vdsllineprofile_set_raModeUs},
	{"raUsNrmDs","Downstream up-shift Signal/Noise Margin", NULL, NULL,com_profiles_vdsllineprofile_set_raUsNrmDs},
	{"raUsNrmUs","Upstream up-shift Signal/Noise Margin", NULL, NULL,com_profiles_vdsllineprofile_set_raUsNrmUs},
	{"raUsTimeDs","Downstream up-shift time interval", NULL, NULL,com_profiles_vdsllineprofile_set_raUsTimeDs},
	{"raUsTimeUs","Upstream up-shift  time interval", NULL, NULL,com_profiles_vdsllineprofile_set_raUsTimeUs},
	{"raDsNrmDs","Downstream down-shift Signal/Noise Margin", NULL, NULL,com_profiles_vdsllineprofile_set_raDsNrmDs},
	{"raDsNrmUs","Upstream down-shift Signal/Noise Margin", NULL, NULL,com_profiles_vdsllineprofile_set_raDsNrmUs},
	{"raDsTimeDs","Downstream down-shift time interval", NULL, NULL,com_profiles_vdsllineprofile_set_raDsTimeDs},
	{"raDsTimeUs","Upstream down-shift  time interval", NULL, NULL,com_profiles_vdsllineprofile_set_raDsTimeUs},
	{"snrModeDs","Enable/Disable virtual noise is active on the line in the downstream", NULL, NULL,com_profiles_vdsllineprofile_set_snrModeDs},
	{"snrModeUs","Enable/Disable virtual noise is active on the line in the upstream", NULL, NULL,com_profiles_vdsllineprofile_set_snrModeUs},
	{"maxNomAtpDs","Maximum nominal aggregate transmit power in the downstream", NULL, NULL,com_profiles_vdsllineprofile_set_maxNomAtpDs},
	{"maxNomAtpUs","Maximum nominal aggregate transmit power in the upstream", NULL, NULL,com_profiles_vdsllineprofile_set_maxNomAtpUs},
	{"maxNomPsdDs","Maximum nominal aggregate transmit PSD in the downstream", NULL, NULL,com_profiles_vdsllineprofile_set_maxNomPsdDs},
	{"maxNomPsdUs","Maximum nominal aggregate transmit PSD in the upstream", NULL, NULL,com_profiles_vdsllineprofile_set_maxNomPsdUs},
	{"automodeColdStart","Automode cold start forced", NULL, NULL, com_profiles_vdsllineprofile_set_automodeColdStart},
	{"automodeLength","Automode threshold", NULL, NULL, com_profiles_vdsllineprofile_set_automodeLength},
	{"bandConfig","All tone on or disable 1100K/2200K below", NULL, NULL, com_profiles_vdsllineprofile_set_bandConfig},
	{"IOT","IOT option", NULL, NULL, com_profiles_vdsllineprofile_set_IOT},
	{"exit", "Change to upper directory", profiles_vdsllineprofile_cmd, NULL, com_vdsl_line_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-line-profile end Template2


//yalee980812 vdsl-chan-profile start Template2
int com_profiles_vdslchanprofile_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_CHAN_PROFILE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdslchanprofile_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_CHAN_PROFILE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslchanprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_CHAN_PROFILE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_CHAN_PROFILE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslchanprofile_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslchanprofile_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslchanprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslchanprofile_set_cmd;
	set_prompt("(profiles chan-profile set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdslchanprofile_cmd[] = {
	{"new","Create new xdsl channel profile", NULL, NULL,com_profiles_vdslchanprofile_new},
	{"del", "Delete xdsl channel profile",NULL, NULL,com_profiles_vdslchanprofile_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdslchanprofile_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdslchanprofile_save},
//	{"init","Initialize Vdsl Channel Profile", NULL, NULL,com_profiles_vdslchanprofile_init},
	{"set", "Set commands for xdsl channel profile",profiles_vdslchanprofile_set_cmd, NULL,com_profiles_vdslchanprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_chan_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslchanprofile_cmd;
	set_prompt("(profiles chan-profile)");
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Minimum Data Rate on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minDataRateDsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinDataRateDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Minimum Data Rate on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minDataRateUsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinDataRateUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Maximum Data Rate on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDataRateDsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDataRateDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Maximum Data Rate on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDataRateUsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDataRateUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

#ifdef PROFILE_DUAL_CHANNEL
/**
 * modify profile CH2 Minimum Data Rate on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minDataRateDsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinDataRateDs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Minimum Data Rate on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minDataRateUsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value); 
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>  <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinDataRateUs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Maximum Data Rate on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDataRateDsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value); 
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDataRateDs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Maximum Data Rate on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-200000
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDataRateUsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int  value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value); 
	if ((ret != 2)|| (value > 200000)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-200000 kbps");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDataRateUs1, NULL, value, NULL);
	return DSL_ERR_OK;
}
#endif// PROFILE_DUAL_CHANNEL

/**
 * modify profile CH1 Maximum Interleave Delay on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-255
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDelayDsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 255)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value: 0-255 ms");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDelayDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Maximum Interleave Delay on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-255
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDelayUsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 255)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value: 0-255 ms");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDelayUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Downstrem minimum impulse noise protection in 4.3125kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInpDsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 18) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-18");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtectionDs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Upstrem minimum impulse noise protection in 4.3125kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInpUsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 18) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-18");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtectionUs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Downstrem minimum impulse noise protection in 8.625kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInp8DsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 17) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-17");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtection8Ds, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH1 Upstrem minimum impulse noise protection in 8.625kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInp8UsCh1 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 17) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-17");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtection8Us, NULL, value, NULL);
	return DSL_ERR_OK;
}

#ifdef PROFILE_DUAL_CHANNEL
/**
 * modify profile CH2 Maximum Interleave Delay on Downstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-255
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDelayDsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 255)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-255 ms");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDelayDs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Maximum Interleave Delay on Upstream direction settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: 0-255
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_maxDelayUsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2)|| (value > 255)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:0-255 ms");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMaxDelayUs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Downstrem minimum impulse noise protection in 4.3125kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInpDsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 18) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-18");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtectionDs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Upstrem minimum impulse noise protection in 4.3125kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInpUsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 18) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-18");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtectionUs1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Downstrem minimum impulse noise protection in 8.625kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInp8DsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 17) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-17");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtection8Ds1, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile CH2 Upstrem minimum impulse noise protection in 8.625kHz settings
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value: integer
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanprofile_set_minInp8UsCh2 (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value > 17) || (value < 1)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "value:1-17");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_PROFILE_ID, xdsl2ChConfProfMinProtection8Us1, NULL, value, NULL);
	return DSL_ERR_OK;
}
#endif// PROFILE_DUAL_CHANNEL


cmdt profiles_vdslchanprofile_set_cmd[] = {
	//Channel Profile Modify command space
	{"minDataRateDsCh1","CH1 Mini Data Rate at DS", NULL, NULL,com_profiles_vdslchanprofile_set_minDataRateDsCh1},
	{"minDataRateUsCh1","CH1 Mini Data Rate at US", NULL, NULL,com_profiles_vdslchanprofile_set_minDataRateUsCh1},
	{"maxDataRateDsCh1","CH1 Maxi Data Rate at DS", NULL, NULL,com_profiles_vdslchanprofile_set_maxDataRateDsCh1},
	{"maxDataRateUsCh1","CH1 Maxi Data Rate at US", NULL, NULL,com_profiles_vdslchanprofile_set_maxDataRateUsCh1},
#ifdef PROFILE_DUAL_CHANNEL
	{"minDataRateDsCh2","CH2 Mini Data Rate at DS", NULL, NULL,com_profiles_vdslchanprofile_set_minDataRateDsCh2},
	{"minDataRateUsCh2","CH2 Mini Data Rate at US", NULL, NULL,com_profiles_vdslchanprofile_set_minDataRateUsCh2},
	{"maxDataRateDsCh2","CH2 Maxi Data Rate at DS", NULL, NULL,com_profiles_vdslchanprofile_set_maxDataRateDsCh2},
	{"maxDataRateUsCh2","CH2 Maxi Data Rate at US", NULL, NULL,com_profiles_vdslchanprofile_set_maxDataRateUsCh2},
#endif
	{"maxDelayDsCh1","CH1 Max Interleave Delay at DS", NULL, NULL,com_profiles_vdslchanprofile_set_maxDelayDsCh1},
	{"maxDelayUsCh1","CH1 Max Interleave Delay at US", NULL, NULL,com_profiles_vdslchanprofile_set_maxDelayUsCh1},
	{"minInpDsCh1","CH1 DS min INP in 4.3125kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInpDsCh1},
	{"minInpUsCh1","CH1 US min INP in 4.3125kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInpUsCh1},
	{"minInp8DsCh1","CH1 DS min INP in 8.625kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInp8DsCh1},
	{"minInp8UsCh1","CH1 US min INP in 8.625kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInp8UsCh1},
#ifdef PROFILE_DUAL_CHANNEL
	{"maxDelayDsCh2","CH2 Max Interleave Delay at DS", NULL, NULL,com_profiles_vdslchanprofile_set_maxDelayDsCh2},
	{"maxDelayUsCh2","CH2 Max Interleave Delay at US", NULL, NULL,com_profiles_vdslchanprofile_set_maxDelayUsCh2},
	{"minInpDsCh2","CH2 DS min INP in 4.3125kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInpDsCh2},
	{"minInpUsCh2","CH2 US min INP in 4.3125kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInpUsCh2},
	{"minInp8DsCh2","CH2 DS min INP in 8.625kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInp8DsCh2},
	{"minInp8UsCh2","CH2 US min INP in 8.625kHz", NULL, NULL,com_profiles_vdslchanprofile_set_minInp8UsCh2},
#endif
	{"exit", "Change to upper directory", profiles_vdslchanprofile_cmd, NULL, com_vdsl_chan_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-chan-profile end Template2


//yalee980812 vdsl-alarm-template start Template2
int com_profiles_vdslalarmtemplate_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_ALARM_TEMPLATE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;

}

int com_profiles_vdslalarmtemplate_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_ALARM_TEMPLATE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslalarmtemplate_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_ALARM_TEMPLATE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_ALARM_TEMPLATE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslalarmtemplate_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslalarmtemplate_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslalarmtemplate_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslalarmtemplate_set_cmd;
	set_prompt("(profiles alarm-template set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdslalarmtemplate_cmd[] = {
	{"new","Create new xdsl template profile", NULL, NULL,com_profiles_vdslalarmtemplate_new},
	{"del", "Delete xdsl template profile",NULL, NULL,com_profiles_vdslalarmtemplate_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdslalarmtemplate_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdslalarmtemplate_save},
//	{"init","Initialize Vdsl Alarm Template", NULL, NULL,com_profiles_vdslalarmtemplate_init},
	{"set", "Set commands for xdsl template profile",profiles_vdslalarmtemplate_set_cmd, NULL,com_profiles_vdslalarmtemplate_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_alarm_template (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslalarmtemplate_cmd;
	set_prompt("(profiles alarm-template)");
	return DSL_ERR_OK;
}

int com_profiles_vdslalarmtemplate_set_linealarmprofile (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name_at[256];
	char profile_name_lap[256];
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name_at, profile_name_lap);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <AlarmTemplate profile_name> <LineAlarmProfile profile_name>");
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_LINE_ALARM_PROFILE_ID, profile_name_lap);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Alarm Profile No Exist",profile_name_lap);
		profiles_main_vdslprofile_show("line-alarm-profile",NULL);
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID, profile_name_at);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template No Exist",profile_name_at);
		profiles_main_vdslprofile_show("alarm-template",NULL);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_line_name, "%s",profile_name_lap);
	profile_P->modify = '*';
	profile_param[VDSL_ALARM_TEMPLATE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}

int com_profiles_vdslalarmtemplate_set_chanalarmprofile (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name_at[256];
	char profile_name_cap[256];
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;

	ret = sscanf(pbuf, "%s %s", profile_name_at, profile_name_cap);
	if(ret != 2){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <AlarmTemplate profile_name> <ChannelAlarmProfile profile_name>");
		return -DSL_ERR_NOPASS;
	}

	profile_P = all_profile_search(VDSL_CHAN_ALARM_PROFILE_ID, profile_name_cap);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Channel Alarm Profile No Exist",profile_name_cap);
		profiles_main_vdslprofile_show("chan-alarm-profile",NULL);
		return -DSL_ERR_NOPASS;
	}
	profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID, profile_name_at);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template No Exist",profile_name_at);
		profiles_main_vdslprofile_show("alarm-template",NULL);
		return -DSL_ERR_NOPASS;
	}
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(uMibs.mibs_member->vdsl_chan_name, "%s",profile_name_cap);
	profile_P->modify = '*';
	profile_param[VDSL_ALARM_TEMPLATE_ID].modify_vdsl_profile = 1;

	return DSL_ERR_OK;
}


cmdt profiles_vdslalarmtemplate_set_cmd[] = {
	{"line-alarm-profile","Specifies the line alarm configuration profile", NULL, NULL, com_profiles_vdslalarmtemplate_set_linealarmprofile},
	{"chan-alarm-profile","Specifies the channel alarm configuration profile", NULL, NULL, com_profiles_vdslalarmtemplate_set_chanalarmprofile},
	{"exit", "Change to upper directory", profiles_vdslalarmtemplate_cmd, NULL, com_vdsl_alarm_template},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-alarm-template end Template2


//yalee980812 vdsl-line-alarm-profile start Template2
int com_profiles_vdsllinealarmprofile_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_ALARM_PROFILE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdsllinealarmprofile_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_LINE_ALARM_PROFILE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdsllinealarmprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_LINE_ALARM_PROFILE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdsllinealarmprofile_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllinealarmprofile_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdsllinealarmprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllinealarmprofile_set_cmd;
	set_prompt("(profiles line-alarm-profile set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdsllinealarmprofile_cmd[] = {
	{"new","Create new xdsl line alarm profile", NULL, NULL,com_profiles_vdsllinealarmprofile_new},
	{"del", "Delete xdsl line alarm profile",NULL, NULL,com_profiles_vdsllinealarmprofile_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdsllinealarmprofile_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdsllinealarmprofile_save},
//	{"init","Initialize Vdsl Line Alarm Profile", NULL, NULL,com_profiles_vdsllinealarmprofile_init},
	{"set", "Set commands for xdsl line alarm profile",profiles_vdsllinealarmprofile_set_cmd, NULL,com_profiles_vdsllinealarmprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_line_alarm_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdsllinealarmprofile_cmd;
	set_prompt("(profiles line-alarm-profile)");
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Fecs counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xtucFecs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXtucThresh15MinFecs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Es counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xtucEs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXtucThresh15MinEs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Ses counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xtucSes (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXtucThresh15MinSes, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Loss counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xtucLoss (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXtucThresh15MinLoss, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Uas counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xtucUas (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXtucThresh15MinUas, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Fecs counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xturFecs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXturThresh15MinFecs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Es counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xturEs (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXturThresh15MinEs, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Ses counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xturSes (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXturThresh15MinSes, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Loss counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xturLoss (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXturThresh15MinLoss, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the Uas counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_xturUas (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileXturThresh15MinUas, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the count of failed full initilizations in the current 15M interval
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_fullInt (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileThresh15MinFailedFullInt, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the count of failed short initilizations in the current 15M interval
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdsllinealarmprofile_set_shrtInt (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_LINE_ALARM_PROFILE_ID, xdsl2LineAlarmConfProfileThresh15MinFailedShrtInt, NULL, value, NULL);
	return DSL_ERR_OK;
}


cmdt profiles_vdsllinealarmprofile_set_cmd[] = {
	//**Line Alarm Profile Modify command space**//
	{"xtucFecs","A threshold for the Fecs counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xtucFecs},
	{"xtucEs","A threshold for the Es counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xtucEs},
	{"xtucSes","A threshold for the Ses counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xtucSes},
	{"xtucLoss","A threshold for the Loss counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xtucLoss},
	{"xtucUas","A threshold for the Uas counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xtucUas},
	{"xturFecs","A threshold for the Fecs counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xturFecs},
	{"xturEs","A threshold for the Es counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xturEs},
	{"xturSes","A threshold for the Ses counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xturSes},
	{"xturLoss","A threshold for the Loss counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xturLoss},
	{"xturUas","A threshold for the Uas counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdsllinealarmprofile_set_xturUas},
	{"fullInt","A threshold for the count of failed full initilizations in the current 15M interval", NULL, NULL,com_profiles_vdsllinealarmprofile_set_fullInt},
	{"shrtInt","A threshold for the count of failed short initilizations in the current 15M interval", NULL, NULL,com_profiles_vdsllinealarmprofile_set_shrtInt},
	{"exit", "Change to upper directory", profiles_vdsllinealarmprofile_cmd, NULL, com_vdsl_line_alarm_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-line-alarm-profile end Template2


//yalee980812 vdsl-chan-alarm-profile start Template2
int com_profiles_vdslchanalarmprofile_new (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *new;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_CHAN_ALARM_PROFILE_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);
	return ret;
}

int com_profiles_vdslchanalarmprofile_del (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	struct list_head        *next, *tmp;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_CHAN_ALARM_PROFILE_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslchanalarmprofile_show (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];

	ret = sscanf(pbuf,"%s", profile_name);
	if(ret == 1){
		display_vdsl_profiles_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, 1);
	}else{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		display_vdsl_profiles_fun(NULL, VDSL_CHAN_ALARM_PROFILE_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslchanalarmprofile_save (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslchanalarmprofile_init (unsigned char * pbuf, cmdt * pcmd)
{
	return DSL_ERR_OK;
}

int com_profiles_vdslchanalarmprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslchanalarmprofile_set_cmd;
	set_prompt("(profiles chan-alarm-profile set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdslchanalarmprofile_cmd[] = {
	{"new","Create new xdsl channel alarm profile", NULL, NULL,com_profiles_vdslchanalarmprofile_new},
	{"del", "Delete xdsl channel alarm profile",NULL, NULL,com_profiles_vdslchanalarmprofile_del},
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdslchanalarmprofile_show},
//	{"save","Save all profile config", NULL, NULL,com_profiles_vdslchanalarmprofile_save},
//	{"init","Initialize Vdsl Channel Alarm Profile", NULL, NULL,com_profiles_vdslchanalarmprofile_init},
	{"set", "Set commands for xdsl channel profile",profiles_vdslchanalarmprofile_set_cmd, NULL,com_profiles_vdslchanalarmprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_chan_alarm_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslchanalarmprofile_cmd;
	set_prompt("(profiles chan-alarm-profile)");
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the coding violation counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanalarmprofile_set_cvThresXtuc (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int value;

	ret = sscanf(pbuf, "%s %u", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXtucThresh15MinCodingViolations, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the corrected code word counter in the current 15M interval on XTUC
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanalarmprofile_set_correctedThresXtuc (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXtucThresh15MinCorrected, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the coding violation counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanalarmprofile_set_cvThresXtur (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXturThresh15MinCodingViolations, NULL, value, NULL);
	return DSL_ERR_OK;
}

/**
 * modify profile A threshold for the corrected code word counter in the current 15M interval on XTUR
 * \par Usage:
 * 		cmd <profile_name> <value>
 * \param profile_name: exist file_name form user defined
 * \param value:
 * \return
 *	- 0 : success
 *	- < 0 : error code
 *
 */
int com_profiles_vdslchanalarmprofile_set_correctedThresXtur (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0) || (value > 8388607)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXturThresh15MinCorrected, NULL, value, NULL);
	return DSL_ERR_OK;
}

#if 0
int com_profiles_vdslchanalarmprofile_set_value (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	int value;

	ret = sscanf(pbuf, "%s %d", profile_name, &value);
	if ((ret != 2) || (value < 0)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name> <value-dec>");
		return -DSL_ERR_NOPASS;
	}

	//switch start
	//cvThresXtuc
	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXtucThresh15MinCodingViolations, NULL, value, NULL);
	//correctedThresXtuc
	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXtucThresh15MinCorrected, NULL, value, NULL);
	//cvThresXtur
	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXturThresh15MinCodingViolations, NULL, value, NULL);
	//correctedThresXtur
	update_profile_value_fun(profile_name, VDSL_CHAN_ALARM_PROFILE_ID, xdsl2ChAlarmConfProfileXturThresh15MinCorrected, NULL, value, NULL);

	return DSL_ERR_OK;
}
#endif


cmdt profiles_vdslchanalarmprofile_set_cmd[] = {
	//**Channel Alarm Profile Modify command space**//
	{"cvThresXtuc","A threshold for the coding violation counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdslchanalarmprofile_set_cvThresXtuc},
	{"correctedThresXtuc","A threshold for the corrected code word counter in the current 15M interval on XTUC", NULL, NULL,com_profiles_vdslchanalarmprofile_set_correctedThresXtuc},
	{"cvThresXtur","A threshold for the coding violation counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdslchanalarmprofile_set_cvThresXtur},
	{"correctedThresXtur","A threshold for the corrected code word counter in the current 15M interval on XTUR", NULL, NULL,com_profiles_vdslchanalarmprofile_set_correctedThresXtur},
	{"exit", "Change to upper directory", profiles_vdslchanalarmprofile_cmd, NULL, com_vdsl_chan_alarm_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980812 vdsl-chan-alarm-profile end Template2


//yalee980819 vdsl-port start Template2
int com_profiles_vdslport_show (unsigned char * pbuf, cmdt * pcmd)
{
	profiles_main_vdslprofile_show ("port", NULL);
	return DSL_ERR_OK;
}

int com_profiles_vdslport_initprofile (unsigned char * pbuf, cmdt * pcmd)
{
	int i = 0;
	char port_profilename[PROFILE_BUF_SIZE];
	char command[256], line[256];
	FILE *streamout;
	struct vdsl_all_profile *profile_P;

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	//**disconncet vdsl all port
/*
	if(MAX_PORTS == 1) sprintf(command,"2 %d",MAX_PORTS);
	else sprintf(command,"2 %d",MAX_PORTS+1);
	test_portop(command, NULL);
*/
	for(i = 0 ; i < MAX_PORTS ; i++){
		disconnect_port(i);
		//PRINTL(DBG_LVL_CLI, "Disabling Port%d ...", i+1);
	}

	for(i = 0 ; i < MAX_PORTS ; i++){
		line[0] = 0x00;
		memset(command,'\0',sizeof(char)*256);
		sprintf(command, ""CFGMGR_PATH" -r V_POWEROFF_P%d",i+1);
		if((streamout = popen(command, "r")) != NULL) {
			if(fgets(line, 256, streamout) != NULL) {
				stripwhite(line);
				if(line[0] == '#'){
					PRINTL(DBG_LVL_ALWAYS, "Init Port%d LineTemplate(%s), AlarmTemplate(%s)",
							i+1,port_map_linetemplate[i],port_map_alarmtemplate[i]);
					//PRINTL(DBG_LVL_ALWAYS, "Init port%d use profile name:%s",i+1, port_map_profile[i]);
					memset(port_profilename,'\0',sizeof(char)*PROFILE_BUF_SIZE);
					sprintf(port_profilename,"%d ",i+1);
					//set Line Template Profile
					//**check profile exist? if not exist use default profile**//
					profile_P = all_profile_search(VDSL_LINE_TEMPLATE_ID, port_map_linetemplate[i]);
					//profile_P = all_profile_search(VDSL_PROFILE_ID,port_map_profile[i]);
					if(profile_P != NULL )
					{
						strcat(port_profilename, port_map_linetemplate[i]);
					}else{
						PRINTL(DBG_LVL_ALWAYS, "%s Line Template not exist, Use Default",port_map_linetemplate[i]);
						strcat(port_profilename,"DEFVAL");
					}
					//yalee980730 alway apply ,not disconnect connect
					strcat(port_profilename," 0");
					//com_profiles_vdslport_set_profile(port_profilename, NULL);
					com_profiles_vdslport_set_line_template (port_profilename, NULL);

					//set Alarm Template Profile
					memset(port_profilename,'\0',sizeof(char)*PROFILE_BUF_SIZE);
					sprintf(port_profilename,"%d ",i+1);
					profile_P = all_profile_search(VDSL_ALARM_TEMPLATE_ID, port_map_alarmtemplate[i]);
					if(profile_P != NULL )
					{
						strcat(port_profilename, port_map_alarmtemplate[i]);
					}else{
						PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template not exist, Use Default",port_map_linetemplate[i]);
						strcat(port_profilename,"DEFVAL");
					}
					strcat(port_profilename," 0");
					com_profiles_vdslport_set_alarm_template (port_profilename, NULL);

				}else{
						PRINTL(DBG_LVL_ALWAYS, "V_POWEROFF_P%d ,not Init",i+1);
					}
			}
		}
				pclose(streamout);
	}

	//**conncet vdsl all port
/*
	if(MAX_PORTS == 1) sprintf(command,"1 %d",MAX_PORTS);
	else sprintf(command,"1 %d",MAX_PORTS+1);
	test_portop(command, NULL);
*/
	for(i = 0 ; i < MAX_PORTS ; i++){
		line[0] = 0x00;
		sprintf(command, ""CFGMGR_PATH" -r V_DISABLE_P%d", i+1);
		if((streamout = popen(command, "r")) != NULL) {
			if(fgets(line, 256, streamout) != NULL) {
				stripwhite(line);
			}
			pclose(streamout);
		}

		if(line[0] == '#') {
			connect_port(i);
			PRINTL(DBG_LVL_CLI, "Port%d Enabled...", i+1);
		}
		else{
			PRINTL(DBG_LVL_CLI, "Port%d Not Enabled...", i+1);
		}
	}

	return DSL_ERR_OK;
}

int com_profiles_vdslport_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslport_set_cmd;
	set_prompt("(profiles port set)");
	return DSL_ERR_OK;
}


cmdt profiles_vdslport_cmd[] = {
	{"show", "Show all profile names or show detail information of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},//com_profiles_vdslport_show},
	{"initprofile","Initialize profile to all vdsl port", NULL, NULL,com_profiles_vdslport_initprofile},
	{"set", "Set commands for xdsl port",profiles_vdslport_set_cmd, NULL,com_profiles_vdslport_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_port_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslport_cmd;
	set_prompt("(profiles port)");
	return DSL_ERR_OK;
}

int com_profiles_vdslport_set_profile (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	mt_uint32 portid;
	char profile_name[256],command[256];
	struct vdsl_all_profile *profile_P;
	union union_mibs_struct uMibs;
	int option2 = 1;//connect ,disconnect
	FILE *streamout;
	char line[256];

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf, "%u %s %d", &portid, profile_name, &option2);
	if ((ret != 2) && (ret != 3))
	{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <port> <VDSL Profile Name>");
//		PRINTL(DBG_LVL_ALWAYS, "option2:connect,disconnect");
		profiles_main_vdslprofile_show ("profile", NULL);
		return -DSL_ERR_NOPASS;
	}

	if(portid > MAX_PORTS){
		PRINTL(DBG_LVL_ALWAYS, "Over MAX_PORTS");
		return -DSL_ERR_NOPASS;
	}
	portid--;

	//Main Profile
	profile_P = all_profile_search(VDSL_PROFILE_ID ,profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Vdsl Profile No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	if (option2){
		//disconnect vdsl
		disconnect_port(portid);
		//PRINTL(DBG_LVL_CLI, "Disconnecting Port%d ...", portid+1);
	}

	set_vdsl_profiles_fun(portid, profile_name, VDSL_PROFILE_ID);

	line[0] = 0x00;
	sprintf(command, ""CFGMGR_PATH" -r V_DISABLE_P%d", portid+1);
	if((streamout = popen(command, "r")) != NULL) {
		if(fgets(line, 256, streamout) != NULL) {
			stripwhite(line);
		}
		pclose(streamout);
	}

	if (option2){
		//connect vdsl
		if(line[0] == '#') {
			PRINTL(DBG_LVL_CLI, "Port%d Enabled...", portid+1);
			connect_port(portid);
		}
		else{
			PRINTL(DBG_LVL_CLI, "Port%d Not Enabled...", portid+1);
		}
	}

	/*record port and profile relations*/
	uMibs.mibs_member = (struct mibs_member_struct *)profile_P->mibs;
	sprintf(port_map_linetemplate[portid], "%s",uMibs.mibs_member->vdsl_line_name);
	sprintf(port_map_alarmtemplate[portid], "%s",uMibs.mibs_member->vdsl_chan_name);
	/*write port_map_profile data to board.conf*/
	sprintf(command, ""CFGMGR_PATH" -w port%d_map_profile=%s",
				portid+1 ,port_map_linetemplate[portid], port_map_alarmtemplate[portid]);
	ret = system(command);
	return DSL_ERR_OK;
}

int com_profiles_vdslport_set_line_template (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	mt_uint32 portid, i;
	char profile_name[256],command[256];
	struct vdsl_all_profile *profile_P;
	int option2 = 1;//connect ,disconnect
	FILE *streamout;
	char line[256];

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf, "%d %s %d", &portid, profile_name, &option2);

	if ((ret != 2) && (ret != 3)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <port> <Vdsl Config Line Template Name>");
//		PRINTL(DBG_LVL_ALWAYS, "option2:connect,disconnect");
		profiles_main_vdslprofile_show ("line-template", NULL);
		return -DSL_ERR_NOPASS;
	}

	if(portid > MAX_PORTS){
		PRINTL(DBG_LVL_ALWAYS, "Over MAX_PORTS");
		return -DSL_ERR_NOPASS;
	}
	portid--;

	/*search profile context from link-list*/
	profile_P = all_profile_search( VDSL_LINE_TEMPLATE_ID, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Line Template No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	if (option2){
		//disconnect vdsl
		disconnect_port(portid);
		//PRINTL(DBG_LVL_CLI, "Disconnecting Port%d ...", portid+1);
	}

	set_vdsl_profiles_fun(portid, profile_name, VDSL_LINE_TEMPLATE_ID);

	line[0] = 0x00;
	sprintf(command, ""CFGMGR_PATH" -r V_DISABLE_P%d", portid+1);
	if((streamout = popen(command, "r")) != NULL) {
		if(fgets(line, 256, streamout) != NULL) {
			stripwhite(line);
		}
		pclose(streamout);
	}

	if (option2){
		//connect vdsl
		if(line[0] == '#') {
			connect_port(portid);
			PRINTL(DBG_LVL_CLI, "Port%d Enabled...", portid+1);
		}
		else{
			PRINTL(DBG_LVL_CLI, "Port%d Not Enabled...", portid+1);
		}
	}

	/*record port and profile relations*/
	sprintf(port_map_linetemplate[portid], "%s",profile_name);
	sprintf(command, ""CFGMGR_PATH" -w port%d_map_profile=%s@%s",
				portid+1 ,port_map_linetemplate[portid], port_map_alarmtemplate[portid]);
	ret = system(command);

	return DSL_ERR_OK;
}

int com_profiles_vdslport_set_alarm_template (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	mt_uint32 portid, i;
	char profile_name[256],command[256];
	struct vdsl_all_profile *profile_P;
	int option2 = 1;//connect ,disconnect
	FILE *streamout;
	char line[256];

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf, "%d %s %d", &portid, profile_name, &option2);

	if ((ret != 2) && (ret != 3)){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <port> <Vdsl Config Alarm Template Name>");
//		PRINTL(DBG_LVL_ALWAYS, "option2:connect,disconnect");
		profiles_main_vdslprofile_show ("alarm-template", NULL);
		return -DSL_ERR_NOPASS;
	}

	if(portid > MAX_PORTS){
		PRINTL(DBG_LVL_ALWAYS, "Over MAX_PORTS");
		return -DSL_ERR_NOPASS;
	}
	portid--;

	/*search profile context from link-list*/
	profile_P = all_profile_search( VDSL_ALARM_TEMPLATE_ID, profile_name);
	if(profile_P == NULL){
		PRINTL(DBG_LVL_ALWAYS, "%s Alarm Template No Exist",profile_name);
		return -DSL_ERR_NOPASS;
	}

	if (option2){
		//disconnect vdsl
		disconnect_port(portid);
		//PRINTL(DBG_LVL_CLI, "Disconnecting Port%d ...", portid+1);
	}

	set_vdsl_profiles_fun(portid, profile_name, VDSL_ALARM_TEMPLATE_ID);

	line[0]=0x00;
	sprintf(command, ""CFGMGR_PATH" -r V_DISABLE_P%d", portid+1);
	if((streamout = popen(command, "r")) != NULL) {
		if(fgets(line, 256, streamout) != NULL) {
			stripwhite(line);
		}
		pclose(streamout);
	}

	if (option2){
		//connect vdsl
		if(line[0] == '#') {
			connect_port(portid);
			PRINTL(DBG_LVL_CLI, "Port%d Enabled...", portid+1);
		}
		else{
			PRINTL(DBG_LVL_CLI, "Port%d Not Enabled...", portid+1);
		}
	}

	/*record port and profile relations*/
	sprintf(port_map_alarmtemplate[portid], "%s",profile_name);
	sprintf(command, ""CFGMGR_PATH" -w port%d_map_profile=%s@%s",
				portid+1 ,port_map_linetemplate[portid], port_map_alarmtemplate[portid]);
	ret = system(command);

	return DSL_ERR_OK;
}

int com_profiles_vdslport_set_line_alarm_template (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	mt_uint32 portid;
	char profile_name[256],command[256];
	struct vdsl_all_profile *profile_P;
	int option2 = 1;//connect ,disconnect
	char line_template[256], alarm_template[256];
	char buffer[256];

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf, "%u %s %s", &portid, line_template, alarm_template);
	if (ret != 3)
	{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <port> <LineTemplate Name> <AlarmTemplate Name>");
//		PRINTL(DBG_LVL_ALWAYS, "option2:connect,disconnect");
		profiles_main_vdslprofile_show ("line-template", NULL);
		profiles_main_vdslprofile_show ("alarm-template", NULL);
		return -DSL_ERR_NOPASS;
	}

	if(portid > MAX_PORTS){
		PRINTL(DBG_LVL_ALWAYS, "Over MAX_PORTS");
		return -DSL_ERR_NOPASS;
	}
	portid--;

	if (option2){
		//disconnect vdsl
		disconnect_port(portid);
	}

	//set Line Template
	memset(buffer,'\0',sizeof(char)*256);
	sprintf(buffer,"%d ",portid+1);
	strcat(buffer, line_template);
	strcat(buffer," 0");
	com_profiles_vdslport_set_line_template (buffer, NULL);
	//set Alarm Template
	memset(buffer,'\0',sizeof(char)*256);
	sprintf(buffer,"%d ",portid+1);
	strcat(buffer, alarm_template);
	strcat(buffer," 0");
	com_profiles_vdslport_set_alarm_template (buffer, NULL);

	if (option2){
		//connect vdsl
		connect_port(portid);
	}

	return DSL_ERR_OK;
}

int com_profiles_vdslport_set_active (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char port_map[MAX_PORTS];
	int type = 0;
	int i =0;
	char buff[64];

	/**if first time use profile command call init function**/
	if(init_profile_linklist != 2){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_END_ID);
	}

	ret = sscanf(pbuf, "%d %s", &type, profile_name);
	if (ret != 2 || type < 1|| type > 10)
	{
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <options> <Profile Name>");
		PRINTL(DBG_LVL_ALWAYS, "options range:1-10");
		PRINTL(DBG_LVL_ALWAYS, "1:LineTemplate");
		PRINTL(DBG_LVL_ALWAYS, "2:LineProfile");
		PRINTL(DBG_LVL_ALWAYS, "3:ChannelProfile");
		PRINTL(DBG_LVL_ALWAYS, "4:AlarmTemplate");
		PRINTL(DBG_LVL_ALWAYS, "5:LineAlarmProfile");
		PRINTL(DBG_LVL_ALWAYS, "6:ChanAlarmProfile");
		PRINTL(DBG_LVL_ALWAYS, "7:VirtualNose");
		PRINTL(DBG_LVL_ALWAYS, "8:DpboPsd");
		PRINTL(DBG_LVL_ALWAYS, "9:RfiBands");
		PRINTL(DBG_LVL_ALWAYS, "10:PsdMasks");
		return -DSL_ERR_NOPASS;
	}

	vdsl_profiles_map_port_fun (type, profile_name, port_map);

	for(i = 0 ; i < MAX_PORTS; i++){
		memset(buff,'\0',64);
		if(port_map[i] == '*'){
			PRINTL(DBG_LVL_ALWAYS, "Active xDSL Port %d",i+1);
			//apply port
			sprintf(buff,"%d %s %s",i+1,port_map_linetemplate[i],port_map_alarmtemplate[i]);
			com_profiles_vdslport_set_line_alarm_template (buff, NULL);
		}
	}
	return DSL_ERR_OK;
}


cmdt profiles_vdslport_set_cmd[] = {
	//**VDSL PORT Set Modify command space**//
//	{"profile", "Apply a well-defined profile to xdsl lines",NULL, NULL, com_profiles_vdslport_set_profile},
	{"line-template", "Apply VDSL line configuration template for this line",NULL, NULL, com_profiles_vdslport_set_line_template},
	{"alarm-template", "Apply VDSL line alarm configuration template for this line",NULL, NULL, com_profiles_vdslport_set_alarm_template},
	{"line-alarm-template", "Apply VDSL line, line and alarm configuration template for this line",NULL, NULL, com_profiles_vdslport_set_line_alarm_template},
	{"active", "Active VDSL line that use this profile",NULL, NULL, com_profiles_vdslport_set_active},
	{"exit", "Change to upper directory", profiles_vdslport_cmd, NULL, com_vdsl_port_profile},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};
//yalee980819 vdsl-port end Template2


//yalee980921 vdsl-extern start Template2
int com_profiles_vdslexternprofile_vnnew (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_VN_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_dpbnew (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_DPB_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_rfinew (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_RFI_ID, profile_name);
	ret = com_profiles_main_new (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_psdnew (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf, "%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_PSD_ID, profile_name);
	com_profiles_main_new (buff, NULL);

	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_vndel (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_VN_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_dpbdel (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_DPB_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_rfidel (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_RFI_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;

}

int com_profiles_vdslexternprofile_psddel (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char buff[384];

	ret = sscanf(pbuf,"%s", profile_name);
	if (ret != 1 ){
		PRINTL(DBG_LVL_ALWAYS, "Usage: cmd <profile_name>");
		return -DSL_ERR_NOPASS;
	}

	sprintf(buff,"%d %s",VDSL_PROFILE_PSD_ID, profile_name);
	ret = com_profiles_main_del (buff, NULL);

	return ret;
}

int com_profiles_vdslexternprofile_vnsetds (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int index;
	float nlevel;
	unsigned int tone;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %f ", profile_name, buffer, &tone, &nlevel);
	if(ret == 4){
		index = atoi(buffer);
		if ((index > 32) || (index < 1 )|| (tone > 7000) || (tone < 0 )|| (nlevel < -140) || (nlevel > -40)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~32");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_VN_ID , xdsl2LConfProfTxRefVnDs, index , tone, nlevel);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_VN_DS_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~32");
			PRINTL(DBG_LVL_ALWAYS, "tone:1~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_VN_ID, xdsl2LConfProfTxRefVnDs, NULL, 0, buffer);
	}
	else{
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
		PRINTL(DBG_LVL_ALWAYS, "index:1~32");
		PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
		PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
		PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
		return -DSL_ERR_NOPASS;
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_vnsetus (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int index;
	float nlevel;
	unsigned int tone;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %f ", profile_name, buffer, &tone, &nlevel);

	if(ret == 4){
		index = atoi(buffer);
		if ((index > 16) || (index < 1 ) || (tone > 7000) || (tone < 0 )|| (nlevel < -140) || (nlevel > -40)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~16");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 96 hex encode");
			return -DSL_ERR_NOPASS;
		}
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_VN_ID , xdsl2LConfProfTxRefVnUs, index , tone, nlevel);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_VN_US_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~16");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 96 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_VN_ID, xdsl2LConfProfTxRefVnUs, NULL, 0, buffer);
	}
	else{
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
		PRINTL(DBG_LVL_ALWAYS, "index:1~16");
		PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
		PRINTL(DBG_LVL_ALWAYS, "nlevel:-40~-140 dBm/Hz");
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
		PRINTL(DBG_LVL_ALWAYS, "mibs-value is 96 hex encode");
		return -DSL_ERR_NOPASS;
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_dpbset (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int index;
	float nlevel;
	unsigned int tone;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %f ", profile_name, buffer, &tone, &nlevel);
	if(ret == 4){
		index = atoi(buffer);
		if ((index > 32) || (index < 1 )|| (tone > 7000) || (tone < 0)|| (nlevel > 0) || (nlevel < -127.5)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~32");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-127.5~0 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_DPB_ID , xdsl2LConfProfDpboEPsd, index , tone, nlevel);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_DPB_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~32");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-127.5~0 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_DPB_ID, xdsl2LConfProfDpboEPsd, NULL, 0, buffer);
	}
	else {
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~32");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:-127.5~0 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;

	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_rfiset (unsigned char * pbuf, cmdt * pcmd)
{

	mt_ret ret;
	char profile_name[256];
	unsigned int index, index2;
	unsigned int tone, tone2;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %u ", profile_name, buffer, &tone, &tone2);

	if(ret == 4){
		index = atoi(buffer);
		if ((index > 16) || (index < 1)|| (tone > 7000) || (tone < 0)|| (tone2 > 7000) || (tone2 < 0)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <start_tone> <end_tone>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~16");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		//odd = (index*2)-1 ,even = index*2
		index2 = (index*2)-1;
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_RFI_ID , xdsl2LConfProfRfiBands, index2 , tone, 0);
		index2 = index*2;
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_RFI_ID , xdsl2LConfProfRfiBands, index2 , tone2, 0);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_RFI_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <start_tone> <end_tone>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~16");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_RFI_ID, xdsl2LConfProfRfiBands, NULL, 0, buffer);
	}
	else {
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <start_tone> <end_tone>");
		PRINTL(DBG_LVL_ALWAYS, "index:1~16");
		PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
		PRINTL(DBG_LVL_ALWAYS, "mibs-value is 192 hex encode");
	}

	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_psdsetds (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int index;
	float nlevel;
	unsigned int tone;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %f ", profile_name, buffer, &tone, &nlevel);
	if(ret == 4){
		index = atoi(buffer);
		if ((index > 40) || (index < 1 )|| (tone > 7000) || (tone < 0 )|| (nlevel < -127.5) || (nlevel > 0)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~40");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
			return -DSL_ERR_NOPASS;
		}
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_PSD_ID , xdsl2LConfProfPsdMaskDs, index , tone, nlevel);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_PSD_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~40");
			PRINTL(DBG_LVL_ALWAYS, "tone:1~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_PSD_ID, xdsl2LConfProfPsdMaskDs, NULL, 0, buffer);
	}
	else{
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
		PRINTL(DBG_LVL_ALWAYS, "index:1~40");
		PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
		PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
		PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
		return -DSL_ERR_NOPASS;
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_psdsetus (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	unsigned int index;
	float nlevel;
	unsigned int tone;
	int len = 0;
	char buffer[256];

	ret = sscanf(pbuf, "%s %s %u %f ", profile_name, buffer, &tone, &nlevel);

	if(ret == 4){
		index = atoi(buffer);
		if ((index > 40) || (index < 1 ) || (tone > 7000) || (tone < 0 )|| (nlevel < -127.5) || (nlevel > 0)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~40");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
			return -DSL_ERR_NOPASS;
		}
		update_psd_type_profile_fun(profile_name, VDSL_PROFILE_PSD_ID , xdsl2LConfProfPsdMaskUs, index , tone, nlevel);
	}
	else if(ret == 2){
		len = strlen(buffer);
		if (len != (PROFILE_PSD_NUM*6)){
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
			PRINTL(DBG_LVL_ALWAYS, "index:1~16");
			PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
			PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
			PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
			PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
			return -DSL_ERR_NOPASS;
		}
		ret = hexString_check_fun(buffer);
		if(ret != DSL_ERR_OK) return -DSL_ERR_NOPASS;

		update_profile_value_fun(profile_name, VDSL_PROFILE_PSD_ID, xdsl2LConfProfPsdMaskUs, NULL, 0, buffer);
	}
	else{
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <index> <tone> <nlevel>");
		PRINTL(DBG_LVL_ALWAYS, "index:1~40");
		PRINTL(DBG_LVL_ALWAYS, "tone:0~7000 (4.3125kHz)");
		PRINTL(DBG_LVL_ALWAYS, "nlevel:0~-127.5 dBm/Hz");
		PRINTL(DBG_LVL_ALWAYS, "Usage:	cmd <profile_name> <mibs-value>");
		PRINTL(DBG_LVL_ALWAYS, "mibs-value is 240 hex encode");
		return -DSL_ERR_NOPASS;
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_vnshow (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char mibsBuffDs[256];
	char mibsBuffUs[256];

	if(profile_param[VDSL_PROFILE_VN_ID].init_profile == 0){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_VN_ID);
	}

	ret = sscanf(pbuf,"%s", profile_name);

	if(ret == 1){
		ret = syspackage_checkid_fun(VNS_PREFIX, profile_name);
		if (ret == DSL_ERR_OK)
		{
			get_package_profile_oid_value(VNS_PREFIX , profile_name, xdsl2LConfProfTxRefVnDs, mibsBuffDs);
			get_package_profile_oid_value(VNS_PREFIX , profile_name, xdsl2LConfProfTxRefVnUs, mibsBuffUs);
			//print Vitual noise Tables
			virtual_noise_tables_display_fun(profile_name, mibsBuffDs, mibsBuffUs);
			display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_VN_ID);
		}else{
			display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_VN_ID, 1);
		}

	}else{
		get_package_profile_name(1,0, VNS_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_VN_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_dpbshow (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char mibsBuff[256];

	if(profile_param[VDSL_PROFILE_DPB_ID].init_profile == 0){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_DPB_ID);
	}
	ret = sscanf(pbuf,"%s", profile_name);

	if(ret == 1){
		ret = syspackage_checkid_fun(DPB_PREFIX, profile_name);
		if (ret == DSL_ERR_OK){
			get_package_profile_oid_value(DPB_PREFIX , profile_name, xdsl2LConfProfDpboEPsd, mibsBuff);
			psdmask_tables_display_fun(profile_name, mibsBuff, NULL, VDSL_PROFILE_DPB_ID);
			display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_DPB_ID);
		}else{
			display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_DPB_ID, 1);
		}
	}else{
		get_package_profile_name(1,0, DPB_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_DPB_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_rfishow (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char mibsBuff[256];

	if(profile_param[VDSL_PROFILE_RFI_ID].init_profile == 0){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_RFI_ID);
	}
	ret = sscanf(pbuf,"%s", profile_name);

	if(ret == 1){
		ret = syspackage_checkid_fun(RFI_PREFIX, profile_name);
		if (ret == DSL_ERR_OK){
			get_package_profile_oid_value(RFI_PREFIX , profile_name, xdsl2LConfProfRfiBands, mibsBuff);
			rfi_tables_display_fun(profile_name, mibsBuff);
			display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_RFI_ID);
		}else{
			display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_RFI_ID, 1);
		}
	}else{
		get_package_profile_name(1,0, RFI_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_RFI_ID, 0);
	}
	return DSL_ERR_OK;
}

int com_profiles_vdslexternprofile_psdshow (unsigned char * pbuf, cmdt * pcmd)
{
	mt_ret ret;
	char profile_name[256];
	char mibsBuffDs[256],mibsBuffUs[256];

	if(profile_param[VDSL_PROFILE_PSD_ID].init_profile == 0){
		//main init profile space
		profiles_main_vdslprofile_init(VDSL_PROFILE_PSD_ID);
	}
	ret = sscanf(pbuf,"%s", profile_name);

	if(ret == 1){
		ret = syspackage_checkid_fun(PSD_PREFIX, profile_name);
		if (ret == DSL_ERR_OK){
			get_package_profile_oid_value(PSD_PREFIX , profile_name, xdsl2LConfProfPsdMaskDs, mibsBuffDs);
			get_package_profile_oid_value(PSD_PREFIX , profile_name, xdsl2LConfProfPsdMaskUs, mibsBuffUs);
			psdmask_tables_display_fun(profile_name, mibsBuffDs, mibsBuffUs, VDSL_PROFILE_PSD_ID);
			display_vdsl_parent_profile_fun(profile_name, VDSL_PROFILE_PSD_ID);
		}else{
			display_vdsl_profiles_fun(profile_name, VDSL_PROFILE_PSD_ID, 1);
		}
	}else{
		get_package_profile_name(1,0, PSD_PREFIX,NULL);
		display_vdsl_profiles_fun(NULL, VDSL_PROFILE_PSD_ID, 0);
	}
	return DSL_ERR_OK;
}

#if 0
int com_profiles_vdslexternprofile_set (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslexternprofile_set_cmd;
	set_prompt("(profiles vdsl-extern-profile set)");
	return DSL_ERR_OK;
}
#endif


cmdt profiles_vdslexternprofile_cmd[] = {
	{"vn-new","Create new xdsl vitrual noise psd profile", NULL, NULL,com_profiles_vdslexternprofile_vnnew},
	{"vn-del", "Delete xdsl vitrual noise psd profile",NULL, NULL,com_profiles_vdslexternprofile_vndel},
	{"vn-set-ds", "Set xdsl vitrual noise downstream psd profile",NULL, NULL,com_profiles_vdslexternprofile_vnsetds},
	{"vn-set-us", "Set xdsl vitrual noise upstream psd profile",NULL, NULL,com_profiles_vdslexternprofile_vnsetus},
	{"dpb-new","Create new xdsl DpboEPsd profile", NULL, NULL,com_profiles_vdslexternprofile_dpbnew},
	{"dpb-del", "Delete xdsl DpboEPsd profile",NULL, NULL,com_profiles_vdslexternprofile_dpbdel},
	{"dpb-set", "Set xdsl DpboPsd profile",NULL, NULL,com_profiles_vdslexternprofile_dpbset},
	{"rfi-new","Create new xdsl RfiBands profile", NULL, NULL,com_profiles_vdslexternprofile_rfinew},
	{"rfi-del", "Delete xdsl RfiBands profile",NULL, NULL,com_profiles_vdslexternprofile_rfidel},
	{"rfi-set", "Set xdsl RfiBands profile",NULL, NULL,com_profiles_vdslexternprofile_rfiset},
	{"psd-new","Create new xdsl psd profile", NULL, NULL,com_profiles_vdslexternprofile_psdnew},
	{"psd-del", "Delete xdsl psd profile",NULL, NULL,com_profiles_vdslexternprofile_psddel},
	{"psd-set-ds", "Set xdsl downstream psd profile",NULL, NULL,com_profiles_vdslexternprofile_psdsetds},
	{"psd-set-us", "Set xdsl upstream psd profile",NULL, NULL,com_profiles_vdslexternprofile_psdsetus},
	{"show", "Show port of a specified profile",NULL, NULL,profiles_main_vdslprofile_show},
//	{"set", "Set commands for xdsl port",profiles_vdslexternprofile_set_cmd, NULL,com_profiles_vdslexternprofile_set},
	{"exit", "Change to upper directory", profiles_cmd, NULL, com_profiles},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};


int com_vdsl_extern_profile (unsigned char * pbuf, cmdt * pcmd)
{
	commands = profiles_vdslexternprofile_cmd;
	set_prompt("(profiles pre-define)");
	return DSL_ERR_OK;
}
#endif //TEMPLATE_PROFILE
//yalee980921 vdsl-extern end Template2


//=======================profiles cmd tables=============
cmdt profiles_cmd[] = {
#ifdef TEMPLATE_PROFILE
//	{"profile", "xDSL profile configuration", profiles_vdslprofile_cmd, NULL, com_vdsl_profile},
	{"line-template", "xDSL line configuration template", profiles_vdsllinetemplate_cmd, NULL, com_vdsl_line_template},
	{"line-profile", "xDSL line configuration profile", profiles_vdsllineprofile_cmd, NULL, com_vdsl_line_profile},
	{"chan-profile", "xDSL channel configuration profile", profiles_vdslchanprofile_cmd, NULL, com_vdsl_chan_profile},
	{"alarm-template", "xDSL alarm template", profiles_vdslalarmtemplate_cmd, NULL, com_vdsl_alarm_template},
	{"line-alarm-profile", "xDSL line alarm profile", profiles_vdsllinealarmprofile_cmd, NULL, com_vdsl_line_alarm_profile},
	{"chan-alarm-profile", "xDSL channel alarm profile", profiles_vdslchanalarmprofile_cmd, NULL, com_vdsl_chan_alarm_profile},
	{"port", "xDSL Port configuration", profiles_vdslport_cmd, NULL, com_vdsl_port_profile},
	{"pre-define", "xDSL pre-define configuration", profiles_vdslexternprofile_cmd, NULL, com_vdsl_extern_profile},
#endif //TEMPLATE_PROFILE
	{"help", "Help display an overview of the CLI syntax", NULL, NULL,com_help},
	{"exit", "Change to upper directory", root_cmd, NULL, com_root},
	{"home", "Return to the root directory", root_cmd, NULL,com_home},
	{"quit", "Exit this CLI session", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, com_help},
	{NULL, NULL, NULL, NULL, NULL}
};

#endif //CO_API
