/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2010-11-24 07:50:48 $
*
* Overview:     
* Functions:
*
* Author:       Yuan lee 
* 
* -- Metanoia Copyright Notice --				
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief VDSL Template Profile Manage Data structure define header
 */

#ifndef _PROFILEDEF_H_
#define _PROFILEDEF_H_

#define PROFILE_DEBUG_MEG 0//Debug Message
#define xstr(s) str(s)
#define str(s) #s
#define PROFILE_VERSION xstr(1.0)
#define PROFILE_SMALL_BUF_SIZE 256
#define PROFILE_BUF_SIZE 1024
#define PROFILE_LARGE_BUF_SIZE 4096
#define MAX_PROFILE_NUMBER 30 
#define CFGMGR_READ_NUM 50 //for multi read cfgmgr

//PSD index number 
#define PROFILE_VN_NUM 32 //vitual noise
#define PROFILE_VN_DS_NUM 32 
#define PROFILE_VN_US_NUM 16 
#define PROFILE_DPB_NUM 32 //DpboEPsd
#define PROFILE_RFI_NUM 32 //RfiBands
#define PROFILE_PSD_NUM 40 //PsdMask

//Mibs number
#define MIB_MainP_NUMBER 2 //VdslMainProfile 
#define MIB_LineT_NUMBER 2 //LineTemplate 
#define MIB_LineP_NUMBER 54  //LineProfile
#define MIB_ChanP_NUMBER 10 //ChannelProfile
#define MIB_AlarmT_NUMBER 2 //AlarmTemplate 
#define MIB_LineAlarmP_NUMBER 12 //Line Alarm Profile
#define MIB_ChanAlarmP_NUMBER 4 //Channel Alarm Profile
#define MIB_VN_NUMBER 2 //Virtual Noise PSD
#define MIB_DPB_NUMBER 1 //DpboEPsd:Downstream power back-off E-side Psd
#define MIB_RFI_NUMBER 1 //RfiBands
#define MIB_PSD_NUMBER 2 //PsdMask

//profile type id
enum vdsl_profile_type_id{
VDSL_PROFILE_ID,
VDSL_LINE_TEMPLATE_ID,
VDSL_LINE_PROFILE_ID,
VDSL_CHAN_PROFILE_ID,
VDSL_ALARM_TEMPLATE_ID,
VDSL_LINE_ALARM_PROFILE_ID,
VDSL_CHAN_ALARM_PROFILE_ID,
VDSL_PROFILE_VN_ID,
VDSL_PROFILE_DPB_ID,
VDSL_PROFILE_RFI_ID,
VDSL_PROFILE_PSD_ID,
VDSL_PROFILE_END_ID
};
//Template Profile define
typedef struct mib_struct
{
        char oid[24];
        char *value;
}mib_struct;
//Define tables struct
typedef struct mib_struct4
{
        char *oid;
        char *value;
}mib_struct4;

//line alarm profile data struct 
typedef struct mibs_line_alarm_struct
{
        struct mib_struct mib[MIB_LineAlarmP_NUMBER];
}mibs_line_alarm_struct;
//channel alarm profile data struct
typedef struct mibs_chan_alarm_struct
{
        struct mib_struct mib[MIB_ChanAlarmP_NUMBER];
}mibs_chan_alarm_struct;
//line profile data struct
typedef struct mibs_line_struct
{
        struct mib_struct mib[MIB_LineP_NUMBER];
}mibs_line_struct;
//channel profile data struct
typedef struct mibs_chan_struct
{
        struct mib_struct mib[MIB_ChanP_NUMBER];
}mibs_chan_struct;
//main profile , line template, alarm template's data struct
typedef struct mibs_member_struct
{
	char vdsl_line_name[256];
	char vdsl_chan_name[256];
}mibs_member_struct;
//virtual noise data struct
typedef struct mibs_VN_struct
{
        struct mib_struct mib[MIB_VN_NUMBER];
	
}mibs_VN_struct;
//DpboEPsd data struct
typedef struct mibs_DPB_struct
{
        struct mib_struct mib[MIB_DPB_NUMBER];
	
}mibs_DPB_struct;
//RfiBands data struct
typedef struct mibs_RFI_struct
{
        struct mib_struct mib[MIB_RFI_NUMBER];
	
}mibs_RFI_struct;
//PsdMask data struct
typedef struct mibs_PSD_struct
{
        struct mib_struct mib[MIB_PSD_NUMBER];
	
}mibs_PSD_struct;

//union all profile data struct
typedef union union_mibs_struct{
	struct mibs_chan_struct     *mibs_chan;
	struct mibs_line_struct     *mibs_line;
	struct mibs_chan_alarm_struct *mibs_chan_alarm;
	struct mibs_line_alarm_struct *mibs_line_alarm;
	struct mibs_member_struct   *mibs_member;
	struct mibs_VN_struct	*vn; 	
	struct mibs_DPB_struct	*dpb;
	struct mibs_RFI_struct	*rfi;
	struct mibs_PSD_struct	*psd;
}union_mibs_struct;

//linklist profile data struct
typedef struct vdsl_all_profile
{
        char   profile_name[256];
	char   modify; //X:not modified *:modified
	unsigned int    vdsl_profile_id;//save seat ex:vdsl_profile_id=1 VdslChanProfiles1
	int type ;
        void *mibs; //access mibs_XXX_struct mibs:line_profile chan_profile alarm_line_profile alarm_chan_profile vn dpb 
        struct list_head        list;
}vdsl_all_profile;

typedef struct vdsl_all_profile_param
{
	unsigned int max_vdsl_profile_id;
	unsigned int init_profile_number;
	unsigned int modify_vdsl_profile;
	int init_profile;//init set to 1, not init set zero

}vdsl_all_profile_param;

#endif //_PROFILEDEF_H_
