/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.1 $
* Date:         $Date: 2012-01-05 11:07:18 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief header of dslcli.h
 */

#ifndef _DSLCLI_H_
#define _DSLCLI_H_

#define DSL2VERSION "1.1"
#define MT_DSLVERSION "$Revision: 1.1 $"

//CPU architecture definition
#define LITTLE_ENDIAN_PACKAGE
//#define BIG_ENDIAN_PACKAGE

// Mode directive, should only 1 level
//#define DEBUG_API
//#define WITH_SYS // system support
//#define WITH_ADV // xdsl advanced features support
//#define WITH_DUAL // dual latency support
#define WITH_STATISTIC // statistic support


//=======================dslman include=========================
#ifdef LITTLE_ENDIAN_PACKAGE
#define GET_DMT_WORD(WORD_BUF) ((WORD_BUF[0] << 16) | (WORD_BUF[1] << 8) | WORD_BUF[2])	// transform DMT_WORD from little-endian to little-endian
#elif defined (BIG_ENDIAN_PACKAGE)
#define GET_DMT_WORD(WORD_BUF) ((WORD_BUF[2] << 16) | (WORD_BUF[1] << 8) | WORD_BUF[0])	// transform DMT_WORD from big-endian to little-endian
#endif

//#define OPEN_LOG	// enable XML debugging log to /var/log/message
//#define CLI_DEBUG	// enable CLI debugging log to cli-debug.txt and cli-ks.txt

#define CMD_BUFFER_SIZE 4096
#define XML_CMD_BUFFER_SIZE 65536
#define MAX_CMD_DEPTH 20	/* Maximum number of commands in a line */
#define MAX_CMD_LEN 64
#define MAX_BUFFER 4096
#define MAX_SAVE_MIB 16

/// max command buffer
#define MT_CMD_BufferSize 512
#define MT_OPT_BufferSize 64

//remote debuger define
//#ifdef MT_DEBUG
//this follows windows eyebox define
#define MT_MEM_P 0x00
#define MT_MEM_X 0x40
#define MT_MEM_Y 0x80

#define MT_DEFAULT_PORT 5001
#define MT_DEFAULT_PROTO SOCK_STREAM // TCP

#define MT_SOCKET_ERROR -1
#define MT_INVALID_SOCKET -1

#define MT_READ_MEMORY 0x01
#define MT_WRITE_MEMORY 0x02
#define MT_READ_MIB 0x03
#define MT_WRITE_MIB 0x04
#define MT_DISABLE_DEBUG 0x05
#define MT_RAW_COMMAND 0x06
#define MT_READ_REMOTE_FILE 0x07
#define MT_WRITE_REMOTE_FILE 0x08
#define MT_CHECK_MIB2_HEADER 0x09
#define MT_EOC_READ_MEMORY 0x11
#define MT_EOC_WRITE_MEMORY 0x12
#define MT_EOC_RAW_COMMAND 0x13

extern int h_errno;
//#endif


//=======================cfgsh include=========================
#define HWADRSIZ (18)
#define IPQUADSIZ (16)
#define IFNAMEBASE "eth"
#define IFNAMESIZ 5
#define MAXIF (3)
#define NUMIF (MAXIF + 1)

#ifndef PATH_MAX
#define PATH_MAX (1024)
#endif

#define MAX_BUF_SIZE (512)

#define TZ_PATH "/etc/localtime"
#define ZONES_PATH "/usr/share/zoneinfo"

#define PING_PATH "/bin/ping"
#define PING_COUNT_PARAM "-c"
#define PING_COUNT "4"

/* Location of file to parse for Ethernet interface info */
#define PROC_NET_DEV "/proc/net/dev"

/* Location of system DNS resolver config file */
#define RESOLV_PATH "/etc/resolv.conf"

/* Location of vdsl firmware package file */
#if defined (VIA_SAMSUNG)
#define PACKAGE_PATH "/var/vdsl/firmware_package.b"
#elif defined (RALINK_RT3052)
#define PACKAGE_PATH "/mtd/bin/firmware_package.b"
#elif defined (ICPLUS_IP3210)
#define PACKAGE_PATH "/var/firmware_package.b"
#else
#define PACKAGE_PATH "/mtd/bin/firmware_package.b"
#endif

/* Location of system wide configuration file */
#if defined (VIA_SAMSUNG)
#define CONFIG_PATH "/mtd/mnt/vdsl/system.conf"
#elif defined (RALINK_RT3052)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (ICPLUS_IP3210)
#define CONFIG_PATH "/etc/system.conf"
#else
#define CONFIG_PATH "/etc/system.conf"
#endif

/* Location of network configuration file */
#define NETWORK_CONFIG_PATH "/etc/network.scr"

/* Location of preset configuration file */
#define PRESET_CONFIG_PATH "/etc/preset.scr"

/* Location of vdsl configuration file */
#define VDSL_CONFIG_PATH "/etc/vdsl.scr"

/* Location of default script file */
#define DEFAULTSCRIPT_PATH "/mtd/bin/default.scr"

/* Location of system wide export file */
#if defined (VIA_SAMSUNG)
#define EXPORT_PATH "/var/config/vdsl.conf"
#elif defined (RALINK_RT3052)
#define EXPORT_PATH "/mtd/board.conf"
#elif defined (ICPLUS_IP3210)
#define EXPORT_PATH "/var/board.conf"
#else
#define EXPORT_PATH "/mtd/board.conf"
#endif

/* Location of config manager */
#if defined (VIA_SAMSUNG)
#define CFGMGR_PATH "/var/vdsl/cfgmgr"
#elif defined (RALINK_RT3052)
#define CFGMGR_PATH "/mtd/bin/cfgmgr"
#elif defined (ICPLUS_IP3210)
#define CFGMGR_PATH "/mnt/cfgmgr"
#else
#define CFGMGR_PATH "/mtd/bin/cfgmgr"
#endif

/* Script to write GPIO to remote control service */
#define RC_WRITE_GPIO_PATH "/mtd/bin/sigusr1.sh"

/* Script to read GPIO from remote control service */
#define RC_READ_GPIO_PATH "/mtd/bin/sigusr2.sh"

/* Plain text file with ramdisk version */
#define RAMDISK_VERSION_PATH "/version"


/* Name and max length of DHCP options: on, off and iponly */
#define DHCP_OPT (7)
#define DHCP_OPT_ON "on"
#define DHCP_OPT_IPONLY "iponly"
#define DHCP_OPT_OFF "off"

#define SHOW_OPT_CONFIG "config"
#define SHOW_OPT_INTERFACES "interfaces"
#define SHOW_OPT_RESOLVER "resolver"
#define SHOW_OPT_ROUTES "routes"


/* Path to symlink to current system role */
#define ROLE_PATH "/etc/role"

/* Path to directory with all possible system roles */
#define ROLES_PATH "/etc/roles/"

//#define HOST_NAME_MAX (255)
#define APP_NAME "dslcli"

/* This is the system prompt */
#define PROMPT_SIZE (256)
#define PROMPT ">"
#define HNAME_SIZE (64)

#define MAX_ROUTE_SIZE (255)
#define ROUTE_NUM (3)

/********************************************************
 *
 *      End of user servicable part
 *
 *******************************************************/

/*
 *      Display an IP address in readable format.
 */

#define NIPQUAD(addr) \
	((unsigned char *)&addr)[0], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[3]

/* Command function forwards */
/*int com_ip PARAMS((char *));
int com_netmask PARAMS((char *));
int com_dhcp PARAMS((char *));
int com_broadcast PARAMS((char *));
int com_gw PARAMS((char *));
int com_ns PARAMS((char *));
int com_ns2 PARAMS((char *));
int com_search PARAMS((char *));
int com_nameservers PARAMS((char *));
int com_role PARAMS((char *));
int com_help PARAMS((char *));
int com_quit PARAMS((char *));
int com_save PARAMS((char *));
int com_show PARAMS((char *));
int com_ping PARAMS((char *));
int com_tz PARAMS((char *));
int com_halt PARAMS((char *));
int com_reboot PARAMS((char *));
int com_net PARAMS((char *));
int com_int PARAMS((char *));
int com_root PARAMS((char *));
int com_hostname PARAMS((char *));
int com_route PARAMS((char *));
int com_set_route PARAMS((char *));
int com_del_route PARAMS((char *));
int com_show_route PARAMS((char *));*/

#ifdef DEBUG_API
/* Utility function forwards */
int find_ifs(void);
int commit_file(char * tmp_file, char *file);
#endif 
/* A structure which contains information on the commands this program
   can understand. */
typedef char ** (complete_func_t)(const char *, char *, int);

typedef struct cmdt {
	unsigned char * cmd;
	unsigned char * help;
	struct cmdt * sub;
	complete_func_t *complete_func;
	int (*cmdf)(unsigned char * buffer, 
	struct cmdt * pcmd);
} cmdt;

typedef struct cmdhist {
	struct cmdhist * prev;
	char * cmd;
	struct cmdhist * next;
} cmdhist;

typedef int (*cmdtf)(unsigned char * buffer, cmdt * pcmd);

typedef struct index_structure {
	mt_uint8 ifIndex;
	mt_uint8 totalIndex;
} index_structure;

#endif //_DSLCLI_H_
