/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.1 $
* Date:         $Date: 2012-01-05 11:07:18 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**\file 
 * \brief DSL CLI main program
 * 
 * \n The functionality of this program is
 * - <1> unit test of each functionality of xDSLAPI
 * - <2> debug mode server
 * - <3> sample program for user to integrate with their AP
 * - <4> sample lib routing that user may need it.
 * 
 */
//cfgsh include
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
//dslman include
#include <signal.h>
#include <time.h>
#include <termios.h>		/* Terminal settings */
#include <stdarg.h>
#ifdef IOCTL_INTRFCE
#include "ioctlmeta.h"
#include "dsll3.h"
#include "dsltype.h"
#include "dslerr.h"
#include "vdsllib.h"
#include "vdsl2loid.h"
#include "awardm.h"
#else
#include "dsl.h"
#endif
#include "output_status.h"
#include "xmlparse.h"
#include "maketime.h"
#include "bsp.h"
#include "clitr069.h"
#include "if2.h"

#define OUTPUTFILE "/etc/vdslstatus.txt"

mt_uint8 buffer[1024*6];


static int IsValidMibValue(int value){
	/* 0x7FFFFE:8388606, 0x7FFFFF:8388607, 0xFFFFCC:16777164 */
	return (value == 0x7FFFFE || value == 0x7FFFFF || value == 0xFFFFCC) ? 0 : 1;
}


/**
 * Print uint32 mib entry
 * \param portid: port Id, start from 0
 * \param fmt: print format, ex: "%-24s|%-24s %s"
 * \param loid: logic oid, defined in header file
 * \param name: mib entry name
 * \param desc: mib entry description
 * \param idx: mib entry index
 * \return
 * 	- 0 : success
 * 	- other : error code 
 */
int static print_mib_uint32(mt_uint32 portid, const char * fmt, mt_uint8 * loid, char * name, char * desc, int idx)
{
	int ret , value;
	mt_uint8 loidf[OID_MAX_LEN], valuestr[64];

	sprintf(loidf, "%s.%d", loid, idx);
	if ((ret = get_mib2_uint32(portid, loidf, &value)) == DSL_ERR_OK){
		if (IsValidMibValue(value))
			sprintf(valuestr, "%d", value);
		else
			strcpy(valuestr, "NA");
			
		sprintf(buffer+strlen(buffer), fmt, name, valuestr, desc);
	}

	return ret;
}


int com_interface_xdsl_show_status(void)
{
	const char * outfmt_b = "%-24s|%-24s %s";
	const char * outfmt_a = "%-24s|%-14s%-14s %s";
	const char * profile_str[] = {"8a", "8b", "8c", "8d", "12a", "12b", "17a", "30a"};  
	char * advitem[][4] = {
			/* desc, us, ds */
			{"Actual delay", xdsl2ChStatusActDelay, xdsl2ChStatusActDelay2, "ms\n"},
			{"Actual INP", xdsl2ChStatusActInp, xdsl2ChStatusActInp2, "0.1 symbols\n"},
			{"15M CV", xdsl2PMChCurr15MCodingViolations, xdsl2PMChCurr15MCodingViolations2, "\n"},
			{"1Day CV", xdsl2PMChCurr1DayCodingViolations, xdsl2PMChCurr1DayCodingViolations2, "\n"},
			{"Total CV", xdsl2MetanoiaOtCodingViolations0, xdsl2MetanoiaOtCodingViolations01, "\n"},
			{"15M FEC", xdsl2PMChCurr15MCorrectedBlocks, xdsl2PMChCurr15MCorrectedBlocks2, "\n"},
			{"1Day FEC", xdsl2PMChCurr1DayCorrectedBlocks, xdsl2PMChCurr1DayCorrectedBlocks2, "\n"},
			{"Total FEC", xdsl2MetanoiaOtCorrectedBlocks0, xdsl2MetanoiaOtCorrectedBlocks01, "\n"},
			{"Previous Data Rate", xdsl2ChStatusPrevDataRate, xdsl2ChStatusPrevDataRate2, "Kbps\n"},
			{"Attainable Rate", xdsl2LineStatusAttainableRateUs, xdsl2LineStatusAttainableRateDs, "Kbps\n"},
			{"Electrical Length", xdsl2LineStatusElectricalLength, xdsl2LineStatusElectricalLength, "0.1 dB\n"},
			{"SNR Margin", xdsl2LineBandStatusSnrMargin, "", "(US0,--) 0.1 dB\n"},
			{"SNR Margin", xdsl2LineBandStatusSnrMargin1, xdsl2LineBandStatusSnrMargin5, "(US1,DS1) 0.1 dB\n"},
			{"SNR Margin", xdsl2LineBandStatusSnrMargin2, xdsl2LineBandStatusSnrMargin6, "(US2,DS2) 0.1 dB\n"},
			{"SNR Margin", xdsl2LineBandStatusSnrMargin3, xdsl2LineBandStatusSnrMargin7, "(US3,DS3) 0.1 dB\n"},
			{"SNR Margin", xdsl2LineBandStatusSnrMargin4, xdsl2LineBandStatusSnrMargin8, "(US4,DS4) 0.1 dB\n"},
			{"Signal Attenuation", xdsl2LineBandStatusSigAtten, "", "(US0,--) 0.1 dB\n"},
			{"Signal Attenuation", xdsl2LineBandStatusSigAtten1, xdsl2LineBandStatusSigAtten5, "(US1,DS1) 0.1 dB\n"},
			{"Signal Attenuation", xdsl2LineBandStatusSigAtten2, xdsl2LineBandStatusSigAtten6, "(US2,DS2) 0.1 dB\n"},
			{"Signal Attenuation", xdsl2LineBandStatusSigAtten3, xdsl2LineBandStatusSigAtten7, "(US3,DS3) 0.1 dB\n"},
			{"Signal Attenuation", xdsl2LineBandStatusSigAtten4, xdsl2LineBandStatusSigAtten8, "(US4,DS4) 0.1 dB\n"},
			{"Line Attenuation", xdsl2LineBandStatusLnAtten, "", "(US0,--) 0.1 dB\n"},
			{"Line Attenuation", xdsl2LineBandStatusLnAtten1, xdsl2LineBandStatusLnAtten5, "(US1,DS1) 0.1 dB\n"},
			{"Line Attenuation", xdsl2LineBandStatusLnAtten2, xdsl2LineBandStatusLnAtten6, "(US2,DS2) 0.1 dB\n"},
			{"Line Attenuation", xdsl2LineBandStatusLnAtten3, xdsl2LineBandStatusLnAtten7, "(US3,DS3) 0.1 dB\n"},
			{"Line Attenuation", xdsl2LineBandStatusLnAtten4, xdsl2LineBandStatusLnAtten8, "(US4,DS4) 0.1 dB\n"},
			{"15M Elapsed time", xdsl2PMLCurr15MTimeElapsed, xdsl2PMLCurr15MTimeElapsed1, "secs\n"},
			{"15M FECS", xdsl2PMLCurr15MFecs, xdsl2PMLCurr15MFecs1, "\n"},
			{"15M ES", xdsl2PMLCurr15MEs, xdsl2PMLCurr15MEs1, "\n"},
			{"15M SES", xdsl2PMLCurr15MSes, xdsl2PMLCurr15MSes1, "\n"},
			{"15M LOSS", xdsl2PMLCurr15MLoss, xdsl2PMLCurr15MLoss1, "\n"},
			{"15M UAS", xdsl2PMLCurr15MUas, xdsl2PMLCurr15MUas1, "\n"},
			{"1Day Elapsed time", xdsl2PMLCurr1DayTimeElapsed, xdsl2PMLCurr1DayTimeElapsed1, "secs\n"},
			{"1Day FECS", xdsl2PMLCurr1DayFecs, xdsl2PMLCurr1DayFecs1, "\n"},
			{"1Day ES", xdsl2PMLCurr1DayEs, xdsl2PMLCurr1DayEs1, "\n"},
			{"1Day SES", xdsl2PMLCurr1DaySes, xdsl2PMLCurr1DaySes1, "\n"},
			{"1Day LOSS", xdsl2PMLCurr1DayLoss, xdsl2PMLCurr1DayLoss1, "\n"},
			{"1Day UAS", xdsl2PMLCurr1DayUas, xdsl2PMLCurr1DayUas1, "\n"},
			{"Total FECS", xdsl2MetanoiaOtFecs0, xdsl2MetanoiaOtFecs01, "\n"},
			{"Total ES", xdsl2MetanoiaOtEs0, xdsl2MetanoiaOtEs01, "\n"},
			{"Total SES", xdsl2MetanoiaOtSes0, xdsl2MetanoiaOtSes01, "\n"},
			{"Total LOSS", xdsl2MetanoiaOtLoss0, xdsl2MetanoiaOtLoss01, "\n"},
			{"Total UAS", xdsl2MetanoiaOtUas0, xdsl2MetanoiaOtUas01, "\n"},
			{NULL, NULL, NULL}};
	mt_uint8 phy_status, advusstr[32],advdsstr[32];
	mt_uint32 portid, advus, advds, firmver, profile;
	int ret, advidx;

	portid = 0;

	get_phy_status(portid, &phy_status, NULL);
	if(phy_status == MT_OPSTATE_DISABLE){
		ret = DSL_ERR_NOTOK;
	}
	else{
		ret = get_phy_status(portid, &phy_status, NULL);
		if (ret == DSL_ERR_OK){
			switch (phy_status){
			case MT_OPSTATE_IDLE:
				sprintf(buffer, "Status (Basic) of Line %i: Idle\n", portid+1);
				break;
			case MT_OPSTATE_HANDSHAKE:
				sprintf(buffer, "Status (Basic) of Line %i: Handshake\n", portid+1);
				break;
			case MT_OPSTATE_TRAINING:
				sprintf(buffer, "Status (Basic) of Line %i: Training\n", portid+1);
				break;
			case MT_OPSTATE_SHOWTIME:
				sprintf(buffer, "Status (Basic) of Line %i: Showtime\n", portid+1);
				break;
			}

			if (MT_OPSTATE_SHOWTIME == phy_status){
				get_mib2_uint32(portid, xdsl2LineStatusActProfile, &profile);
				sprintf(buffer+strlen(buffer), "Profile: %s\n", profile_str[profile]);
			}else{
				sprintf(buffer+strlen(buffer), "Profile: NA\n");
			}

			sprintf(buffer+strlen(buffer), "%-24s|%-24s %s\n", "", "Value", "Description");
			print_mib_uint32(portid, outfmt_b, xdsl2ChStatusActDataRate, "Actual Data Rate", "(US) Kb/s\n", 1);
			print_mib_uint32(portid, outfmt_b, xdsl2ChStatusActDataRate, "Actual Data Rate", "(DS) Kb/s\n", 3);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusSnrMargin, "SNR Margin", "(US) 0.1dB\n", 10);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusSnrMargin, "SNR Margin", "(DS) 0.1dB\n", 11);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusLnAtten, "Line Attenuation", "(US) 0.1dB\n", 10);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusLnAtten, "Line Attenuation", "(DS) 0.1dB\n", 11);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusSigAtten, "Singal Attenuation", "(US) 0.1dB\n", 10);
			print_mib_uint32(portid, outfmt_b, xdsl2LineBandStatusSigAtten, "Singal Attenuation", "(DS) 0.1dB\n", 11);
			get_mib2_uint32(portid, xdslFirmwareVer, &firmver);
			sprintf(buffer+strlen(buffer), "%-24s|%06x\n", "Firmware Version", firmver);
			sprintf(buffer+strlen(buffer), "\nStatus (Advance) of Line %i:\n", portid+1);
			sprintf(buffer+strlen(buffer), "%24s %-14s%-14s\n", "", "Upstream", "Downstream");

			for (advidx = 0; advitem[advidx][0] != NULL; advidx++){
				if (strlen(advitem[advidx][1]) == 0)
					strcpy(advusstr, "--");
				else{
					ret = get_mib2_uint32(portid, advitem[advidx][1], &advus);
					
					if (MT_OK != ret)
						strcpy(advusstr, "FAILED");
					else {
						if (IsValidMibValue(advus))
							sprintf(advusstr, "%d", advus);
						else
							strcpy(advusstr, "NA");
					}
				}
				
				if (strlen(advitem[advidx][2]) == 0)
					strcpy(advdsstr, "--");
				else{
					ret = get_mib2_uint32(portid, advitem[advidx][2], &advds);
					
					if (MT_OK != ret)
						strcpy(advdsstr, "FAILED");
					else {
						if (IsValidMibValue(advds))
							sprintf(advdsstr, "%d", advds);
						else
							strcpy(advdsstr, "NA");
					}
				}

				sprintf(buffer+strlen(buffer), outfmt_a, advitem[advidx][0], advusstr, advdsstr, advitem[advidx][3]);
			}
		}
	}
	
	if(ret != DSL_ERR_OK) 
		sprintf(buffer, "Error getting port status.");
	
	return ret;
}


int main(void)
{
	FILE *fp;

	while(1) {
		com_interface_xdsl_show_status();
		fp = fopen(OUTPUTFILE, "w");
		fwrite(buffer, sizeof(buffer), 1, fp);
		fclose(fp);
		
		sleep(5);
	}
	
	return 0;
}
