/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2011-05-26 07:51:01 $
*
* Overview:
* Functions:
*
* Author:       Ian Tsao
*
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
*
* Metanoia reserves the right to change specifications without notice.
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet
* indicates this product is in design and the specification may change.
* Electrical parametrics have not been analyzed and are not specified. Do not
* use this data sheet as a design reference document. Please contact Metanoia
* for a current data sheet that may be used as a design reference. All
* contents of this document are protected by copyright law and may not be
* reproduced without the express written consent of Metanoia, Inc. Metanoia,
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.
* Other product names used in this publication are for identification purposes
* only and may be trademarks or registered trademarks of their respective
* companies. The contents of this document are provided in connection with
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that
* the information contained herein is accurate and reliable. However, Metanoia,
* Inc. makes no warranties, express or implied, as to the accuracy or
* completeness of the contents of this publication and is providing this
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to
* specifications and product descriptions at any time without notice, and to
* discontinue or make changes to its products at any time without notice.
* Metanoia, Inc. does not assume any liability arising out of the application
* or use of any product or circuit, and specifically disclaims any and all
* liability, including without limitation special, consequential, or
* incidental damages.
*
****************************************************************************/
#include <stdio.h>
#include <signal.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "dsl.h"
#include "dslcli.h"
#include "mterror.h"
#include "xmlparse.h"
#include "dslsocket.h"


char err_buf[128];
unsigned short listen_port = MT_DEFAULT_PORT;


int Socket(int family, int type, int protocol) 
{
	int n;

	if ((n = socket(family, type, protocol)) == -1)	{
		sprintf(err_buf, "socket() failed: Error\n");
		return DSL_ERR_NOTOK;
	}
	return n;
}


int Bind(int fd, const struct sockaddr *sa, socklen_t salen)
{
	if (bind(fd, sa, salen) < 0) {
		sprintf(err_buf, "socket() failed: Error\n");
		return DSL_ERR_NOTOK;
	}
	return 0;
}


int Listen(int fd, int backlog)
{
	if (listen(fd, backlog) < 0) {
		sprintf(err_buf, "listen() failed: Error\n");
		return DSL_ERR_NOTOK;
	}
	return 0;
}


int Accept(int fd, struct sockaddr *sa, socklen_t *salenptr)
{
	int n;

	if ((n = accept(fd, sa, salenptr)) < 0) {
		sprintf(err_buf, "accept error\n");
		return DSL_ERR_NOTOK;
	}
	return n;
}


// jerry
#ifdef __USE_SOCKET__
mt_ret debug_enable(int listen_socket)
{
	char socket_buf[BUF_SIZE];
	char err_buf[128];
	char fname[64];
	int fromlen;
	struct sockaddr_in from;
	int msgsock;
	int actionid;
	mt_ret ret;
	mt_uint8 pdata[6];
	mt_uint8 loid[OID_MAX_LEN];
	mt_uint16 bytesread, byteswrite;
	mt_uint32 address, memtype = 0;
	mt_uint32 portid;
	FILE *fp;

	fromlen = sizeof(from);
	msgsock = accept(listen_socket,(struct sockaddr*)&from, &fromlen);
	if (msgsock == MT_INVALID_SOCKET) {
		sprintf(err_buf,"accept() error: Error \"%s\"\n",
			hstrerror(h_errno));
		PRINTL(DBG_LVL_ALWAYS, err_buf);
		return DSL_ERR_NOTOK;
	}

	close(listen_socket);
	set_debug_level(DBG_LVL_NONE);

	sprintf(err_buf,"accepted connection from %s, port %d\n",
				inet_ntoa(from.sin_addr),
				htons(from.sin_port)) ;
	PRINTL(DBG_LVL_ALWAYS, err_buf);

	while(1) {
		//
		// In the case of SOCK_STREAM, the server can do recv() and
		// send() on the accepted socket and then close it.

		// However, for SOCK_DGRAM (UDP), the server will do
		// recvfrom() and sendto()  in a loop.

		// get socket buffer length first
		ret = recv(msgsock, socket_buf, 2, 0 );
		if (ret <= MT_SOCKET_ERROR) {
			sprintf(err_buf,"recv() failed: Error \"%s\"\n",
				hstrerror(h_errno));
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			close(msgsock);
			break;
		}
		if (ret == 0) {
			sprintf(err_buf,"Client closed connection\n\n");
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			close(msgsock);
			break;
		}

		// get real socket data
		bytesread = (socket_buf[0] << 8) | socket_buf[1];
		bytesread = (bytesread < BUF_SIZE) ? bytesread : BUF_SIZE;
		ret = recv(msgsock, socket_buf, bytesread, 0 );
		if (ret <= MT_SOCKET_ERROR) {
			sprintf(err_buf,"recv() failed: Error \"%s\"\n",
				hstrerror(h_errno));
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			close(msgsock);
			break;
		}
		if (ret == 0) {
			sprintf(err_buf,"Client closed connection\n\n");
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			close(msgsock);
			break;
		}

			actionid = socket_buf[0];
			switch(actionid){
				case MT_READ_MEMORY:
					portid=(socket_buf[1]&0x000000ff)-1;
					address=((socket_buf[2]<<16)&0xff0000)|((socket_buf[3]<<8)&0x00ff00)|(socket_buf[4]&0x0000ff);
					if(socket_buf[5] == (char)MT_MEM_X)
						memtype=MT_MEMTYPE_X;
					else if(socket_buf[5] == (char)MT_MEM_Y)
						memtype=MT_MEMTYPE_Y;
					else if(socket_buf[5] == (char)MT_MEM_P)
						memtype=MT_MEMTYPE_P;

					//sprintf(err_buf,"ReadMemory from address '%6x'\n",address);
					//PRINTL(DBG_LVL_ALWAYS, err_buf);
					if(get_port_mem(portid, address, memtype, pdata)==DSL_ERR_OK){
						socket_buf[0]=0;	//memory data reading successful
						socket_buf[1]=pdata[0];
						socket_buf[2]=pdata[1];
						socket_buf[3]=pdata[2];
					}
					else
						socket_buf[0]=0xff;	//memory data reading failed

					ret = send(msgsock,socket_buf,4*sizeof(char),0);
					break;

				case MT_WRITE_MEMORY:
					portid=(socket_buf[1]&0x000000ff)-1;
					address=((socket_buf[2]<<16)&0xff0000)|((socket_buf[3]<<8)&0x00ff00)|(socket_buf[4]&0x0000ff);
					pdata[0]=socket_buf[5];
					pdata[1]=socket_buf[6];
					pdata[2]=socket_buf[7];
					if(socket_buf[8] == MT_MEM_X)
						memtype=MT_MEMTYPE_X;
					else if(socket_buf[8] == (char)MT_MEM_Y)
						memtype=MT_MEMTYPE_Y;
					else if(socket_buf[8] == (char)MT_MEM_P)
						memtype=MT_MEMTYPE_P;

					//sprintf(err_buf,"WriteMemory to address '%6x'\n",address);
					//PRINTL(DBG_LVL_ALWAYS, err_buf);
					if(set_port_mem(portid, address, memtype, pdata)==DSL_ERR_OK)
						socket_buf[0]=0;
					else
						socket_buf[0]=0xff;

					ret = send(msgsock,socket_buf,2*sizeof(char),0);
					break;

				case MT_READ_MIB:
					portid = (socket_buf[1]&0x000000ff)-1;
					strcpy(loid, socket_buf+2);

					ret = get_port_mib(portid, loid, pbuffer);
					if(ret == DSL_ERR_OK) {
						PRINTL(DBG_LVL_CLI,"=================\nMIB value: %s\n=================\n", pbuffer+2);
						byteswrite = (pbuffer[0] << 8) | pbuffer[1];
						byteswrite = 6*byteswrite + 1 + 1;	// plus "1" socket_buf[2] erroe code and "1" mib value string terminator
						socket_buf[0] = (byteswrite & 0x00ff00)>>8;
						socket_buf[1] = byteswrite & 0x0000ff;
						socket_buf[2] = 0x00;
						strcpy(socket_buf+3, pbuffer+2);

						PRINTL(DBG_LVL_CLI, "in debug_enable: GetMIBData==DSL_ERR_OK\n\n");
					}
					else {
						socket_buf[0] = 0x00;
						socket_buf[1] = 0x02;

						if(ret == DSL_ERR_REVISION)
							socket_buf[2]=0xff;	//-1
						else if(ret == DSL_ERR_ENDMARK)
							socket_buf[2]=0xfe;	//-2
						else if(ret == DSL_ERR_BINDRVNOTLOAD)
							socket_buf[2]=0xfc;	//-4
						else if(ret == DSL_ERR_BINDRVSIGNATURE)
							socket_buf[2]=0xfb;	//-5
						else if(ret == DSL_ERR_BINDRVCHKSUM)
							socket_buf[2]=0xfa;	//-6
						else
							socket_buf[2]=0xfd;	//-3 unknow status

						byteswrite = 2;

						PRINTL(DBG_LVL_CLI, "in debug_enable: GetMIBData!=DSL_ERR_OK\n\n");
					}

					ret = send(msgsock,socket_buf, byteswrite+2, 0);
					break;

				case MT_WRITE_MIB:
					portid = (socket_buf[1]&0x000000ff)-1;
					strcpy(loid, socket_buf+2);
					strcpy(pbuffer, socket_buf+2+strlen(loid)+1);

					ret = set_port_mib(portid, loid, pbuffer);
					if(ret == DSL_ERR_OK) {
						socket_buf[0] = 0x00;

						PRINTL(DBG_LVL_CLI, "in debug_enable: SetMIBData==DSL_ERR_OK\n\n");
					}
					else {
						if(ret == DSL_ERR_REVISION)
							socket_buf[0]=0xff;	//-1
						else if(ret == DSL_ERR_ENDMARK)
							socket_buf[0]=0xfe;	//-2
						else if(ret == DSL_ERR_BINDRVNOTLOAD)
							socket_buf[0]=0xfc;	//-4
						else if(ret == DSL_ERR_BINDRVSIGNATURE)
							socket_buf[0]=0xfb;	//-5
						else if(ret == DSL_ERR_BINDRVCHKSUM)
							socket_buf[0]=0xfa;	//-6
						else
							socket_buf[0]=0xfd;	//-3 unknow status

						PRINTL(DBG_LVL_CLI, "in debug_enable: SetMIBData!=DSL_ERR_OK\n\n");
					}

					ret = send(msgsock,socket_buf, 2, 0);
					break;

				case MT_READ_REMOTE_FILE:
					sscanf(socket_buf+1, "%s", fname);
					fp = fopen(fname, "r");
					if (!fp){
						//sprintf(err_buf,"Can't open file \"%s\"\n", fname);
						//PRINTL(DBG_LVL_ALWAYS, err_buf);
						socket_buf[0] = 0xff;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf,"send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
						}

						break;
					}
					else{
						socket_buf[0] = 0x00;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf,"send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}
					}

					do{
						bytesread = fread(socket_buf+1, 1, FILE_EXCHG_SIZE-1, fp);
						socket_buf[0] = bytesread;
						ret = send(msgsock, socket_buf, FILE_EXCHG_SIZE, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf, "send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}

						ret = recv(msgsock, socket_buf, 2, 0);
						if (ret <= MT_SOCKET_ERROR) {
							sprintf(err_buf, "recv() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							ret = MT_SOCKET_ERROR;
							break;
						}
						if(socket_buf[0] != (char)(0x00) || socket_buf[1] != (char)(0xff)) break;
					}while(bytesread == FILE_EXCHG_SIZE - 1);

					fclose(fp);

					socket_buf[0] = 0;
					ret = send(msgsock, socket_buf, 2, 0);
					break;

				case MT_WRITE_REMOTE_FILE:
					sscanf(socket_buf+1, "%s", fname);
					fp = fopen(fname, "w");
					if (!fp){
						sprintf(err_buf,"Can't open file \"%s\"\n", fname);
						PRINTL(DBG_LVL_ALWAYS, err_buf);
						break;
					}

					do{
						ret = recv(msgsock, socket_buf, FILE_EXCHG_SIZE, 0);
						if (ret <= MT_SOCKET_ERROR) {
							sprintf(err_buf, "recv() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							ret = MT_SOCKET_ERROR;
							break;
						}

						byteswrite = socket_buf[0];
						fwrite(socket_buf+1, 1, byteswrite, fp);

						socket_buf[0] = 0x00;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf, "send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}
					}while(byteswrite == FILE_EXCHG_SIZE - 1);

					fclose(fp);

					ret = recv(msgsock, socket_buf, 2, 0);
					if (ret <= MT_SOCKET_ERROR) {
						sprintf(err_buf, "recv() failed: Error \"%s\"\n",
							hstrerror(h_errno));
						PRINTL(DBG_LVL_ALWAYS, err_buf);
						ret = MT_SOCKET_ERROR;
					}
					break;

				case MT_CHECK_MIB2_HEADER:
					portid = (socket_buf[1] & 0x000000ff) - 1;

					ret = get_mib2_header(portid);
					if(ret == DSL_ERR_OK)
						socket_buf[0] = 0x01;
					else if(ret == DSL_ERR_REVISION)
						socket_buf[0] = 0xff;	//-1
					else if(ret == DSL_ERR_ENDMARK)
						socket_buf[0] = 0xfe;	//-2
					else if(ret == DSL_ERR_BINDRVNOTLOAD)
						socket_buf[0] = 0xfc;	//-4
					else if(ret == DSL_ERR_BINDRVSIGNATURE)
						socket_buf[0] = 0xfb;	//-5
					else if(ret == DSL_ERR_BINDRVCHKSUM)
						socket_buf[0] = 0xfa;	//-6
					else
						socket_buf[0] = 0xfd;	//-3 unknow status

					ret = send(msgsock, socket_buf, 2, 0);
					break;

				case MT_DISABLE_DEBUG:
					socket_buf[0] = 0x00;
					ret = send(msgsock, socket_buf, 2, 0);

					close(msgsock);
					exit(0);

				case MT_RAW_COMMAND:
					if(!strcmp(socket_buf+1, "null"))
						socket_buf[0] = 0x00;
					else{
						commands = root_cmd;
						if(execute_line(socket_buf+sizeof(char), commands) == DSL_ERR_OK)
							socket_buf[0] = 0x00;
						else
							socket_buf[0] = 0xff;
					}

					ret = send(msgsock, socket_buf, 2, 0);
					break;

				default:
					sprintf(err_buf,"debug_enable: No such command.\n\n");
					PRINTL(DBG_LVL_ALWAYS, err_buf);
					break;
			}

			if (ret == MT_SOCKET_ERROR){
				sprintf(err_buf,"send() failed: Error \"%s\"\n",
					hstrerror(h_errno));
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}
		}
//	}	// end while 1 before accept
	return 0;
}

#ifdef XML_MIN_SIZE
mt_ret silent_enable(int connfd, fd_set *fds, client_structure cli_struct[], int *amount)
{
	int ret;
	unsigned char xml_cmd_buf[XML_CMD_BUFFER_SIZE];
	char err_buf[128];
#ifdef VIA_SAMSUNG
	unsigned char *pxml;
#endif

	silent = 1;
	set_debug_level(DBG_LVL_XML);

//	while (1) {

		ret = recv(connfd, xml_cmd_buf, XML_CMD_BUFFER_SIZE, 0 );
		if (ret <= MT_SOCKET_ERROR) {
			sprintf(err_buf,"recv() failed: Error \"%s\"\n",
				hstrerror(h_errno));
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			close(connfd);
			FD_CLR(connfd, fds);
			return DSL_ERR_NOTOK;
		}
		if (ret == 0) {
			int i;
			sprintf(err_buf,"Client closed connection\n\n");
			PRINTL(DBG_LVL_ALWAYS, err_buf);

			(*amount)--;
			// new connection fd is put into the array item whose silent_fd is 0.
			for (i = 0; i < MAX_SILENT_CLIENT; i++) {
				if (cli_struct[i].silent_fd == connfd) {
					cli_struct[i].silent_fd = 0;
					break;
				}
			}
			close(connfd);
			FD_CLR(connfd, fds);
			return 0;
		}

#ifdef OPEN_LOG
		syslog(1, xml_cmd_buf);
#endif

		if (strlen(xml_cmd_buf) == XML_CMD_BUFFER_SIZE &&
				xml_cmd_buf[XML_CMD_BUFFER_SIZE - 1] != 0x0) {
			PRINTD("<REPLY id=\"\" status=\"0\" msg=\"Buffer overflow!!\"></REPLY>");
			goto end_silent;
		}

	//silent mode can execute batch actions in a time
//	if(silent) {
		unsigned char c;
		int ci = 0;
		int depth = 0;
		unsigned char *token = NULL;
//		unsigned char xml_cmd_buf[XML_CMD_BUFFER_SIZE];
		XML_Parser parser;
#ifdef VIA_SAMSUNG
		unsigned char *pxml;
#endif
		unsigned char buffer[CMD_BUFFER_SIZE];

#ifdef VIA_SAMSUNG
		pxml = xml_cmd_buf;
		token = (unsigned char *)strcasestr(pxml, "</ACTION>");
		while (token != NULL) {
			bzero(buffer, sizeof(char) * CMD_BUFFER_SIZE);
			*token = '\0';
			strcat(buffer, pxml);
			strcat(buffer, "</ACTION>");
			*token = '<';
			pxml = token + 9; // 9 is the length of "</ACTION>";

			depth = 0;
			//execute_line("profiles xdsl-line init", root_cmd);
			parser = XML_ParserCreate(NULL);
			XML_SetUserData(parser, &depth);
			XML_SetElementHandler(parser, startElement, endElement);
			//printf("buffer:%s, strlen(buffer)=%d\n", buffer, strlen(buffer));

			if (!XML_Parse(parser, buffer, strlen(buffer), 1)) {
				sprintf(buffer,
							"%s at line %d\n",
							XML_ErrorString(XML_GetErrorCode(parser)),
							XML_GetCurrentLineNumber(parser));
//				PRINTD("%s", buffer);
				send(connfd, buffer, sizeof(buffer), 0);

				XML_ParserFree(parser);
				goto end_silent;
			}
  			XML_ParserFree(parser);
			token = (unsigned char *)strcasestr(pxml, "</ACTION>");
		}
#else //not VIA_SAMSUNG
		token = (unsigned char *)strtok(xml_cmd_buf, ">");
		while(token != NULL) {
			bzero(buffer, sizeof(char) * MAX_BUFFER);
			for(ci=0; ci<2; ci++) {
				strcat(buffer, token);
				buffer[strlen(buffer)+1] = buffer[strlen(buffer)];
				buffer[strlen(buffer)] = '>';
				token = (unsigned char *)strtok(NULL, ">");
				if(token == NULL) break;
			}
#ifdef OPEN_LOG
			syslog(1, buffer);
#endif

			parser = XML_ParserCreate(NULL);
			XML_SetUserData(parser, &depth);
			XML_SetElementHandler(parser, startElement, endElement);
			if (!XML_Parse(parser, buffer, strlen(buffer), 1)) {
				sprintf(buffer,
						"<REPLY id=\"\" status=\"0\" msg=\"%s at line %d\"></REPLY>",
						XML_ErrorString(XML_GetErrorCode(parser)),
						XML_GetCurrentLineNumber(parser));
//				PRINTD("%s", buffer);
				send(connfd, buffer, sizeof(buffer), 0);

				XML_ParserFree(parser);
				goto end_silent;
			}
			XML_ParserFree(parser);
//		}
#endif //VIA_SAMSUNG

		send(connfd, xmlparserbuf, sizeof(xmlparserbuf), 0);
end_silent:
		//send appWeb the output ending character
		c = 0x0;
//		ci = fwrite(&c, sizeof(char), 1, stdout);
		ci = send(connfd, &c, sizeof(char), 0);
		sprintf(xml_cmd_buf, "%d", ci);
#ifdef OPEN_LOG
		syslog(1, xml_cmd_buf);
#endif
		syslog(1, "End of Command");
//		goto out_sh;
		}
//	}
	return 0;
}
#endif	//XML_MIN_SIZE

mt_ret open_socket(void)
{
	int listenfd1;
	struct sockaddr_in local1;
	struct linger dontlinger1;
#ifdef XML_MIN_SIZE
	int listenfd2;
	struct sockaddr_in local2;
	struct linger dontlinger2;
#endif
	fd_set rset, allfds;
	int maxfd, nready;
	int debug_cpid = 0;
	int i = 0, j =0;
	struct timeval tv;
	unsigned int max_active = 1;	// keep the max active number
	int min_active = 0xffff;		// search the min active number. If hit, keep the index
	int idx_cli_struct;				// keep the index of the min active cli struct in the array
	int tmp;						// bubble sort used
	int silent_fd_amount = 0;
	client_structure cli_struct[MAX_SILENT_CLIENT];

	memset(cli_struct, 0, MAX_SILENT_CLIENT * sizeof(client_structure));

	listenfd1 = Socket(AF_INET, MT_DEFAULT_PROTO, 0);
	bzero(&local1, sizeof(local1));
	local1.sin_family = AF_INET;
	local1.sin_addr.s_addr = htonl(INADDR_ANY);
	local1.sin_port = htons(listen_port);
	Bind(listenfd1, (struct sockaddr*)&local1, sizeof(local1));
	Listen(listenfd1, 5);
	dontlinger1.l_onoff=1;
	dontlinger1.l_linger=0;
	setsockopt(listenfd1, SOL_SOCKET, SO_LINGER, &dontlinger1, sizeof(struct linger));

#ifdef XML_MIN_SIZE
	listenfd2 = Socket(AF_INET, MT_DEFAULT_PROTO, 0);
	bzero(&local2, sizeof(local2));
	local2.sin_family = AF_INET;
	local2.sin_addr.s_addr = htonl(INADDR_ANY);
	local2.sin_port = htons(MT_SILENT_PORT);
	Bind(listenfd2, (struct sockaddr*)&local2, sizeof(local2));
	Listen(listenfd2, 5);
	dontlinger2.l_onoff=1;
	dontlinger2.l_linger=0;
	setsockopt(listenfd2, SOL_SOCKET, SO_LINGER, &dontlinger2, sizeof(struct linger));
#endif

	FD_ZERO(&allfds);
	FD_SET(listenfd1, &allfds);

#ifdef XML_MIN_SIZE
	FD_SET(listenfd2, &allfds);
	maxfd = ((listenfd1 > listenfd2) ? listenfd1 : listenfd2);
#else
	maxfd = listenfd1;
#endif

	while(1) {
		// set timeout for select
		tv.tv_sec = 30;
		tv.tv_usec = 0;

		memcpy(&rset, &allfds, sizeof(fd_set));
		nready = select(maxfd+1, &rset, NULL, NULL, &tv);
		if (nready < 0) {
			perror("select error");
			break;
		}

		// debug_enable: at most 1 client
		if (FD_ISSET(listenfd1, &rset)) {
			if (debug_cpid) kill(debug_cpid, SIGKILL);
#ifndef VIA_SAMSUNG
			debug_cpid = fork();
#else
			debug_cpid = vfork();
#endif
			if(debug_cpid < 0) {
#ifndef VIA_SAMSUNG
				PRINTL(DBG_LVL_ALWAYS, "fork() failed!!");
#else
				PRINTL(DBG_LVL_ALWAYS, "vfork() failed!!");
#endif
			}
			else if(debug_cpid == 0) {
				// child executes debug_enable, close fd for silent mode
#ifdef XML_MIN_SIZE
				close(listenfd2);
#endif
				debug_enable(listenfd1);
			}
			if (--nready == 0) continue;
			// parent does nothing but checks if any other fds become readable
		}

#ifdef XML_MIN_SIZE
		// a connected socket is readable
		for (i = 0; i < MAX_SILENT_CLIENT; i++) {
			if (FD_ISSET(cli_struct[i].silent_fd, &rset)) {
				silent_enable(cli_struct[i].silent_fd, &allfds, cli_struct, &silent_fd_amount);
				// increase active number, check if overflow
				cli_struct[i].active = max_active;
				max_active++;
				if (max_active == 0xffff) {
					max_active = 5;
				    for (i = MAX_SILENT_CLIENT - 1; i > 0; i--) {
						for (j = 0; j <= i - 1; j++) {
							if (cli_struct[j].active > cli_struct[j + 1].active) {
								tmp = cli_struct[j].silent_fd;
								cli_struct[j].silent_fd = cli_struct[j + 1].silent_fd;
								cli_struct[j + 1].silent_fd = tmp;
							}
						}
					}
					for (i = 0; i < MAX_SILENT_CLIENT ; i++) {
						cli_struct[i].active = i + 1;
					}
				}
				if (--nready == 0) break;
			}
		}

		// the silent port comes a connection
		if (FD_ISSET(listenfd2, &rset)) {
			// jerry issues
			// the algo. kills the working oldest pid while other later client terminate unnormally.
			// issue is sloved by client_struct with active number.
			struct sockaddr_in	cli_addr;
			socklen_t clilen;
			int connfd;
			char err_buf[128];
			char clientip[128],local_ip[] = "127.0.0.1";

			// if listenfd2 is readable, accept the new connection from client
			clilen = sizeof(cli_addr);
			connfd = accept(listenfd2, (struct sockaddr *)&cli_addr, &clilen);
			if (connfd == MT_INVALID_SOCKET) {
				sprintf(err_buf,"accept() error: Error \"%s\"\n",
					hstrerror(h_errno));
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				return DSL_ERR_NOTOK;
			}

			// if connection is not from local host, refuse connection and close accepted socket
			if (strcmp(local_ip, inet_ntop(AF_INET, &cli_addr.sin_addr, clientip, sizeof(clientip))) != 0) {
				close(connfd);
				continue;
			}

			// add connfd to array and fdset
			if (silent_fd_amount < MAX_SILENT_CLIENT) {
				silent_fd_amount++;
				for (i = 0; i < MAX_SILENT_CLIENT; i++) {
					// new connection fd is put into the array item whose silent_fd is 0.
					if (cli_struct[i].silent_fd == 0) {
						cli_struct[i].silent_fd = connfd;
						break;
					}
				}
			} else {
				// too many clients, search the min active and close the socket
				min_active = 0xffff;
				for (i = 0; i < MAX_SILENT_CLIENT; i++) {
					if (cli_struct[i].active < min_active) {
						min_active = cli_struct[i].active;
						idx_cli_struct = i;
					}
				}
				close(cli_struct[idx_cli_struct].silent_fd);
				FD_CLR(cli_struct[idx_cli_struct].silent_fd, &allfds);
				cli_struct[idx_cli_struct].silent_fd = connfd;
			}
			FD_SET(connfd, &allfds);
			if (connfd > maxfd) maxfd = connfd;
		}
#endif
	}

	close(listenfd1);
#ifdef XML_MIN_SIZE
	close(listenfd2);
#endif
	return 0;
}
#else	//Original debug_enable()
/**
 * Remote eyebox commands parser
 */
mt_ret debug_enable(unsigned char * pbuf, cmdt * pcmd)
{
	char socket_buf[BUF_SIZE];
	char err_buf[128];
	char fname[64];
	int fromlen;
	int socket_type = MT_DEFAULT_PROTO;
	struct linger dontlinger;
	struct sockaddr_in local, from;
	int listen_socket, msgsock;
	int actionid;
	mt_ret ret;
	mt_uint8 pdata[6];
	mt_uint8 loid[OID_MAX_LEN];
	mt_uint16 bytesread, byteswrite;
	mt_uint32 address, memtype;
	mt_uint32 portid, value;
	mt_uint32 groupid, tableid, idx, paramid, interval;
	FILE *fp;
	pid_t cpid = 0;

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = INADDR_ANY;

	/*
	 * Port MUST be in Network Byte Order
	 */
	local.sin_port = htons(listen_port);

	listen_socket = socket(AF_INET, socket_type, 0); // TCP socket

	if (listen_socket == MT_INVALID_SOCKET){
		sprintf(err_buf, "socket() failed: Error \"%s\"\n",
			hstrerror(h_errno));
		PRINTL(DBG_LVL_ALWAYS, err_buf);
		return DSL_ERR_NOTOK;
	}
	//
	// bind() associates a local address and port combination with the
	// socket just created. This is most useful when the application is a
	// server that has a well-known port that clients know about in advance.
	//

	if (bind(listen_socket, (struct sockaddr*)&local, sizeof(local))
		== MT_SOCKET_ERROR) {
		sprintf(err_buf,"bind() failed: Error \"%s\"\n",
			hstrerror(h_errno));
		PRINTL(DBG_LVL_ALWAYS, err_buf);
		return DSL_ERR_NOTOK;
	}

	//
	// So far, everything we did was applicable to TCP as well as UDP.
	// However, there are certain steps that do not work when the server is
	// using UDP.
	//

	// We keep listen() on a TCP socket.
	if (listen(listen_socket,5) == MT_SOCKET_ERROR) {
		sprintf(err_buf,"listen() failed: Error \"%s\"\n",
			hstrerror(h_errno));
		PRINTL(DBG_LVL_ALWAYS, err_buf);
		return DSL_ERR_NOTOK;
	}

	dontlinger.l_onoff=1;
	dontlinger.l_linger=0;
	setsockopt(listen_socket,SOL_SOCKET,SO_LINGER,&dontlinger,sizeof(struct linger));

	PRINTL(DBG_LVL_ALWAYS, "debug_enable:Server is listening\n");
	sprintf(err_buf,"Listening on port %d\n",listen_port);
	PRINTL(DBG_LVL_ALWAYS, err_buf);
	while(1){
		fromlen = sizeof(from);
		msgsock = accept(listen_socket,(struct sockaddr*)&from, &fromlen);
		if (msgsock == MT_INVALID_SOCKET) {
			sprintf(err_buf,"accept() error: Error \"%s\"\n",
				hstrerror(h_errno));
			PRINTL(DBG_LVL_ALWAYS, err_buf);
			return DSL_ERR_NOTOK;
		}

		if(cpid != 0) kill(cpid, SIGKILL);

#if !defined (VIA_SAMSUNG) && !defined (REALTEK_RTL8672)
		cpid = fork();
#else
		cpid = vfork();
#endif
		if(cpid < 0) {
#if !defined (VIA_SAMSUNG) && !defined (REALTEK_RTL8672)
			PRINTL(DBG_LVL_ALWAYS, "fork() failed!!");
#else
			PRINTL(DBG_LVL_ALWAYS, "vfork() failed!!");
#endif

			close(msgsock);
			continue;
		}
		else if(cpid != 0) {		//parent process
			close(msgsock);
			continue;
		}
		else {	//child process
			close(listen_socket);
		}

		sprintf(err_buf,"accepted connection from %s, port %d\n",
					inet_ntoa(from.sin_addr),
					htons(from.sin_port)) ;
		PRINTL(DBG_LVL_ALWAYS, err_buf);

		while(1) {
			//
			// In the case of SOCK_STREAM, the server can do recv() and
			// send() on the accepted socket and then close it.

			// However, for SOCK_DGRAM (UDP), the server will do
			// recvfrom() and sendto()  in a loop.

			// get socket buffer length first
			ret = recv(msgsock, socket_buf, 2, 0 );
			if (ret <= MT_SOCKET_ERROR) {
				sprintf(err_buf,"recv() failed: Error \"%s\"\n",
					hstrerror(h_errno));
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}
			if (ret == 0) {
				sprintf(err_buf,"Client closed connection\n\n");
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}

			// get real socket data
			bytesread = (socket_buf[0] << 8) | socket_buf[1];
			bytesread = (bytesread < BUF_SIZE) ? bytesread : BUF_SIZE;
			ret = recv(msgsock, socket_buf, bytesread, 0 );
			if (ret <= MT_SOCKET_ERROR) {
				sprintf(err_buf,"recv() failed: Error \"%s\"\n",
					hstrerror(h_errno));
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}
			if (ret == 0) {
				sprintf(err_buf,"Client closed connection\n\n");
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}

			/*PRINTL(DBG_LVL_CLI,"Received %d bytes from client:",ret);
			for(i=0;i<ret;i++)
				PRINTL(DBG_LVL_CLI," %x",socket_buf[i]);
			PRINTL(DBG_LVL_CLI,"\n");*/

			actionid = socket_buf[0];
			switch(actionid){
				case MT_READ_MEMORY:
					portid=(socket_buf[1]&0x000000ff)-1;
					address=((socket_buf[2]<<16)&0xff0000)|((socket_buf[3]<<8)&0x00ff00)|(socket_buf[4]&0x0000ff);
					if(socket_buf[5] == (char)MT_MEM_X)
						memtype=MT_MEMTYPE_X;
					else if(socket_buf[5] == (char)MT_MEM_Y)
						memtype=MT_MEMTYPE_Y;
					else if(socket_buf[5] == (char)MT_MEM_P)
						memtype=MT_MEMTYPE_P;

					//sprintf(err_buf,"ReadMemory from address '%6x'\n",address);
					//PRINTL(DBG_LVL_ALWAYS, err_buf);
					if(get_port_mem(portid, address, memtype, pdata)==DSL_ERR_OK){
						socket_buf[0]=0;	//memory data reading successful
						socket_buf[1]=pdata[0];
						socket_buf[2]=pdata[1];
						socket_buf[3]=pdata[2];
					}
					else
						socket_buf[0]=0xff;	//memory data reading failed

					ret = send(msgsock,socket_buf,4*sizeof(char),0);
					break;

				case MT_WRITE_MEMORY:
					portid=(socket_buf[1]&0x000000ff)-1;
					address=((socket_buf[2]<<16)&0xff0000)|((socket_buf[3]<<8)&0x00ff00)|(socket_buf[4]&0x0000ff);
					pdata[0]=socket_buf[5];
					pdata[1]=socket_buf[6];
					pdata[2]=socket_buf[7];
					if(socket_buf[8] == MT_MEM_X)
						memtype=MT_MEMTYPE_X;
					else if(socket_buf[8] == (char)MT_MEM_Y)
						memtype=MT_MEMTYPE_Y;
					else if(socket_buf[8] == (char)MT_MEM_P)
						memtype=MT_MEMTYPE_P;

					//sprintf(err_buf,"WriteMemory to address '%6x'\n",address);
					//PRINTL(DBG_LVL_ALWAYS, err_buf);
					if(set_port_mem(portid, address, memtype, pdata)==DSL_ERR_OK)
						socket_buf[0]=0;
					else
						socket_buf[0]=0xff;

					ret = send(msgsock,socket_buf,2*sizeof(char),0);
					break;

				case MT_READ_MIB:
					portid = (socket_buf[1]&0x000000ff)-1;
					strcpy(loid, socket_buf+2);

					ret = get_port_mib(portid, loid, pbuffer);
					if(ret == DSL_ERR_OK) {
						PRINTL(DBG_LVL_CLI,"=================\nMIB value: %s\n=================\n", pbuffer+2);
						byteswrite = (pbuffer[0] << 8) | pbuffer[1];
						byteswrite = 6*byteswrite + 1 + 1;	// plus "1" socket_buf[2] erroe code and "1" mib value string terminator
						socket_buf[0] = (byteswrite & 0x00ff00)>>8;
						socket_buf[1] = byteswrite & 0x0000ff;
						socket_buf[2] = 0x00;
						strcpy(socket_buf+3, pbuffer+2);

						PRINTL(DBG_LVL_CLI, "in debug_enable: GetMIBData==DSL_ERR_OK\n\n");
					}
					else {
						socket_buf[0] = 0x00;
						socket_buf[1] = 0x02;

						if(ret == DSL_ERR_REVISION)
							socket_buf[2]=0xff;	//-1
						else if(ret == DSL_ERR_ENDMARK)
							socket_buf[2]=0xfe;	//-2
						else if(ret == DSL_ERR_BINDRVNOTLOAD)
							socket_buf[2]=0xfc;	//-4
						else if(ret == DSL_ERR_BINDRVSIGNATURE)
							socket_buf[2]=0xfb;	//-5
						else if(ret == DSL_ERR_BINDRVCHKSUM)
							socket_buf[2]=0xfa;	//-6
						else
							socket_buf[2]=0xfd;	//-3 unknow status

						byteswrite = 2;

						PRINTL(DBG_LVL_CLI, "in debug_enable: GetMIBData!=DSL_ERR_OK\n\n");
					}

					ret = send(msgsock,socket_buf, byteswrite+2, 0);
					break;

				case MT_WRITE_MIB:
					portid = (socket_buf[1]&0x000000ff)-1;
					strcpy(loid, socket_buf+2);
					strcpy(pbuffer, socket_buf+2+strlen(loid)+1);

					ret = set_port_mib(portid, loid, pbuffer);
					if(ret == DSL_ERR_OK) {
						socket_buf[0] = 0x00;

						PRINTL(DBG_LVL_CLI, "in debug_enable: SetMIBData==DSL_ERR_OK\n\n");
					}
					else {
						if(ret == DSL_ERR_REVISION)
							socket_buf[0]=0xff;	//-1
						else if(ret == DSL_ERR_ENDMARK)
							socket_buf[0]=0xfe;	//-2
						else if(ret == DSL_ERR_BINDRVNOTLOAD)
							socket_buf[0]=0xfc;	//-4
						else if(ret == DSL_ERR_BINDRVSIGNATURE)
							socket_buf[0]=0xfb;	//-5
						else if(ret == DSL_ERR_BINDRVCHKSUM)
							socket_buf[0]=0xfa;	//-6
						else
							socket_buf[0]=0xfd;	//-3 unknow status

						PRINTL(DBG_LVL_CLI, "in debug_enable: SetMIBData!=DSL_ERR_OK\n\n");
					}

					ret = send(msgsock,socket_buf, 2, 0);
					break;

				case MT_READ_REMOTE_FILE:
					sscanf(socket_buf+1, "%s", fname);
					fp = fopen(fname, "r");
					if (!fp){
						//sprintf(err_buf,"Can't open file \"%s\"\n", fname);
						//PRINTL(DBG_LVL_ALWAYS, err_buf);
						socket_buf[0] = 0xff;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf,"send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
						}

						break;
					}
					else{
						socket_buf[0] = 0x00;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf,"send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}
					}

					do{
						bytesread = fread(socket_buf+1, 1, FILE_EXCHG_SIZE-1, fp);
						socket_buf[0] = bytesread;
						ret = send(msgsock, socket_buf, FILE_EXCHG_SIZE, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf, "send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}

						ret = recv(msgsock, socket_buf, 2, 0);
						if (ret <= MT_SOCKET_ERROR) {
							sprintf(err_buf, "recv() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							ret = MT_SOCKET_ERROR;
							break;
						}
						if(socket_buf[0] != (char)(0x00) || socket_buf[1] != (char)(0xff)) break;
					}while(bytesread == FILE_EXCHG_SIZE - 1);

					fclose(fp);

					socket_buf[0] = 0;
					ret = send(msgsock, socket_buf, 2, 0);
					break;

				case MT_WRITE_REMOTE_FILE:
					sscanf(socket_buf+1, "%s", fname);
					fp = fopen(fname, "w");
					if (!fp){
						sprintf(err_buf,"Can't open file \"%s\"\n", fname);
						PRINTL(DBG_LVL_ALWAYS, err_buf);
						break;
					}

					do{
						ret = recv(msgsock, socket_buf, FILE_EXCHG_SIZE, 0);
						if (ret <= MT_SOCKET_ERROR) {
							sprintf(err_buf, "recv() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							ret = MT_SOCKET_ERROR;
							break;
						}

						byteswrite = socket_buf[0];
						fwrite(socket_buf+1, 1, byteswrite, fp);

						socket_buf[0] = 0x00;
						socket_buf[1] = 0xff;
						ret = send(msgsock, socket_buf, 2, 0);
						if (ret == MT_SOCKET_ERROR){
							sprintf(err_buf, "send() failed: Error \"%s\"\n",
								hstrerror(h_errno));
							PRINTL(DBG_LVL_ALWAYS, err_buf);
							break;
						}
					}while(byteswrite == FILE_EXCHG_SIZE - 1);

					fclose(fp);

					ret = recv(msgsock, socket_buf, 2, 0);
					if (ret <= MT_SOCKET_ERROR) {
						sprintf(err_buf, "recv() failed: Error \"%s\"\n",
							hstrerror(h_errno));
						PRINTL(DBG_LVL_ALWAYS, err_buf);
						ret = MT_SOCKET_ERROR;
					}
					break;

				case MT_CHECK_MIB2_HEADER:
					portid = (socket_buf[1] & 0x000000ff) - 1;

					ret = get_mib2_header(portid);
					if(ret == DSL_ERR_OK)
						socket_buf[0] = 0x01;
					else if(ret == DSL_ERR_REVISION)
						socket_buf[0] = 0xff;	//-1
					else if(ret == DSL_ERR_ENDMARK)
						socket_buf[0] = 0xfe;	//-2
					else if(ret == DSL_ERR_BINDRVNOTLOAD)
						socket_buf[0] = 0xfc;	//-4
					else if(ret == DSL_ERR_BINDRVSIGNATURE)
						socket_buf[0] = 0xfb;	//-5
					else if(ret == DSL_ERR_BINDRVCHKSUM)
						socket_buf[0] = 0xfa;	//-6
					else
						socket_buf[0] = 0xfd;	//-3 unknow status

					ret = send(msgsock, socket_buf, 2, 0);
					break;

				case MT_DISABLE_DEBUG:
					socket_buf[0] = 0x00;
					ret = send(msgsock, socket_buf, 2, 0);

					close(msgsock);
					exit(0);

				case MT_RAW_COMMAND:
					if(!strcmp(socket_buf+1, "null"))
						socket_buf[0] = 0x00;
					else{
						commands = root_cmd;
						if(execute_line(socket_buf+sizeof(char), commands) == DSL_ERR_OK)
							socket_buf[0] = 0x00;
						else
							socket_buf[0] = 0xff;
					}

					ret = send(msgsock, socket_buf, 2, 0);
					break;

				default:
					sprintf(err_buf,"debug_enable: No such command.\n\n");
					PRINTL(DBG_LVL_ALWAYS, err_buf);
					break;
			}

			if (ret == MT_SOCKET_ERROR){
				sprintf(err_buf,"send() failed: Error \"%s\"\n",
					hstrerror(h_errno));
				PRINTL(DBG_LVL_ALWAYS, err_buf);
				close(msgsock);
				break;
			}
		}
	}
}
#endif	//__USE_SOCKET__
