/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.48 $
* Date:         $Date: 2012-05-23 12:44:14 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file
 * \brief header of dslcli.h
 */

#ifndef _DSLCLI_H_
#define _DSLCLI_H_

#define DSL2VERSION xDSL_VERSION

//firmware_package.b binary format
#define LITTLE_ENDIAN_PACKAGE
//#define BIG_ENDIAN_PACKAGE

// Mode directive, should only 1 level
//#define DEBUG_API
//#define WITH_SYS // system support
//#define WITH_ADV // xdsl advanced features support
//#define WITH_DUAL // dual latency support
#define WITH_STATISTIC // statistic support


//=======================dslman include=========================
#ifdef LITTLE_ENDIAN_PACKAGE
#define GET_DMT_WORD(WORD_BUF) ((WORD_BUF[0] << 16) | (WORD_BUF[1] << 8) | WORD_BUF[2])	// transform DMT_WORD from little-endian to little-endian
#elif defined (BIG_ENDIAN_PACKAGE)
#define GET_DMT_WORD(WORD_BUF) ((WORD_BUF[2] << 16) | (WORD_BUF[1] << 8) | WORD_BUF[0])	// transform DMT_WORD from big-endian to little-endian
#endif

//#define OPEN_LOG	// enable XML debugging log to /var/log/message
//#define CLI_DEBUG	// enable CLI debugging log to cli-debug.txt and cli-ks.txt

#define CMD_BUFFER_SIZE 4096
#define XML_CMD_BUFFER_SIZE 65536
#define MAX_CMD_DEPTH 20	/* Maximum number of commands in a line */
#define MAX_CMD_LEN 64
#define MAX_BUFFER 4096
#define MAX_SAVE_MIB 16

/// max command buffer
#define MT_CMD_BufferSize 512
#define MT_OPT_BufferSize 64

//firmware_package.b parsing define
#define DEFAULT_PROFILE 6
#define FW_COUNT 9
#define PROFILE_COUNT 12
#define PROFILE_START 15
#define PROFILE_HDR_LEN 72
#define FW_START_OFFSET 39
#define FW_BINDRV_START_OFFSET 714
#define END_OID "0.0.0.0"
#define PREFIX_LEN 4
#define SYS_PREFIX "SYS_"
#define BND_PREFIX "BND_"
#define VNS_PREFIX "VNS_"
#define PSD_PREFIX "PSD_"
#define RFI_PREFIX "RFI_"
#define DPB_PREFIX "DPB_"
#define IOT_PREFIX "IOT_"

//ADSL related definitions
#define NUM_OF_PVC		4
//variable boundary
#define VPI_LIMIT		255
#define VCI_LIMIT1		32
#define VCI_LIMIT2		65535
#define VLAN_LIMIT1		1
#define VLAN_LIMIT2		4094
//#define PRIO_LIMIT		3
#define PRIO_LIMIT		0
#define ENCAP_LIMIT		1
//#define ATMQOS_LIMIT	3
#define ATMQOS_LIMIT	0
#define PCR_LIMIT		5500
#define SCR_LIMIT		5500
#define MBS_LIMIT		65535
#define ACTIVE_LIMIT	1

//ATM QoS priority, small number means higher priority
/*#define CBR			0
#define VBR-RT		1
#define VBR-NRT		2
#define UBR			3*/
#define CBR			0
#define VBR_RT		0
#define VBR_NRT		0
#define UBR			0

//ATM encapsulation
#define VC_MUX		0
#define LLC			1

//VLAN operation
#define VLAN_OP_PASS		0
#define VLAN_OP_REPLACE		1
#define VLAN_OP_REMOVE		2

//default MIB values
#define CfgSarfr_Default			0x000000
#define CfgSarReamFr_Default		0x101000
#define CfgSarReamProcPx_Default	0x830000
#define CfgSarSegFr_Default			0x011000
#define CfgSarSegProcPx_Default		0x010000


//=======================cfgsh include=========================
#define MAX_BUF_SIZE (512)

/* Location of vdsl firmware package file */
#if defined (VIA_SAMSUNG)
#define PACKAGE_PATH "/var/vdsl/firmware_package.b"
#elif defined (RALINK_RT3052) || defined (RALINK_RT3352)
#define PACKAGE_PATH "/mtd/bin/firmware_package.b"
#elif defined (ICPLUS_IP3210)
#define PACKAGE_PATH "/var/firmware_package.b"
#elif defined (ATHEROS_AR93XX)
#define PACKAGE_PATH "/lib/modules/2.6.31/vdsl/firmware_package.b"
#elif defined (ATHEROS_AR93XX_OPENWRT)
#define PACKAGE_PATH "/lib/modules/3.2.9/vdsl/firmware_package.b"
#elif defined (REALTEK_RTL8672)
#define PACKAGE_PATH "/lib/modules/2.6.30.9/vdsl/firmware_package.b"
#elif defined (VITESS_VSC7501)
#define PACKAGE_PATH "/lib/vdsl/firmware_package.b"
#else
#define PACKAGE_PATH "/mtd/bin/firmware_package.b"
#endif

/* Location of system wide configuration file */
#if defined (VIA_SAMSUNG)
#define CONFIG_PATH "/mtd/mnt/vdsl/system.conf"
#elif defined (RALINK_RT3052) || defined (RALINK_RT3352)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (ICPLUS_IP3210)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (ATHEROS_AR93XX)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (ATHEROS_AR93XX_OPENWRT)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (REALTEK_RTL8672)
#define CONFIG_PATH "/etc/system.conf"
#elif defined (VITESS_VSC7501)
#define CONFIG_PATH "/etc/vdsl.conf"
#else
#define CONFIG_PATH "/etc/system.conf"
#endif

/* Location of preset configuration file */
#define PRESET_CONFIG_PATH "/etc/preset.scr"

/* Location of vdsl configuration file */
#define VDSL_CONFIG_PATH "/etc/vdsl.scr"

/* Location of default script file */
#define DEFAULTSCRIPT_PATH "/mtd/bin/default.scr"

/* Location of system wide export file */
#if defined (VIA_SAMSUNG)
#define EXPORT_PATH "/var/config/vdsl.conf"
#elif defined (RALINK_RT3052) || defined (RALINK_RT3352)
#define EXPORT_PATH "/etc/board.conf"
#elif defined (ICPLUS_IP3210)
#define EXPORT_PATH "/var/board.conf"
#elif defined (ATHEROS_AR93XX)
#define EXPORT_PATH "/etc/board.conf"
#elif defined (ATHEROS_AR93XX_OPENWRT)
#define EXPORT_PATH "/etc/board.conf"
#elif defined (REALTEK_RTL8672)
#define EXPORT_PATH "/etc/board.conf"
#else
#define EXPORT_PATH "/mtd/board.conf"
#endif

/* Location of config manager */
#if defined (VIA_SAMSUNG)
#define CFGMGR_PATH "/var/vdsl/cfgmgr"
#elif defined (RALINK_RT3052) || defined (RALINK_RT3352)
#define CFGMGR_PATH "/mtd/bin/cfgmgr"
#elif defined (ICPLUS_IP3210)
#define CFGMGR_PATH "/mnt/cfgmgr"
#elif defined (ATHEROS_AR93XX)
#define CFGMGR_PATH "/bin/cfgmgr"
#elif defined (ATHEROS_AR93XX_OPENWRT)
#define CFGMGR_PATH "/bin/cfgmgr"
#elif defined (REALTEK_RTL8672)
#define CFGMGR_PATH "/bin/cfgmgr"
#elif defined (VITESS_VSC7501)
#define CFGMGR_PATH "/etc/cfgmgr"
#else
#define CFGMGR_PATH "/mtd/bin/cfgmgr"
#endif

/* This is the system prompt */
#define PROMPT_SIZE (256)
#define PROMPT ">"
#define HNAME_SIZE (64)

#define MAX_ROUTE_SIZE (255)
#define ROUTE_NUM (3)

/********************************************************
 *
 *      End of user serviceable part
 *
 *******************************************************/

/*
 *      Display an IP address in readable format.
 */

#define NIPQUAD(addr) \
	((unsigned char *)&addr)[0], \
	((unsigned char *)&addr)[1], \
	((unsigned char *)&addr)[2], \
	((unsigned char *)&addr)[3]

/* Command function forwards */
#ifdef DEBUG_API
/* Utility function forwards */
int find_ifs(void);
int commit_file(char * tmp_file, char *file);
#endif 

/* A structure which contains information on the commands this program
   can understand. */
typedef char ** (complete_func_t)(const char *, char *, int);

typedef struct cmdt {
	unsigned char * cmd;
	unsigned char * help;
	struct cmdt * sub;
	complete_func_t *complete_func;
	int (*cmdf)(unsigned char * buffer, struct cmdt * pcmd);
} cmdt;

typedef struct cmdhist {
	struct cmdhist * prev;
	char * cmd;
	struct cmdhist * next;
} cmdhist;

typedef int (*cmdtf)(unsigned char * buffer, cmdt * pcmd);

typedef struct mib_table_set {
	mt_uint8 group;
	mt_uint8 table;
	mt_uint8 param;
	mt_uint8 index;
	mt_uint8 interval;
} mib_table_set;

//ADSL PVC data structure
/*  VLANs Range: 0 - 4095
	0, 4095 Reserved range
	1 Normal range
	2-1000 Normal range
	1001 Normal range
	1002-1005 Reserved range
	1006-1009 Reserved range
	1010-1024 Reserved range
	1025-4094 Extended range

	0 and 4095 are Reserved VLAN
	1 is system default VLAN a.k.a. NATIVE VLAN
	1002 - 1005 are VLAN dedicate for FDDI*/
/*
	pcr - Peak cell rate, in Kbps, in the range 0 - 149760 (for OC3 ATM modules) or 0 - 599040 (for OC12 ATM modules)
	scr - Sustained cell rate, in Kbps, in the range 0 - 149760 (for OC3 ATM modules) or 0 - 599040 (for OC12 ATM modules)
	mbs - Maximum burst size, in cells, in the range 0 - 16777215
 */
typedef struct atmconfig {
	mt_uint8 vpi;		//0 - 255
	mt_uint16 vci;		//32 - 65535
	mt_uint16 vlanid;	//1 - 4094
	mt_uint8 prio;		//0 - 3
	mt_uint8 encap;		//0: VC-MUX, 1: LLC
	mt_uint8 atmqos;	//0: CBR, 1: VBR-RT, 2: VBR-NRT, 3: UBR
	mt_uint32 pcr;		//Peak Cell Rate, in cells, 0 - 5500
	mt_uint32 scr;		//Sustainable Cell Rate, in cells, 0 - 5500
	mt_uint32 mbs;		//Maximum Burst Size, in cells, 0 - 65535
	mt_uint8 active;	//0: Deactivate, 1: Activate
} atmconfig;

atmconfig atm_pvc[NUM_OF_PVC];

typedef struct index_structure {
	mt_uint8 ifIndex;
	mt_uint8 totalIndex;
} index_structure;

typedef struct client_structure {
	mt_uint32 silent_fd;		// fd for connection socket
	mt_uint32 active;			// to recognize the latest active client
} client_structure;

/* Forward declarations. */
/* External functions */
//dslcli2 com list
//for doxygen reference
#ifdef DOXYGEN
int show_pvc_rule (unsigned char * pbuf, cmdt * pcmd);
int show_portstat_by_oid (unsigned char * pbuf, cmdt * pcmd);
int show_portstat (unsigned char * pbuf, cmdt * pcmd);
int show_mibentry (unsigned char * pbuf, cmdt * pcmd);
int show_logic_mibentry (unsigned char * pbuf, cmdt * pcmd);
int com_interface_xdsl_show_summary (unsigned char * pbuf, cmdt * pcmd);
int com_interface_xdsl_show_table_scstatussegment (unsigned char * pbuf, cmdt * pcmd);
int set_pvc_rule (unsigned char * pbuf, cmdt * pcmd);
int set_logic_mibentry (unsigned char * pbuf, cmdt * pcmd);
int set_mibentry (unsigned char * pbuf, cmdt * pcmd);
int set_logic_mibbit (unsigned char * pbuf, cmdt * pcmd);
#endif	//DOXYGEN

#ifndef DOXYGEN
//for in-file function reference
extern char * stripwhite ();

extern cmdt root_cmd[];
extern int com_exitf (unsigned char * pbuf, cmdt * pcmd);

extern cmdt diag_cmd[];
extern int com_diag (unsigned char * pbuf, cmdt * pcmd);

extern cmdt interface1_cmd[];
extern int com_interface (unsigned char * pbuf, cmdt * pcmd);

extern cmdt interface_xdsl_cmd[];
extern int com_interface_xdsl (unsigned char * pbuf, cmdt * pcmd);

extern cmdt interface_xdsl_show_table_cmd[];
extern int com_interface_xdsl_show_table (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_line (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_lineband (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_channelstatus (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_scstatus (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_scstatussegment (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_table_pmlineinitcurr (unsigned char * pbuf, cmdt * pcmd);

extern cmdt interface_xdsl_show_cmd[];
extern int com_interface_xdsl_show (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_summary (unsigned char * pbuf, cmdt * pcmd);
#ifdef VIA_SAMSUNG
extern int com_interface_xdsl_show_xmlstatus (unsigned char * pbuf, cmdt * pcmd);
#endif //VIA_SAMSUNG
extern int com_interface_xdsl_show_status (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_pm_line_curr (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_pm_ch_curr (unsigned char * pbuf, cmdt * pcmd);
#ifdef WITH_ADV
extern int com_interface_xdsl_show_pm_15m_hist (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_pm_1d_hist (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_delt (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_linetest (unsigned char * pbuf, cmdt * pcmd);
#endif //WITH_ADV
extern int com_interface_xdsl_show_invent (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_show_threshold (unsigned char * pbuf, cmdt * pcmd);

extern cmdt interface_xdsl_set_cmd[];
#ifdef CO_API
extern int com_interface_xdsl_set_profile (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_set_initprofile (unsigned char * pbuf, cmdt * pcmd);
extern int com_interface_xdsl_set_threshold (unsigned char * pbuf, cmdt * pcmd); 
#endif //CO_API

#ifdef CO_API
extern cmdt profiles_cmd[];
extern int com_profiles (unsigned char * pbuf, cmdt * pcmd);

#ifdef TEMPLATE_PROFILE
//vdsl-profile
extern cmdt profiles_vdslprofile_cmd[];
extern cmdt profiles_vdslprofile_set_cmd[];

//vdsl-line-template
extern cmdt profiles_vdsllinetemplate_cmd[];
extern cmdt profiles_vdsllinetemplate_set_cmd[];
//vdsl-line-profile
extern cmdt profiles_vdsllineprofile_cmd[];
extern cmdt profiles_vdsllineprofile_set_cmd[];
//**Line Profile Modify command space**//

//vdsl-channel-profile
extern cmdt profiles_vdslchanprofile_cmd[];
extern cmdt profiles_vdslchanprofile_set_cmd[];
//**Channel Profile Modify command space**//

//vdsl-alarm-template
extern cmdt profiles_vdslalarmtemplate_cmd[];
extern cmdt profiles_vdslalarmtemplate_set_cmd[];
//vdsl-line-alarm-profile
extern cmdt profiles_vdsllinealarmprofile_cmd[];
extern cmdt profiles_vdsllinealarmprofile_set_cmd[];
//**Line Alarm Profile Modify command space**//

//vdsl-channel-alarm-profile
extern cmdt profiles_vdslchanalarmprofile_cmd[];
extern cmdt profiles_vdslchanalarmprofile_set_cmd[];
//**Channel Alarm Profile Modify command space**//
 
//vdsl-port
extern cmdt profiles_vdslport_cmd[];
extern cmdt profiles_vdslport_set_cmd[];
//**VDSL PORT Set Modify command space**//

//vdsl-extern-profile
extern cmdt profiles_vdslexternprofile_cmd[];
//extern cmdt profiles_vdslexternprofile_set_cmd[];
#endif//TEMPLATE_PROFILE
#endif //CO_API
#endif	//DOXYGEN

#endif //_DSLCLI_H_
