/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.2 $
* Date:         $Date: 2010-12-06 02:23:00 $
*
* Overview:
* Functions:
*
* Author:       Ian Tsao
*
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
*
* Metanoia reserves the right to change specifications without notice.
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet
* indicates this product is in design and the specification may change.
* Electrical parametrics have not been analyzed and are not specified. Do not
* use this data sheet as a design reference document. Please contact Metanoia
* for a current data sheet that may be used as a design reference. All
* contents of this document are protected by copyright law and may not be
* reproduced without the express written consent of Metanoia, Inc. Metanoia,
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.
* Other product names used in this publication are for identification purposes
* only and may be trademarks or registered trademarks of their respective
* companies. The contents of this document are provided in connection with
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that
* the information contained herein is accurate and reliable. However, Metanoia,
* Inc. makes no warranties, express or implied, as to the accuracy or
* completeness of the contents of this publication and is providing this
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to
* specifications and product descriptions at any time without notice, and to
* discontinue or make changes to its products at any time without notice.
* Metanoia, Inc. does not assume any liability arising out of the application
* or use of any product or circuit, and specifically disclaims any and all
* liability, including without limitation special, consequential, or
* incidental damages.
*
****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <stdarg.h>
#include <termios.h>		/* Terminal settings */
#include <sys/socket.h>
#include "dsl.h"
#include "dslcli.h"
#include "cmdprocess.h"


#ifdef __linux__
struct termios term, termsave; /* For use with terminal */
void (*signal(int signo, void (*func)(int)))(int);
#endif

#ifdef __linux__
typedef char uchar;
#else
typedef unsigned char uchar;
#endif


int cmd_idx = 0;		/* Current command index */
char cmds[CMD_BUFFER_SIZE][MAX_CMD_DEPTH];
unsigned long state_cnt = 0;
FILE *monitor_fp;
int is_tab_completion = 2;
int cli_debug_mask = 0xffffffff;
/* int is_space = 1; */
int cmd_len = 0;		/* Current command length */
/* int is_tab_completed = 0; */
int is_new_line = 1;
int is_list_question_mark = 1;
int cmd_cnt;
int prev_cmd_idx[MAX_CMD_DEPTH];
cmdt *prev_cmd[MAX_CMD_DEPTH];
cmdt *cli_pcmd = NULL;
int is_invalid_cmd = FALSE;
int invalid_cmd_ci = 0;
int is_space_at_last = 0;
int is_partial_word = 0;
int is_null_input = 0;
int is_cursor_at_tail = 1;
unsigned char esc = 0;
unsigned char esc_follow = 0;
unsigned char is_empty_cmd = 0;
pid_t pidSocket;
cmdhist *cmd_ptr= NULL;

#ifdef CLI_DEBUG
FILE *cli_fp;
FILE *cli_ks_fp;		/* Log keystrokes */
#endif	/* CLI_DEBUG */

char *null_str = "";

const char *sig_str[] = {
	"",
	"SIGHUP",
	"SIGINT",
	"SIGQUIT",
	"SIGILL",
	"SIGTRAP",
	"SIGABRT.SIGIOT",
	"SIGBUS",
	"SIGFPE",
	"SIGKILL",
	"SIGUSR1",
	"SIGSEGV",
	"SIGUSR2",
	"SIGPIPE",
	"SIGALRM",
	"SIGTERM",
	"SIGSTKFLT",
	"SIGCHLD",
	"SIGCONT",
	"SIGSTOP",
	"SIGTSTP",
	"SIGTTIN",
	"SIGTTOU",
	"SIGURG",
	"SIGXCPU",
	"SIGXFSZ",
	"SIGVTALRM",
	"SIGPROF",
	"SIGWINCH",
	"SIGIO.SIGPOLL",
	"SIGPWR",
	"SIGSYS.SIGUNUSED",
	"SIGSWI",
};

const char *debug_monitor_state_str[] = {
	"",
	"",
	""
};

typedef struct esc_char_table_t {
	char ch;
	char *fmt;
	char *fmt2;
} esc_char_table_t;

esc_char_table_t esc_table[] = {
	{'\a', "\\a", "<BELL>"},
	{'\b', "\\b", "<BS>"},
	{'\t', "\\t", "<TAB>"},
	{'\f', "\\f", "<LFD>"},
	{'\r', "\\r", "<RET>"},
	{'\v', "\\v", "<VTAB>"},
	{'\0', "", ""}
};

char COMBO_RIGHT_ARROW[] = {0x1b, 0x5b, 0x43};
char COMBO_LEFT_ARROW[] = {0x1b, 0x5b, 0x44};

#ifndef IOCTL_INTRFCE
mt_ret debug_monitor(unsigned char *pbuf, cmdt *pcmd);
#endif


// -------------------------- command interpreter function -----------------------
/** Initializes tab completion processor  */
void init_if_new_line(unsigned char *pbuf)
{
	if (is_new_line) {
		prev_cmd[cmd_cnt++] = NULL;
		prev_cmd_idx[cmd_cnt-1] = 0;
		cli_pcmd = commands;
		is_new_line = 0;
		//cmds[cmd_idx++] = pbuf;
	}
}

/** Search current menu pointer  */
void find_current_menu(unsigned char *pbuf)
{
	int i = 0;
	int l = 0;
	int mi = 0;
	int is_space_char = 0;
	int is_leading_space = 0;

	char tokens[] = " ";
	char *token = 0;
	int match_cmds[MAX_CMD_DEPTH];
	char tmp_str[CMD_BUFFER_SIZE];
	char *cmd_tokens[MAX_CMD_DEPTH];
	int cmd_token_idx = 0;

	/* Clear current menu */
	cli_pcmd = commands;
	for (i = 0; i < MAX_CMD_DEPTH; i++) {
		prev_cmd[i] = NULL;
		prev_cmd_idx[i] = 0;
		cmd_tokens[i] = null_str;
	}

	bzero(tmp_str, sizeof(char) * CMD_BUFFER_SIZE);
	bzero(cmds, sizeof(char) * CMD_BUFFER_SIZE * MAX_CMD_DEPTH);
	is_partial_word = FALSE;
	is_space_at_last = FALSE;
	is_invalid_cmd = FALSE;
	is_null_input = FALSE;

	if (strlen(pbuf) == 0) {
		cli_log(0, "find_current_menu with input null string\n");
		cli_pcmd = commands;
		is_null_input = TRUE;
		return;
	}

	cli_log(0, "find_current_menu, input: '%s'\n", pbuf);

	/* Stripping consecutive spaces and leading spaces */
	l = 0;
	for (i = 0; i < strlen(pbuf); i++) {
		/* Eliminate leading spaces */
		if ((i == 0) && (pbuf[i] == ' ')) {
			is_leading_space = TRUE;
		} else if ((is_leading_space) && (pbuf[i] == ' ')) {
			/* Ignore leading spaces */
		} else if ((pbuf[i] == ' ') && (!is_space_char)) {
			is_space_char = TRUE;
			tmp_str[l++] = pbuf[i];
		} else if ((pbuf[i] == ' ') && (is_space_char)) {
			/* Ignore consecutive spaces */
		} else {
			is_leading_space = FALSE;
			is_space_char = FALSE;
			tmp_str[l++] = pbuf[i];
		}
	}
	if (tmp_str[l-1] == ' ') {
		cli_log(0, "Space at last char\n");
		is_space_at_last = TRUE;
	}

	cli_log(0, "find_current_menu, after stripping spaces: '%s'\n", tmp_str);

	/* Split commands */
	cmd_idx = 0;
	token = strtok(tmp_str, tokens);
	while (token != NULL) {
		cli_log(0, "Found a token: '%s'\n", token);
		cli_log(0, "tmp_str = '%s'\n", tmp_str);
		//Edited by Ian
		if(strlen(token) > MAX_CMD_DEPTH)
			break;
		cmd_tokens[cmd_token_idx++] = token;
		strcpy(cmds[cmd_idx++], token);
		token = strtok(NULL, tokens);
	}

	if (is_space_at_last) {
		cmd_idx++;
	}

	cli_log(0, "Splitted %d commands\n", cmd_token_idx);

	/* Search menus */
	mi = 0;
	cmd_cnt = 0;
	for (i = 0; i < cmd_token_idx; i++) {
		cli_log(0, "%d time parse\n", i);
		mi = search_cmd(match_cmds, cmd_tokens[i], strlen(cmd_tokens[i]), TRUE);

		if ((mi == 0) && (i < cmd_token_idx-1)) {
			is_invalid_cmd = TRUE;
			cli_log(0, "Invalid command!\n");
		} else if ((mi == 0) && (is_space_at_last) && (i == cmd_token_idx-1) ) {
			is_invalid_cmd = TRUE;
			cli_log(0, "Invalid command with space at last!\n");
		} else if (mi == 0) {
			is_partial_word = TRUE;
		}

		if (mi == 1) {
			//Edited by Ian
			//advance_to_next_level(pbuf, match_cmds[0], 0);
			if(cli_pcmd[match_cmds[0]].sub == NULL && (cmd_token_idx-1) > i) {
				is_invalid_cmd = TRUE;
				is_partial_word = TRUE;
				break;
			}
			else {
				advance_to_next_level(pbuf, match_cmds[0], 0);
			}
		}
		cli_log(0, "%d time parse end\n", i);
	}
}

/** Command loop keyboard handling function */
void get_line(unsigned char * pbuf)
{
	uchar c;
	int i = 0;
	int ci = 0;		/* Current character index */
	int curpos = 0;
/* 	char *test = "e"; */
	int cmd_i = 0;
	char dch = 0;		/* Deleted character */
	cmdhist *curr_cmd= NULL;
	char tmpbuf[CMD_BUFFER_SIZE];

	/*
	 * \bug gets have security issue, need to be change to fgets
	 */
	//gets(pbuf);

	//Edited by Ian
	/* add "!show_prompt" for allowing get_line() to read from stdin without prompt */
	if (!show_prompt) {
		fgets(pbuf, CMD_BUFFER_SIZE, stdin);
		return;
	}

	if (!is_tab_completion) {
		cli_log(0, "Line input: '%s'\n");
		fgets(pbuf, CMD_BUFFER_SIZE, stdin);
		return;
	}

	/* Initializes get_line variables */
	cmd_idx = 0;
	cmd_len = 0;
	cli_pcmd = NULL;
	is_new_line = 1;
	ci = 0;
/* 	is_space = 1; */
/* 	is_tab_completed = 1; */
	for (i = 0; i < MAX_CMD_DEPTH; i++) {
		prev_cmd[i] = NULL;
		prev_cmd_idx[i] = 0;
	}

	bzero(pbuf, sizeof(char) * CMD_BUFFER_SIZE);
	bzero(cmds, sizeof(char) * CMD_BUFFER_SIZE * MAX_CMD_DEPTH);

	//create new command history link
	if (cmd_ptr == NULL) {
		if((cmd_ptr = (cmdhist *)malloc(sizeof(cmdhist))) == NULL)
			PRINTD("Memory allocation error!!\n");
		cmd_ptr->prev = NULL;
		cmd_ptr->cmd = NULL;
		cmd_ptr->next = NULL;
	}
	else {
		if (is_empty_cmd == 0) {
			if((cmd_ptr->next = (cmdhist *)malloc(sizeof(cmdhist))) == NULL)
				PRINTD("Memory allocation error!!\n");
			cmd_ptr->next->prev = cmd_ptr;
			cmd_ptr->next->cmd = NULL;
			cmd_ptr->next->next = NULL;
			cmd_ptr = cmd_ptr->next;
		} else	//is_empty_cmd == 1
			is_empty_cmd = 0;
	}
	curr_cmd = cmd_ptr;

	cli_log(0, "cmd_idx = %d\n", cmd_idx);

	/* Start to accept input, one character at a time */
	while ((c = getchar()) != '\n') {
		cli_log(0, "* Input[%d]: 0x%02x'%c'\n", ci, c, c);
		cli_ks_log(c);
		switch (c) {
		case '\t':
			//init_if_new_line(pbuf);
			cli_log(0, "[TAB] entered: \n");

			if(!is_cursor_at_tail) {
				bzero(tmpbuf, sizeof(char) * CMD_BUFFER_SIZE);
				strcpy(tmpbuf, pbuf);
				bzero(pbuf, sizeof(char) * CMD_BUFFER_SIZE);
				strncpy(pbuf, tmpbuf, curpos);
				ci = curpos;
			}

			find_current_menu(pbuf);

			/* When user input complete word, add a space to indicate completion */
			if ((!is_partial_word) &&
			    (!is_space_at_last) &&
			    (!is_null_input)) {
				cli_log(0, "Add a space is_partial_word=%x, is_space_at_last=%x\n",
					is_partial_word, is_space_at_last);
				pbuf[ci++] = ' ';
				putchar(' ');
			}
  			if (cli_pcmd == NULL) {
 				cmd_i = prev_cmd_idx[cmd_cnt-1];
 				PRINTD("\n%-16s - %s\n",
 				       prev_cmd[cmd_cnt-1][cmd_i].cmd,
 				       prev_cmd[cmd_cnt-1][cmd_i].help);
 				PRINTD("%s%s", prompt, pbuf);
 				cli_log(0, "No subdirectries\n");
 				break;
  			}

			cmd_len = strlen(cmds[cmd_idx-1]);
			list_cmd_table(cmds[cmd_idx-1], &cmd_len, pbuf, &ci);

			cli_log(0, "cmd_idx=%d\n", cmd_idx);
			for (i = 0; i < cmd_idx-1; i++)
				cli_log(0, "cmds[%d] = '%s'\n", i, cmds[i]);

			cli_log(0, "cmd is %x, prev_cmd is %x\n",
				cli_pcmd, prev_cmd[cmd_cnt-1]);

			if(!is_cursor_at_tail) {
				//calibrate display string
				PRINTD("%s", tmpbuf+curpos);
				//calibrate pbuf
				strcat(pbuf, tmpbuf+curpos);
				//calibrate curpos
				curpos = ci;
				//calibrate ci
				ci = strlen(pbuf);
				//move cursor to cuspos
				for(i = ci - curpos; i > 0; i--)
					PRINTD("%c%c%c", COMBO_LEFT_ARROW[0], COMBO_LEFT_ARROW[1], COMBO_LEFT_ARROW[2]);
			} else {
				//calibrate curpos
				curpos = ci;
			}
			break;
		case '?':
			find_current_menu(pbuf);
			if(is_invalid_cmd == TRUE &&
				is_partial_word == TRUE) {
				break;
			}
			if (cli_pcmd != NULL) {
				PRINTD("\n");
				help("?", cli_pcmd);
				PRINTD("%s%s", prompt, pbuf);
			} else {
				//Edited by Ian
				/*PRINTD("\n");
				help(pbuf, root_cmd);
				PRINTD("%s%s", prompt, pbuf);
				cli_log(0, "? at first!\n");*/

 				cmd_i = prev_cmd_idx[cmd_cnt-1];
 				PRINTD("\n%-16s - %s\n",
 				       prev_cmd[cmd_cnt-1][cmd_i].cmd,
 				       prev_cmd[cmd_cnt-1][cmd_i].help);
 				PRINTD("%s%s", prompt, pbuf);
 				cli_log(0, "No subdirectries\n");
			}

			break;
		default:
			//Edited by Ian
			//Used to process arrow buttons ^[A ^[B ^[C ^[D
			//^[A previous-line
			//^[B next-line
			//^[C forward-char
			//^[D backward-char
			if (c == 0x1b) { //Intercept Escape(^) character
				esc = 1;
				break;
			} else if (c == '[') {
				if (esc == 1) {
					esc_follow = 1;
					break;
				}
			} else if (c == 'A') {
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					if (curr_cmd->prev != NULL) {
						if (curr_cmd->cmd != NULL) {
							free(curr_cmd->cmd);
						}
						if((curr_cmd->cmd = (char *)malloc(ci+1)) == NULL)
							PRINTD("Memory allocation error!!\n");
						pbuf[ci] = 0;
						strcpy(curr_cmd->cmd, pbuf);
						curr_cmd = curr_cmd->prev;
						//move cursor to end of line
						if(!is_cursor_at_tail) {
							for(i = ci - curpos; i > 0; i--)
								PRINTD("%c%c%c", COMBO_RIGHT_ARROW[0], COMBO_RIGHT_ARROW[1], COMBO_RIGHT_ARROW[2]);
						}
						//if history cmd shorter than current cmd,
						//then erase current cmd, otherwise just
						//fall back the cursor and print history cmd
						if (strlen(curr_cmd->cmd) >= ci) {
							for (i = ci; i > 0; i--)
								putchar('\b');
						} else {
							//erase the undesired part of current cmd
							for (i = ci - strlen(curr_cmd->cmd); i > 0; i--)
								PRINTD("\b \b");
							for (i = strlen(curr_cmd->cmd); i > 0; i--)
								putchar('\b');
						}
						PRINTD("%s", curr_cmd->cmd);	//print history cmd
						bzero(pbuf, sizeof(char) * CMD_BUFFER_SIZE);
						strcpy(pbuf, curr_cmd->cmd);
						curpos = ci = strlen(curr_cmd->cmd);
						is_cursor_at_tail = 1;
					}
					cli_log(0, "[Up-arrow] entered\n");
					break;
				}
			} else if (c == 'B') {
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					if (curr_cmd->next != NULL) {
						if (curr_cmd->cmd != NULL) {
							free(curr_cmd->cmd);
						}
						if((curr_cmd->cmd = (char *)malloc(ci+1)) == NULL)
							PRINTD("Memory allocation error!!\n");
						pbuf[ci] = 0;
						strcpy(curr_cmd->cmd, pbuf);
						curr_cmd = curr_cmd->next;
						if(!is_cursor_at_tail) {
							for(i = ci - curpos; i > 0; i--)
								PRINTD("%c%c%c", COMBO_RIGHT_ARROW[0], COMBO_RIGHT_ARROW[1], COMBO_RIGHT_ARROW[2]);
						}
						if(strlen(curr_cmd->cmd) >= ci) {
							for (i = ci; i > 0; i--)
								putchar('\b');
						} else {
							for(i = ci - strlen(curr_cmd->cmd); i > 0; i--)
								PRINTD("\b \b");
							for(i = strlen(curr_cmd->cmd); i > 0; i--)
								putchar('\b');
						}
						PRINTD("%s", curr_cmd->cmd);
						bzero(pbuf, sizeof(char) * CMD_BUFFER_SIZE);
						strcpy(pbuf, curr_cmd->cmd);
						curpos = ci = strlen(curr_cmd->cmd);
						is_cursor_at_tail = 1;
					}
					cli_log(0, "[Down-arrow] entered\n");
					break;
				}
			} /*else if (c == 'C' || c == 'D') {	//skip left-arrow and right-arrow
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					break;
				}
			}*/	else if (c == 'C') {
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					if(curpos < ci) {
						curpos++;
						if(curpos == ci) is_cursor_at_tail = 1;	//cursor reach end of line
						else is_cursor_at_tail = 0;
						//PRINTD("%c%c%c", 0x1b, '[', 'C');
						PRINTD("%c%c%c", COMBO_RIGHT_ARROW[0], COMBO_RIGHT_ARROW[1], COMBO_RIGHT_ARROW[2]);
					}/* else {	// curpos == ci
						is_cursor_at_tail = 1;	//cursor at end of line
					}*/
					cli_log(0, "[Right-arrow] entered, position %d\n", curpos);
					break;
				}
			} else if (c == 'D') {
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					if(curpos > 0) {
						curpos--;
						is_cursor_at_tail = 0;
						//PRINTD("%c%c%c", 0x1b, '[', 'D');
						PRINTD("%c%c%c", COMBO_LEFT_ARROW[0], COMBO_LEFT_ARROW[1], COMBO_LEFT_ARROW[2]);
					}
					cli_log(0, "[Left-arrow] entered, position %d\n", curpos);
					break;
				}
			} else if (c == '3') {	//Map VT220 escape code "Del" key(^[3) to Backspace key
				if (esc == 1 && esc_follow == 1) {
					esc = esc_follow = 0;
					c = '\b';
				}
			} else {
				if (esc == 1)
					esc = 0;
			}

			//Edited by Ian
			//Map "Del" key to Backspace key
			if (c == 0x7f || c == term.c_cc[VERASE]) {
				c = '\b';
			}

			//Edited by Ian
			//if (c == term.c_cc[VERASE]) {
			if (c == '\b') {
				if(is_cursor_at_tail) {
					if (ci == 0) {
						cli_log(0, "Command prompt reaches, BS is not executed!\n");
						break;
					}

					dch = pbuf[ci-1];
					cli_log(0, "[Backspace] entered: deleting '%c'\n", dch);

					//deleting last char
					pbuf[--ci] = 0;
					//calibrate curpos
					curpos--;
					putchar(c);
					putchar(' ');
					putchar(c);
				} else {	//cursor not in end of line, process in "edit" mode
					if (curpos == 0) {
						cli_log(0, "Cursor reaches command prompt, BS is not executed!\n");
						break;
					}

					dch = pbuf[curpos-1];
					cli_log(0, "[Backspace] entered: deleting '%c'\n", dch);

					bzero(tmpbuf, sizeof(char) * CMD_BUFFER_SIZE);
					strncpy(tmpbuf, pbuf, curpos-1);
					strncpy(tmpbuf+(curpos-1), pbuf+curpos, ci - curpos);
					//cleaning last char in pbuf
					pbuf[--ci] = 0;
					strcpy(pbuf, tmpbuf);
					//calibrate curpos
					curpos--;

					putchar(c);
					//calibrate display string
					PRINTD("%s", pbuf+curpos);
					putchar(' ');
					putchar(c);
					//move cursor to cuspos
					for(i = ci - curpos; i > 0; i--)
						PRINTD("%c%c%c", COMBO_LEFT_ARROW[0], COMBO_LEFT_ARROW[1], COMBO_LEFT_ARROW[2]);
				}
				break;
			} /*else if (c == term.c_cc[VERASE]) {
				if (ci == 0) {
					cli_log(0, "Command prompt reaches, BS is not executed!\n");
					break;
				}

				dch = pbuf[ci-1];
				cli_log(0, "[Backspace] entered: deleting '%c'\n", dch);

				pbuf[--ci] = 0;
				putchar(term.c_cc[VERASE]);
				putchar(' ');
				putchar(term.c_cc[VERASE]);
				break;
			}*/ else if (c == term.c_cc[VKILL]) {
				cli_log(0, "Kill this line!\n");
				bzero(pbuf, sizeof(char) * CMD_BUFFER_SIZE);
				if(!is_cursor_at_tail) {
					for(i = ci - curpos; i > 0; i--)
						PRINTD("%c%c%c", COMBO_RIGHT_ARROW[0], COMBO_RIGHT_ARROW[1], COMBO_RIGHT_ARROW[2]);
				}
				for (i = 0; i < ci; i++) {
					//putchar(term.c_cc[VERASE]);
					//putchar(' ');
					//putchar(term.c_cc[VERASE]);
					putchar('\b');
					putchar(' ');
					putchar('\b');
				}
				curpos = ci = 0;
				is_cursor_at_tail = 1;
				break;
			}

			//Edited by Ian
			if(is_cursor_at_tail) {
				if (ci+1 != CMD_BUFFER_SIZE) {
					pbuf[ci++] = c;
					putchar(c);
					curpos = ci;
				}
			} else {
				if (ci+1 != CMD_BUFFER_SIZE) {
					bzero(tmpbuf, sizeof(char) * CMD_BUFFER_SIZE);
					strncpy(tmpbuf, pbuf, curpos);
					tmpbuf[curpos] = c;
					strncpy(tmpbuf+curpos+1, pbuf+curpos, ci - curpos);
					strcpy(pbuf, tmpbuf);
					ci++;
					curpos++;

					putchar(c);
					//calibrate display string
					PRINTD("%s", pbuf+curpos);
					//move cursor to cuspos
					for(i = ci - curpos; i > 0; i--)
						PRINTD("%c%c%c", COMBO_LEFT_ARROW[0], COMBO_LEFT_ARROW[1], COMBO_LEFT_ARROW[2]);
				}
			}

			break;
		}
	}

	putchar(c);	//print out the last-enterd "\n"
	cli_ks_log(c);
	cli_log(0, "Input command: '%s'\n", pbuf);
	if (strlen(pbuf) != 0) {	//add current inputted command to history
		if((cmd_ptr->cmd = (char *)malloc(strlen(pbuf)+1)) == NULL)
			PRINTD("Memory allocation error!!\n");
		strcpy(cmd_ptr->cmd, pbuf);
	} else
		is_empty_cmd = 1;
}

/** Search command tables with command prefix == PREFIX under current menu level */
int search_cmd(int *match_cmds, char *prefix, int length, int is_complete_word)
{
	int mi = 0;
	int i = 0;

	char tmp_str[MAX_CMD_LEN];

	bzero(tmp_str, sizeof(char) * MAX_CMD_LEN);
	for (i = 0; i < length; i++)
		tmp_str[i] = prefix[i];

	i = 0;
	/* Search command tables with command prefix == PREFIX */
	cli_log(0, "Search %s with length %d\n", prefix, length);
	while (cli_pcmd[i].cmd != NULL) {
		cli_log(0, "Searching cmd[%d] = %x, '%s'.... ",
			i, cli_pcmd[i].cmd, cli_pcmd[i].cmd);

		if (strncmp("?", cli_pcmd[i].cmd, 1) == 0) {
			cli_log(0, "Skipping \?");
		} else if ((length > 0) && ((*prefix) != 0)) {
			if (is_complete_word) {
				if (strcmp(tmp_str, cli_pcmd[i].cmd) == 0) {
					match_cmds[mi++] = i;
					cli_log(0, "Match!");
				}
			} else {
				if (strncmp(tmp_str, cli_pcmd[i].cmd, length) == 0) {
					match_cmds[mi++] = i;
					cli_log(0, "Match!");
				}
			}

		} else if (length == 0) {
			match_cmds[mi++] = i;
			cli_log(0, "Match!");
		}
		cli_log(0, "\n");

		i++;
	}
	return mi;
}

/** Advance to next level menu  */
void advance_to_next_level(unsigned char *pbuf, int match_index, int cursor_index)
{
	/* Advance to next level directory */
	cli_log(0, "cmd changes to [%d]%x, which is '%s'\n",
		match_index, cli_pcmd[match_index],
		cli_pcmd[match_index].cmd);

	prev_cmd[cmd_cnt++] = cli_pcmd;
	prev_cmd_idx[cmd_cnt-1] = match_index;
	cli_pcmd = cli_pcmd[match_index].sub;
	//cmds[cmd_idx++] = (char *)(pbuf + cursor_index);
/* 	is_tab_completed = 1; */
	cli_log(0, "cmd changes to %x, prev_cmd changes to [%d]%x\n",
		cli_pcmd, prev_cmd_idx[cmd_cnt-1], prev_cmd[cmd_cnt-1]);

}

/** List command table */
void list_cmd_table(char *prefix, int *length, char *pbuf, int *pbuf_idx)
{
	int i = 0;
	int mi = 0;		/* Match indices */
	int match_cmds[MAX_CMD_LEN];

	// jerry
	int j = 0;							// for loop
	int max_length = MAX_CMD_LEN;	// the maximun length of the same string of cli_pcmd

	if (prefix == NULL)
		cli_log(0, "prefix length=%x, prefix ptr=%x, pbuf: '%s'\n",
			*length, prefix, pbuf);
	else
		cli_log(0, "prefix length=%x, Prefix(%x): '%s', , pbuf: '%s'\n",
			*length, prefix, prefix, pbuf);

	if (is_invalid_cmd) {
		cli_log(0, "Invalid command! No listing command table!\n");
		return;
	}

	mi = search_cmd(match_cmds, prefix, *length, FALSE);

	cli_log(0, "Found %d matching!\n", mi);

	/* Return if no matching */
	if ((mi == 0) && (*length > 0)) {
		cli_log(0, "No matching, returning...\n");
		return;
	}

	/* Complete if matches only one command */
	if (mi == 1) {
		for (i = *length; i < strlen(cli_pcmd[match_cmds[0]].cmd); i++) {
			pbuf[(*pbuf_idx)++] = cli_pcmd[match_cmds[0]].cmd[i];
			putchar(cli_pcmd[match_cmds[0]].cmd[i]);
		}

		//Edited by Ian
		if(is_partial_word && (!is_space_at_last)) {
			/* Add space to buffer */
			pbuf[(*pbuf_idx)++] = ' ';
			putchar(' ');
		}

		cli_log(0, "After completion: pbuf='%s'\n", pbuf);

		advance_to_next_level(pbuf, match_cmds[0], *pbuf_idx);

	} else {
		PRINTD("\n");
		cli_log(0, "Output: ");
		for (i = 0; i < mi; i++) {
			//PRINTD("%s ", cli_pcmd[match_cmds[i]].cmd); // display cmd in one line
			PRINTD("%-16s - %s\n", cli_pcmd[match_cmds[i]].cmd, cli_pcmd[match_cmds[i]].help);
			cli_log(0, "'%s ',", cli_pcmd[match_cmds[i]].cmd);
		}

		// jerry
		/* get length of the same string in commands */
		for (i = 0; i < mi - 1; i++) {
			for (j = 0; j < max_length; j++) {
				if (cli_pcmd[match_cmds[i]].cmd[j] != cli_pcmd[match_cmds[i+1]].cmd[j])
					break;
			}
			if (j < max_length) max_length = j;
		}

		for (i = *length; i < max_length; i++) {
			pbuf[(*pbuf_idx)++] = cli_pcmd[match_cmds[0]].cmd[i];
		}
		// jerry end

		PRINTD("\n%s%s", prompt, pbuf);
		cli_log(0, "\n%s'%s'\n", prompt, pbuf);
	}
}

/** Signal functions for terminal*/
void sig_term(int signo)
{
	PRINTD("Catch signal #%d: %s\n", signo, sig_str[signo]);
	switch(signo) {
	case SIGINT:
		restore_tab_term();
		exit_sh(signo);
		break;
	}
	restore_tab_term();
	exit_sh(0);
}

/** Catch signals for debugging */
static void sig_debug_monitor(int signo)
{
	PRINTD("Catching signal #%d: %s\n", signo, sig_str[signo]);
	switch(signo) {
	case SIGINT:
		exit_debug_monitor();
		exit_sh(signo);
		break;
	}

	exit_debug_monitor();
	exit_sh(0);
}

/** Log function for cli debug  */
void cli_log(int level, char *fmt, ...)
{
	va_list arg;
	int done;
#ifdef CLI_DEBUG
	va_start(arg, fmt);
	if (cli_debug_mask & (1<<level))
		done = vfprintf(cli_fp, fmt, arg);
	va_end(arg);
#endif
}


/** Toggle TAB completion function  */
mt_ret toggle_tab(unsigned char *pbuf,  cmdt *pcmd)
{
	if (is_tab_completion) {
		is_tab_completion = 0;
		PRINTD("TAB completion is off\n");
		cli_log(0, "TAB completion if off\n");
		restore_tab_term();
		/* Should be changed in the future because of losing
		 * previous file content after toggling */
	} else {
		is_tab_completion = 1;
		PRINTD("TAB completion is on\n");
		init_tab_term();
	}
	return DSL_ERR_OK;
}


/** Initialize terminal for tab completion  */
void init_tab_term(void)
{
#ifdef __linux__
#ifdef CLI_DEBUG
	if (is_tab_completion == 2) {
		init_debug_file();
	}
	tcgetattr(0, &term);

	cli_log(0, "Init Term 0: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       term.c_lflag, term.c_cc[VMIN], term.c_cc[VTIME]);

#endif
	/* Initialize termios structures */
	bzero(&termsave, sizeof(termsave));
	bzero(&term, sizeof(term));

	if ((tcgetattr(0, &termsave)) < 0)
		PRINTD("Error getting stdin attr\n");
	term = termsave;
	term.c_lflag &= ~ICANON; /* Canonical mode for terminal, i.e. char at a time */
	term.c_lflag &= ~(ECHOE | ECHOK | ECHONL | ECHO | ECHOPRT);
	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 0;
	if ((tcsetattr(0, TCSADRAIN, &term)) < 0)
		PRINTD("Error setting stdin\n");

#ifdef CLI_DEBUG
	cli_log(0, "Init Term 0: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       term.c_lflag, term.c_cc[VMIN], term.c_cc[VTIME]);
	cli_log(0, "Saved Term 0: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       termsave.c_lflag, termsave.c_cc[VMIN], termsave.c_cc[VTIME]);

	tcgetattr(0, &term);

	cli_log(0, "Init Term 0: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       term.c_lflag, term.c_cc[VMIN], term.c_cc[VTIME]);

#endif

	setvbuf(stdout, NULL, _IONBF, 0);
	setvbuf(stdin, NULL, _IONBF, 0);
#endif

#ifdef CLI_DEBUG
	tcgetattr(0, &term);

	cli_log(0, "Term 0: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       term.c_lflag, term.c_cc[VMIN], term.c_cc[VTIME]);

	tcgetattr(1, &term);

	cli_log(0, "Term 1: c_lflag = %x, c_cc[VMIN] = %x, c_cc[VTIME] = %x\n",
	       term.c_lflag, term.c_cc[VMIN], term.c_cc[VTIME]);

#endif
}

/** Restore terminal settings */
void restore_tab_term(void)
{
#ifdef __linux__
	cli_log(0, "Restoring terminal settings...\n");

	if ((tcsetattr(0, TCSADRAIN, &termsave)) < 0)
		PRINTD("Error restoring stdin settings\n");
#endif

}

/** Initialize logging file  */
void init_debug_file(void)
{
#ifdef CLI_DEBUG
	cli_fp = fopen("cli-debug.txt", "w");
	fprintf(cli_fp, "-*- outline -*-\n");
	cli_ks_fp = fopen("cli-ks.txt", "w");
#endif
}

/** Exit point for logging file  */
void exit_debug_file(void)
{
#ifdef CLI_DEBUG
	cli_log(0, "Closing debug logging file...\n");
	fclose(cli_fp);
	fclose(cli_ks_fp);
#endif
}

/** Log keystroke  */
void cli_ks_log(char c)
{
#ifdef CLI_DEBUG
	esc_char_table_t *esc_ptr;
	esc_ptr = esc_table;

	while (esc_ptr->ch != '\0') {
		if (esc_ptr->ch == c) {
			fprintf(cli_ks_fp, esc_ptr->fmt);
			return;
		}
		esc_ptr++;
	}

	fputc(c, cli_ks_fp);
#endif
}

/** Exit point for dslcli  */
void exit_sh(int signo)
{
	exit_debug_file();
	exit(signo);
}


#ifndef IOCTL_INTRFCE
/** Debug function, monitoring DMT state transitions  */
mt_ret debug_monitor(unsigned char *pbuf, cmdt *pcmd)
{
	char s = 0;
	char output[132];

	init_debug_monitor();
	bzero(output, sizeof(char) * 132);

	for (;;) {
		s = (char) read_hpi_8(0);
		sprintf(output, "%d: %02x %s\n", state_cnt++, debug_monitor_state_str[s]);
		PRINTD(output);
		fprintf(monitor_fp, output);
	}

	exit_debug_monitor();

	return DSL_ERR_OK;
}
#endif //IOCTL_INTRFCE


/** Entry point for debug_monitor */
void init_debug_monitor(void)
{
	if (signal(SIGINT, sig_debug_monitor) == SIG_ERR)
		fprintf(stderr, "can't catch signal SIGINT");
	restore_tab_term();
	state_cnt = 0;
	monitor_fp = fopen("monitor.txt", "w");
}


/** Exit point for debug_monitor */
void exit_debug_monitor(void)
{
	fprintf(monitor_fp, "End of monitoring...\n");
	fclose(monitor_fp);

}


/**
 * Show command's help strings
 */
int help(unsigned char * pbuf, cmdt * pcmd)
{
	int i = 0;
	unsigned char cmd[MT_CMD_BufferSize];

	//printf("pbuf:%s, strlen(pbuf):%d\n", pbuf, strlen(pbuf));
	if(strlen(pbuf) > 1) //display help for single command, 1 means "?", "> 1" means single command help
	{
		sscanf(pbuf, "%s", cmd);
		//printf("cmd:%s, commands[0].cmd:%s\n", cmd, commands[0].cmd);
		while(commands[i].cmd != NULL)
		{
			if(strcmp(commands[i].cmd, cmd) == 0){
				PRINTL(DBG_LVL_ALWAYS, "%-16s - %s", commands[i].cmd, commands[i].help);
				break;
			}
			i++;
		}
		if(commands[i].cmd == NULL)
			PRINTL(DBG_LVL_ALWAYS, "No help for such command.");
	}
	else{	//display help for whole command table
		while(commands[i].cmd != NULL)
		{
			if ((is_list_question_mark) && (strncmp("?", commands[i].cmd, 1) != 0)) {
				PRINTL(DBG_LVL_ALWAYS, "%-16s - %s", commands[i].cmd, commands[i].help);
			}
			i++;
		}
	}

	return DSL_ERR_OK;
}
