/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.16 $
* Date:         $Date: 2012-05-23 12:44:14 $
*
* Overview:
* Functions:
*
* Author:       Ian Tsao
*
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
*
* Metanoia reserves the right to change specifications without notice.
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet
* indicates this product is in design and the specification may change.
* Electrical parametrics have not been analyzed and are not specified. Do not
* use this data sheet as a design reference document. Please contact Metanoia
* for a current data sheet that may be used as a design reference. All
* contents of this document are protected by copyright law and may not be
* reproduced without the express written consent of Metanoia, Inc. Metanoia,
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.
* Other product names used in this publication are for identification purposes
* only and may be trademarks or registered trademarks of their respective
* companies. The contents of this document are provided in connection with
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that
* the information contained herein is accurate and reliable. However, Metanoia,
* Inc. makes no warranties, express or implied, as to the accuracy or
* completeness of the contents of this publication and is providing this
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to
* specifications and product descriptions at any time without notice, and to
* discontinue or make changes to its products at any time without notice.
* Metanoia, Inc. does not assume any liability arising out of the application
* or use of any product or circuit, and specifically disclaims any and all
* liability, including without limitation special, consequential, or
* incidental damages.
*
****************************************************************************/
#include "clitr069.h"
#include "tr069.h"


/**
 * TR-069 Get Parameter Values function
 * \par Usage:
 * 		cmd <Name>
 * \param name: A TR-069 Parameter Name corresponds to xDSL under "InternetGatewayDevice.WANDevice.1." node
 * \return
 *
 */
int com_get_parameter_values(unsigned char * pbuf, cmdt * pcmd)
{
	int value,value1;
	mt_uint8 para_name[BUF_SIZE];
	mt_uint8 buffer[LARGE_BUF_SIZE];
	mt_uint32 ret;
	
	ret = sscanf(pbuf, "%s", para_name);
	if (ret != 1) {
    	PRINTL(DBG_LVL_ALWAYS, "GetParameterValues <Name>");
		return -DSL_ERR_NOPASS;		
	}

	memset(para_name, 0, sizeof(para_name));
	sprintf(para_name, "%s %s", GET_PAR_VALUE, GATEWAY_DEVICE);
	strcat(para_name, pbuf);

	vdsl_tr069(GATEWAY_DEVICE, para_name, buffer);

	PRINTL(DBG_LVL_CLI, "dslcli %s = %s\n", para_name, buffer);

	return DSL_ERR_OK;
}


/**
 * TR-069 Set Parameter Values function
 * \par Usage:
 * 		cmd <Name>.<Value>
 * \param name.value: A TR-069 Parameter Name-Value pair corresponds to xDSL under "InternetGatewayDevice.WANDevice.1." node
 * \return
 *
 */
int com_set_parameter_values(unsigned char * pbuf, cmdt * pcmd)
{
	int value,value1;
	mt_uint8 para_name[BUF_SIZE];
	mt_uint8 buffer[LARGE_BUF_SIZE];
	mt_uint32 ret;

	ret = sscanf(pbuf, "%s", para_name);
	if (ret != 1) {
    	PRINTL(DBG_LVL_ALWAYS, "SetParameterValues <Name>.<Value>");
		return -DSL_ERR_NOPASS;		
	}

	memset(para_name, 0, sizeof(para_name));
	sprintf(para_name, "%s %s", SET_PAR_VALUE, GATEWAY_DEVICE);
	strcat(para_name, pbuf);

	vdsl_tr069(GATEWAY_DEVICE, para_name, buffer);

	PRINTL(DBG_LVL_CLI, "dslcli %s = %s\n", para_name, buffer);

	return DSL_ERR_OK;
}


/**
 * TR-069 Get Parameter Attributes function
 * \par Usage:
 * 		cmd <Name>
 * \param name: A TR-069 Parameter Name corresponds to xDSL under "InternetGatewayDevice.WANDevice.1." node
 * \return
 *
 */
int com_get_parameter_attributes(unsigned char * pbuf, cmdt * pcmd)
{
	int value,value1;
	mt_uint8 para_name[BUF_SIZE];
	mt_uint8 buffer[LARGE_BUF_SIZE];
	mt_uint32 ret;

	ret = sscanf(pbuf, "%s", para_name);
	if (ret != 1) {
    	PRINTL(DBG_LVL_ALWAYS, "GetParameterAttributes <Name>");
		return -DSL_ERR_NOPASS;
	}

	memset(para_name, 0, sizeof(para_name));
	sprintf(para_name, "%s %s", GET_PAR_ATTR, GATEWAY_DEVICE);
	strcat(para_name, pbuf);

	vdsl_tr069(GATEWAY_DEVICE, para_name, buffer);

	PRINTL(DBG_LVL_CLI, "dslcli %s = %s\n", para_name, buffer);

	return DSL_ERR_OK;
}


/**
 * TR-069 Set Parameter Attributes function
 * \par Usage:
 * 		cmd <Name>
 * \param name: A TR-069 Parameter Name corresponds to xDSL under "InternetGatewayDevice.WANDevice.1." node
 * \return
 *
 */
int com_set_parameter_attributes(unsigned char * pbuf, cmdt * pcmd)
{
	int value,value1;
	mt_uint8 para_name[BUF_SIZE];
	mt_uint8 buffer[LARGE_BUF_SIZE];
	mt_uint32 ret;

	ret = sscanf(pbuf, "%s", para_name);
	if (ret != 1) {
    	PRINTL(DBG_LVL_ALWAYS, "SetParameterAttributes <Name>");
		return -DSL_ERR_NOPASS;
	}

	memset(para_name, 0, sizeof(para_name));
	sprintf(para_name, "%s %s", SET_PAR_ATTR, GATEWAY_DEVICE);
	strcat(para_name, pbuf);

	vdsl_tr069(GATEWAY_DEVICE, para_name, buffer);

	PRINTL(DBG_LVL_CLI, "dslcli %s = %s\n", para_name, buffer);

	return DSL_ERR_OK;
}


/**
 * TR-069 Get Parameter Names function
 * \par Usage:
 * 		cmd <Name>.<NextLevel>
 * \param name.nextlevel: A TR-069 Parameter Name corresponds to xDSL under "InternetGatewayDevice.WANDevice.1." node, nextlevel can be "0"(full list) or "1"(partial list)
 * \return
 *
 */
int com_get_parameter_names(unsigned char * pbuf, cmdt * pcmd)
{
	int value,value1;
	mt_uint8 para_name[BUF_SIZE];
	mt_uint8 buffer[LARGE_BUF_SIZE];
	mt_uint32 ret;
	
	ret = sscanf(pbuf, "%s", para_name);
	if (ret != 1) {
    	PRINTL(DBG_LVL_ALWAYS, "GetParameterNames <Name>.<NextLevel>");
		return -DSL_ERR_NOPASS;		
	}

	memset(para_name, 0, sizeof(para_name));
	sprintf(para_name, "%s %s", GET_PAR_NAME, GATEWAY_DEVICE);
	strcat(para_name, pbuf);

	vdsl_tr069(GATEWAY_DEVICE, para_name, buffer);

	PRINTL(DBG_LVL_CLI, "dslcli %s = %s\n", para_name, buffer);

	return DSL_ERR_OK;
}


int com_tr069_dumptr069(unsigned char * pbuf, cmdt * pcmd)
{
	dump_tr069(1);

	return DSL_ERR_OK;
}


int com_tr069 (unsigned char * pbuf, cmdt * pcmd)
{
  commands = tr069_cmd;
  set_prompt("tr069");
  return DSL_ERR_OK;
}


cmdt tr069_cmd[] = 
{
	{"GetParameterValues", "TR069 GetParmeterValues , <parmeter>",NULL, NULL, com_get_parameter_values},
	{"SetParameterValues", "TR069 SetParmeterValues , <parmeter>.<value>",NULL, NULL, com_set_parameter_values},
	{"GetParameterAttributes", "TR069 GetParmeterAttributes , <parmeter>",NULL, NULL, com_get_parameter_attributes},
	{"SetParameterAttributes", "TR069 SetParmeterAttributes , <parmeter>.<value>",NULL, NULL, com_set_parameter_attributes},
	{"GetParameterNames", "TR069 GetParmeterNames , <parmeter>.<nextlevel>",NULL, NULL, com_get_parameter_names},
	{"dumptr069", "dump tr069 table", NULL, NULL, com_tr069_dumptr069},	
	{"exit", "Return to the root directory", root_cmd, NULL, com_root},
	{"quit", "Logout", NULL, NULL, com_exitf},
	{"?", "Help", NULL, NULL, help},
	{NULL, NULL, NULL, NULL, NULL}
};
