/***************************************************************
* Filename     : bsp.h 			                                   *
* Copyright    : Copyright (C) 2002, Glotrex. Co. LTD          *
***************************************************************/

#ifndef __C133_LOADER_BSP__
#define __C133_LOADER_BSP__

/*
* common definitions
*/

/*
* Constant Definitions
*/
#define SZ_1                0x00000001
#define SZ_2                0x00000002
#define SZ_4                0x00000004
#define SZ_8                0x00000008
#define SZ_16               0x00000010
#define SZ_32               0x00000020
#define SZ_64               0x00000040
#define SZ_128              0x00000080
#define SZ_256              0x00000100
#define SZ_512              0x00000200
#define SZ_512							0x00000200
#define SZ_1K               0x00000400
#define SZ_2K               0x00000800
#define SZ_4K               0x00001000
#define SZ_8K               0x00002000
#define SZ_16K              0x00004000
#define SZ_32K              0x00008000
#define SZ_64K              0x00010000
#define SZ_128K             0x00020000
#define SZ_256K             0x00040000
#define SZ_512K             0x00080000
#define SZ_640K             0x000a0000
#define SZ_768K             0x000c0000
#define SZ_1M               0x00100000
#define SZ_2M               0x00200000
#define SZ_4M               0x00400000
#define SZ_8M               0x00800000
#define SZ_16M              0x01000000
#define SZ_32M              0x02000000
#define SZ_64M              0x04000000
#define SZ_128M             0x08000000
#define SZ_256M             0x10000000
#define SZ_512M             0x20000000
#define SZ_1G               0x40000000
#define SZ_2G               0x80000000

#define REMAP_BIT						0x00000001
#define	SAR_ENABLE					0x00000002
#define DRAM_BASE_ADDR			0x0
#define	SDRAM_LOADER_ADDR		DRAM_BASE_ADDR
#define FLASH_BASE_ADDR			0x21000000			// EBI Bank 1
#define EEPROM_BASE_ADDR		0x20000000			// EBI Bank 0

/*
* Flash/Sdram Size Definitions
*/
#define FLASH_SIZE					SZ_4M						// FLASH SIZE
#define DRAM_SIZE						SZ_16M					// SDRAM SIZE

/*
* Size of Flash Partition
* 0x21000000 ~ 0x21010000			: Boot Loader
* 0x21010000 ~ 0x210D0000			: Kernel
* 0x210D0000 ~ 0x213F0000			: Ramdisk
* 0x213F0000 ~ 0x21400000			: SIB
*/
#define LOADER_MAX_SIZE				SZ_64K
#define KERNEL_MAX_SIZE				(SZ_512K+SZ_256K)
#define RAMDISK_MAX_SIZE			(SZ_2M+SZ_1M+SZ_128K)
//#define RAMDISK_MAX_SIZE			0x16FFFF	
#define SIB_MAX_SIZE					SZ_64K

/*
* Address of Flash Partition
* LOADER_SRAM_BASE : 0x21000000
* KERNEL_SRAM_BASE : 0x21010000
* RAMDISK_SRAM_BASE : 0x210D0000
* CELLO_SIB_BASE : 0x213F0000
*/
#define LOADER_SRAM_BASE		(FLASH_BASE_ADDR)
#define KERNEL_SRAM_BASE		(LOADER_SRAM_BASE + LOADER_MAX_SIZE)
#define RAMDISK_SRAM_BASE		(KERNEL_SRAM_BASE + KERNEL_MAX_SIZE)
#define CELLO_SIB_BASE			(RAMDISK_SRAM_BASE + RAMDISK_MAX_SIZE)

/*
* Address Of DRAM Partition
* LOADER_DRAM_BASE : 0x00010000
* KERNEL_DRAM_BASE : 0x00020000
* RAMDISK_DRAM_BASE : 0x000E0000
* STACK_POINT : (0x81000000-4)
*/
#define	LOADER_DRAM_BASE		SZ_64K
#define KERNEL_DRAM_BASE		(LOADER_DRAM_BASE + LOADER_MAX_SIZE)
#define KERNEL_DRAM_BASE_TFTP		KERNEL_DRAM_BASE+KERNEL_MAX_SIZE
#define RAMDISK_DRAM_BASE		(KERNEL_DRAM_BASE + KERNEL_MAX_SIZE)
#define	SIB_DRAM_BASE				(RAMDISK_DRAM_BASE + RAMDISK_MAX_SIZE)
#define STACK_POINT					((DRAM_BASE_ADDR+DRAM_SIZE-4)|0x80000000)

/*
* SIB base address definition
*/
#define SIB_BADDR     (FLASH_BASE_ADDR+FLASH_SIZE-SIB_MAX_SIZE)

#define DELAY_BEFORE_BOOT		3						// delay before boot procedure

/*
* General Bit Field Definitions
*/
#define	BIT_31				0x80000000
#define	BIT_30				0x40000000
#define	BIT_29				0x20000000
#define	BIT_28				0x10000000
#define	BIT_27				0x08000000
#define	BIT_26				0x04000000
#define	BIT_25				0x02000000
#define	BIT_24				0x01000000
#define	BIT_23				0x00800000
#define	BIT_22				0x00400000
#define	BIT_21				0x00200000
#define	BIT_20				0x00100000
#define	BIT_19				0x00080000
#define	BIT_18				0x00040000
#define	BIT_17				0x00020000
#define	BIT_16				0x00010000
#define	BIT_15				0x00008000
#define	BIT_14				0x00004000
#define	BIT_13				0x00002000
#define	BIT_12				0x00001000
#define	BIT_11				0x00000800
#define	BIT_10				0x00000400
#define	BIT_9					0x00000200
#define	BIT_8					0x00000100
#define	BIT_7					0x00000080
#define	BIT_6					0x00000040
#define	BIT_5					0x00000020
#define	BIT_4					0x00000010
#define	BIT_3					0x00000008
#define	BIT_2					0x00000004
#define	BIT_1					0x00000002
#define	BIT_0					0x00000001

/*
* GPIO Assignment
*/

#define	BIT_SYSTEM_LED	         	BIT_15
#define	BIT_ETH_RST_L			BIT_30

#ifdef BOARD_A3
	#define GPIO_ENABLE 0x40078EF0
	
	#define BIT_PASSPORT_RST_L              BIT_11
	#define BIT_PASSPORT_INTA               BIT_9
	#define BIT_PASSPORT_INTB               BIT_27
	#define BIT_PASSPORT_INTC               BIT_25
	#define BIT_PASSPORT_INTD               BIT_10
	#define BIT_LEDXDSL_LINK                BIT_8
	#define BIT_LEDXDSL_ACT                 BIT_28

#else /* original V1,V2 */
	#define GPIO_ENABLE 0x40FF80F0
	
	#define BIT_PASSPORT_RST_L              BIT_16
	#define BIT_PASSPORT_INTA               BIT_18
	#define BIT_PASSPORT_INTB               BIT_19
	#define BIT_PASSPORT_INTC               BIT_20
	#define BIT_PASSPORT_INTD               BIT_21
	#define BIT_LEDXDSL_LINK                BIT_22
	#define BIT_LEDXDSL_ACT                 BIT_23
#endif

/*
* Operating Frequency Definitions
*/
#define	CLK_80M				80000000
#define	CLK_100M			100000000
#define	CLK_125M			125000000
#define	CLK_130M			130000000
#define	CLK_150M			150000000
#define DEFAULT_CLK		CLK_130M		// CLOCK CONFIGURATION

/*
* External Clock Definitions
*/
#define	EXTERNAL_CLOCK	25000000	// 25MHz External Clock for RTC

#define	MAX_ETH_PORT		4
#define	MAX_SAR_SAP			16

#endif	// of __C133_LOADER_BSP__
/* EOF */


