/*
 * queue.h
 *
 *  Created on: 02-04-2014
 *      Author: Szymon Janek
 */

#ifndef QUEUE_H_INCLUDED
#define QUEUE_H_INCLUDED 1

#include <inttypes.h>
#include <string.h>

typedef struct Queue_T* Queue_T;

Queue_T queue_new(void* (*malloc)(size_t size), void (*free)(void*), uint16_t item_size, uint16_t queue_capacity);
void queue_delete(Queue_T queue, void (*free)(void*));
uint8_t queue_write(Queue_T queue, const void* data);
uint8_t queue_read(Queue_T queue, void* data);
uint16_t queue_size(Queue_T queue);
uint16_t queue_capacity(Queue_T queue);
void queue_clean(Queue_T queue);

#endif /* QUEUE_H_ */
