//
//  NHClientTypes.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 * Enum indicating current Internet-Booster device status
 */
typedef NS_ENUM(NSInteger, NHBoosterStatus)
{
    /** Could not retrieve status */
    NHBoosterStatusError,
    
    /** Device not physically installed */
    NHBoosterStatusNotInstalled,
    
    /** Device is installed, user subscription is not configured for use of Internet-Booster */
    NHBoosterStatusNotSupported,

    /** Device is installed, something is not working on the server side */
    NHBoosterStatusServiceUnavailable,
    
    /** Device is installed and working properly */
    NHBoosterStatusWorking
};

NS_ASSUME_NONNULL_END
