//
//  NHClientListener.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 * Enum indicating internal errors that can occur in the HomeNGTI framework
 */
typedef NS_ENUM(NSInteger, NHFrameworkErrorType)
{
    /** General error */
    NHFrameworkErrorTypeGeneral,
    
    /** Connection to gateway was lost */
    NHFrameworkErrorTypeConnectionError,
    
    /** API failed on gateway */
    NHFrameworkErrorTypeAPIError
};

/**
 * Protocol for processing events from the HomeNGTI framework
 */
@protocol NHClientListener

/**
 * Framework finished succesfully.
 * NOTE: It is up to the calling application to return to the desired UI location/viewcontroller inside your app.
 */
- (void)frameworkFinished;

/**
 * An internal error occurred in the framework
 * NOTE: It is up to the calling application to return to the desired UI location/viewcontroller inside your app.
 * @param error Indication of error type
 */
- (void)frameworkErrorOccurred:(NHFrameworkErrorType)error;

/**
 * Framework wants to report an analytics state. Forward this to your analytics code.
 * @param states State to report
 * @param ... Further state(s) to report
 */
- (void)reportAnalyticsState:(NSString *)states, ...;

/**
 * Framework wants to report an analytics action. Forward this to your analytics code.
 * @param actions Action to report
 * @param ... Further action(s) to report
 */
- (void)reportAnalyticsAction:(NSString *)actions, ...;

@end

NS_ASSUME_NONNULL_END
