//
//  NHClientDelegate.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/** Remote connectivity state */
typedef NS_ENUM(NSUInteger, NHRemoteConnectivityState)
{
    /** No connection to Internet-Box, default */
    NHRemoteConnectivityStateNoConnection,
    
    /** Directly connected to Internet-Box WLAN */
    NHRemoteConnectivityStateLocal,
    
    /** Local connection to the different Internet-Box */
    NHRemoteConnectivityStateLocalDifferentInternetBox,
    
    /** Not directly connected to Internet-Box WLAN (e.g. remote access or VPN) */
    NHRemoteConnectivityStateRemote,
};

/** Completion block for checkConnectivityWithCompletion */
typedef void(^NHCheckConnectivityCompletionBlock)(NHRemoteConnectivityState state);

/**
 * Protocol for executing requests from the HomeNGTI framework
 */
@protocol NHClientDelegate

/**
 * Requests image from HomeApp for specified device type (should be black)
 * @param deviceType Device type ("DeviceType" key in topology)
 * @return UIImage* if an image is avalailable, otherwise 'nil'
 */
- (nullable UIImage *)iconForDeviceType:(NSString *)deviceType;

/**
 * Check remote connectivity state
 * @param completion Completion block that will be called on the main thread when the operation finishes
 */
- (void)checkConnectivityWithCompletion:(NHCheckConnectivityCompletionBlock)completion;

@end

NS_ASSUME_NONNULL_END

