//
//  NHWLANBoxInfo.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

#import "NHClientTypes.h"

NS_ASSUME_NONNULL_BEGIN

/**
 * Information about WLAN-Box
 */
@interface NHWLANBoxInfo : NSObject

/**
 * Name of a WLAN-Box
 */
@property (nonatomic, readonly, copy) NSString *name;

/**
 * WLAN-Box link quality to the parent node. Can be `Good` or `Poor`.
 */
@property (nonatomic, readonly) NHWLANBoxLinkQuality linkQuality;


/**
 * Unavailable initializers
 */
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

@end

NS_ASSUME_NONNULL_END
