//
//  NHClientDelegate.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 * Protocol for executing requests from the HomeNGTI framework
 */
@protocol NHClientDelegate

/**
 * Requests image from HomeApp for specified device type (should be black)
 * @param deviceType Device type ("DeviceType" key in topology)
 * @return UIImage* if an image is avalailable, otherwise 'nil'
 */
- (nullable UIImage *)iconForDeviceType:(NSString *)deviceType;

/**
 * Request proxy port number from HomeApp for remote access
 * @return If > 0, remote access is available and value indicates port number.
 *         If 0, remote access is in the process of connecting (suggestion is to wait for notification center event)
 *         If < 0, an error occurred
 *
 * @note Connectivity state changes are signalled from HomeApp to NHClient::remoteAccessStateChanged.
 *       When this method is called, getRemoteTunnelPort will be queried for current status.
 */
- (NSInteger)getRemoteTunnelPort;

@end

NS_ASSUME_NONNULL_END

