//
//  NHClientLogger.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Protocol for logging output from HomeNGTI framework
 */
@protocol NHClientLogger

/**
 * Log the selected message on 'verbose' log level
 * @param message Log message contents
 */
- (void)nh_logVerbose:(NSString *)message;

/**
 * Log the selected message on 'debug' log level
 * @param message Log message contents
 */
- (void)nh_logDebug:(NSString *)message;

/**
 * Log the selected message on 'info' log level
 * @param message Log message contents
 */
- (void)nh_logInfo:(NSString *)message;

/**
 * Log the selected message on 'error' log level
 * @param message Log message contents
 */
- (void)nh_logError:(NSString *)message;

@end

NS_ASSUME_NONNULL_END

