//
//  NHClientTypes.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

/**
 * Enum indicating current Internet-Booster device status
 */
typedef NS_ENUM(NSInteger, NHBoosterStatus)
{
    /** Could not retrieve status */
    NHBoosterStatusError,

    /** Not provisioned, IB not connected*/
    NHBoosterStatusNotProvisioned,
    
    /** Not provisioned, IB connected */
    NHBoosterStatusNotSupported,
    
    /** Provisioned, IB not connected */
    NHBoosterStatusProvisioned,
    
    /** Provisioned, IB was connected previously but is now offline */
    NHBoosterStatusOffline,
    
    /** Provisioned, IB connected, service unavailable */
    NHBoosterStatusServiceUnavailable,
    
    /** Provisioned, IB connected, service working, cellular connection down */
    NHBoosterStatusNoCellularSignal,

    /** Provisioned, IB connected, service working, cellular connection up, weak connection */
    NHBoosterStatusWeakConnection,

    /** Provisioned, IB connected, service working, cellular connection up, good connection */
    NHBoosterStatusGoodConnection
};

/**
 * Enum indicating WLAN-Box link quality to a parent node (could be another WLAN-Box or Internet-Box)
 */
typedef NS_ENUM(NSUInteger, NHWLANBoxLinkQuality)
{
    /** WLAN-Box connected via ethernet or WLAN signal is strong */
    NHWLANBoxLinkQualityGood,
    
    /** WLAN signal is weak */
    NHWLANBoxLinkQualityPoor
};

/**
 * Enum indicating Internet-Box gateway type
 */
typedef NS_ENUM(NSUInteger, NHGatewayType)
{
    /** Internet-Box 2 */
    NHGatewayTypeInternetBox2,
    
    /** Internet-Box Plus */
    NHGatewayTypeInternetBoxPlus,

    /** Internet-Box Standard */
    NHGatewayTypeInternetBoxStandard,

    /** Internet-Box Light */
    NHGatewayTypeInternetBoxLight
};
