//
//  NHClientListener.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 * Protocol for processing events from the HomeNGTI framework
 */
@protocol NHClientListener

/**
 * Framework wants to report an analytics state. Forward this to your analytics code.
 * @param states State to report
 * @param ... Further state(s) to report
 */
- (void)reportAnalyticsState:(NSString *)states, ...;

/**
 * Framework wants to report an analytics action. Forward this to your analytics code.
 * @param actions Action to report
 * @param ... Further action(s) to report
 */
- (void)reportAnalyticsAction:(NSString *)actions, ...;

@end

NS_ASSUME_NONNULL_END
