//
//  NHClientDelegate.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

/**
 * Protocol for executing requests from the HomeNGTI framework
 */
@protocol NHClientDelegate

/**
 * Requests image from HomeApp for specified device type and active status
 * @param deviceType Device type ("DeviceType" key in topology)
 * @param active Device active status ("Active" key in topology)
 * @return UIImage* if an image is avalailable, otherwise 'nil'
 */
- (nullable UIImage *)iconForDeviceType:(NSString *)deviceType active:(BOOL)active;

@end

NS_ASSUME_NONNULL_END

