//
//  NHClientTypes.h
//  HomeNGTI
//
//  Copyright © 2017 Swisscom. All rights reserved.
//

/**
 * Enum indicating current Internet-Booster device status
 */
typedef NS_ENUM(NSInteger, NHBoosterStatus)
{
    /** Could not retrieve status */
    NHBoosterStatusError,
    
    /** Device not physically installed */
    NHBoosterStatusNotInstalled,
    
    /** Device is installed, user subscription is not configured for use of Internet-Booster */
    NHBoosterStatusNotSupported,

    /** Device is installed, something is not working on the server side */
    NHBoosterStatusServiceUnavailable,
    
    /** Device is installed and working properly */
    NHBoosterStatusWorking
};

/**
 * Enum indicating WLAN-Box link quality to a parent node (could be another WLAN-Box or Internet-Box)
 */
typedef NS_ENUM(NSUInteger, NHWLANBoxLinkQuality)
{
    /** WLAN-Box connected via ethernet or WLAN signal is strong */
    NHWLANBoxLinkQualityGood,
    
    /** WLAN signal is weak */
    NHWLANBoxLinkQualityPoor
};
