#ifndef COMMCLIENTWRAPPERS_H_
#define COMMCLIENTWRAPPERS_H_

#define COMM_DLNA_PATH "dlna.path"
#define COMM_USER_AGENT "user-agent"
#define COMM_CA_CERTIFICATE "cacertificate"
#define COMM_SKIP_CERTIFICATE_CHECK "skipsslcertcheck"
#define COMM_INET_PROPERTY  "inet-connection"
#define COMM_INET_WIFI_NAME "WIFI"
#define COMM_INET_GSM_NAME  "GSM"
#define COMM_INET_LTE_NAME  "GSM 4G"
#define COMM_INET_3G_NAME   "GSM 3G"
#define COMM_INET_NONE_NAME "NONE"

#ifdef __cplusplus
extern "C" {
#endif

enum ConfigurationStatus {
	CSSuccess,
	CSSessionError,
	CSParseError,
	CSInternetChanged,
	CSFlushedOnStop,
	CSCancelOnSessionChange,
	CSUnexpectedError
};

void commSetCACertificatePath(const char* path); // deprecated, use commSetProperty(COMM_CA_CERTIFICATE, path)
void commSetUserAgent(const char* ua); // deprecated, use commSetProperty(COMM_USER_AGENT, ua)
void commSetDLNAControlPath(const char* path); // deprecated, use commSetProperty(COMM_DLNA_PATH, path)
void commSetProperty(const char* key, const char* value);
char* commGetProperty(const char* key); // free after use
void commGlobalEnvStart(void);
void commGlobalEnvStop(void);

typedef void (*comm_log_function_type)(int level, const char* logger, const char* message, void* context); // same type as in log4cplus/platformloggerext.h
void commSetLogFunction(comm_log_function_type fn, void* context);
void commSetLogConfiguration(const char* conf);

int commClientAssertsActive(void);

#ifdef __cplusplus
}
#endif

#endif /* COMMCLIENTWRAPPERS_H_ */
