//
//  RemoteNASAPI.m
//  RemoteNASClient
//
//  Created by CapSel on 23/02/2018.
//  Copyright © 2018 Kacper Kopczyński. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "remoteNASWrappers.h"

@interface RemoteNASAPI : NSObject

typedef void (^discoverCompletionBlock)(BOOL success, NSString* ip_ap, NSString* ip_np);

+ (void) discover:(discoverCompletionBlock) completionBlock;
+ (void) discoverTryDomain:(NSString*) domain
		   completionBlock:(discoverCompletionBlock) completionBlock;

typedef void (^pairCompletionBlock)(enum PairStargateStatus status, NSString* haid);

+ (void) pairWithIP:(NSString*) ip
		   username:(NSString*) username
		   password:(NSString*) password
	completionBlock:(pairCompletionBlock) completionBlock;

@end
