#ifndef HomeMonitor_HomeMonitorClientCBinding_h
#define HomeMonitor_HomeMonitorClientCBinding_h

#ifndef WIN32
#include <unistd.h>
#endif
#include <stdint.h>

#include "commClientWrappers.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef uint32_t LanDevice_id_type_encoded_id_type;

typedef void (*ConfigurationReadyCallback)(void* arg, const ConfigurationStatus);
typedef void (*TunnelStatusChangeCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, int status);
typedef void (*ErrorCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, const char* message);
typedef void (*HWH264RendererCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, const char*, size_t len);

struct event_base;

// this is the "opaque handle"
struct _hmv;
typedef struct _hmv hmv_t;

void hmv_set_base_path(const char* base_path);

hmv_t* hmv_init(void* arg, const char* sessionId);
hmv_t* hmv_init_empty(void* arg);
void hmv_reinit(hmv_t* hmv, const char* sesionId);
void hmv_stop(hmv_t* hmv);
void hmv_destroy(hmv_t* hmv);

void hmv_set_tunnel_status_change_callback(hmv_t* hmv, TunnelStatusChangeCallback callback);
void hmv_set_configuration_ready_callback(hmv_t* hmv, ConfigurationReadyCallback callback);
void hmv_set_error_callback(hmv_t* hmv, ErrorCallback callback);
void hmv_set_renderer_callback(hmv_t* hmv, HWH264RendererCallback callback);

LanDevice_id_type_encoded_id_type hmv_add_proxy_device(hmv_t* hmv, const char* url);
void hmv_remove_proxy_device(hmv_t* hmv, LanDevice_id_type_encoded_id_type device_id);
	
void hmv_set_global_mute_for_cameras(int mute);
void hmv_start_video(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, int lowResolution);
int hmv_start_video_from_path(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, const char* path);
void hmv_stop_video(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
void hmv_send_command(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, const char* command);
void hmv_reconfigure(hmv_t* hmv, const char* sessionId);
void hmv_refresh_devices(hmv_t* hmv);
size_t hmv_get_total_data_usage(hmv_t* hmv);
int hmv_two_way_audio_start(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_two_way_audio_stop(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_mute(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_unmute(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
void hmv_mute_all(hmv_t* hmv);
void hmv_unmute_all(hmv_t* hmv);

struct event_base* hmv_get_event_base(hmv_t* hmv);

#ifdef __cplusplus
}
#endif

#endif
