/*
 *  remoteNASWrappers.h
 *  RemoteNASVirtualDriveForMacOSX
 *
 *  Created by Tomek on 8/03/12.
 *  Copyright 2012 Smart-apps. All rights reserved.
 *
 */

#ifndef _REMOTENAS_WRAPPERS_H
#define _REMOTENAS_WRAPPERS_H

#include <stdint.h>

#include "PairStargateStatus.h"
#include "commClientWrappers.h"

#ifdef __cplusplus 
extern "C" { 
#endif 

typedef uint32_t LanDevice_id_type_encoded_id_type;

struct LanDeviceStruct {
	LanDevice_id_type_encoded_id_type lanDeviceId;
	char* deviceClass;
	char* name;
	unsigned short port;
	int shared;
	char* ownerEmail;
	int local;
};

/** Same values as in RemoteNASClient::LoginStatus. */
enum LoginStatus {
	LoginSuccess = 0,
	LoginFailure = 1,
	LoginError = 2,
	LoginErrorNoConf = 3,
	LoginErrorUnexpected = 4,
	LoginExcessiveAttempts = 5,
	LoginPasswordExpired = 6,
	LoginInterruptedInternetChange = 7
};

enum RegisterStatus {
	RegisterSuccess = 0,
	RegisterFailure = 1, // generic
	RegisterError = 2,
	RegisterFailureUsernameInvalid = 3,
	RegisterFailureUsernameTaken = 4,
	RegisterFailureEmailInvalid = 5,
	RegisterFailureEmailTaken = 6,
	RegisterFailurePasswordInvalid = 7,
	RegisterFailureFirstNameInvalid = 8,
	RegisterFailureLastNameInvalid = 9,
	RegisterErrorUnexpected = 10
};

enum LanDeviceActivationStatus {
	LDASSuccess = 0,
	LDASAlreadyActivated = 1,
	LDASNotConnected = 2,
	LDASIncorrectCode = 3,
	LDASError = 4,
	LDASManual = 5,
	LDASNotSupported = 6,
	LDASAnotherAccountAssigned = 7,
	LDASReachedMaxDeviceCount = 8,
	LDASNoAnswer = 9,
	LDASNoAccess = 10,
	LDASActivationOutsideLocalNetwork = 11,
	LDASUnexpectedError = 12,
	LDASInterruptedInternetChange = 13
};

enum LanDeviceActivationDialogVisibility {
	LDADHidden = 0, // do not ever show dialog, returned on error also
	LDADVisibleAtRegistration = 1, // show only when performing user registration, don't show in menu
	LDADVisible = 2  // show whenever user requests it
};

enum GatewayClientRemoveStatus {
	GCRSOK = 0,
	GCRSFailed = 1,
	GCRSError = 2,
	GCRSUnexpectedError = 3
};

enum LanDeviceUnshareStatus {
	LDUSSuccess = 0,
	LDUSDeviceIdUndefined = 1,
	LDUSEmailUndefined = 2,
	LDUSDeviceNotFound = 3,
	LDUSDeviceNotShared = 4,
	LDUSEmailProblem = 5,
	LDUSError = 6,
	LDUSUnexpectedError = 7
};

enum TunnelType {
	TunnelLocal,
	TunnelForward,
	TunnelICE,
	TunnelRelay,
	TunnelNone
};

typedef void (* rnasLoginCallback)(enum LoginStatus status, const char* rememberMe);
typedef void (* rnasActiveCallback)(int status, struct LanDeviceStruct* ld);
typedef void (* rnasTunnelUpgradeCallback)(struct LanDeviceStruct* ld);
typedef void (* rnasRegisterCallback)(enum RegisterStatus, const char* username);
typedef void (* rnasResetPasswordCallback)(int status, const char* message);
typedef void (* rnasChangePasswordCallback)(int status, const char* message);
typedef void (* rnasChangeExpiredPasswordCallback)(int status);
typedef void (* rnasVerifyPasswordCallback)(int status, const char* message);
typedef void (* rnasRemoveUserCallback)(int status, const char* message);
typedef void (* rnasLanDeviceActivationCallback)(enum LanDeviceActivationStatus);
typedef void (* rnasParameterValueCallback)(int status, const char* value);
typedef void (* rnasGatewayClientRemoveCallback)(enum GatewayClientRemoveStatus);
typedef void (* rnasConfigurationReadyCallback)(enum ConfigurationStatus status);
typedef void (* rnasUnshareLanDeviceCallback)(enum LanDeviceUnshareStatus);
typedef void (* rnasLocalDeviceAvailableCallback)(); // true/false
typedef void (* rnasPairStargateCallback)(void* ptr, enum PairStargateStatus status, const char* ha_id);
typedef void (* rnasDiscoverStargateCallback)(void* ptr, int status, const char* ip_ap, const char* ip_np);
typedef void (* rnasMoveFolderCallback)(int status);

void rnasSetCacheBasePath(const char* path, const char* databasePath);
void rnasSetTransportType(const char* transportType);
void rnasSetBasePath(const char* base_path);

void rnasPreInit();
void rnasInit(const char* sessionId);
void rnasLogin(const char* username, const char* password, int rememberMe, rnasLoginCallback callback); // TODO it currently does init also...
char* rnasGetSessionId();
void rnasLoginWithRememberMeCookie(const char* rememberMeCookie, rnasLoginCallback callback);
void rnasResetPassword(const char* email, rnasResetPasswordCallback callback);
void rnasChangePassword(const char* newPassword, const char* oldPassword, rnasResetPasswordCallback callback);
void rnasChangeExpiredPassword(const char* username, const char* password, const char* oldPassword, rnasChangeExpiredPasswordCallback callback);
void rnasVerifyPassword(const char* password, rnasVerifyPasswordCallback callback);
void rnasRemoveUser(rnasRemoveUserCallback);
void rnasRegister(const char* firstName, const char* lastName, const char* email, const char* password, rnasRegisterCallback callback);
void rnasActivateLanDevice(const char* code, rnasLanDeviceActivationCallback); // user is already logged in
void rnasShowActivationCode();
void rnasRemoveGatewayClientForLanDevice(unsigned int lanDeviceId, rnasGatewayClientRemoveCallback);
void rnasSetConfigurationReadyCallback(rnasConfigurationReadyCallback);
void rnasCleanup();
#ifdef WIN32
void rnasDoNotMount();
#endif
void rnasStop();
void rnasLanDeviceSetActive(LanDevice_id_type_encoded_id_type lanDeviceId, int status);
void rnasSetActiveCallback(rnasActiveCallback callback);
void rnasSetTunnelUpgradeCallback(rnasTunnelUpgradeCallback callback);
int rnasLanDeviceGetActive(LanDevice_id_type_encoded_id_type lanDeviceId);
int rnasLanDeviceGetConnected(LanDevice_id_type_encoded_id_type lanDeviceId);
size_t rnasLanDeviceCount();
struct LanDeviceStruct* rnasLanDeviceGetAt(size_t idx);
struct LanDeviceStruct* rnasLanDeviceGetWithId(LanDevice_id_type_encoded_id_type ldId);
void rnasLanDeviceFree(struct LanDeviceStruct* virtualDrive);
void rnasSetCacheMaxDiskSpace(long long int bytes);
long long int rnasGetCacheMaxDiskSpace();
long long int rnasGetCacheDiskSpace();
void rnasSetCacheAsyncWriteMemLimit(long long bytes);
long long rnasGetCacheAsyncWriteMemLimit();
void rnasUnshareLanDevice(LanDevice_id_type_encoded_id_type lanDeviceId, const char* email, rnasUnshareLanDeviceCallback callback);
void rnasRetryConfigurationInit();
void rnasSetLocalDeviceAvailableCallback(rnasLocalDeviceAvailableCallback);
void rnasDiscoverStargate(const char* gcDomain, rnasDiscoverStargateCallback callback, void* ptr);
void rnasPairStargate(const char* ipAddress, const char* username, const char* password, rnasPairStargateCallback callback, void* ptr);
char* rnasGetVersion(LanDevice_id_type_encoded_id_type deviceId);

/** from and to are UTF8 encoded */
void rnasMoveFolder(LanDevice_id_type_encoded_id_type lanDeviceId, const char* from, const char* to, rnasMoveFolderCallback);

/** Triggers request for value from parameter table.
 */
void rnasRequestParameterValue(const char* name, rnasParameterValueCallback callback);
enum LanDeviceActivationDialogVisibility rnasActivationDialogVisibilityParse(const char* value);

char* rnasLanDeviceGetDirectUrlForPath(LanDevice_id_type_encoded_id_type lanDeviceId, const char* path, const char* query);

enum TunnelType rnasGetTunnelTypeForDevice(LanDevice_id_type_encoded_id_type lanDeviceId);
int rnasGetUploadBlockSize(LanDevice_id_type_encoded_id_type deviceId);
int rnasSupportSortingByDate(LanDevice_id_type_encoded_id_type deviceId);

char* rnasGetMacForDeviceId(LanDevice_id_type_encoded_id_type deviceId);

#ifdef WITH_VIRTUAL_DRIVE
struct VirtualDriveStruct {
	LanDevice_id_type_encoded_id_type lanDeviceId;
	char* diskId;
	char* diskLabel;
#ifdef WIN32
	char* driveLetter;
#endif
};
int rnasVirtualDriveCount(LanDevice_id_type_encoded_id_type lanDeviceId);
struct VirtualDriveStruct* rnasVirtualDriveGetAt(LanDevice_id_type_encoded_id_type lanDeviceId, size_t idx);
void rnasVirtualDriveFree(struct VirtualDriveStruct* virtualDrive);
void rnasVirtualDriveSetActive(LanDevice_id_type_encoded_id_type lanDeviceId, size_t idx, int status);
int rnasVirtualDriveGetActive(LanDevice_id_type_encoded_id_type lanDeviceId, size_t idx);
#endif

#ifdef  __cplusplus 
} 
#endif

#endif
