//
//  HomeMonitorClientCBinding.h
//  HomeMonitor
//
//  Created by Mateusz Slupny on 12-11-02.
//  Copyright (c) 2012 Smart-apps. All rights reserved.
//

#ifndef HomeMonitor_HomeMonitorClientCBinding_h
#define HomeMonitor_HomeMonitorClientCBinding_h

#ifndef WIN32
#include <unistd.h>
#endif
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int IHardwareH264Renderer_id_type;
typedef uint32_t LanDevice_id_type_encoded_id_type;

typedef void (*TunnelStatusChangeCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, int status);
typedef void (*NextVideoFrameCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, const char* buffer, size_t length);
typedef void (*SendCommandResultCallback)(void* arg, const char* correlator, int result);
typedef void (*ErrorCallback)(void* arg, LanDevice_id_type_encoded_id_type deviceId, const char* message);
typedef void (*HWH264RendererCallback)(void* arg, IHardwareH264Renderer_id_type rendererId, char*, int len);
typedef void (*HWH264RendererClosedCallback)(void* arg, IHardwareH264Renderer_id_type rendererId, char*, int len);

struct event_base;

// TODO this is the "opaque handle" - place unique_ptr here for hmv
typedef struct _hmv {
	void* arg;
	void* hmv;
	TunnelStatusChangeCallback tunnelStatusChangeCallback;
	NextVideoFrameCallback nextVideoFrameCallback;
	SendCommandResultCallback sendCommandResultCallback;
	ErrorCallback errorCallback;
	HWH264RendererCallback hwH264RendererCallback;
	HWH264RendererClosedCallback h2H264RendererClosedCallback;
} hmv_t;

void hmv_stop(hmv_t* hmv);

void hmv_set_base_path(const char* base_path);
hmv_t* hmv_init(void* arg, const char* sessionId);
hmv_t* hmv_init_empty(void* arg);
void hmv_reinit(hmv_t* hmv, const char* sesionId);
void hmv_destroy(hmv_t* hmv);

LanDevice_id_type_encoded_id_type hmv_add_proxy_device(hmv_t* hmv, const char* url);
void hmv_remove_proxy_device(hmv_t* hmv, LanDevice_id_type_encoded_id_type device_id);
	
void hmv_set_global_mute_for_cameras(int mute);
void hmv_start_video(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, int lowResolution);
int hmv_start_video_from_path(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, const char* path);
void hmv_stop_video(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
void hmv_send_command(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId, const char* command);
void hmv_reconfigure(hmv_t* hmv, const char* sessionId);
size_t hmv_get_total_data_usage(hmv_t* hmv);
int hmv_two_way_audio_start(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_two_way_audio_stop(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_mute(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
int hmv_unmute(hmv_t* hmv, LanDevice_id_type_encoded_id_type deviceId);
void hmv_mute_all(hmv_t* hmv);
void hmv_unmute_all(hmv_t* hmv);
struct event_base* hmv_get_event_base(hmv_t* hmv);

IHardwareH264Renderer_id_type hmv_request_hwh264_renderer(hmv_t* hmv, LanDevice_id_type_encoded_id_type lanDeviceId);
int hmv_stop_hwh264_renderer(hmv_t* hmv, IHardwareH264Renderer_id_type renderer_id);
int hmv_init_hwh264(hmv_t* hmv, IHardwareH264Renderer_id_type renderer_id, int width, int height, int cropImage);

#ifdef __cplusplus
}
#endif

#endif
