// HIDtoUARTExampleDlg.h : header file
//

#pragma once
#include "HIDDevice.h"
#include "afxwin.h"
#include <vector>
#include "afxcmn.h"

typedef struct Report{
	unsigned char ReportByte[64];
}Report;

// CHIDtoUARTExampleDlg dialog
class CHIDtoUARTExampleDlg : public CDialog
{
// Construction
public:
	CHIDtoUARTExampleDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_HIDTOUARTEXAMPLE_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:
	void HIDcallback (BYTE*);
	DWORD HID_InterruptGetReport (BYTE*);
	void CharsReceivedFromDevice(Report);

	bool RXthreadmaycontinue;
private:

	CString InsertCarriageReturns (CString);
	void OnTimer(UINT nIDEvent);
	void RegisterNotification (void);
	void UnregisterNotification(void);
	BOOL OnDeviceChange(UINT, DWORD);
	void AttemptConnection(void);
	void EnableScreen(bool);
	void TransmitToDevice(unsigned char*,DWORD);
	void EnableRadioButtons(bool);
	void ModeCheck(void);
	void EnableTerminalMode(bool);
	void EnableTransferMode(bool);
	void EnableBaudRateEdit(bool);
	void EnableTestPattern(bool);
	void InitProgressBar(DWORD);
	void UpdateProgressBar(DWORD);
	void EnableBytesReceivedTransmitted(bool);
	void EnableBytesReportLogs(bool);
	void EnableProgressBar(bool);
	void ByteToASCII(unsigned char, unsigned char*);

	afx_msg void OnBnClickedConnect();
	afx_msg void OnEnChangeInput();
	afx_msg void OnBnClickedCheck1();
	afx_msg void OnBnClickedTransmitnow();
	afx_msg void OnBnClickedClearoutputtext();
	afx_msg void OnBnClickedClearinputtext();
	afx_msg void OnBnClickedRadioTerminalmode();
	afx_msg void OnBnClickedRadioTransfermode();
	afx_msg void OnBnClickedClearbytestxedbutton();
	afx_msg void OnBnClickedClearbytesrxedbutton();
	afx_msg void OnBnClickedTransferfile();
	afx_msg void OnBnClickedInputfilebutton();
	afx_msg void OnBnClickedClearoutputfilecheck();
	afx_msg void OnBnClickedOutputfilebutton();
	afx_msg void OnBnClickedDownloadreportsbutton();
	afx_msg void OnBnClickedClearreportbufferbutton();
	afx_msg void OnBnClickedDownloadparsedreports();
	afx_msg void OnBnClickedDownloadoutreportsbutton2();
	afx_msg void OnBnClickedDownloadparsedoutreports2();
	afx_msg void OnBnClickedTestpatternbutton();
	afx_msg void OnBnClickedButton1();
	afx_msg void OnBnClickedCheckresultsbutton();
	afx_msg void OnBnClickedGetbaudrate();
	afx_msg void OnBnClickedSetbaudrate();
	afx_msg void OnStnClickedReportlogdescriptionstatic();

	bool UpdateWindow;
	CString local_output_string;
	HDEVNOTIFY m_hNotifyDevNode;
	CHIDDevice HIDtoUARTDevice;
	CString m_InputToDeviceBox;
	CString m_OutputFromDeviceBox;
	CString m_CharactersToTransmit;
	CString m_InputToDeviceBoxOld;
	bool m_IsConnected;
	BOOL m_TransmitRealTime;
	HANDLE HID_RX_THREAD;
	BOOL m_RadioTerminalMode;
	BOOL m_RadioTransferMode;
	DWORD m_BytesTransmitted;
	DWORD m_BytesReceived;
	DWORD m_BytesTransmittedLocal;
	DWORD m_BytesReceivedLocal;
	CString m_BytesReceivedDuringTransfer;
	CString m_TXFileName;
	CString m_RXFileName;
	BOOL m_ClearRXFile;
	std::vector<Report> IN_DATA_Reports;
	std::vector<Report> OUT_DATA_Reports;
	std::vector<Report> m_TransferTextReports;
	
	CProgressCtrl m_ProgressBar;
	DWORD m_ThisStep;
	DWORD m_BytesPerStep;
	DWORD m_BytesPerReport;
	DWORD m_NumReports;
	DWORD m_BaudRate;
	
};