// HIDtoUARTExampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HIDtoUARTExample.h"
#include "HIDtoUARTExampleDlg.h"
#include "dbt.h"
#include "initguid.h"
#include "HIDDevice.h"
#include <vector>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define VID_HIDtoUART 0x10C4
#define PID_HIDtoUART 0x8468

#define IN_REPORT_BUFFER_SIZE 60
#define OUT_REPORT_BUFFER_SIZE 60
#define IN_CONTROL_REPORT_BUFFER_SIZE 8
#define OUT_DATA_SIZE 60
#define OUT_DATA 0x02
#define IN_DATA  0x01
#define IN_DATA_SIZE 60
#define OUT_DATA_OVERHEAD 2
#define OUT_CONTROL 0xFD
#define IN_CONTROL  0xFE

static DWORD WINAPI InterruptThreadProc(LPVOID lpParameter);


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CHIDtoUARTExampleDlg dialog




CHIDtoUARTExampleDlg::CHIDtoUARTExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHIDtoUARTExampleDlg::IDD, pParent)
	, m_InputToDeviceBox(_T(""))
	, m_OutputFromDeviceBox(_T(""))
	, m_TransmitRealTime(FALSE)
	, m_RadioTerminalMode(FALSE)
	, m_RadioTransferMode(FALSE)
	, m_BytesTransmitted(0)
	, m_BytesReceived(0)
	, m_TXFileName(_T(""))
	, m_RXFileName(_T(""))
	, m_ClearRXFile(FALSE)
	, m_BytesPerReport(58)
	, m_NumReports(500)
	, m_BaudRate(2400)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHIDtoUARTExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_INPUT, m_InputToDeviceBox);
	DDX_Text(pDX, IDC_OUTPUT, m_OutputFromDeviceBox);
	DDX_Check(pDX, IDC_TRANSMITNOWCHECK, m_TransmitRealTime);
	DDX_Radio(pDX, IDC_RADIO_TERMINALMODE, m_RadioTerminalMode);
	DDX_Radio(pDX, IDC_RADIO_TRANSFERMODE, m_RadioTransferMode);
	DDX_Text(pDX, IDC_EDIT3, m_BytesTransmitted);
	DDX_Text(pDX, IDC_EDIT4, m_BytesReceived);
	DDX_Text(pDX, IDC_INPUTFILEBOX, m_TXFileName);
	DDX_Text(pDX, IDC_OUTPUTFILEBOX, m_RXFileName);
	DDX_Check(pDX, IDC_CLEAROUTPUTFILECHECK, m_ClearRXFile);
	DDX_Control(pDX, IDC_PROGRESS1, m_ProgressBar);
	DDX_Text(pDX, IDC_EDIT1, m_BytesPerReport);
	DDX_Text(pDX, IDC_EDIT2, m_NumReports);
	DDX_Text(pDX, IDC_BAUDRATEBOX, m_BaudRate);
}

BEGIN_MESSAGE_MAP(CHIDtoUARTExampleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DEVICECHANGE()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CONNECT, &CHIDtoUARTExampleDlg::OnBnClickedConnect)
	ON_EN_CHANGE(IDC_INPUT, &CHIDtoUARTExampleDlg::OnEnChangeInput)
	ON_BN_CLICKED(IDC_TRANSMITNOWCHECK, &CHIDtoUARTExampleDlg::OnBnClickedCheck1)
	ON_BN_CLICKED(IDC_TRANSMITNOW, &CHIDtoUARTExampleDlg::OnBnClickedTransmitnow)
	ON_BN_CLICKED(IDC_CLEAROUTPUTBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedClearoutputtext)
	ON_BN_CLICKED(IDC_CLEARINPUTBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedClearinputtext)
	ON_BN_CLICKED(IDC_RADIO_TERMINALMODE, &CHIDtoUARTExampleDlg::OnBnClickedRadioTerminalmode)
	ON_BN_CLICKED(IDC_RADIO_TRANSFERMODE, &CHIDtoUARTExampleDlg::OnBnClickedRadioTransfermode)
	ON_BN_CLICKED(IDC_CLEARBYTESTXEDBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedClearbytestxedbutton)
	ON_BN_CLICKED(IDC_CLEARBYTESRXEDBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedClearbytesrxedbutton)
	ON_BN_CLICKED(IDC_TRANSFERFILE, &CHIDtoUARTExampleDlg::OnBnClickedTransferfile)
	ON_BN_CLICKED(IDC_INPUTFILEBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedInputfilebutton)
	ON_BN_CLICKED(IDC_OUTPUTFILEBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedOutputfilebutton)
	ON_BN_CLICKED(IDC_CLEAROUTPUTFILECHECK, &CHIDtoUARTExampleDlg::OnBnClickedClearoutputfilecheck)
	ON_BN_CLICKED(IDC_DOWNLOADREPORTSBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedDownloadreportsbutton)
	ON_BN_CLICKED(IDC_CLEARREPORTBUFFERBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedClearreportbufferbutton)
	ON_BN_CLICKED(IDC_DOWNLOADPARSEDREPORTS, &CHIDtoUARTExampleDlg::OnBnClickedDownloadparsedreports)
	ON_BN_CLICKED(IDC_DOWNLOADOUTREPORTSBUTTON2, &CHIDtoUARTExampleDlg::OnBnClickedDownloadoutreportsbutton2)
	ON_BN_CLICKED(IDC_DOWNLOADPARSEDOUTREPORTS2, &CHIDtoUARTExampleDlg::OnBnClickedDownloadparsedoutreports2)
	ON_BN_CLICKED(IDC_TESTPATTERNBUTTOn, &CHIDtoUARTExampleDlg::OnBnClickedTestpatternbutton)
	ON_BN_CLICKED(IDC_CHECKRESULTSBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedCheckresultsbutton)
	ON_BN_CLICKED(IDC_GETBAUDRATEBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedGetbaudrate)
	ON_BN_CLICKED(IDC_SETBAUDRATEBUTTON, &CHIDtoUARTExampleDlg::OnBnClickedSetbaudrate)
END_MESSAGE_MAP()


// CHIDtoUARTExampleDlg message handlers

BOOL CHIDtoUARTExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	RegisterNotification();
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_InputToDeviceBoxOld = _T("");
	m_CharactersToTransmit = _T("");
	m_IsConnected = false;
	EnableScreen(false);

	m_TransmitRealTime = true;
	GetDlgItem(IDC_TRANSMITNOW)->EnableWindow(false);
	UpdateData(false);
	m_BytesTransmittedLocal = 0;
	m_BytesReceivedLocal = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHIDtoUARTExampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CHIDtoUARTExampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHIDtoUARTExampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


//-----------------------------------------------------------------------------
// NOTIFICATION ROUTINES
//-----------------------------------------------------------------------------
//
// These routines enable the dialog box to monitor and respond to USB
// devices being connected to and disconnected from the USB.

//-----------------------------------------------------------------------------
// RegisterNotification
//-----------------------------------------------------------------------------
//
// Routine registers the notification handle so that device
// connect/disconnect information  initiates a call
// to the OnDeviceChange routine.  This allows the system to
// respond to devices being connected or unexpectedly removed
// from the USB.
//
void CHIDtoUARTExampleDlg::RegisterNotification()
{
	// Register device notification
	DEV_BROADCAST_DEVICEINTERFACE devIF = {0};
	GUID		hidGuid;

	GetHidGuid(&hidGuid);

	devIF.dbcc_size = sizeof(devIF);
	devIF.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
	devIF.dbcc_classguid  = hidGuid;

	m_hNotifyDevNode = RegisterDeviceNotification(GetSafeHwnd(),
		&devIF, DEVICE_NOTIFY_WINDOW_HANDLE);
		
}

//-----------------------------------------------------------------------------
// UnregisterNotification
//-----------------------------------------------------------------------------
//
// Routine unregisters the notification handle so that device
// connect/disconnect information no longer initiates a call
// to the OnDeviceChange routine.
//
void CHIDtoUARTExampleDlg::UnregisterNotification()
{
	// Unegister device notification
	if(NULL != m_hNotifyDevNode)
	{
		UnregisterDeviceNotification(m_hNotifyDevNode);
		m_hNotifyDevNode = INVALID_HANDLE_VALUE;
	}
}

//-----------------------------------------------------------------------------
// OnDeviceChange
//-----------------------------------------------------------------------------
//
// Routine is called whenever the dialog box receives notification that
// a device has either been attached to or removed from USB.  This fuction
// requires that the function RegisterNotification has been executed
// to operate properly.
//
BOOL CHIDtoUARTExampleDlg::OnDeviceChange(UINT nEventType, DWORD dwData)
{
	DWORD results;

	switch(nEventType)
	{
		// A device has been inserted and is now available.
		case DBT_DEVICEARRIVAL:		
			AttemptConnection();
			break;

		// A device has been removed from USB.
		case DBT_DEVICEREMOVECOMPLETE:
			// Check for HIDtoUART devices
			results = GetNumHidDevices(VID_HIDtoUART, PID_HIDtoUART);
			if (results == 0)
			{
				// Close device if found
				results = HIDtoUARTDevice.Close();
				// Disable buttons, text boxes, and text on screen
				EnableScreen(false);
				m_IsConnected = false;
				MessageBox(_T("Device disconnected."));

			}
			break;

		default:
			break;
	}

	return TRUE;
}


//-----------------------------------------------------------------------------
// OnBnClickedConnect
//-----------------------------------------------------------------------------
//
// Runs when user presses "Connect".
//
void CHIDtoUARTExampleDlg::OnBnClickedConnect()
{
	AttemptConnection();
}


//-----------------------------------------------------------------------------
// AttemptConnection
//-----------------------------------------------------------------------------
//
// Checks for connected devices, establishes a communications link with
// connected devices.
//
void CHIDtoUARTExampleDlg::AttemptConnection(void)
{
	DWORD results;
	// Check for connected devices
    results = GetNumHidDevices(VID_HIDtoUART, PID_HIDtoUART);
	// Only proceed if 1 device is found
	if (results == 1)
	{
		// Open connection to device
		results = HIDtoUARTDevice.Open(0,VID_HIDtoUART, PID_HIDtoUART);
		// If device connection not established, output failure
		if (results != HID_DEVICE_SUCCESS)
		{
			MessageBox(_T("Error in connecting to device."));
		}
		else
		{
			m_IsConnected = true;
			EnableScreen(true);
			// Create thread that polls for INTERRUPT IN reports
			HID_RX_THREAD = CreateThread (NULL,NULL,
				InterruptThreadProc,this,0,0);
			
			SetTimer (1,100,NULL);	// Create timer to be used to
	                                   // update on-screen information

		}
	}
	else
	{
		MessageBox(_T("No device found."));
	}
}

//-----------------------------------------------------------------------------
// OnEnChangeInput
//-----------------------------------------------------------------------------
//
// Runs every time the user types characters into the "Input to device" box.
// If user has checked the "Transmit immediately" box, the routine collects 
// the character and transmits it to the device.
//
void CHIDtoUARTExampleDlg::OnEnChangeInput()
{
	unsigned char ByteBuffer[4096];
	CString TempString;

	// Copy new text box contents to m_InputToDeviceBox
	UpdateData(true);

	if (m_TransmitRealTime)
	{
		// First determine the string of characters to be transmitted
		if (m_InputToDeviceBox.GetLength() <= m_InputToDeviceBoxOld.GetLength())
		{
			// do nothing
		}
		else
		{	
			// Extract new characters from text box
			TempString = m_InputToDeviceBox.Mid(m_InputToDeviceBoxOld.GetLength());
			// Add characters to CString to be transmitted to device
			m_CharactersToTransmit.Append(TempString);
			// Copy characters to 8-bit buffer
			for (int i = 0; i < TempString.GetLength(); i++)
			{
				ByteBuffer[i] = TempString.GetAt(i);
			}
		}
		// Update string, send buffer to routine that will 
		// transmit to a device
		m_InputToDeviceBoxOld = m_InputToDeviceBox;
		TransmitToDevice(ByteBuffer,TempString.GetLength());
	}
}

//-----------------------------------------------------------------------------
// EnableScreen
//-----------------------------------------------------------------------------
//
// Calls routines that either enable or disable text boxes, buttons,
// and static text on screen.
//
void CHIDtoUARTExampleDlg::EnableScreen(bool select)
{
	EnableRadioButtons(select);
	EnableBytesReceivedTransmitted(select);
	EnableBytesReportLogs(select);
	EnableProgressBar(select);
	EnableBaudRateEdit(select);
	EnableTestPattern(select);
	if (select == false)
	{
		EnableTransferMode(false);
		EnableTerminalMode(false);
	}
}

//-----------------------------------------------------------------------------
// EnableBytesReceivedTransmitted
//-----------------------------------------------------------------------------
//
// Enables/disables text boxes, static text, and buttons that display
// total number of bytes transmitted and received.
//
void CHIDtoUARTExampleDlg::EnableBytesReceivedTransmitted(bool select)
{
	GetDlgItem(IDC_BYTESRECEIVEDBOX)->EnableWindow(select);
	GetDlgItem(IDC_BYTESTRANSMITTEDBOX)->EnableWindow(select);
	GetDlgItem(IDC_BYTESTRANSMITTEDTEXT)->EnableWindow(select);
	GetDlgItem(IDC_BYTESRECEIVEDTEXT)->EnableWindow(select);
	GetDlgItem(IDC_CLEARBYTESRXEDBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_CLEARBYTESTXEDBUTTON)->EnableWindow(select);
	
}

//-----------------------------------------------------------------------------
// EnableBytesReportLogs
//-----------------------------------------------------------------------------
//
// Enables/disables buttons and static text for outputting IN_DATA and 
// OUT_DATA report logs to text files.
//
void CHIDtoUARTExampleDlg::EnableBytesReportLogs(bool select)
{
	GetDlgItem(IDC_DOWNLOADPARSEDREPORTS)->EnableWindow(select);
	GetDlgItem(IDC_DOWNLOADPARSEDREPORTS)->EnableWindow(select);
	GetDlgItem(IDC_DOWNLOADPARSEDOUTREPORTS2)->EnableWindow(select);
	GetDlgItem(IDC_DOWNLOADOUTREPORTSBUTTON2)->EnableWindow(select);
	GetDlgItem(IDC_DOWNLOADREPORTSBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_CLEARREPORTBUFFERBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_REPORTLOGDESCRIPTIONSTATIC)->EnableWindow(select);
	GetDlgItem(IDC_RAWDATASTATIC)->EnableWindow(select);
	GetDlgItem(IDC_PARSEDDATASTATIC)->EnableWindow(select);
}

//-----------------------------------------------------------------------------
// EnableProgressBar
//-----------------------------------------------------------------------------
//
// Enables/disables progress bar displayed on the bottom side of the screen.
//
void CHIDtoUARTExampleDlg::EnableProgressBar(bool select)
{
	GetDlgItem(IDC_PROGRESS1)->EnableWindow(select);	
}


//-----------------------------------------------------------------------------
// EnableTerminalMode
//-----------------------------------------------------------------------------
//
// Enables/disables text boxes, static text, and buttons for the
// input and output windows used in Terminal Mode.
//
void CHIDtoUARTExampleDlg::EnableTerminalMode(bool select)
{
	GetDlgItem(IDC_OUTPUT)->EnableWindow(select);
	GetDlgItem(IDC_INPUT)->EnableWindow(select);
	GetDlgItem(IDC_TRANSMITNOWCHECK)->EnableWindow(select);
	GetDlgItem(IDC_CLEAROUTPUTBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_CLEARINPUTBUTTON)->EnableWindow(select);	
	GetDlgItem(IDC_INPUTTODEVICESTATIC)->EnableWindow(select);	
	GetDlgItem(IDC_OUTPUTFROMDEVICESTATIC)->EnableWindow(select);
	GetDlgItem(IDC_TRANSMITNOW)->EnableWindow(select);
}

//-----------------------------------------------------------------------------
// EnableTransferMode
//-----------------------------------------------------------------------------
//
// Enables/disables text boxes, static text, and buttons for the
// controls to  choose input and output files used in terminal Mode.
//
void CHIDtoUARTExampleDlg::EnableTransferMode(bool select)
{
	GetDlgItem(IDC_OUTPUTFILEBOX)->EnableWindow(select);
	GetDlgItem(IDC_INPUTFILEBOX)->EnableWindow(select);
	GetDlgItem(IDC_OUTPUTFILEBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_INPUTFILEBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_CLEAROUTPUTFILECHECK)->EnableWindow(select);
	GetDlgItem(IDC_TRANSFERFILE)->EnableWindow(select);
	GetDlgItem(IDC_INPUTTODEVICESTATIC2)->EnableWindow(select);
	GetDlgItem(IDC_INPUTTODEVICESTATIC3)->EnableWindow(select);
}

//-----------------------------------------------------------------------------
// EnableTestPattern
//-----------------------------------------------------------------------------
//
// Enables/disables buttons, text boxes, and static text to control
// the test pattern generator.
//
void CHIDtoUARTExampleDlg::EnableTestPattern(bool select)
{
	GetDlgItem(IDC_BYTESPERREPORTBOX)->EnableWindow(select);
	GetDlgItem(IDC_NUMBEROFREPORTSBOX)->EnableWindow(select);
	GetDlgItem(IDC_TESTPATTERNBUTTOn)->EnableWindow(select);
	GetDlgItem(IDC_CHECKRESULTSBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_NUMBEROFREPORTSSTATIC)->EnableWindow(select);
	GetDlgItem(IDC_BYTESPERREPORTSTATIC)->EnableWindow(select);
	GetDlgItem(IDC_TESTNOTESTATIC)->EnableWindow(select);
}

//-----------------------------------------------------------------------------
// EnableBaudRateEdit
//-----------------------------------------------------------------------------
//
// Enables/disables text boxes, static text, and buttons that control
// device baud rate.
//
void CHIDtoUARTExampleDlg::EnableBaudRateEdit(bool select)
{
	GetDlgItem(IDC_GETBAUDRATEBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_SETBAUDRATEBUTTON)->EnableWindow(select);
	GetDlgItem(IDC_BAUDRATEBOX)->EnableWindow(select);
	GetDlgItem(IDC_BAUDRATESTATIC)->EnableWindow(select);
}

//-----------------------------------------------------------------------------
// TransmitToDevice
//-----------------------------------------------------------------------------
//
// Transmits a char buffer using the HID DLL routine.  The routine breaks
// up the buffer into individual reports.
//
void CHIDtoUARTExampleDlg::TransmitToDevice(unsigned char* BytesToTransmit, DWORD length)
{
	// This routine transmits all bytes contained in CString
	// by breaking the bytes up into reports
	unsigned char output_buffer[OUT_REPORT_BUFFER_SIZE+OUT_DATA_OVERHEAD];
	DWORD buffer_size;
	DWORD BytesLeft = length;
	while (BytesLeft > 0)
	{
		// Format one report
		if (BytesLeft > OUT_REPORT_BUFFER_SIZE-OUT_DATA_OVERHEAD)
		{
			buffer_size = OUT_REPORT_BUFFER_SIZE-OUT_DATA_OVERHEAD;
		}
		else
		{
			buffer_size = BytesLeft;
		}

		// Format the report
		output_buffer[0] = OUT_DATA;
		output_buffer[1] = buffer_size;
		// Copy bytes from the buffer into the report.
		for (DWORD index = 0; index < buffer_size; index++)
		{
			output_buffer[index+OUT_DATA_OVERHEAD] = BytesToTransmit[index+(length-BytesLeft)];
		}
		// Transmit buffer
		HIDtoUARTDevice.SetOutputReport_Interrupt(output_buffer,OUT_REPORT_BUFFER_SIZE+1);
		
		// Create Report struct used to copy report just transmitted 
		// into vector of OUT reports
		Report OUT_DATA_Report;
		for (DWORD index = 0; index < OUT_REPORT_BUFFER_SIZE+1;index++)
		{
			OUT_DATA_Report.ReportByte[index] = output_buffer[index];
		}
		// Push report onto vector
		OUT_DATA_Reports.push_back(OUT_DATA_Report);
		
		// Decrement buffer size
		m_BytesTransmittedLocal += buffer_size;
		BytesLeft-=buffer_size;
		UpdateWindow = TRUE;
	}
}

//-----------------------------------------------------------------------------
// CharsReceivedFromDevice
//-----------------------------------------------------------------------------
//
// Copies bytes from report received from device into string to be output
// on screen.
//
void CHIDtoUARTExampleDlg::CharsReceivedFromDevice(Report bytes_received)
{
	for (int i = 0; i < bytes_received.ReportByte[1];i++)
	{
		local_output_string.AppendChar(bytes_received.ReportByte[i+2]);
	}
}

//-----------------------------------------------------------------------------
// OnBnClickedCheck1
//-----------------------------------------------------------------------------
//
// Called whenever user chooses either Terminal Mode or File Transfer mode.
//
void CHIDtoUARTExampleDlg::OnBnClickedCheck1()
{
	UpdateData(true);
	
	if (m_TransmitRealTime)
	{
		GetDlgItem(IDC_TRANSMITNOW)->EnableWindow(false);
	}
	else
	{
		m_CharactersToTransmit = m_InputToDeviceBox;
		GetDlgItem(IDC_TRANSMITNOW)->EnableWindow(true);
	}
}	

//-----------------------------------------------------------------------------
// OnBnClickedTransmitnow
//-----------------------------------------------------------------------------
//
// Executes when user presses "Transmit Now" button.  This routine
// copies bytes from the "Input to device" text box to a buffer
// that is passed to routines that transmits to the device.
//
void CHIDtoUARTExampleDlg::OnBnClickedTransmitnow()
{
	CString TempString;
	unsigned char Buffer[4096];
	UpdateData(true);
	
	TempString = m_InputToDeviceBox;
	m_CharactersToTransmit.Append(TempString);
	for (int i = 0; i < TempString.GetLength(); i++)
	{
		Buffer[i] = TempString.GetAt(i);
	}
	TransmitToDevice(Buffer,TempString.GetLength());
}


//-----------------------------------------------------------------------------
// HID_InterruptGetReport
//-----------------------------------------------------------------------------
//
// Called by thread spawned to receive bytes from the device.
//
DWORD CHIDtoUARTExampleDlg::HID_InterruptGetReport (BYTE* reportbuffer)
{
	DWORD results;
	return HIDtoUARTDevice.GetInputReport_Interrupt(reportbuffer,
		HIDtoUARTDevice.GetInputReportBufferLength(),1,&results);
}

//-----------------------------------------------------------------------------
// InterruptThreadProc
//-----------------------------------------------------------------------------
//
// Routine is called from the thread created when the "Connect" button is
// pressed and communication begins.  This routine continuously attempts
// to retrieve IN INTERRUPT reports from the bus.  If a report is received,
// the routine then calls the dialog box HID callback routine to process
// the received data.
//
static DWORD WINAPI InterruptThreadProc(LPVOID lpParameter)
{
	CHIDtoUARTExampleDlg* dlg;
	dlg = (CHIDtoUARTExampleDlg*)lpParameter;
	BYTE reportbuffer[256];
	DWORD status;

	dlg->RXthreadmaycontinue = TRUE;   // Variable will be cleared whenever
									   // device is disconnected

	while (dlg->RXthreadmaycontinue == TRUE)
	{
		// Attempt to retrieve a report
		status = dlg->HID_InterruptGetReport (reportbuffer);
		// If a report has been recieved, call the callback routine
		// to process the data stored in reportbuffer
		if (status == HID_DEVICE_SUCCESS)
		{
			dlg->HIDcallback (reportbuffer);
		}
	}

	return 1;
}

//-----------------------------------------------------------------------------
// HIDcallback
//-----------------------------------------------------------------------------
//
// This routine is called by the thread created to receive INTERRUPT IN
// reports from the device.  The routine checks the report ID and
// processes the received data.
//
void CHIDtoUARTExampleDlg::HIDcallback (BYTE* reportbuffer)
{			
	CString tempstring;
	CString DebugString;
	Report IN_Report;
	// check report ID and determine
	switch(reportbuffer[0])
	{
		case (IN_DATA):
			// Reads length byte from report, adds to global counter
			m_BytesReceivedLocal += reportbuffer[1];

			// Save report received to vector of unsigned chars
			for(int i = 0; i < 64; i++)
			{
				IN_Report.ReportByte[i] = reportbuffer[i];
			}
			// If in terminal mode, process report to output on screen
			if (m_RadioTerminalMode == false)
			{
				CharsReceivedFromDevice(IN_Report);
				UpdateWindow = TRUE;
			}
			// Save report on IN report vector
			IN_DATA_Reports.push_back(IN_Report);
			
			// Save report in vector used to construct the text file
			// received across UART interface
			if (m_RadioTransferMode == false)
			{
				m_TransferTextReports.push_back(IN_Report);
			}
			
			break;
		default:
		break;
	}
}



//-----------------------------------------------------------------------------
// OnTimer
//-----------------------------------------------------------------------------
//
// Timer is configured to call this routine every 100 ms.  If UpdateWindow
// has been set, on-screen dialog values are saved and updated.
//
void CHIDtoUARTExampleDlg::OnTimer(UINT nIDEvent)
{
	static int timeout_count = 0;

	// If flag is set by other routine and delay used to prevent
	// too many CPU resources from being spent on updating the screen
	// has reached its terminal value (10), update screen
	if ((UpdateWindow == TRUE) || (timeout_count++ >= 10))
	{
		UpdateData(true);
		// Insert carriage returns on terminal mode's output box so that
		// long strings can be displayed
		m_OutputFromDeviceBox = InsertCarriageReturns(local_output_string);

		// Copy variable created by functions into global variables used by
		// the screen
		m_BytesTransmitted = m_BytesTransmittedLocal;
		m_BytesReceived = m_BytesReceivedLocal;

		UpdateData(false);
		UpdateWindow = false;
	}

	CDialog::OnTimer(nIDEvent);		   // Call base class function
}

//-----------------------------------------------------------------------------
// InsertCarriageReturns
//-----------------------------------------------------------------------------
//
// Adds new line characters to a string to allow long strings to be
// displayed in text boxes.
//
CString CHIDtoUARTExampleDlg::InsertCarriageReturns(CString inputstring)
{	
	DWORD localinputstringsize;
	CString NewLine = _T("\r\n");
	CString tempstring;
	tempstring.Empty();
	// Step through entire string, insert new line characters 
	// every 80 characters
	for (int i = 0; i < inputstring.GetLength(); i++)
	{
		if (((i % 80) == 0) && (i != 0))
		{
			
			tempstring += (NewLine);
		}
		tempstring += (inputstring.GetAt(i));
	}

	return tempstring;
}

//-----------------------------------------------------------------------------
// OnBnClickedClearoutputtext
//-----------------------------------------------------------------------------
//
// Clear text from terminal mode text box showing bytes received from device.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearoutputtext()
{
	m_OutputFromDeviceBox.Empty();
	local_output_string.Empty();
	UpdateData(false);
}


//-----------------------------------------------------------------------------
// Screen control routines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// OnBnClickedClearinputtext
//-----------------------------------------------------------------------------
//
// Clear text from terminal mode text box showing bytes transmitted from 
// device.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearinputtext()
{
	m_InputToDeviceBox.Empty();
	m_InputToDeviceBoxOld.Empty();
	m_CharactersToTransmit.Empty();
	UpdateData(false);
}

//-----------------------------------------------------------------------------
// EnableRadioButtons
//-----------------------------------------------------------------------------
//
// This routine is called after a device is connected and gives customers
// the choice between enabling terminal mode and file transfer mode.
//
void CHIDtoUARTExampleDlg::EnableRadioButtons(bool select)
{
	GetDlgItem(IDC_RADIO_TERMINALMODE)->EnableWindow(select);	
	GetDlgItem(IDC_RADIO_TRANSFERMODE)->EnableWindow(select);	

	m_RadioTerminalMode = true;
	m_RadioTransferMode = true;

	UpdateData(false);
}

//-----------------------------------------------------------------------------
// OnBnClickedRadioTransfermode
//-----------------------------------------------------------------------------
//
// This routine enables all file transfer mode boxes and buttons and
// disables all terminal mode buttons.
//
void CHIDtoUARTExampleDlg::OnBnClickedRadioTransfermode()
{
	m_RadioTransferMode = false;
	m_RadioTerminalMode = true;
	EnableTerminalMode(false);
	EnableTransferMode(true);
	UpdateData(false);
}


//-----------------------------------------------------------------------------
// OnBnClickedRadioTerminalmode
//-----------------------------------------------------------------------------
//
// This routine enables all terminal mode boxes and buttons and
// disables all file transfer mode buttons.
//
void CHIDtoUARTExampleDlg::OnBnClickedRadioTerminalmode()
{
	m_RadioTransferMode = true;
	m_RadioTerminalMode = false;
	EnableTerminalMode(true);
	EnableTransferMode(false);
	UpdateData(false);
}

//-----------------------------------------------------------------------------
// OnBnClickedClearbytestxedbutton
//-----------------------------------------------------------------------------
//
// Clear text in bytes transmitted to device.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearbytestxedbutton()
{
	m_BytesTransmittedLocal = 0;
	m_BytesTransmitted = 0;
	UpdateWindow = TRUE;
}

//-----------------------------------------------------------------------------
// OnBnClickedClearbytesrxedbutton
//-----------------------------------------------------------------------------
//
// Clear text in bytes received from device.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearbytesrxedbutton()
{
	m_BytesReceivedLocal = 0;
	m_BytesReceived = 0;
	UpdateWindow = TRUE;
}



//-----------------------------------------------------------------------------
// File Transfer mode routines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// OnBnClickedTransferfile
//-----------------------------------------------------------------------------
//
// This routine reads bytes from a file, packetizes bytes into
// reports, and transmits them to the device.  If the device is
// in loopback, it will then receive bytes, transmit them across UART,
// receive bytes across UART, and transmit them back upstream
// across the USB.  These bytes will be read by the application
// and written to an output file.
//
void CHIDtoUARTExampleDlg::OnBnClickedTransferfile()
{
	// Check if input file is defined
	if (m_TXFileName == _T(""))
	{
		MessageBox(_T("ERROR: Please define input file"));
		return;
	}
	
	//m_BytesReceivedDuringTransfer.Empty();
	m_TransferTextReports.clear();

	DWORD ByteCount = 0;
	if (m_TXFileName.GetLength() > 0)
	{
		CFile readfile;
		// Open file to transmit
		if (readfile.Open(m_TXFileName, CFile::modeRead |CFile::shareDenyNone))
		{
			DWORD BytesToRead = readfile.GetLength();
			DWORD TotalBytes = BytesToRead;
			m_ProgressBar.SetRange(1,100);
			m_ProgressBar.SetPos(0);

			unsigned char tempbuffer[4096];
			//DWORD BytesWritten = 0;
			// Read file into a CString variable
			m_CharactersToTransmit.Empty();

			// Counter equals 0 when all bytes have been read
			while(BytesToRead != 0)
			{
				// Set up variable to read up to 4096 bytes from file
				DWORD bytes_to_read_this_iteration;
				if (BytesToRead < 4096)
				{
					bytes_to_read_this_iteration = BytesToRead;
				}
				else
				{
					bytes_to_read_this_iteration = 4096;
				}
				// Read bytes from file
				readfile.Read (tempbuffer,bytes_to_read_this_iteration);
				// Decrement file byte counter
				BytesToRead -= bytes_to_read_this_iteration;
				// Increment variable used to adjust progress bar
				ByteCount+=bytes_to_read_this_iteration;
				m_ProgressBar.SetPos(50-50*BytesToRead/TotalBytes);
				// Transmit packetized bytes to device
				TransmitToDevice(tempbuffer,bytes_to_read_this_iteration);
			}
			// Close file after finished reading
			readfile.Close();
		}
	}
	// If file name for file to store received bytes has been defined,
	// write received bytes into file
	if (m_RXFileName != _T(""))
	{
		CFile writefile;
		// Delete contents of file if check box is set
		if (m_ClearRXFile)
		{
			writefile.Open(m_RXFileName, CFile::modeWrite | CFile::modeCreate);
		}
		else
		{
			writefile.Open(m_RXFileName, CFile::modeWrite | CFile::modeCreate | CFile::modeNoTruncate);
			writefile.SeekToEnd();
		}
		// Create iterator that can be used to step through received reports
		std::vector<Report>::iterator CStringIndex;
		DWORD Strings = 0;
		unsigned int localcount = 0;
		char buffer[4096];
		// Move through entire vector
		for(CStringIndex = m_TransferTextReports.begin(); CStringIndex != m_TransferTextReports.end(); CStringIndex++)
		{
			// Read each byte, write each byte to file
			for(DWORD local_index = 0; local_index < CStringIndex->ReportByte[1]; local_index++)
			{
				unsigned char character = CStringIndex->ReportByte[2+local_index];
				buffer[localcount++] = character;
				writefile.Write(&character,1);
				m_ProgressBar.SetPos(++Strings);
			}
		}
		writefile.Close();
		
		
	}
	else
	{
		m_ProgressBar.SetPos(100);
	}
		
}

//-----------------------------------------------------------------------------
// OnBnClickedInputfilebutton
//-----------------------------------------------------------------------------
//
// Opens dialog box that allows users to select a file to transmit.
//
void CHIDtoUARTExampleDlg::OnBnClickedInputfilebutton()
{
	CFileDialog FileDlg (TRUE);
	if (FileDlg.DoModal() == IDOK)
	{
		m_TXFileName = FileDlg.GetPathName();
		UpdateData(FALSE);
	}
}


//-----------------------------------------------------------------------------
// OnBnClickedOutputfilebutton
//-----------------------------------------------------------------------------
//
// Opens dialog box that allows users to select a file where received
// bytes can be stored.
//
void CHIDtoUARTExampleDlg::OnBnClickedOutputfilebutton()
{
	CFileDialog FileDlg (TRUE);
	if (FileDlg.DoModal() == IDOK)
	{
		m_RXFileName = FileDlg.GetPathName();
		UpdateData(FALSE);
	}
}

//-----------------------------------------------------------------------------
// OnBnClickedClearoutputfilecheck
//-----------------------------------------------------------------------------
//
// Checks/unchecks box that clears output file before writing new
// bytes to it.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearoutputfilecheck()
{
	UpdateData(TRUE);
}



//-----------------------------------------------------------------------------
// Report Log Routines
//-----------------------------------------------------------------------------

void CHIDtoUARTExampleDlg::ByteToASCII(unsigned char Input, unsigned char* Output)
{
	Output[0] =(((Input & 0xF0)>>4));
	if ((Output[0] >= 0) && (Output[0] <= 9))
		Output[0] += '0';
	if ((Output[0] >= 0x0a) && (Output[0] <= 0x0f))
		Output[0] = Output[0] - 10 + 'a';

	Output[1] =(((Input & 0x0F)));
	if ((Output[1] >= 0) && (Output[1] <= 9))
		Output[1] += '0';
	if ((Output[1] >= 0x0a) && (Output[1] <= 0x0f))
		Output[1] = Output[1] - 10 + 'a';
}

//-----------------------------------------------------------------------------
// OnBnClickedDownloadreportsbutton
//-----------------------------------------------------------------------------
//
// Copies data reports sent from device to host into a file.
//
void CHIDtoUARTExampleDlg::OnBnClickedDownloadreportsbutton()
{
	// Create output file in project directory
	CString report_output_file = _T("IN_ReportOutput.txt");
	CFile outputfile;
	// Open file
	outputfile.Open(report_output_file, CFile::modeWrite | CFile::modeCreate);
	// Create iterator to move through IN reports
	std::vector<Report>::iterator CStringIndex;
	m_ProgressBar.SetRange(1,IN_DATA_Reports.size());
	m_ProgressBar.SetPos(0);
	DWORD Strings = 0;
	// Step through each report stored in vector
	for(CStringIndex = IN_DATA_Reports.begin(); CStringIndex != IN_DATA_Reports.end(); CStringIndex++)
	{
		// Read each byte in report, write to file as follows:
		// |   Byte 0    | |   Byte 1   | | Byte 2  |
		// | High nibble | | Low nibble | | [Space] |
		for(DWORD local_index = 0; local_index < IN_DATA_SIZE+1; local_index++)
		{
			unsigned char character = CStringIndex->ReportByte[local_index];
			unsigned char bytes[3];
			ByteToASCII(character,bytes);
			bytes[2] = ' ';

			outputfile.Write(bytes,3);
			m_ProgressBar.SetPos(++Strings);
		}

		// Add newline characters between each report
		unsigned char carriage_return[2];
		carriage_return[0] = '\r';
		carriage_return[1] = '\n';
		outputfile.Write(carriage_return,2);
	}

	outputfile.Close();
}

//-----------------------------------------------------------------------------
// OnBnClickedClearreportbufferbutton
//-----------------------------------------------------------------------------
//
// Deletes all IN and OUT DATA reports stored in vectors.
//
void CHIDtoUARTExampleDlg::OnBnClickedClearreportbufferbutton()
{
	IN_DATA_Reports.clear();
	OUT_DATA_Reports.clear();
}

//-----------------------------------------------------------------------------
// OnBnClickedDownloadparsedreports
//-----------------------------------------------------------------------------
//
// Copies data reports sent from device to host into a file, showing both
// the ASCII character and the character's hex value.
//
void CHIDtoUARTExampleDlg::OnBnClickedDownloadparsedreports()
{
	CString report_output_file = _T("IN_ReportOutputParsed.txt");
	CFile outputfile;
	DWORD total_bytes = 0;
	outputfile.Open(report_output_file, CFile::modeWrite | CFile::modeCreate);
	std::vector<Report>::iterator CStringIndex;
	m_ProgressBar.SetRange(1,IN_DATA_Reports.size());
	m_ProgressBar.SetPos(0);
	DWORD Strings = 0;

	// Read all reports stored in IN DATA vector
	for(CStringIndex = IN_DATA_Reports.begin(); CStringIndex != IN_DATA_Reports.end(); CStringIndex++)
	{
		// Only read IN_DATA reports
		if (CStringIndex->ReportByte[0] == IN_DATA)
		{
			// Read length byte showing number of valid bytes
			// contained within report, write value to file formatted as:
			// |   Byte 0    | |   Byte 1   | | Byte 2  |
			// | High nibble | | Low nibble | | [Space] |
			unsigned char character = CStringIndex->ReportByte[1];
			unsigned char numbytes[3];
			total_bytes = total_bytes + character;
			numbytes[2] = ' ';
			ByteToASCII(character, numbytes);
			outputfile.Write(numbytes,3);

			// Read each byte in report, output to file formatted as:
			// |   Byte 0    | |   Byte 1   | | Byte 2  | | Byte 3  | | Byte 4  | | Byte 5  |
			// | High nibble | | Low nibble | |  ':'    | | ASCII   | | [space] | | [space] |
			for(DWORD local_index = 0; local_index < CStringIndex->ReportByte[1]; local_index++)
			{
				unsigned char character = CStringIndex->ReportByte[local_index+2];
				unsigned char bytes[6];
				bytes[2] = ':';
				bytes[3] = character;
				bytes[4] = ' ';
				bytes[5] = ' ';
				ByteToASCII(character,bytes);
				outputfile.Write(bytes,6);
			}
			// Insert newline character between reports
			unsigned char carriage_return[2];
			carriage_return[0] = '\r';
			carriage_return[1] = '\n';
			outputfile.Write(carriage_return,2);
		}
		m_ProgressBar.SetPos(++Strings);
	}

	// Output total bytes written to file
	unsigned char total[8];
	DWORD temp_total_bytes = total_bytes;
	DWORD denominator;

	// Write total number of bytes written to file
	for(int index = 7; index >= 0; index--)
	{
		denominator = 1;
		if(index != 0)
		{
			for (int power = 0; power < index; power++)
			{
				denominator = denominator * 10;
			}
		}
		total[7-index] = temp_total_bytes / denominator + '0';
		temp_total_bytes = temp_total_bytes % denominator;
	}
	outputfile.Write(total,8);
	outputfile.Close();
}

//-----------------------------------------------------------------------------
// OnBnClickedDownloadparsedreports
//-----------------------------------------------------------------------------
//
// Copies data reports sent from host to device into a file.
//
void CHIDtoUARTExampleDlg::OnBnClickedDownloadoutreportsbutton2()
{
CString report_output_file = _T("OUT_ReportOutput.txt");
	CFile outputfile;
	outputfile.Open(report_output_file, CFile::modeWrite | CFile::modeCreate);
	std::vector<Report>::iterator CStringIndex;
	m_ProgressBar.SetRange(1,OUT_DATA_Reports.size());
	m_ProgressBar.SetPos(0);
	DWORD Strings = 0;

	// Read all reports from the vector
	for(CStringIndex = OUT_DATA_Reports.begin(); CStringIndex != OUT_DATA_Reports.end(); CStringIndex++)
	{
		// Write byte to file formatted as:
		// |   Byte 0    | |   Byte 1   | | Byte 2  |
		// | High nibble | | Low nibble | | [Space] |
		for(DWORD local_index = 0; local_index < OUT_DATA_SIZE+1; local_index++)
		{
			unsigned char character = CStringIndex->ReportByte[local_index];
			unsigned char bytes[3];
			ByteToASCII(character, bytes);
			bytes[2] = ' ';
			outputfile.Write(bytes,3);
		}
		// Insert newline character
		unsigned char carriage_return[2];
		carriage_return[0] = '\r';
		carriage_return[1] = '\n';
		outputfile.Write(carriage_return,2);
		m_ProgressBar.SetPos(++Strings);
	}
}

//-----------------------------------------------------------------------------
// OnBnClickedDownloadparsedoutreports2
//-----------------------------------------------------------------------------
//
// Copies data reports sent from host to device into a file with
// formatting to show the hex value for each ASCII character.
//
void CHIDtoUARTExampleDlg::OnBnClickedDownloadparsedoutreports2()
{
	CString report_output_file = _T("OUT_ReportOutputParsed.txt");
	CFile outputfile;
	DWORD total_bytes = 0;
	outputfile.Open(report_output_file, CFile::modeWrite | CFile::modeCreate);
	std::vector<Report>::iterator CStringIndex;
	m_ProgressBar.SetPos(0);
	m_ProgressBar.SetRange(1,OUT_DATA_Reports.size());
	DWORD Strings = 0;

	// Read all OUT reports
	for(CStringIndex = OUT_DATA_Reports.begin(); CStringIndex != OUT_DATA_Reports.end(); CStringIndex++)
	{
		if (CStringIndex->ReportByte[0] == OUT_DATA)
		{
			// Read length byte showing number of valid bytes
			// contained within report, write value to file formatted as:
			// |   Byte 0    | |   Byte 1   | | Byte 2  |
			// | High nibble | | Low nibble | | [Space] |
			unsigned char character = CStringIndex->ReportByte[1];
			unsigned char numbytes[3];
			total_bytes = total_bytes + character;
			numbytes[2] = ' ';
			ByteToASCII(character, numbytes);
			outputfile.Write(numbytes,3);

			// Read each byte in the report, write each to file
			for(DWORD local_index = 0; local_index < CStringIndex->ReportByte[1]; local_index++)
			{
				// Read each byte in report, output to file formatted as:
				// |   Byte 0    | |   Byte 1   | | Byte 2  | | Byte 3  | | Byte 4  | | Byte 5  |
				// | High nibble | | Low nibble | |  ':'    | | ASCII   | | [space] | | [space] |
				unsigned char character = CStringIndex->ReportByte[local_index+2];
				unsigned char bytes[6];
				bytes[2] = ':';
				bytes[3] = character;
				bytes[4] = ' ';
				bytes[5] = ' ';
				ByteToASCII(character, bytes);
				outputfile.Write(bytes,6);
			}
			// Insert carriage return between reports
			unsigned char carriage_return[2];
			carriage_return[0] = '\r';
			carriage_return[1] = '\n';
			outputfile.Write(carriage_return,2);
		}
		Strings++;
		m_ProgressBar.SetPos(Strings);
	}
	// Output total number of bytes read to file
	unsigned char total[8];
	DWORD temp_total_bytes = total_bytes;
	DWORD denominator;
	for(int index = 7; index >= 0; index--)
	{
		denominator = 1;
		if(index != 0)
		{
			for (int power = 0; power < index; power++)
			{
				denominator = denominator * 10;
			}
		}
		total[7-index] = temp_total_bytes / denominator + '0';
		temp_total_bytes = temp_total_bytes % denominator;
	}
	outputfile.Write(total,8);
	outputfile.Close();
}




//-----------------------------------------------------------------------------
// Test Pattern routines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// OnBnClickedTestpatternbutton
//-----------------------------------------------------------------------------
//
// Outputs sequence of bytes to device in loopback.
//
void CHIDtoUARTExampleDlg::OnBnClickedTestpatternbutton()
{
	unsigned char element;
	UpdateData(false);

	element = 0;
	DWORD Bytes = 0;
	m_ProgressBar.SetRange(0,100);
	m_ProgressBar.SetPos(0);

	// Output <m_NumReports> reports of <m_BytesPerReport> size
	for (DWORD report_count = 0; report_count < m_NumReports; report_count++)
	{
		Report BytesToTransmit;
		for (DWORD byte_in_report = 0; byte_in_report < m_BytesPerReport; byte_in_report++)
		{
			BytesToTransmit.ReportByte[byte_in_report] = element;
			element++;
			Bytes++;
			m_ProgressBar.SetPos(100*Bytes/(m_NumReports*m_BytesPerReport));
			
		}
		TransmitToDevice(BytesToTransmit.ReportByte,m_BytesPerReport);
	}
}

//-----------------------------------------------------------------------------
// OnBnClickedCheckresultsbutton
//-----------------------------------------------------------------------------
//
// Compares test pattern transmitted to test pattern received.
//
void CHIDtoUARTExampleDlg::OnBnClickedCheckresultsbutton()
{
	std::vector<Report>::iterator IN_DATA_StringIndex;
	std::vector<Report>::iterator OUT_DATA_StringIndex;
	IN_DATA_StringIndex = IN_DATA_Reports.begin();
	OUT_DATA_StringIndex = OUT_DATA_Reports.begin();

	unsigned char bytes_this_OUT_DATA_report = 0;
	unsigned char bytes_this_IN_DATA_report = 0;
	unsigned char IN_DATA_index = 0;
	unsigned char OUT_DATA_index = 0;

	// Construct the OUT_DATA report Ctring
	CString OUT_DATA_Bytes;
	OUT_DATA_Bytes.Empty();
	//InitProgressBar(OUT_DATA_Reports.size()+IN_DATA_Reports.size()-1);
	m_ProgressBar.SetRange(0,100);
	m_ProgressBar.SetPos(0);
	DWORD Strings = 0;
	// Read all OUT DATA report bytes into a single CString
	while (OUT_DATA_StringIndex != OUT_DATA_Reports.end())
	{
		// Create CString one report byte at a time
		for (DWORD index = 0; index < OUT_DATA_StringIndex->ReportByte[1]; index++)
		{
			OUT_DATA_Bytes.AppendChar(OUT_DATA_StringIndex->ReportByte[index+2]);
		}
		OUT_DATA_StringIndex++;
		Strings++;
		m_ProgressBar.SetPos(50*(Strings/OUT_DATA_Reports.size()));
	}

	// Construct the IN_DATA report Ctring
	CString IN_DATA_Bytes;
	IN_DATA_Bytes.Empty();
	Strings = 0;
	while (IN_DATA_StringIndex != IN_DATA_Reports.end())
	{
		for (DWORD index = 0; index < IN_DATA_StringIndex->ReportByte[1]; index++)
		{
			IN_DATA_Bytes.AppendChar(IN_DATA_StringIndex->ReportByte[index+2]);
		}
		IN_DATA_StringIndex++;
		Strings++;
		m_ProgressBar.SetPos(50 + 50*(Strings/IN_DATA_Reports.size()));
	}
	// Compare two CStrings using CString class member function
	int IN_DATA_BytesSize = IN_DATA_Bytes.GetLength();
	int OUT_DATA_BytesSize = OUT_DATA_Bytes.GetLength();
	if (IN_DATA_Bytes.Compare(OUT_DATA_Bytes) == 0)
	{
		MessageBox(_T("SUCCESS"));
	}
	else
	{
		MessageBox(_T("FAILURE"));
	}
}


//-----------------------------------------------------------------------------
// Get/Set Baudrate routines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// OnBnClickedGetbaudrate
//-----------------------------------------------------------------------------
//
// Reads baud rate from device and displays value onscreen.
// Note: this will only work if the device firmware's build includes
// routines to respond to Get/Set commands.
//
void CHIDtoUARTExampleDlg::OnBnClickedGetbaudrate()
{
	unsigned char input_buffer[100];

	// Request IN_CONTROL across control endpoint
	input_buffer[0] = IN_CONTROL;
	BYTE retval = HIDtoUARTDevice.GetInputReport_Control(input_buffer,IN_REPORT_BUFFER_SIZE+1);
	if (retval != HID_DEVICE_SUCCESS)
	{
	}
	// Output data from report, which is the 4-byte baud rate, onscreen
	DWORD temp_baudrate = 0;
	temp_baudrate = input_buffer[1];
	temp_baudrate<<=8;
	temp_baudrate += input_buffer[2];
	temp_baudrate<<=8;
	temp_baudrate += input_buffer[3];
	temp_baudrate<<=8;
	temp_baudrate += input_buffer[4];
	m_BaudRate = temp_baudrate;
	UpdateData(false);
}

//-----------------------------------------------------------------------------
// OnBnClickedSetbaudrate
//-----------------------------------------------------------------------------
//
// Sets baud rate typed into text box to the device.
// Note: this will only work if the device firmware's build includes
// routines to respond to Get/Set commands.
//
void CHIDtoUARTExampleDlg::OnBnClickedSetbaudrate()
{
	unsigned char output_buffer[100];
	// Retrieve baud rate info from screen
	UpdateData(true);

	// Format packet
	output_buffer[0] = OUT_CONTROL;
	output_buffer[4] = (unsigned char)(m_BaudRate>>0);
	output_buffer[3] = (unsigned char)(m_BaudRate>>8);
	output_buffer[2] = (unsigned char)(m_BaudRate>>16);
	output_buffer[1] = (unsigned char)(m_BaudRate>>24);
	HIDtoUARTDevice.SetOutputReport_Control(output_buffer,OUT_REPORT_BUFFER_SIZE+1);
}






