//-----------------------------------------------------------------------------
//
// Copyright 2004 Silicon Laboratories
// 
// Filename:      F350_Weigh_Scale.h
// Target Device: C8051F350
// Created:       15 JAN 2004
// Created By:    DKC
// Tool chain:    KEIL Eval C51
//
// This is header file that is used to define all preprossor directives, 
//      global variables, and prototypes.
// The user must modify this header file for their particular Bridge Transducer
//      in use before proceeding.
// 
//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void Config_F350(void);
void FLASH_PageCopy (unsigned char code *src, unsigned char xdata *dest)
reentrant;
void FLASH_PageUpdate (unsigned char *src, unsigned char *dest, int length)
reentrant;
void CalibrateADCforMeasurement(void);
void Calculate_One_Count(void);
int  Monitor_Weigh_Scale(unsigned char);
void Update_Display_Via_UART(void);
void Update_Display_Via_LCD(void);

//-----------------------------------------------------------------------------
// UNIONs, STRUCTUREs, and ENUMs
//-----------------------------------------------------------------------------
typedef union LONG {                              // byte-addressable LONG
  long l;
  unsigned char b[4];
} LONG;

typedef union INT {                               // byte-addressable INT
  int i;
  unsigned char b[2];
} INT;

LONG code DATA_PAGE[128]    _at_ 0x1A00;          // Reserved Space
char code SCRATCH_PAGE[512] _at_ 0x1800;          // Reserved Space
			
//-----------------------------------------------------------------------------
// Globale Variable Definitions
//-----------------------------------------------------------------------------
                                                  // Units;
unsigned int   Temperature           = 0;         // 0.1K
unsigned int   Weight                = 0;         // lbs
unsigned long  Tare_Count            = 0;         // Digital Output,empty scale
unsigned long  Full_Counts           = 0;         // Digital Output,full scale
unsigned long  One_Count             = 0;         // Digital Output,one unit
unsigned int   Data_Word             = 0;         // Used to Communicate 
                                                  //   to HT1620 LCD Driver

LONG temp_LONG_1,temp_LONG_2;                     // Temporary Storage Var.
INT  temp_INT_1,temp_INT_2;                       // Temporary Storage Var.


//-----------------------------------------------------------------------------
// 8051F350 PARAMETERS
//-----------------------------------------------------------------------------
#define SYSCLK             3062500                // System clock frequency
#define BAUDRATE           9600                   // Baud rate of UART in bps
#define TEMP_SENSOR_OFFSET -438                   // Temp Sensor OFFSET(uV/degC)
#define TEMP_SENSOR_GAIN   -1730                  // Temp Sensor Gain(uV/degC)
#define VREF               3300                   // ADC Volt Ref, (mV)
#define SCRATCH_PAGE       0x1800                 // FLASH page, temp storage

//-----------------------------------------------------------------------------
// Bit maskable PORT Definitions
//-----------------------------------------------------------------------------
sbit FREE1                         = P0^0;        // P0.0 : FREE
sbit FREE2                         = P0^1;        // P0.1 : FREE
sbit FREE3                         = P0^2;        // P0.2 : FREE
sbit CS                            = P1^0;        // P1.0 : Chip Select
sbit WR                            = P1^1;        // P1.1 : Write
sbit RD                            = P1^2;        // P1.2 : Read
sbit DATA                          = P1^3;        // P1.3 : DATA

// AMUX Selections; Analog Inputs
#define VSCALE                     0x08           // P0.0(+)  : Unipolar, VIN
#define TSCALE                     0xF8           // Internal : Unipolar TEMP

//-----------------------------------------------------------------------------
// Calibration/Calculation PARAMETERS
//-----------------------------------------------------------------------------
                                                  // An estimate of the 
                                                  // Temperature<SLOPE>
                                                  //   in [tenth codes / K]
#define TEMP_SLOPE ((long) 16777216 / 100 * TEMP_SENSOR_GAIN / VREF)

//-----------------------------------------------------------------------------
// Directives for Weigh Scale Monitor Function
//-----------------------------------------------------------------------------
                                                  // Units
#define TEMPERATURE                0x01           // 0.1K
#define WEIGHT                     0x02           // Grams

//-----------------------------------------------------------------------------
// Directives for Weigh Scale DATA_PAGE Elements
//-----------------------------------------------------------------------------
#define Check_Byte_1               0x00           // 0x0A0A Default value
#define scale_slope                0x01           // Measurement Slope Register
#define scale_offset               0x02           // Voltage Offset Register
#define tare_count                 0x03           // Voltage Offset Register
#define full_counts                0x04           // Voltage Offset Register
#define one_count                  0x05           // Voltage Offset Register