//-----------------------------------------------------------------------------
//
// Copyright 2002 Cygnal Integrated Products, Inc.
//
// Filename:      LIION_BC_MAIN.h
// Target Device: 8051F300
// Created:       11 SEP 2002
// Created By:    DKC
// Tool chain: KEIL Eval C51
//
// This header file is used to define all preprocessor directives, prototypes,
// and global variable for LIION_BC_MAIN.c.
//
// The user should modify this header file before proceeding as key
//    battery parameter limits are set here.
//

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void Config_F300(void);
void Reset_Time_Base(void);
void CalibrateADCforMeasurement(void);
void Regulate_Current(int);
void Regulate_Voltage(void);
void Turn_PWM_Off(void);
int  Monitor_Battery(unsigned char);
void Bulk_Charge(void);
void Lowcurrent_Charge(void);
unsigned int Measure(void);
void Delay_Loop(void);

//-----------------------------------------------------------------------------
// UNIONs, STRUCTUREs, and ENUMs
//-----------------------------------------------------------------------------
typedef union LONG {                    // byte-addressable LONG
   long l;
   unsigned char b[4];
} LONG;

typedef union INT {                     // byte-addressable INT
   int i;
   unsigned char b[2];
} INT;

typedef struct
{
    unsigned long int t_count;
    int sec;                            // global seconds
    int min;                            // global minutes
    int hour;                           // global hour
}time_struct;





//-----------------------------------------------------------------------------
// Global Variable Definitions
//-----------------------------------------------------------------------------
time_struct TIME;                       // Global Struct to Track Time
char bdata TERMINATION;                 // Global Variable to Track Termination
char bdata CHARGE_STATUS;               // Global Variable to Track Charging
INT code CHECK_BYTE      _at_ 0x1A00;   // 0x0A0A Default value, for later use
LONG code VOLT_SLOPE     _at_ 0x1A60;   // Volt Slope Register
LONG code VOLT_OFFSET    _at_ 0x1A64;   // Volt Offset Register
LONG code I_NOAMP_SLOPE  _at_ 0x1A70;   // Current Slope Register,ext. amp off
LONG code I_NOAMP_OFFSET _at_ 0x1A74;   // Current Offset Register,ext. amp.off
LONG temp_LONG_1,temp_LONG_2;           // Temporary Storage Variables
INT  temp_INT_1,temp_INT_2;             // Temporary Storage Variables

//-----------------------------------------------------------------------------
// Bit maskable CHARGE STATUS Register Definition
//-----------------------------------------------------------------------------
sbit BULK       = CHARGE_STATUS^0;      // bit 0 : BULK charge status bit
sbit LOWCURRENT = CHARGE_STATUS^1;      // bit 1 : LOWCURRENT charge status bit
sbit ERROR      = CHARGE_STATUS^2;      // bit 2 : ERROR before/during charging
sbit CONST_V    = CHARGE_STATUS^3;      // bit 3 : charged w/ constant VOLTAGE
sbit CONST_C    = CHARGE_STATUS^4;      // bit 4 : charged w/ constant CURRENT
sbit DELAY      = CHARGE_STATUS^5;      // bit 5 : BULK charge DELAY for LiIon
                                        //    after CURRENT threshold detection
sbit READY      = CHARGE_STATUS^6;      // bit 6 : Lowcurrent charge is
                                        //     terminated; battery is charged
sbit FREE1      = CHARGE_STATUS^7;      // bit 7 : Not Currently used

//-----------------------------------------------------------------------------
// Bit Maskable TERMINATION Register Definition
//-----------------------------------------------------------------------------
sbit TEMP_MIN  = TERMINATION^0;         // bit 0 : minimum TEMPERATURE overflow
sbit TEMP_MAX  = TERMINATION^1;         // bit 1 : maximum TEMPERATURE overflow
sbit I_MIN     = TERMINATION^2;         // bit 2 : minimum CURRENT overflow
sbit I_MAX     = TERMINATION^3;         // bit 3 : maximum CURRENT overflow
sbit TIME_MAX  = TERMINATION^4;         // bit 4 : maximum time overflow
sbit VOLT_MAX  = TERMINATION^5;         // bit 5 : maximum VOLTAGE overflow
sbit VOLT_MIN  = TERMINATION^6;         // bit 6 : minimum VOLTAGE overflow
sbit FREE2     = TERMINATION^7;         // bit 7 : Not Currently used

//-----------------------------------------------------------------------------
// Bit maskable PORT Definitions
//-----------------------------------------------------------------------------
sbit SDA       = P0 ^ 0;                // bit 0 : SDA In/Output, Pin P0.
sbit SCL       = P0 ^ 1;                // bit 1 : SCL Output, Pin P1.
sbit CEX0      = P0 ^ 2;                // bit 2 : PWM Output, Pin P2.
sbit LED0      = P0 ^ 3;                // bit 3 : LED0, Pin P0.3
sbit SW0       = P0 ^ 7;                // bit 7 : Switch0, Pin P0.7

                                        // AMUX Selections; Analog Inputs
#define TBAT   0xF8;                    // bit 4 : Temp.   Ch.; Analog In
#define IBAT   0x65;                    // bit 5 : Current Ch.; Analog In
#define VBAT   0xF6;                    // bit 6 : Voltage Ch.; Analog In




//-----------------------------------------------------------------------------
// 8051F300 PARAMETERS
//-----------------------------------------------------------------------------
#define SYSCLK             24500000     // System clock frequency
#define TEMP_SENSOR_GAIN   3300         // Temp Sensor Gain in (uV / degC)
#define TEMP_GAIN          2            // PGA gain setting
#define CURRENT_GAIN       4            // PGA gain setting
#define VREF               3200         // ADC Voltage Reference (mV)
#define SCRATCH_PAGE       0x1C00       // FLASH page used for temp storage
#define PWM_CLOCK          SYSCLK/255   // PWM frequency is 96 kHz

//-----------------------------------------------------------------------------
// Calibration/Calculation PARAMETERS
//-----------------------------------------------------------------------------
#define V1_CAL             67           // 1st cal point for 2 point cal.
#define V2_CAL             2800         // 2nd cal point for 2 point cal.
#define I1_CAL             67           // 1st cal point for 2 point cal.
#define I2_CAL             133          // 2nd cal point for 2 point cal.
#define RSENSE             1            // RSENSE is assumed to be 1/2 ohm
#define RESB               20           // 10k Ohms, Voltage Divide Resistor
#define RESAB              30           // 20k Ohms, Voltage Divide Resistor


#define TEMP_SLOPE ((long) TEMP_GAIN * TEMP_SENSOR_GAIN * 65536 / 100 / VREF)
                                        // An estimate of the Temperature<SLOPE>
                                        // in [tenth codes / K]
                                        // The temperature measurement is
                                        // within 3 degrees of accuracy.

//-----------------------------------------------------------------------------
// Monitor_Battyer Switch PARAMETERS
//-----------------------------------------------------------------------------
#define TEMPERATURE        7            // Value for Switch Statement
#define VOLTAGE            5            // Value for Switch Statement
#define VOLTAGE_PWM_OFF    3            // Value for Switch Statement
#define CURRENT            1            // Value for Switch Statement


//-----------------------------------------------------------------------------
// Battery/Pack Parameters
//-----------------------------------------------------------------------------
#define  CELLS              1            // Number of cells in the battery pack
#define  CAPACITY           150          // mAh, Battery Capacity (LiIon)
#define  LiIon_CELL_VOLT    4200         // mV, Nominal Charge Voltage
#define I_BULK             (unsigned int)(CAPACITY)
#define I_LOWCURRENT       (unsigned int)(CAPACITY/4)
#define VOLT_BULK          (unsigned int)(LiIon_CELL_VOLT)

#define VOLT_LOWCURRENT    (unsigned int)(LiIon_CELL_VOLT)

#define VOLT_TOLERANCE     (unsigned int)(LiIon_CELL_VOLT/100)// 1 Percent Acc
#define CURRENT_TOLERENCE  (unsigned int)(CAPACITY/10)        // 10 Percent Acc






//-----------------------------------------------------------------------------
// Battery Characteristics: Charge TERMINATION Limits
//-----------------------------------------------------------------------------
#define  MIN_TEMP_ABS        26300      // Abs. min. TEMPERATURE = -10 C, 263K
#define  MAX_TEMP_ABS        32300      // Abs. max. TEMPERATURE = 50C, 323K:
#define  MIN_VOLT_BULK       3000       // Minimum BULK Voltage
#define  MAX_VOLT_ABS        (unsigned int)(CELLS * LiIon_CELL_VOLT)
#define  MIN_I_BULK          (unsigned int)(CAPACITY/4)
#define  MAX_TIME_LOWCURRENT 30         // Max Lowcurrent Charge Time = 90min
#define  MAX_TIME_BULK       90         // Maximum BULK Charge Time = 90 min
                                        //   at 1C CURRENT
#define  BULK_TIME_DELAY     30         // DELAY  = 30min after "MIN_I_BULK"
