;
;Implementing an 16-bit PWM on SA_TB4PCB-002 target board and sampling to test 
;	the 8-bit analog-to-digital convertor (ADC). The following program will 
;	configure on-chip peripherals and use a low-pass filter on the target board.
;
;FILE:			PWM.asm
;DEVICE:		C8051F2xx
;TOOL:			Cygnal IDE, 8051 assembler (Metalink)
;AUTHOR:		LS
;-----------------------------------------------------------------------
$MOD8F200
;-----------------------------------------------------------------------
;
;Reset Vector
;
	org		00h
	jmp		MAIN
;
;-----------------------------------------------------------------------
;
;ISR Vectors
	org 		0Bh
	jmp		TIMER0_ISR


	org		7Bh
	jmp		ADC_ISR

;-----------------------------------------------------------------------
;Data/RAM
pulse_width				EQU				10000d					; Value to load into TIMER0 which
																; adjusts
																; pulse width (duty cycle)
																; in PWM and thus adjusts the
																; DC bias level output from the
																; low-pass
																; filter. Set from 19-65522d.

ADCsampl				EQU				55536d					; Load into TIMER2 for ADC sampling rate




;-Start of MAIN code----------------------------------------------------


		org	0B3h

MAIN:
		mov		OSCICN,#07h										; Configure internal OSC for 15MHz
		mov		WDTCN,#0DEh										; Disable Watchdog timing
		mov		WDTCN,#0ADh									
		orl		PRT2CF,#80h										; Configure P2.7 as push-pull
		mov		P3MODE,#0FEh										; Configure P3.0 for analog input 														 															; pass filter 
		orl		CKCON,#28h										; Set TIMER0 and TIMER2 to use system
																; clk
		orl		TMOD,#01h										; Set TIMER0 in 16-bit counter mode								
		mov		RCAP2H,#HIGH(ADCsampl)							; Load autoreload values for sampling	
																; rate of ADC
		mov		RCAP2L,#LOW(ADCsampl)							; using TIMER2 overflow for ADC
																; conversion start
		mov		TH2,#HIGH(ADCsampl)								; initilaize T2 for ADC sampling
																; rate=1.6KHz
		mov		TL2,#LOW(ADCsampl)
		orl		AMX0SL,#38h										; Set AMUX for P3.0 input and enable the AMUX
		mov		ADC0CF,#60h										; Set conversion CLK 8 of sysclk, and
																; gain=1
		orl		ADC0CN,#00001100b								; Set the ADC to start a conversion on
																; Timer2 overflow
		orl		REF0CN,#03h										; Set to the internal reference
		orl		EIE2,#00000010b									; Enable ADC end of conv. interrupts
		setb	ET0												; Enable timer0 interrupts									
		setb	EA												; Global interrupt enable
		setb	TR0												; Start TIMER0
		setb	TR2												; Start TIMER2
		setb	ADCEN											; Enable the ADC
IDLE:	
		orl		PCON,#01h
		sjmp	IDLE											; Upon return from interrupt loop back
																; to put MCU in IDLE Mode


;------TIMER0 ISR----------------------------------------------------------
TIMER0_ISR:
		jbc		P2.7,LO											; Test to see if low/high in waveform
		setb	P2.7											; Transition low to high
		clr		TR0												; Stop Timer0 during load
		mov		TH0,#HIGH(-pulse_width)							; Set length of pulse for DC bias level
		mov		TL0,#LOW(-pulse_width)							;
		setb	TR0												; Restart Timer0 
		jmp		RETURN
LO:		clr		TR0
		mov		TH0,#HIGH(pulse_width)							; Set low time of duty cycle
		mov		TL0,#LOW(pulse_width)
		setb	TR0
RETURN:	reti													; Return from interrupt

;------ADC ISR-------------------------------------------------------------
ADC_ISR:
		clr		ADCINT											; ADC flag must be cleared in software
		reti													; Return from interrupt


;---------------------------------------------------------------------------


;End of program
END