package eu.maydu.gwt.validation.client.validators.strings.algorithms;

import java.util.List;

import eu.maydu.gwt.validation.client.validators.ValidatorAlgorithm;
import eu.maydu.gwt.validation.client.validators.ValidatorAlgorithmResult;

/**
 * Validates that a given string equals another string
 * 
 * @author Anatol Mayen
 *
 */
public class StringEqualsValidatorAlgorithm implements ValidatorAlgorithm<List<String>> {

	/**
	 * The error messages provided by this validator.
	 * Parameter 1: String 1
	 */
	public static final int NOT_EQUAL = 1;
	
	
	
	public ValidatorAlgorithmResult validate(List<String> strings) {
		
		boolean allNull = true;
		boolean someNull = false;
		for(String s : strings) {
			if(s != null)
				allNull = false;
			if(s == null)
				someNull = true;
		}
		
		if(allNull)
			return null;
		
		if(someNull)
			return notEqual();

		String sample = strings.get(0);
		for(String s : strings) {
			if(!s.equals(sample))
				return notEqual();
		}
		
		return null;
	}

	private ValidatorAlgorithmResult notEqual() {
		return new ValidatorAlgorithmResult(NOT_EQUAL);
	}

}
