package eu.maydu.gwt.validation.client.validators;


/**
 * This interface is used by supporting <code>Validator</code>s to specify
 * a dynamic source that will provide some configuration data.
 * 
 * This makes it possible for validators to change their behaviour
 * during runtime by providing possibly new configuration data based
 * for example on previous input from a user.
 * 
 * Validators using this possibility should try to avoid to
 * force the user to implement this interface. Most validators
 * will often have no need for dynamic runtime configuration so
 * the validators should give the user the possibility to configure
 * them without having to implement this interface.
 * 
 * 
 * For an example see the {@link RegularExpressionValidator} that
 * makes use of dynamic configuration but also can be completely
 * configured through its constructors.
 * 
 * 
 * @author Anatol Mayen
 * 
 * @param <T> The type of configuration data the <code>Validator</code> expects.
 *
 */
public interface ValidatorConfigurationSource<T> {

	/**
	 * This method is invoked by the validator on 
	 * each validation run.
	 * 
	 * (For sure the validator may choose to only call this
	 * method on e.g. each second validation call for whatever reason, but this
	 * should be stated in the docs for that specific validator.)
	 * 
	 * 
	 * @return The configuration data for a specific validator
	 */
	public T getConfigurationValue();
	
}
