/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.description;

/**
 * Description capabilities should be implementing this interface.
 * 
 * 
 * For an example see the <code>PopupDescription</code>.
 * 
 * @author Anatol Mayen
 *
 * @param <T> The Type that can be described by an implementation
 */
public interface Description<T> {
	
	public void addDescription(String msgKey, T widget);

}
