/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.actions;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.UIObject;

import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;


/**
 * Action that focus a widget when it fails validation.
 * This is a stateless Action, this means in most use-cases
 * it will be sufficient to only create a single instance
 * that can be reused by different validators even on different
 * fields.
 * 
 * @author Anatol Gregory Mayen
 *
 */
public class AlertAction extends ValidationAction<UIObject> {

	private String text;
	
	public AlertAction(String text) {
		this.text = text;
	}
	
	@Override
	public void invoke(ValidationResult result, UIObject object) {
		Window.alert(text);
	}

}