/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import eu.maydu.gwt.validation.client.exceptions.IncorrectSerializationFormatException;

public class ValidationProcessorUtils {

	/**
	 * Deserializes a serialized <code>ValidationException</code> and returns
	 * the generated <code>ValidationException</code> object.
	 * 
	 * @param serializedValidationException
	 * @return The <code>ValidationException</code> that was deserialized
	 * @throws IncorrectSerializationFormatException When the format of the serialized input could not be parsed
	 */
	public static ValidationException deserializeValidationException(
			String serializedValidationException) throws IncorrectSerializationFormatException {

		
		if (!serializedValidationException.startsWith("VE_SERIALIZE_"))
			throw new IncorrectSerializationFormatException("Wrong serialization format. Must begin with: VE_SERIALIZE_");
		
		ValidationException ex = new ValidationException();
		
		String ivs[] = serializedValidationException.split(":_\\[");
		
		if(ivs == null || ivs.length == 0)
			throw new IncorrectSerializationFormatException("Wrong serialization format. Expected delimiter: :_[");
		
		for(int i=1; i<ivs.length; i++) {
			String ivi[] = ivs[i].split("_,_");
			if(ivi == null || ivi.length != 2)
				throw new IncorrectSerializationFormatException("Wrong serialization format. Expected delimiter: _,_");
			
			InvalidValueSerializable iv = new InvalidValueSerializable();
			iv.setPropertyName(ivi[0]);
			iv.setMessage(ivi[1].substring(0, ivi[1].length()-2));
			ex.getInvalidValues().add(iv);
		}

		return ex;
	}
}
