var $ = jQuery;

var Frontpage = function() {
	var exports = {};

	function getBaseURL() {
		return base_url;
	}
	
	String.prototype.nl2br = function()
	{
	    return this.replace(/\n/g, "<br />");
	}
	
	function createURL(partsNum) {
		var l = window.location;
		var p = l.pathname.split('/');
		var base = getBaseURL(); 
		var count = 0;
		var i=1;
		while (i < p.length && count < partsNum) {
			if (base.indexOf(p[i]) == -1) {
				base += p[i]+'/';
				++count;
			}
			++i;
		}
		return base;
	}
	
	function showCompleteText(id) {
		var text = $("#"+id).text();
		$("#completeText").text(text);
		$("#completeText_dialog").dialog("open");
	}
	
	function loginAs (id) {
		$.ajax({
			type : 'GET',
			async : false,
			url : getBaseURL()+'/user/loginAs/'+id,
			dataType: 'json',
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				} else if (data.status) {
					$("#sessionId").text(data.response);
					$("#loginAs_dialog").dialog("open");
				} else {
					$("#ajax_error").text(data.response).show();
				}
			},
			error: function(error) {
				$("#ajax_error").text(eval(error)).show();
			}
		});
	}
	
	function resetAlerts() {
		$("#loader").hide();
		$("#ajax_msg_text").hide();
		$(".alert").hide();
	}
	
	function upgradeFirmware (id) {
		resetAlerts();
		$('#upgradeFirmware_btn').attr("disabled", "disabled");
		$("#loader").show();
		$("#ajax_msg_text").text('Firmware upgrading could take few minutes. Please wait...').show();
		$("#ajax_msg").show();
		$.ajax({
			type : 'GET',
			async : false,
			url : getBaseURL()+'/landevice/upgradeFirmware/'+id,
			dataType: 'json',
			success : function(data) {
				resetAlerts();
				if (data.status) {
					$("#ajax_msg_text").text(data.response).show();
				} else {
					$("#ajax_error").text(data.response).show();
				}
				$('#upgradeFirmware_btn').removeAttr("disabled");
			},
			error: function(error) {
				resetAlerts();
				$("#ajax_error").text(eval(error)).show();
				$('#upgradeFirmware_btn').removeAttr("disabled");
			}
		});
	}
	
	function sendGetURLRequest () {
		$("#getURL_dialog_error").hide();
		var id = $("#getURL_dialog_id").val();
		var method = $("#getURL_dialog_get").is(':checked') ? 'GET' : 'POST';
		var queryString = $("#getURL_dialog_queryString").val();
		var body = $("#getURL_dialog_body").val();
		var data = {
			 'method': method,
			 'queryString': queryString,
			 'body': body
		};
		var additionalFields = $("#getURL_dialog_ip_address").length * $("#getURL_dialog_port").length * 
			$("#getURL_dialog_user").length * $("#getURL_dialog_pass").length;
		if (additionalFields) {
			var ipAddress = $("#getURL_dialog_ip_address").val();
			var port = $("#getURL_dialog_port").val();
			var user = $("#getURL_dialog_user").val();
			var pass = $("#getURL_dialog_pass").val();
			data.ip_address = ipAddress;
			data.port = port;
			data.user = user;
			data.pass = pass;
		}
		var result = false;
		$.ajax({
			type : 'POST',
			async : false,
			url : createURL(1)+'getURL/'+id,
			data : data,
			dataType: 'json',
			success : function(data) {
				if (data.redirect) {
					window.location.href = data.redirect;
				} else if (data.status) {
					var win = window.open("", "URL from lan device");
					var doc = win.document;
					doc.open("text/html", "replace");
					doc.write(data.response);
					doc.close();
					result = true;
				} else {
					$("#getURL_dialog_error").text(data.response).show();
				}
			},
			error: function(error) {
				$("#getURL_dialog_error").text(eval(error)).show();
			}
		});
		return result;
	}
	
	

	function init() {

		$('#article_content img').wrap('<a href="#" rel="lytebox"/>').parent().attr('href', function(i, val) {
			return $('img', this).attr('src');
		});

		$('.date').datepicker({
			dateFormat : 'yy-mm-dd',
			minDate : '-80y',
			maxDate : new Date(),
			yearRange : "-80:-0",
			changeMonth : true,
			changeYear : true
		});
		
		$("#loginAs_dialog").dialog({
			autoOpen : false,
			modal : true,
			resizable : false,
			show : "blind",
			hide : "blind",
			buttons : {
				"Open new window" : function() {
					window.open(app_url, '_blank');
					$(this).dialog("close");
					$("#ajax_error").hide();
				},
				"Cancel" : function() {
					$(this).dialog("close");
					$("#ajax_error").hide();
				}
			}
		});
		
		$("#completeText_dialog").dialog({
			autoOpen : false,
			modal : true,
			resizable : false,
			width: 800,
			show : "blind",
			hide : "blind"
		});

		$("#getURL_dialog").dialog({
			autoOpen : false,
			modal : true,
			resizable : false,
			show : "blind",
			hide : "blind",
			buttons : {
				"Send" : function () {
					var result = sendGetURLRequest();
					if (result)
						$("#getURL_dialog").dialog("close");
				}, 
				"Cancel" : function() {
					$(this).dialog("close");
					$("#getURL_dialog_error").hide();
				}
			}
		});

		$("#getURL_dialog_post").click(function() {
			$("#getURL_dialog_body_block").show();
		});

		$("#getURL_dialog_get").click(function() {
			$("#getURL_dialog_body_block").hide();
		});
		$("#getURL_dialog_get").click();

		$("#getURL_btn").click(function() {
			$("#getURL_dialog").dialog("open");
			return false;
		});
		
		$("#getURL_dialog_btn").click(sendGetURLRequest);
		
		$("#executeScript_btn").click(function() {
			$("#executeScript_error").hide();
			id = $("#executeScript_id").val();
			controller = $("#executeScript_controller").val();
			script = $("#executeScript_script").val();
			data = 'script='+script;
			$.ajax({
				type : 'POST',
				async : false,
				url : getBaseURL() + controller + '/executeScript/'+id,
				data: data,
				dataType: 'json',
				success : function(data) {
					if (data.redirect) {
						window.location.href = data.redirect;
					} else if (data.status) {
						var console = $("#executeScript_response");
						console.append('> '+script+'<br/>');
						console.append(data.response.nl2br()+'<br/>');
					} else {
						$("#executeScript_error").text(data.response.nl2br()).show();
					}
				},
				error: function(error) {
					$("#executeScript_error").text(eval(error)).show();
				}
			});
		});
		
		$("#user_show_deleted_devices").click(function user_show() {
			var show_deleted = $('#user_show_deleted_devices').is(':checked') ? 1 : 0;
			var url = createURL(3) + show_deleted;
			window.location.href = url;
		});

	}


	exports.init = init;
	exports.loginAs = loginAs;
	exports.upgradeFirmware = upgradeFirmware;
	exports.showCompleteText = showCompleteText;
	exports.sendGetURLRequest = sendGetURLRequest;
	
	return exports;
}
var frontpage = new Frontpage();

//frontpage.user_show();

$(document).ready(function() {
	frontpage.init();
}); 