<?

class Transactions extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('t.*, u.username, ld.mac')
			->from('transaction t')
			->join('user_ u','t.user_id = u.id')
			->join('landevice ld','t.landevice_id = ld.landevice_id')
			-> order_by("t.timestamp", "desc"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function prepareRow(&$row) {
		$row['timestamp'] = $this->getDateByDB($row['timestamp']);
		$row['valid_to'] = $this->getDateByDB($row['valid_to']);
		$row['raw_response'] = $this->getTextByDB($row['raw_response']);
	}
	
	function getByUser ($user_id) {
		$where = array('t.user_id' => $user_id);
		return $this->get($where);
	}
	
	function getSearchConditions () {
		$where = array();
		if ($this -> session -> userdata('search_transaction_createdFrom')) {
			$date = $this->setDateByDB($this -> session -> userdata('search_transaction_createdFrom'),false);
			$where['el.timestamp > '] = $date;
		}
		if ($this -> session -> userdata('search_transaction_createdTo')) {
			$date = $this->setDateByDB($this -> session -> userdata('search_transaction_createdTo'),false);
			$where['el.timestamp < '] = $date;
		}
		if ($this -> session -> userdata('search_transaction_username')) {
			$this -> db -> like('u.username', $this -> session -> userdata('search_transaction_username'), 'after');
		}
		if ($this -> session -> userdata('search_transaction_status')) {
			$where['t.status'] = $this -> session -> userdata('search_transaction_status');
		}
		if ($this -> session -> userdata('search_transaction_mac')) {
			$this -> db -> like('ld.mac', $this -> session -> userdata('search_transaction_mac'), 'after');
		}
		return $where;
	}
}
