<?

class Products extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('product p')
			-> order_by("p.name"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		if ($singleRow && $result) {
			$result['productfeatures'] = $this->productfeatures->get(array('product_id' => $result['product_id']));
		}
		return $result;
	}
	
	function prepareRow(&$row) {
		$row['valid_from'] = $this->getDateByDB($row['valid_from']);
		$row['valid_to'] = $this->getDateByDB($row['valid_to']);
	}
	
	function check($product_id) {
		$product = null;
		if ($product_id) {
			$product = $this->get(array('product_id' => $product_id), null, true);
			if (!$product) {
				$this->session->set_flashdata('error', 'Selected product not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No product selected.');
		}
		return $product;
	}
	
	function add ($data) {
		$this->db->insert('product', $data);
		$this->session->set_flashdata('message', 'Product added.');
	}
	
	function edit ($product, $data) {
		$this->db->update('product', $data, array('product_id' => $product['product_id']));
		$this->session->set_flashdata('message', 'Product edited.');
	}
	function delete ($product) {
		$userProducts = $this->getUserProduct(array('p.product_id' => $product['product_id']));
		if (!$userProducts) {
			$this->db->delete('productfeature', array('product_id' => $product['product_id']));
			$this->db->delete('product', array('product_id' => $product['product_id']));
			$this->session->set_flashdata('message', 'Product deleted.');
		} else {
			$this->session->set_flashdata('error', 'Product is asigned to user and can\'t be deleted.');
		}
	}
	
	function getProductsDropdown($withBlank = true, $withDefault = true) {
		$result = $this->get();
		$products = array();
		if ($withBlank)
			$products[''] = '';
		foreach ($result as $product) {
			$products[$product['product_id']] = $product['name'];
		}
		if (!$withDefault) {
            $this->load->model('parameters');
            $where = array('code' => 'productManagement.defaultProductId');
            $defaultProduct = $this->parameters->get($where, null, true);
            unset($products[$defaultProduct['value']]);
        }
		return $products;
	}
	
	function getUserProduct ($where) {
		$this->db->from('userproductlog up')
			->join('product p','up.product_id = p.product_id')
			->order_by("up.date_added", "desc");
		if ($where)
			$this->db->where($where);
		$result = $this->db->get()->result_array();
		foreach($result as &$row) {
			$row['date_added'] = $this->getDateByDB($row['date_added']);
		}
		return $result;
	}
	
	function getByUser ($user_id) {
		$result = $this->getUserProduct(array('user_id' => $user_id));
		return $result;
	}
}
