<?

class Landevices extends Devices_Model
{
    protected $modelsWithUpgradeFirmwareDisabled = array('Vivotek');
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('ld.*, d.class, d.make, d.model, '.
				'gc.mac as gc_mac, gc.connected_date as gc_connected_date, gc.disconnected_date as gc_disconnected_date, '.
				'u.id, u.username, gc.gateway_client_id as gc_id, p.name as product')
			->select($this->getStatusQuery(),false)
			->from('landevice ld')
			->join('user_ u','ld.user_id = u.id')
			->join('product p','u.product_id = p.product_id')
			->join('devicedesc d','ld.devicedesc_id = d.devicedesc_id')
			->join('gatewayclient gc','ld.gateway_client_id = gc.gateway_client_id')
			->join('gatewayclientsession gcs','gc.mac = gcs.mac and gc.deleted = 0', 'left')
			->order_by("ld.added_date", "desc"); 
			
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		if ($singleRow && $result) {
			$result['params'] = $this->getParams($result['landevice_id']);
			$result['upgrade_firmware_available'] = $result['status'] == STATUS_CONNECTED && 
				!in_array($result['make'], $this->modelsWithUpgradeFirmwareDisabled);
		}
		return $result;
	}
	
	function prepareRow(&$row) {
		$row['added_date'] = $this->getDateByDB($row['added_date']);
		$row['modified_date'] = $this->getDateByDB($row['modified_date']);
		$row['deleted_date'] = $this->getDateByDB($row['deleted_date']);
		$row['upgrade_date'] = $this->getDateByDB($row['upgrade_date']);
		$row['product_date'] = $this->getDateByDB($row['product_date'],false);
		$row['trial_product_date'] = $this->getDateByDB($row['trial_product_date'],false);
		$row['valid_to'] = $this->getDateByDB($row['valid_to'],false);
	}
	
	function getByUser ($user_id, $withoutDeleted = true) {
		$where = array('ld.user_id' => $user_id);
		if ($withoutDeleted)
			$where['ld.deleted'] = 0;
		return $this->get($where);
	}
	
	function getById ($device_id, $deleted = null) {
		if (!is_numeric($device_id) && is_mac($device_id))
			$where = array('ld.mac' => $device_id);
		else
			$where = array('ld.landevice_id' => $device_id);
		if ($deleted !== null)
			$where = array('ld.deleted' => $deleted);
		return $this->get($where, null, true);
	}
	
	function getParams($device_id) {
		return $this->db->get_where('landeviceparam', array('landevice_id' => $device_id))
			->result_array();
	}
	function edit ($device, $data) {
		$data['valid_to'] = $this->setDateByDB($data['valid_to'],false);
		$this->db->where('landevice_id', $device['landevice_id']);
		$this->db->update('landevice', $data);
		$this->session->set_flashdata('message', 'Landevice edited.');
	}
	function checkConfigStatus($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->checkConfigStatus($device['landevice_id'])) {
			$ok = true;
			$msg = 'Device status: '.$response -> body -> status;
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
	
	function reconfigure($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->reconfigure($device['landevice_id'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_SUCCESS) {
				$msg = 'Lan device has been sucessfully reconfigured';
				$ok = true;
			} else {
				$msg = 'Lan device reconfigure failed. Reason: '.$this->getErrorMsg($status);
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
	
	function upgradeFirmware($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->upgradeFirmware($device['landevice_id'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_SUCCESS) {
				$msg = 'Lan device firmware has been sucessfully upgraded';
				$ok = true;
			} else {
				$msg = 'Lan device firmware upgrade failed. Reason: '.$this->getErrorMsg($status);
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
	
	function getURL($device,$data) {
		$data['mac'] = $device['gc_mac'];
		$data['user'] = $device['user_'];
		$data['pass'] = $device['pass'];
		$data['ip_address'] = $device['ip_address'];
		$data['port'] = $device['port'];
		return parent::getURL($data);
	}
	
	function delete($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->deleteLanDevice($device['landevice_id'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_SUCCESS) {
				$msg = 'Lan device has been deleted';
				$ok = true;
			} else {
				$msg = 'Lan device delete failed. Reason: '.$this->getErrorMsg($status);
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
}
