<?

class MY_Model extends CI_Model
{
		
	protected $errorMessages = array(
		'FAILED_INVALIDMACADDRESS' => 'Invalid mac address',
		'FAILED_GCDISCONNECTED' => 'Gateway client disconnected',
		'STATUS_FAILED_DEVICENOTCONNECTED' => 'Device disconnected',
		'FAILED_MALFORMEDURL' => 'Malformed url', 
		'FAILED_NOACCESS' => 'No access', 
		'FAILED_NOANSWER' => 'No answer', 
		'FAILED_WRONGOLDPASSWORD' => 'Wrong old password', 
		'FAILED_PASSWORDINVALID' => 'Password invalid', 
		'FAILED_NOTFOUNDUSER' => 'User not found',
		'FAILED_NOTACTIVATED' => 'User not activated',
		'ERROR' => 'Unknown error'
	);
		
		
	protected $name;
	
    function __construct()
    {
        parent::__construct();
    }
	
	function getResult($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		if ($where)
			$this->db->where($where);
		if ($countOnly) {
			$result = $this -> db -> count_all_results();
		} else if ($singleRow) {
			$result = $this -> db -> get() -> row_array();
		} else {
			if ($offset !== null)
				$this -> db -> limit(PER_PAGE, $offset);
			$result = $this -> db -> get() -> result_array();
		}
		
		if (!$countOnly && $result && method_exists($this, 'prepareRow')) {
			if ($singleRow)
				$this->prepareRow($result);
			else
				$this->prepareData($result);
		}
		return $result;
	}
	
	function getSearchConditions() {
		return array();
	}
	
	function count($where = array(), $specialWhere = null) {
		if ($specialWhere)
			foreach ($specialWhere as $field => $value)
				$this->db->where($field, $value, false);
		$where = array_merge($where, $this->getSearchConditions());
		if (!$where)
			$where = null;
		return $this -> get($where, null, false, true);
	}
	
	function countAll() {
		return $this -> get(null, null, false, true);
	}
	
	function getAll($offset = null, $countOnly = false) {
		$where = $this->getSearchConditions();
		return $this->get($where,$offset,false,$countOnly);
	}
	
	function checkResult ($ok, $msg) {
		if ($msg) {
			$type = $ok ? 'message' : 'error';
			$this -> session -> set_flashdata($type, $msg);
		}
		return $ok;
		
	}
	
	function clearSession ($saveFlashdata = true) {
		$error = $this->session->userdata('flash:new:error');
		$message = $this->session->userdata('flash:new:message');
		$this -> session -> sess_destroy();
		$this -> session -> sess_create();
		if ($saveFlashdata) {
			$this->session->set_flashdata('error',$error);
			$this->session->set_flashdata('message',$message);
		}
		delete_cookie('JSESSIONID');
	}
	
	function getDomain() {
		$url = $this->config->item('base_url');
		$parse = parse_url($url);
		return $parse['host'];
	}
	
	function getPath() {
		$url = $this->config->item('base_url');
		$parse = parse_url($url);
		$path = $parse['path'];
		if (strlen($path) > 1 && $path[0] == '/')
			$path = substr($path, 1);
		return $path;
	}
	
	function getLimitedSqlByDB ($sql, $offset, $limit) {
		if ($this->db->dbdriver == 'oci8') {
			$sql = 'select * from '.
				'( select inner_query.*, ROWNUM rnum from '.
 				' ( '.$sql.' ) inner_query '.
  				'where ROWNUM <= '.($offset+$limit).' ) '.
				'where rnum  >= '.$offset;
		} else if ($this->db->dbdriver == 'mysql') {
			$sql .= " LIMIT $offset, $limit ";
		}
		return $sql;
	}
	
	function getTextByDB($field) {
		if ($field) {
			if ($this->db->dbdriver == 'oci8') {
				$field = read_clob($field);
			}
		}
		return $field;
	}
	
	function getDateByDB($field, $withTime = true) {
		if ($field) {
			if ($this->db->dbdriver == 'oci8') {
				$field = $withTime ? from_oracle_datetime($field) : from_oracle_date($field);
			}
		}
		return $field;
	}
	
	function setDateByDB($field, $withTime = true) {
		if ($field) {
			if ($this->db->dbdriver == 'oci8') {
				$field = $withTime ? datetime_to_oracle($field) : date_to_oracle($field);
			}
		}
		return $field;
	}
	
	function prepareData(&$data) {
		foreach ($data as &$row) {
			$this->prepareRow($row);
		}
	}
	
	function getErrorMsg($status) {
		return in_array($status, $this->errorMessages) ? $this->getErrorMsg($status) : $status;
	}
}
require(APPPATH.'core/Devices_Model.php');
