<?

class Rest extends CI_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function sendRequest ($uri, $body, $method) {
		$uri = REST_SERVER.$uri;
		if ($method == METHOD_POST) {
			$response = \Httpful\Request::post($uri) 
				-> addHeader('Cookie', SESSION_COOKIE.'='.$this->session->userdata(SESSION_COOKIE).';')
				-> sendsJson() 
				-> body($body) 
				-> send();
		} else if ($method == METHOD_GET) {
			$response = \Httpful\Request::get($uri) 
				-> addHeader('Cookie', SESSION_COOKIE.'='.$this->session->userdata(SESSION_COOKIE).';')
				-> send();
		}
		return $this->checkResponse($response);		
	}
	
	function sendPostRequest  ($uri, $body) {
		return $this->sendRequest($uri, $body, METHOD_POST);
	}
	
	function sendGetRequest ($uri) {
		return $this->sendRequest($uri, null, METHOD_GET);	
	}
	
	function checkResponse ($response) {
		if (is_object($response -> body)) {
			return $response;
		} else {
			$this -> session -> set_flashdata('error', 'Internal error');
			return null;
		}
	}
	
	function login ($username, $password) {
		$uri = 'user/authenticate';
		$msg = '{"username":"' . $username . '", "password":"' . $password . '", "rememberMe":false}';
		return $this->sendPostRequest($uri, $msg);
	}
	
	function loginAs ($user_id) {
		$uri = 'user/loginAs?userId='.$user_id;
		$this->sendGetRequest($uri);
	}
	
	function logout () {
		$uri = 'user/logout';
		return $this->sendGetRequest($uri);
	}
	
	function changePassAsAdmin ($user_id, $password) {
		$uri = 'user/changePassAsAdmin';
		$msg = '{"userId":"' . $user_id . '", "password":"' . $password . '"}';
		return $this->sendPostRequest($uri, $msg);
	}
	
	function checkConfigStatus ($device_id) {
		$uri = 'ld/checkConfigAsAdmin/'.$device_id;
		return $this->sendGetRequest($uri);
	}
	
	function reconfigure ($device_id) {
		$uri = 'ld/reconfigureAsAdmin/'.$device_id;
		return $this->sendGetRequest($uri);
	}
	
	function getURL ($mac, $method, $url, $body) {
		$uri = 'gc/sendData';
		$msg = '{"mac":"' . $mac . '", "method":"' . $method . '", "url":"' . $url . '", "body":"' . $body . '"}';
		return $this->sendPostRequest($uri, $msg);
	}
	
	function restartGatewayClient ($mac) {
		$uri = 'gc/restartGatewayClient/'.$mac;
		return $this->sendGetRequest($uri);
	}
	
	function upgrade ($device_id) {
		$uri = 'gc/upgradeGatewayClient/'.$device_id;
		return $this->sendGetRequest($uri);
	}

	function executeScript ($mac, $script) {
		$uri = 'gc/executeScript/'.$mac.'/'.$script;
		return $this->sendGetRequest($uri);
	}
	
	function getPublicIP ($device_id) {
		$uri = 'gc/getPublicIP/'.$device_id;
		return $this->sendGetRequest($uri);
	}
	
	function ensureLogedIn() {
		$uri = 'user/ensureLogedIn';
		$response = $this->sendGetRequest($uri);
		if ($response && $response -> body -> status == STATUS_OK)
			return true;
		else {
			$this -> session -> set_flashdata('error', 'Session timeout. Please log in.');
			return false;
		}
	}
}
