<?

class Landevices extends Devices_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('ld.*, d.class, d.make, d.model, '.
				'gc.mac as gc_mac, gc.connected_date as gc_connected_date, gc.disconnected_date as gc_disconnected_date, '.
				'u.id, u.username, gc.gateway_client_id as gc_id, p.name as product')
			->select('IF(gcs.mac IS NOT NULL,"'.STATUS_CONNECTED.'","'.STATUS_DISCONNECTED.'") as status',false)
			->from('landevice ld')
			->join('user u','ld.user_id = u.id')
			->join('product p','u.product_id = p.product_id')
			->join('devicedesc d','ld.devicedesc_id = d.devicedesc_id')
			->join('gatewayclient gc','ld.gateway_client_id = gc.gateway_client_id')
			->join('gatewayclientsession gcs','gc.mac = gcs.mac and gc.deleted = 0', 'left')
			->order_by("ld.added_date", "desc"); 
		
		if ($where)
			$this->db->where($where);
		
		if ($countOnly) {
			return $this -> db -> count_all_results();
		} else if ($singleRow) {
			$result = $this -> db -> get() -> row_array();
			if ($result) {
				$result['params'] = $this->getParams($result['landevice_id']);
			}
			return $result;
		} else {
			if ($offset !== null)
				$this -> db -> limit(PER_PAGE, $offset);
			return $this -> db -> get() -> result_array();
		}
	}
	
	function getByUser ($user_id, $withoutDeleted = true) {
		$where = array('ld.user_id' => $user_id);
		if ($withoutDeleted)
			$where['ld.deleted'] = 0;
		return $this->get($where);
	}
	
	function getById ($device_id, $deleted = null) {
		if (!is_numeric($device_id) && is_mac($device_id))
			$where = array('ld.mac' => $device_id);
		else
			$where = array('ld.landevice_id' => $device_id);
		if ($deleted !== null)
			$where = array('ld.deleted' => $deleted);
		return $this->get($where, null, true);
	}
	
	function getParams($device_id) {
		return $this->db->get_where('landeviceparam', array('landevice_id' => $device_id))
			->result_array();
	}
	function edit ($device, $data) {
		$this->db->where('landevice_id', $device['landevice_id']);
		$this->db->update('landevice', $data);
		$this->session->set_flashdata('message', 'Landevice edited.');
	}
	function checkConfigStatus($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->checkConfigStatus($device['landevice_id'])) {
			$ok = true;
			$msg = 'Device status: '.$response -> body -> status;
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
	
	function reconfigure($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->reconfigure($device['landevice_id'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_SUCCESS) {
				$msg = 'Lan device has been sucessfully reconfigured';
				$ok = true;
			} else {
				$msg = 'Lan device reconfigure failed. Reason: '.$this->errorMessages[$status];
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body : null;
	}
	
	function getURL($device,$data) {
		$data['mac'] = $device['gc_mac'];
		$data['user'] = $device['user'];
		$data['pass'] = $device['pass'];
		$data['ip_address'] = $device['ip_address'];
		$data['port'] = $device['port'];
		return parent::getURL($data);
	}
}
