<?

class Gatewayclients extends Devices_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('gc.*, u.username, gcs.public_ip')
			->select('IF(gcs.mac IS NOT NULL,"'.STATUS_CONNECTED.'","'.STATUS_DISCONNECTED.'") as status',false)
			->from('gatewayclient gc')
			->join('user u','gc.user_id = u.id')
			->join('gatewayclientsession gcs','gc.mac = gcs.mac and gc.deleted = 0', 'left')
			->order_by("gc.activation_date", "desc"); 
		if ($where)
			$this->db->where($where);
		if ($countOnly) {
			return $this -> db -> count_all_results();
		} else if ($singleRow) {
			$result = $this -> db -> get() -> row_array();
			if ($result) {
				$result['landevices'] = $this->getLandevices($result['gateway_client_id']);
			}
			return $result;
		} else {
			if ($offset !== null)
				$this -> db -> limit(PER_PAGE, $offset);
			return $this -> db -> get() -> result_array();
		}
	}
	
	function getByUser ($user_id, $withoutDeleted = true) {
		$where = array('gc.user_id' => $user_id);
		if ($withoutDeleted)
			$where['gc.deleted'] = 0;
		return $this->get($where);
	}
	
	function getById ($device_id, $deleted = null) {
		if (!is_numeric($device_id) && is_mac($device_id))
			$where = array('gc.mac' => $device_id);
		else
			$where = array('gc.gateway_client_id' => $device_id);
		if ($deleted !== null)
			$where = array('gc.deleted' => $deleted);
		return $this->get($where, null, true);
	}
	
	function getLandevices($device_id) {
		$where = array('ld.gateway_client_id' => $device_id);
		return $this->landevices->get($where);
	}
	
	function edit ($device, $data) {
		$this->db->where('gateway_client_id', $device['gateway_client_id']);
		$this->db->update('gatewayclient', $data);
		$this->session->set_flashdata('message', 'Gateway client edited.');
	}
	
	function upgrade($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->upgrade($device['gateway_client_id'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$msg = 'Gateway client has been sucessfully upgraded';
				$ok = true;
			} else {
				$msg = 'Gateway client upgrade failed. Reason: '.$this->errorMessages[$status];
			}
		}
		return $this->checkResult($ok, $msg);
	}

	function restart($device) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->restartGatewayClient($device['mac'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$msg = 'Gateway client has been sucessfully restarted';
				$ok = true;
			} else {
				$msg = 'Gateway client restart failed. Reason: '.$this->errorMessages[$status];
			}
		}
		return $this->checkResult($ok, $msg);
	}
	
	function getPublicIP($device_id) {
		if ($response = $this->rest->getPublicIP($device_id)) {
			return isset($response -> body -> ip) ? $response -> body -> ip : $response -> body -> status;
		} else
			return null;
	}
	
}
