<?

class Events extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function getSourcesDropdown() {
		return array('' => 'ALL', 'GC' => 'GC', 'LD' => 'LD', 'VIEWER' => 'VIEWER');
	}
	
	function getTypesDropdown() {
		return array('' => 'ALL', 'CONFIGURE' => 'CONFIGURE', 'LANIPCHANGE' => 'LANIPCHANGE', 
			'DELETE' => 'DELETE', 'VIDEORECORDING' => 'VIDEORECORDING', 'FIRMWAREUPGRADE' => 'FIRMWAREUPGRADE', 
			'CONNECT' => 'CONNECT', 'DISCONNECT' => 'DISCONNECT', 'ACTIVATE' => 'ACTIVATE',
			'ICESETUP' => 'ICESETUP', 'CLIENTICE' => 'CLIENTICE', 'VIDEOSTREAM' => 'VIDEOSTREAM', 
			'UPNPSETUP' => 'UPNPSETUP');
	}
	
	function getSearchConditions () {
		$where = array();
		
		if ($this -> session -> userdata('search_event_createdFrom')) {
			$where['el.timestamp > '] = $this -> session -> userdata('search_event_createdFrom');
		}
		if ($this -> session -> userdata('search_event_createdTo')) {
			$where['el.timestamp < '] = $this -> session -> userdata('search_event_createdTo');
		}
		
		if ($this -> session -> userdata('search_event_mac')) {
			$this -> db -> like('el.source_mac', $this -> session -> userdata('search_event_mac'), 'after');
		}
		if ($this -> session -> userdata('search_event_ip')) {
			$this -> db -> like('el.source_ip', $this -> session -> userdata('search_event_ip'), 'after');
		}
		if ($this -> session -> userdata('search_event_source')) {
			$where['el.source'] = $this -> session -> userdata('search_event_source');
		}
		if ($this -> session -> userdata('search_event_type')) {
			$where['el.event_type'] = $this -> session -> userdata('search_event_type');
		}
		return $where;
	}
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('eventlog el')
			-> order_by("el.timestamp", "desc"); 
		if ($where)
			$this->db->where($where);
		if ($countOnly) {
			return $this -> db -> count_all_results();
		} else if ($singleRow) {
			return  $this -> db -> get() -> row_array();
		} else {
			if ($offset !== null)
				$this -> db -> limit(PER_PAGE, $offset);
			return $this -> db -> get() -> result_array();
		}
	}
	function getDataSizeStatistics () {
			$this->db->select('IFNULL(SUM(video_file_size),0) as sum_video_file_size, '.
						'IFNULL(SUM(image_file_size),0) as sum_image_file_size, '.
						'TRUNCATE(IFNULL(AVG(video_file_size),0),2) as avg_video_file_size, '.
						'IFNULL(MAX(video_file_size),0) as max_video_file_size ',
						false
			)
			->from('event');
			return  $this -> db -> get() -> row_array();
	}
}
